<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CurrencyCodeType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines currency code (ISO 3-letter code) and optional number of decimals. Not that for request messages the NumberOfDecimals has no effect and is not needed.
 * @subpackage Structs
 */
class CurrencyCodeType extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The NumberOfDecimals
     * Meta information extracted from the WSDL
     * - documentation: Decimal position in fare amount. Example: 2
     * - use: optional
     * @var int
     */
    public $NumberOfDecimals;
    /**
     * The Rate
     * Meta information extracted from the WSDL
     * - documentation: The daily exchange rate defined through sources such as BSR, BBR, ICH between two currencies applied in the conversion
     * @var string
     */
    public $Rate;
    /**
     * The ROE
     * Meta information extracted from the WSDL
     * - documentation: Conversion rate applied to the conversion of a filed fare to NUC as published by IATA. Applicable to FiledInCurrency only.
     * @var string
     */
    public $ROE;
    /**
     * The Table
     * Meta information extracted from the WSDL
     * - documentation: Table reference for the exchange rate.Sample: BSR
     * @var string
     */
    public $Table;
    /**
     * Constructor method for CurrencyCodeType
     * @uses CurrencyCodeType::set_()
     * @uses CurrencyCodeType::setNumberOfDecimals()
     * @uses CurrencyCodeType::setRate()
     * @uses CurrencyCodeType::setROE()
     * @uses CurrencyCodeType::setTable()
     * @param string $_
     * @param int $numberOfDecimals
     * @param string $rate
     * @param string $rOE
     * @param string $table
     */
    public function __construct($_ = null, $numberOfDecimals = null, $rate = null, $rOE = null, $table = null)
    {
        $this
            ->set_($_)
            ->setNumberOfDecimals($numberOfDecimals)
            ->setRate($rate)
            ->setROE($rOE)
            ->setTable($table);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\CurrencyCodeType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get NumberOfDecimals value
     * @return int|null
     */
    public function getNumberOfDecimals()
    {
        return $this->NumberOfDecimals;
    }
    /**
     * Set NumberOfDecimals value
     * @param int $numberOfDecimals
     * @return \StructType\CurrencyCodeType
     */
    public function setNumberOfDecimals($numberOfDecimals = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfDecimals) && !(is_int($numberOfDecimals) || ctype_digit($numberOfDecimals))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfDecimals, true), gettype($numberOfDecimals)), __LINE__);
        }
        $this->NumberOfDecimals = $numberOfDecimals;
        return $this;
    }
    /**
     * Get Rate value
     * @return string|null
     */
    public function getRate()
    {
        return $this->Rate;
    }
    /**
     * Set Rate value
     * @param string $rate
     * @return \StructType\CurrencyCodeType
     */
    public function setRate($rate = null)
    {
        // validation for constraint: string
        if (!is_null($rate) && !is_string($rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->Rate = $rate;
        return $this;
    }
    /**
     * Get ROE value
     * @return string|null
     */
    public function getROE()
    {
        return $this->ROE;
    }
    /**
     * Set ROE value
     * @param string $rOE
     * @return \StructType\CurrencyCodeType
     */
    public function setROE($rOE = null)
    {
        // validation for constraint: string
        if (!is_null($rOE) && !is_string($rOE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rOE, true), gettype($rOE)), __LINE__);
        }
        $this->ROE = $rOE;
        return $this;
    }
    /**
     * Get Table value
     * @return string|null
     */
    public function getTable()
    {
        return $this->Table;
    }
    /**
     * Set Table value
     * @param string $table
     * @return \StructType\CurrencyCodeType
     */
    public function setTable($table = null)
    {
        // validation for constraint: string
        if (!is_null($table) && !is_string($table)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($table, true), gettype($table)), __LINE__);
        }
        $this->Table = $table;
        return $this;
    }
}
