<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CurConversionType StructType
 * Meta information extracted from the WSDL
 * - documentation: The result of converting one currency into another currency. E.g. local currency to USD, air miles to monetary.
 * @subpackage Structs
 */
class CurConversionType extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Amount and currency specified in the converted currency. Example: 15000 USD
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AmountType
     */
    public $Amount;
    /**
     * The ConversionRate
     * Meta information extracted from the WSDL
     * - documentation: Defines the rate used to convert the local currency into the billing currency. Do we want to define an official name for the Billing Currency?
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ConversionRate
     */
    public $ConversionRate;
    /**
     * The LocalAmount
     * Meta information extracted from the WSDL
     * - documentation: Amount and currency as specified by the local Country.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AmountType
     */
    public $LocalAmount;
    /**
     * Constructor method for CurConversionType
     * @uses CurConversionType::setAmount()
     * @uses CurConversionType::setConversionRate()
     * @uses CurConversionType::setLocalAmount()
     * @param \StructType\AmountType $amount
     * @param \StructType\ConversionRate $conversionRate
     * @param \StructType\AmountType $localAmount
     */
    public function __construct(\StructType\AmountType $amount = null, \StructType\ConversionRate $conversionRate = null, \StructType\AmountType $localAmount = null)
    {
        $this
            ->setAmount($amount)
            ->setConversionRate($conversionRate)
            ->setLocalAmount($localAmount);
    }
    /**
     * Get Amount value
     * @return \StructType\AmountType
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \StructType\AmountType $amount
     * @return \StructType\CurConversionType
     */
    public function setAmount(\StructType\AmountType $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get ConversionRate value
     * @return \StructType\ConversionRate
     */
    public function getConversionRate()
    {
        return $this->ConversionRate;
    }
    /**
     * Set ConversionRate value
     * @param \StructType\ConversionRate $conversionRate
     * @return \StructType\CurConversionType
     */
    public function setConversionRate(\StructType\ConversionRate $conversionRate = null)
    {
        $this->ConversionRate = $conversionRate;
        return $this;
    }
    /**
     * Get LocalAmount value
     * @return \StructType\AmountType
     */
    public function getLocalAmount()
    {
        return $this->LocalAmount;
    }
    /**
     * Set LocalAmount value
     * @param \StructType\AmountType $localAmount
     * @return \StructType\CurConversionType
     */
    public function setLocalAmount(\StructType\AmountType $localAmount = null)
    {
        $this->LocalAmount = $localAmount;
        return $this;
    }
}
