<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CryptographyKeyType StructType
 * Meta information extracted from the WSDL
 * - documentation: Cryptography Key.
 * @subpackage Structs
 */
class CryptographyKeyType extends AbstractStructBase
{
    /**
     * The KeyNameText
     * Meta information extracted from the WSDL
     * - documentation: key name. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $KeyNameText;
    /**
     * The KeyValue
     * Meta information extracted from the WSDL
     * - documentation: A Key Value
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KeyValueType
     */
    public $KeyValue;
    /**
     * Constructor method for CryptographyKeyType
     * @uses CryptographyKeyType::setKeyNameText()
     * @uses CryptographyKeyType::setKeyValue()
     * @param string $keyNameText
     * @param \StructType\KeyValueType $keyValue
     */
    public function __construct($keyNameText = null, \StructType\KeyValueType $keyValue = null)
    {
        $this
            ->setKeyNameText($keyNameText)
            ->setKeyValue($keyValue);
    }
    /**
     * Get KeyNameText value
     * @return string
     */
    public function getKeyNameText()
    {
        return $this->KeyNameText;
    }
    /**
     * Set KeyNameText value
     * @param string $keyNameText
     * @return \StructType\CryptographyKeyType
     */
    public function setKeyNameText($keyNameText = null)
    {
        // validation for constraint: string
        if (!is_null($keyNameText) && !is_string($keyNameText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keyNameText, true), gettype($keyNameText)), __LINE__);
        }
        $this->KeyNameText = $keyNameText;
        return $this;
    }
    /**
     * Get KeyValue value
     * @return \StructType\KeyValueType|null
     */
    public function getKeyValue()
    {
        return $this->KeyValue;
    }
    /**
     * Set KeyValue value
     * @param \StructType\KeyValueType $keyValue
     * @return \StructType\CryptographyKeyType
     */
    public function setKeyValue(\StructType\KeyValueType $keyValue = null)
    {
        $this->KeyValue = $keyValue;
        return $this;
    }
}
