<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CouponReference StructType
 * @subpackage Structs
 */
class CouponReference extends AbstractStructBase
{
    /**
     * The CouponNumber
     * Meta information extracted from the WSDL
     * - documentation: Coupon number that voucher is associated to.
     * - use: required
     * @var string
     */
    public $CouponNumber;
    /**
     * The TicketDocNbr
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - use: required
     * @var string
     */
    public $TicketDocNbr;
    /**
     * The VoucherImage
     * @var \StructType\VoucherImage
     */
    public $VoucherImage;
    /**
     * Constructor method for CouponReference
     * @uses CouponReference::setCouponNumber()
     * @uses CouponReference::setTicketDocNbr()
     * @uses CouponReference::setVoucherImage()
     * @param string $couponNumber
     * @param string $ticketDocNbr
     * @param \StructType\VoucherImage $voucherImage
     */
    public function __construct($couponNumber = null, $ticketDocNbr = null, \StructType\VoucherImage $voucherImage = null)
    {
        $this
            ->setCouponNumber($couponNumber)
            ->setTicketDocNbr($ticketDocNbr)
            ->setVoucherImage($voucherImage);
    }
    /**
     * Get CouponNumber value
     * @return string
     */
    public function getCouponNumber()
    {
        return $this->CouponNumber;
    }
    /**
     * Set CouponNumber value
     * @param string $couponNumber
     * @return \StructType\CouponReference
     */
    public function setCouponNumber($couponNumber = null)
    {
        // validation for constraint: string
        if (!is_null($couponNumber) && !is_string($couponNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($couponNumber, true), gettype($couponNumber)), __LINE__);
        }
        $this->CouponNumber = $couponNumber;
        return $this;
    }
    /**
     * Get TicketDocNbr value
     * @return string
     */
    public function getTicketDocNbr()
    {
        return $this->TicketDocNbr;
    }
    /**
     * Set TicketDocNbr value
     * @param string $ticketDocNbr
     * @return \StructType\CouponReference
     */
    public function setTicketDocNbr($ticketDocNbr = null)
    {
        // validation for constraint: string
        if (!is_null($ticketDocNbr) && !is_string($ticketDocNbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketDocNbr, true), gettype($ticketDocNbr)), __LINE__);
        }
        $this->TicketDocNbr = $ticketDocNbr;
        return $this;
    }
    /**
     * Get VoucherImage value
     * @return \StructType\VoucherImage|null
     */
    public function getVoucherImage()
    {
        return $this->VoucherImage;
    }
    /**
     * Set VoucherImage value
     * @param \StructType\VoucherImage $voucherImage
     * @return \StructType\CouponReference
     */
    public function setVoucherImage(\StructType\VoucherImage $voucherImage = null)
    {
        $this->VoucherImage = $voucherImage;
        return $this;
    }
}
