<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CountrySubDivision StructType
 * Meta information extracted from the WSDL
 * - documentation: An area of land which is a sub-division within a country, such as a state, a county, a canton, a province, etc.
 * @subpackage Structs
 */
class CountrySubDivision extends AbstractStructBase
{
    /**
     * The CountrySubDivisionCode
     * Meta information extracted from the WSDL
     * - documentation: ISO code 3166-2 identifying this country sub-division within a given country. E.g. 'US-AZ' for state of Arizona (United States of America), 'DE-BY' for region of Bavaria (Germany).
     * - minOccurs: 0
     * @var string
     */
    public $CountrySubDivisionCode;
    /**
     * The CountrySubDivisionName
     * Meta information extracted from the WSDL
     * - documentation: The name, expressed as text, of the sub-division of a country.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountrySubDivisionName;
    /**
     * Constructor method for CountrySubDivision
     * @uses CountrySubDivision::setCountrySubDivisionCode()
     * @uses CountrySubDivision::setCountrySubDivisionName()
     * @param string $countrySubDivisionCode
     * @param string $countrySubDivisionName
     */
    public function __construct($countrySubDivisionCode = null, $countrySubDivisionName = null)
    {
        $this
            ->setCountrySubDivisionCode($countrySubDivisionCode)
            ->setCountrySubDivisionName($countrySubDivisionName);
    }
    /**
     * Get CountrySubDivisionCode value
     * @return string|null
     */
    public function getCountrySubDivisionCode()
    {
        return $this->CountrySubDivisionCode;
    }
    /**
     * Set CountrySubDivisionCode value
     * @param string $countrySubDivisionCode
     * @return \StructType\CountrySubDivision
     */
    public function setCountrySubDivisionCode($countrySubDivisionCode = null)
    {
        // validation for constraint: string
        if (!is_null($countrySubDivisionCode) && !is_string($countrySubDivisionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countrySubDivisionCode, true), gettype($countrySubDivisionCode)), __LINE__);
        }
        $this->CountrySubDivisionCode = $countrySubDivisionCode;
        return $this;
    }
    /**
     * Get CountrySubDivisionName value
     * @return string|null
     */
    public function getCountrySubDivisionName()
    {
        return $this->CountrySubDivisionName;
    }
    /**
     * Set CountrySubDivisionName value
     * @param string $countrySubDivisionName
     * @return \StructType\CountrySubDivision
     */
    public function setCountrySubDivisionName($countrySubDivisionName = null)
    {
        // validation for constraint: string
        if (!is_null($countrySubDivisionName) && !is_string($countrySubDivisionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countrySubDivisionName, true), gettype($countrySubDivisionName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($countrySubDivisionName) && mb_strlen($countrySubDivisionName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($countrySubDivisionName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($countrySubDivisionName) && mb_strlen($countrySubDivisionName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($countrySubDivisionName)), __LINE__);
        }
        $this->CountrySubDivisionName = $countrySubDivisionName;
        return $this;
    }
}
