<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
 * @subpackage Structs
 */
class ContactInfoType extends AbstractStructBase
{
    /**
     * The ContactInfoID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely Identifies a set of Contact Information, within the context of one message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an
     * agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ContactInfoID;
    /**
     * The ContactPurposeText
     * Meta information extracted from the WSDL
     * - documentation: to identify the contact purpose (PADIS code list 3299) | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var string[]
     */
    public $ContactPurposeText;
    /**
     * The ContactRefusedInd
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, Contact Information was refused to be provided. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ContactRefusedInd;
    /**
     * The EmailAddress
     * Meta information extracted from the WSDL
     * - documentation: The email address which should be used for contact purposes.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EmailAddressType[]
     */
    public $EmailAddress;
    /**
     * The Individual
     * Meta information extracted from the WSDL
     * - documentation: A single human being as distinct from a group, class, or family.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IndividualType
     */
    public $Individual;
    /**
     * The IndividualRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to Individual instance(s) | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IndividualRefID;
    /**
     * The OtherAddress
     * Meta information extracted from the WSDL
     * - documentation: Other Contact Method information. E.g. web site URL, social media handle.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OtherAddressType[]
     */
    public $OtherAddress;
    /**
     * The PaxSegmentRefID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely identifies a Passenger Segment within the context of one message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaxSegmentRefID;
    /**
     * The Phone
     * Meta information extracted from the WSDL
     * - documentation: A telephone number is a sequence of digits assigned to a fixed-line telephone subscriber station connected to a telephone line or to a wireless electronic telephony device, such as a radio telephone or a mobile telephone, or to other
     * devices for data transmission via the public switched telephone network (PSTN) or other private networks.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PhoneType[]
     */
    public $Phone;
    /**
     * The PostalAddress
     * Meta information extracted from the WSDL
     * - documentation: Natural or physical address used for postal service. May be a building address, airport address, etc.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PostalAddressType[]
     */
    public $PostalAddress;
    /**
     * The RelationshipToPax
     * Meta information extracted from the WSDL
     * - documentation: Relationship to the passenger e.g. used for when this individual is an emergency contact | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RelationshipToPax;
    /**
     * Constructor method for ContactInfoType
     * @uses ContactInfoType::setContactInfoID()
     * @uses ContactInfoType::setContactPurposeText()
     * @uses ContactInfoType::setContactRefusedInd()
     * @uses ContactInfoType::setEmailAddress()
     * @uses ContactInfoType::setIndividual()
     * @uses ContactInfoType::setIndividualRefID()
     * @uses ContactInfoType::setOtherAddress()
     * @uses ContactInfoType::setPaxSegmentRefID()
     * @uses ContactInfoType::setPhone()
     * @uses ContactInfoType::setPostalAddress()
     * @uses ContactInfoType::setRelationshipToPax()
     * @param string $contactInfoID
     * @param string[] $contactPurposeText
     * @param bool $contactRefusedInd
     * @param \StructType\EmailAddressType[] $emailAddress
     * @param \StructType\IndividualType $individual
     * @param string $individualRefID
     * @param \StructType\OtherAddressType[] $otherAddress
     * @param string $paxSegmentRefID
     * @param \StructType\PhoneType[] $phone
     * @param \StructType\PostalAddressType[] $postalAddress
     * @param string $relationshipToPax
     */
    public function __construct($contactInfoID = null, array $contactPurposeText = array(), $contactRefusedInd = null, array $emailAddress = array(), \StructType\IndividualType $individual = null, $individualRefID = null, array $otherAddress = array(), $paxSegmentRefID = null, array $phone = array(), array $postalAddress = array(), $relationshipToPax = null)
    {
        $this
            ->setContactInfoID($contactInfoID)
            ->setContactPurposeText($contactPurposeText)
            ->setContactRefusedInd($contactRefusedInd)
            ->setEmailAddress($emailAddress)
            ->setIndividual($individual)
            ->setIndividualRefID($individualRefID)
            ->setOtherAddress($otherAddress)
            ->setPaxSegmentRefID($paxSegmentRefID)
            ->setPhone($phone)
            ->setPostalAddress($postalAddress)
            ->setRelationshipToPax($relationshipToPax);
    }
    /**
     * Get ContactInfoID value
     * @return string
     */
    public function getContactInfoID()
    {
        return $this->ContactInfoID;
    }
    /**
     * Set ContactInfoID value
     * @param string $contactInfoID
     * @return \StructType\ContactInfoType
     */
    public function setContactInfoID($contactInfoID = null)
    {
        // validation for constraint: string
        if (!is_null($contactInfoID) && !is_string($contactInfoID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactInfoID, true), gettype($contactInfoID)), __LINE__);
        }
        $this->ContactInfoID = $contactInfoID;
        return $this;
    }
    /**
     * Get ContactPurposeText value
     * @return string[]|null
     */
    public function getContactPurposeText()
    {
        return $this->ContactPurposeText;
    }
    /**
     * This method is responsible for validating the values passed to the setContactPurposeText method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactPurposeText method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactPurposeTextForArrayConstraintsFromSetContactPurposeText(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contactInfoTypeContactPurposeTextItem) {
            // validation for constraint: itemType
            if (!is_string($contactInfoTypeContactPurposeTextItem)) {
                $invalidValues[] = is_object($contactInfoTypeContactPurposeTextItem) ? get_class($contactInfoTypeContactPurposeTextItem) : sprintf('%s(%s)', gettype($contactInfoTypeContactPurposeTextItem), var_export($contactInfoTypeContactPurposeTextItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContactPurposeText property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContactPurposeText value
     * @throws \InvalidArgumentException
     * @param string[] $contactPurposeText
     * @return \StructType\ContactInfoType
     */
    public function setContactPurposeText(array $contactPurposeText = array())
    {
        // validation for constraint: array
        if ('' !== ($contactPurposeTextArrayErrorMessage = self::validateContactPurposeTextForArrayConstraintsFromSetContactPurposeText($contactPurposeText))) {
            throw new \InvalidArgumentException($contactPurposeTextArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($contactPurposeText) && count($contactPurposeText) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($contactPurposeText)), __LINE__);
        }
        $this->ContactPurposeText = $contactPurposeText;
        return $this;
    }
    /**
     * Add item to ContactPurposeText value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ContactInfoType
     */
    public function addToContactPurposeText($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ContactPurposeText property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->ContactPurposeText) && count($this->ContactPurposeText) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->ContactPurposeText)), __LINE__);
        }
        $this->ContactPurposeText[] = $item;
        return $this;
    }
    /**
     * Get ContactRefusedInd value
     * @return bool|null
     */
    public function getContactRefusedInd()
    {
        return $this->ContactRefusedInd;
    }
    /**
     * Set ContactRefusedInd value
     * @param bool $contactRefusedInd
     * @return \StructType\ContactInfoType
     */
    public function setContactRefusedInd($contactRefusedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($contactRefusedInd) && !is_bool($contactRefusedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($contactRefusedInd, true), gettype($contactRefusedInd)), __LINE__);
        }
        $this->ContactRefusedInd = $contactRefusedInd;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return \StructType\EmailAddressType[]|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * This method is responsible for validating the values passed to the setEmailAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmailAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmailAddressForArrayConstraintsFromSetEmailAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contactInfoTypeEmailAddressItem) {
            // validation for constraint: itemType
            if (!$contactInfoTypeEmailAddressItem instanceof \StructType\EmailAddressType) {
                $invalidValues[] = is_object($contactInfoTypeEmailAddressItem) ? get_class($contactInfoTypeEmailAddressItem) : sprintf('%s(%s)', gettype($contactInfoTypeEmailAddressItem), var_export($contactInfoTypeEmailAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EmailAddress property can only contain items of type \StructType\EmailAddressType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EmailAddress value
     * @throws \InvalidArgumentException
     * @param \StructType\EmailAddressType[] $emailAddress
     * @return \StructType\ContactInfoType
     */
    public function setEmailAddress(array $emailAddress = array())
    {
        // validation for constraint: array
        if ('' !== ($emailAddressArrayErrorMessage = self::validateEmailAddressForArrayConstraintsFromSetEmailAddress($emailAddress))) {
            throw new \InvalidArgumentException($emailAddressArrayErrorMessage, __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Add item to EmailAddress value
     * @throws \InvalidArgumentException
     * @param \StructType\EmailAddressType $item
     * @return \StructType\ContactInfoType
     */
    public function addToEmailAddress(\StructType\EmailAddressType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EmailAddressType) {
            throw new \InvalidArgumentException(sprintf('The EmailAddress property can only contain items of type \StructType\EmailAddressType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EmailAddress[] = $item;
        return $this;
    }
    /**
     * Get Individual value
     * @return \StructType\IndividualType|null
     */
    public function getIndividual()
    {
        return $this->Individual;
    }
    /**
     * Set Individual value
     * @param \StructType\IndividualType $individual
     * @return \StructType\ContactInfoType
     */
    public function setIndividual(\StructType\IndividualType $individual = null)
    {
        $this->Individual = $individual;
        return $this;
    }
    /**
     * Get IndividualRefID value
     * @return string|null
     */
    public function getIndividualRefID()
    {
        return $this->IndividualRefID;
    }
    /**
     * Set IndividualRefID value
     * @param string $individualRefID
     * @return \StructType\ContactInfoType
     */
    public function setIndividualRefID($individualRefID = null)
    {
        // validation for constraint: string
        if (!is_null($individualRefID) && !is_string($individualRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($individualRefID, true), gettype($individualRefID)), __LINE__);
        }
        $this->IndividualRefID = $individualRefID;
        return $this;
    }
    /**
     * Get OtherAddress value
     * @return \StructType\OtherAddressType[]|null
     */
    public function getOtherAddress()
    {
        return $this->OtherAddress;
    }
    /**
     * This method is responsible for validating the values passed to the setOtherAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOtherAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOtherAddressForArrayConstraintsFromSetOtherAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contactInfoTypeOtherAddressItem) {
            // validation for constraint: itemType
            if (!$contactInfoTypeOtherAddressItem instanceof \StructType\OtherAddressType) {
                $invalidValues[] = is_object($contactInfoTypeOtherAddressItem) ? get_class($contactInfoTypeOtherAddressItem) : sprintf('%s(%s)', gettype($contactInfoTypeOtherAddressItem), var_export($contactInfoTypeOtherAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OtherAddress property can only contain items of type \StructType\OtherAddressType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OtherAddress value
     * @throws \InvalidArgumentException
     * @param \StructType\OtherAddressType[] $otherAddress
     * @return \StructType\ContactInfoType
     */
    public function setOtherAddress(array $otherAddress = array())
    {
        // validation for constraint: array
        if ('' !== ($otherAddressArrayErrorMessage = self::validateOtherAddressForArrayConstraintsFromSetOtherAddress($otherAddress))) {
            throw new \InvalidArgumentException($otherAddressArrayErrorMessage, __LINE__);
        }
        $this->OtherAddress = $otherAddress;
        return $this;
    }
    /**
     * Add item to OtherAddress value
     * @throws \InvalidArgumentException
     * @param \StructType\OtherAddressType $item
     * @return \StructType\ContactInfoType
     */
    public function addToOtherAddress(\StructType\OtherAddressType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OtherAddressType) {
            throw new \InvalidArgumentException(sprintf('The OtherAddress property can only contain items of type \StructType\OtherAddressType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OtherAddress[] = $item;
        return $this;
    }
    /**
     * Get PaxSegmentRefID value
     * @return string|null
     */
    public function getPaxSegmentRefID()
    {
        return $this->PaxSegmentRefID;
    }
    /**
     * Set PaxSegmentRefID value
     * @param string $paxSegmentRefID
     * @return \StructType\ContactInfoType
     */
    public function setPaxSegmentRefID($paxSegmentRefID = null)
    {
        // validation for constraint: string
        if (!is_null($paxSegmentRefID) && !is_string($paxSegmentRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxSegmentRefID, true), gettype($paxSegmentRefID)), __LINE__);
        }
        $this->PaxSegmentRefID = $paxSegmentRefID;
        return $this;
    }
    /**
     * Get Phone value
     * @return \StructType\PhoneType[]|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * This method is responsible for validating the values passed to the setPhone method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPhone method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePhoneForArrayConstraintsFromSetPhone(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contactInfoTypePhoneItem) {
            // validation for constraint: itemType
            if (!$contactInfoTypePhoneItem instanceof \StructType\PhoneType) {
                $invalidValues[] = is_object($contactInfoTypePhoneItem) ? get_class($contactInfoTypePhoneItem) : sprintf('%s(%s)', gettype($contactInfoTypePhoneItem), var_export($contactInfoTypePhoneItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Phone property can only contain items of type \StructType\PhoneType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Phone value
     * @throws \InvalidArgumentException
     * @param \StructType\PhoneType[] $phone
     * @return \StructType\ContactInfoType
     */
    public function setPhone(array $phone = array())
    {
        // validation for constraint: array
        if ('' !== ($phoneArrayErrorMessage = self::validatePhoneForArrayConstraintsFromSetPhone($phone))) {
            throw new \InvalidArgumentException($phoneArrayErrorMessage, __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Add item to Phone value
     * @throws \InvalidArgumentException
     * @param \StructType\PhoneType $item
     * @return \StructType\ContactInfoType
     */
    public function addToPhone(\StructType\PhoneType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PhoneType) {
            throw new \InvalidArgumentException(sprintf('The Phone property can only contain items of type \StructType\PhoneType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Phone[] = $item;
        return $this;
    }
    /**
     * Get PostalAddress value
     * @return \StructType\PostalAddressType[]|null
     */
    public function getPostalAddress()
    {
        return $this->PostalAddress;
    }
    /**
     * This method is responsible for validating the values passed to the setPostalAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPostalAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePostalAddressForArrayConstraintsFromSetPostalAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contactInfoTypePostalAddressItem) {
            // validation for constraint: itemType
            if (!$contactInfoTypePostalAddressItem instanceof \StructType\PostalAddressType) {
                $invalidValues[] = is_object($contactInfoTypePostalAddressItem) ? get_class($contactInfoTypePostalAddressItem) : sprintf('%s(%s)', gettype($contactInfoTypePostalAddressItem), var_export($contactInfoTypePostalAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PostalAddress property can only contain items of type \StructType\PostalAddressType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PostalAddress value
     * @throws \InvalidArgumentException
     * @param \StructType\PostalAddressType[] $postalAddress
     * @return \StructType\ContactInfoType
     */
    public function setPostalAddress(array $postalAddress = array())
    {
        // validation for constraint: array
        if ('' !== ($postalAddressArrayErrorMessage = self::validatePostalAddressForArrayConstraintsFromSetPostalAddress($postalAddress))) {
            throw new \InvalidArgumentException($postalAddressArrayErrorMessage, __LINE__);
        }
        $this->PostalAddress = $postalAddress;
        return $this;
    }
    /**
     * Add item to PostalAddress value
     * @throws \InvalidArgumentException
     * @param \StructType\PostalAddressType $item
     * @return \StructType\ContactInfoType
     */
    public function addToPostalAddress(\StructType\PostalAddressType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PostalAddressType) {
            throw new \InvalidArgumentException(sprintf('The PostalAddress property can only contain items of type \StructType\PostalAddressType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PostalAddress[] = $item;
        return $this;
    }
    /**
     * Get RelationshipToPax value
     * @return string|null
     */
    public function getRelationshipToPax()
    {
        return $this->RelationshipToPax;
    }
    /**
     * Set RelationshipToPax value
     * @param string $relationshipToPax
     * @return \StructType\ContactInfoType
     */
    public function setRelationshipToPax($relationshipToPax = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipToPax) && !is_string($relationshipToPax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationshipToPax, true), gettype($relationshipToPax)), __LINE__);
        }
        $this->RelationshipToPax = $relationshipToPax;
        return $this;
    }
}
