<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Combinability StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides rules on allowable combinations between priceclasses, services and other items.
 * @subpackage Structs
 */
class Combinability extends AbstractStructBase
{
    /**
     * The Association
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Association[]
     */
    public $Association;
    /**
     * Constructor method for Combinability
     * @uses Combinability::setAssociation()
     * @param \StructType\Association[] $association
     */
    public function __construct(array $association = array())
    {
        $this
            ->setAssociation($association);
    }
    /**
     * Get Association value
     * @return \StructType\Association[]|null
     */
    public function getAssociation()
    {
        return $this->Association;
    }
    /**
     * This method is responsible for validating the values passed to the setAssociation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAssociation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAssociationForArrayConstraintsFromSetAssociation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $combinabilityAssociationItem) {
            // validation for constraint: itemType
            if (!$combinabilityAssociationItem instanceof \StructType\Association) {
                $invalidValues[] = is_object($combinabilityAssociationItem) ? get_class($combinabilityAssociationItem) : sprintf('%s(%s)', gettype($combinabilityAssociationItem), var_export($combinabilityAssociationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Association property can only contain items of type \StructType\Association, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Association value
     * @throws \InvalidArgumentException
     * @param \StructType\Association[] $association
     * @return \StructType\Combinability
     */
    public function setAssociation(array $association = array())
    {
        // validation for constraint: array
        if ('' !== ($associationArrayErrorMessage = self::validateAssociationForArrayConstraintsFromSetAssociation($association))) {
            throw new \InvalidArgumentException($associationArrayErrorMessage, __LINE__);
        }
        $this->Association = $association;
        return $this;
    }
    /**
     * Add item to Association value
     * @throws \InvalidArgumentException
     * @param \StructType\Association $item
     * @return \StructType\Combinability
     */
    public function addToAssociation(\StructType\Association $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Association) {
            throw new \InvalidArgumentException(sprintf('The Association property can only contain items of type \StructType\Association, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Association[] = $item;
        return $this;
    }
}
