<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CodesetMetadataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Pre-defined code set metadata.
 * @subpackage Structs
 */
class CodesetMetadataType extends AbstractStructBase
{
    /**
     * The CodesetName
     * Meta information extracted from the WSDL
     * - documentation: Name of the codeset (e.g. PADIS Codeset) | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodesetName;
    /**
     * The CodesetVersionNumber
     * Meta information extracted from the WSDL
     * - documentation: Codeset version number. Ex: 14 | A mathematical number that is assigned or is determined by calculation.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $CodesetVersionNumber;
    /**
     * The LangUsage
     * Meta information extracted from the WSDL
     * - documentation: Language Code representation.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LangUsageType
     */
    public $LangUsage;
    /**
     * The OwnerID
     * Meta information extracted from the WSDL
     * - documentation: Owner entity ID. Example: BA | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OwnerID;
    /**
     * The OwnerName
     * Meta information extracted from the WSDL
     * - documentation: Owner Entity Name. Ex: British Airways | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OwnerName;
    /**
     * Constructor method for CodesetMetadataType
     * @uses CodesetMetadataType::setCodesetName()
     * @uses CodesetMetadataType::setCodesetVersionNumber()
     * @uses CodesetMetadataType::setLangUsage()
     * @uses CodesetMetadataType::setOwnerID()
     * @uses CodesetMetadataType::setOwnerName()
     * @param string $codesetName
     * @param float $codesetVersionNumber
     * @param \StructType\LangUsageType $langUsage
     * @param string $ownerID
     * @param string $ownerName
     */
    public function __construct($codesetName = null, $codesetVersionNumber = null, \StructType\LangUsageType $langUsage = null, $ownerID = null, $ownerName = null)
    {
        $this
            ->setCodesetName($codesetName)
            ->setCodesetVersionNumber($codesetVersionNumber)
            ->setLangUsage($langUsage)
            ->setOwnerID($ownerID)
            ->setOwnerName($ownerName);
    }
    /**
     * Get CodesetName value
     * @return string|null
     */
    public function getCodesetName()
    {
        return $this->CodesetName;
    }
    /**
     * Set CodesetName value
     * @param string $codesetName
     * @return \StructType\CodesetMetadataType
     */
    public function setCodesetName($codesetName = null)
    {
        // validation for constraint: string
        if (!is_null($codesetName) && !is_string($codesetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codesetName, true), gettype($codesetName)), __LINE__);
        }
        $this->CodesetName = $codesetName;
        return $this;
    }
    /**
     * Get CodesetVersionNumber value
     * @return float|null
     */
    public function getCodesetVersionNumber()
    {
        return $this->CodesetVersionNumber;
    }
    /**
     * Set CodesetVersionNumber value
     * @param float $codesetVersionNumber
     * @return \StructType\CodesetMetadataType
     */
    public function setCodesetVersionNumber($codesetVersionNumber = null)
    {
        // validation for constraint: float
        if (!is_null($codesetVersionNumber) && !(is_float($codesetVersionNumber) || is_numeric($codesetVersionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($codesetVersionNumber, true), gettype($codesetVersionNumber)), __LINE__);
        }
        $this->CodesetVersionNumber = $codesetVersionNumber;
        return $this;
    }
    /**
     * Get LangUsage value
     * @return \StructType\LangUsageType|null
     */
    public function getLangUsage()
    {
        return $this->LangUsage;
    }
    /**
     * Set LangUsage value
     * @param \StructType\LangUsageType $langUsage
     * @return \StructType\CodesetMetadataType
     */
    public function setLangUsage(\StructType\LangUsageType $langUsage = null)
    {
        $this->LangUsage = $langUsage;
        return $this;
    }
    /**
     * Get OwnerID value
     * @return string|null
     */
    public function getOwnerID()
    {
        return $this->OwnerID;
    }
    /**
     * Set OwnerID value
     * @param string $ownerID
     * @return \StructType\CodesetMetadataType
     */
    public function setOwnerID($ownerID = null)
    {
        // validation for constraint: string
        if (!is_null($ownerID) && !is_string($ownerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerID, true), gettype($ownerID)), __LINE__);
        }
        $this->OwnerID = $ownerID;
        return $this;
    }
    /**
     * Get OwnerName value
     * @return string|null
     */
    public function getOwnerName()
    {
        return $this->OwnerName;
    }
    /**
     * Set OwnerName value
     * @param string $ownerName
     * @return \StructType\CodesetMetadataType
     */
    public function setOwnerName($ownerName = null)
    {
        // validation for constraint: string
        if (!is_null($ownerName) && !is_string($ownerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerName, true), gettype($ownerName)), __LINE__);
        }
        $this->OwnerName = $ownerName;
        return $this;
    }
}
