<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClearanceTravelAgencyType StructType
 * Meta information extracted from the WSDL
 * - documentation: A private retailer or public service that provides travel and tourism related services to the public on behalf of suppliers such as activities, airlines, car rentals, cruise lines, hotels, railways, travel insurance, and package
 * tours.
 * @subpackage Structs
 */
class ClearanceTravelAgencyType extends AbstractStructBase
{
    /**
     * The IATA_Number
     * Meta information extracted from the WSDL
     * - documentation: IATA-assigned agency number. Example: 98417900 | A mathematical number that is assigned or is determined by calculation.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $IATA_Number;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Agency name. Example: Carson Travel | BDT with value constraints for proper, regular names (e.g. Individual Surname, Individual First Name, Company Name, etc.).
     * - base: xs:token
     * - maxLength: 64
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * Constructor method for ClearanceTravelAgencyType
     * @uses ClearanceTravelAgencyType::setIATA_Number()
     * @uses ClearanceTravelAgencyType::setName()
     * @param float $iATA_Number
     * @param string $name
     */
    public function __construct($iATA_Number = null, $name = null)
    {
        $this
            ->setIATA_Number($iATA_Number)
            ->setName($name);
    }
    /**
     * Get IATA_Number value
     * @return float
     */
    public function getIATA_Number()
    {
        return $this->IATA_Number;
    }
    /**
     * Set IATA_Number value
     * @param float $iATA_Number
     * @return \StructType\ClearanceTravelAgencyType
     */
    public function setIATA_Number($iATA_Number = null)
    {
        // validation for constraint: float
        if (!is_null($iATA_Number) && !(is_float($iATA_Number) || is_numeric($iATA_Number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($iATA_Number, true), gettype($iATA_Number)), __LINE__);
        }
        $this->IATA_Number = $iATA_Number;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\ClearanceTravelAgencyType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($name) && mb_strlen($name) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($name)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($name) && mb_strlen($name) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
}
