<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClearanceRoleChoiceType StructType
 * Meta information extracted from the WSDL
 * - documentation: Choice by the party providing the payment processing details or committing the payment of its role in the clearance process, either a Clearance Payer or Clearance Payee.
 * @subpackage Structs
 */
class ClearanceRoleChoiceType extends AbstractStructBase
{
    /**
     * The ClearancePayeeData
     * Meta information extracted from the WSDL
     * - documentation: Data defining the Clearance Payee and relevant to its operations.
     * - choice: ClearancePayeeData | ClearancePayerData
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ClearancePayeeDataType
     */
    public $ClearancePayeeData;
    /**
     * The ClearancePayerData
     * Meta information extracted from the WSDL
     * - documentation: Data defining the Clearance Payer and relevant to its operations.
     * - choice: ClearancePayeeData | ClearancePayerData
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ClearancePayerDataType
     */
    public $ClearancePayerData;
    /**
     * Constructor method for ClearanceRoleChoiceType
     * @uses ClearanceRoleChoiceType::setClearancePayeeData()
     * @uses ClearanceRoleChoiceType::setClearancePayerData()
     * @param \StructType\ClearancePayeeDataType $clearancePayeeData
     * @param \StructType\ClearancePayerDataType $clearancePayerData
     */
    public function __construct(\StructType\ClearancePayeeDataType $clearancePayeeData = null, \StructType\ClearancePayerDataType $clearancePayerData = null)
    {
        $this
            ->setClearancePayeeData($clearancePayeeData)
            ->setClearancePayerData($clearancePayerData);
    }
    /**
     * Get ClearancePayeeData value
     * @return \StructType\ClearancePayeeDataType
     */
    public function getClearancePayeeData()
    {
        return isset($this->ClearancePayeeData) ? $this->ClearancePayeeData : null;
    }
    /**
     * This method is responsible for validating the value passed to the setClearancePayeeData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClearancePayeeData method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateClearancePayeeDataForChoiceConstraintsFromSetClearancePayeeData($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ClearancePayerData',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ClearancePayeeData can\'t be set as the property %s is already set. Only one property must be set among these properties: ClearancePayeeData, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ClearancePayeeData value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ClearancePayeeDataType $clearancePayeeData
     * @return \StructType\ClearanceRoleChoiceType
     */
    public function setClearancePayeeData(\StructType\ClearancePayeeDataType $clearancePayeeData = null)
    {
        // validation for constraint: choice(ClearancePayeeData, ClearancePayerData)
        if ('' !== ($clearancePayeeDataChoiceErrorMessage = self::validateClearancePayeeDataForChoiceConstraintsFromSetClearancePayeeData($clearancePayeeData))) {
            throw new \InvalidArgumentException($clearancePayeeDataChoiceErrorMessage, __LINE__);
        }
        if (is_null($clearancePayeeData) || (is_array($clearancePayeeData) && empty($clearancePayeeData))) {
            unset($this->ClearancePayeeData);
        } else {
            $this->ClearancePayeeData = $clearancePayeeData;
        }
        return $this;
    }
    /**
     * Get ClearancePayerData value
     * @return \StructType\ClearancePayerDataType
     */
    public function getClearancePayerData()
    {
        return isset($this->ClearancePayerData) ? $this->ClearancePayerData : null;
    }
    /**
     * This method is responsible for validating the value passed to the setClearancePayerData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClearancePayerData method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateClearancePayerDataForChoiceConstraintsFromSetClearancePayerData($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ClearancePayeeData',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ClearancePayerData can\'t be set as the property %s is already set. Only one property must be set among these properties: ClearancePayerData, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ClearancePayerData value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ClearancePayerDataType $clearancePayerData
     * @return \StructType\ClearanceRoleChoiceType
     */
    public function setClearancePayerData(\StructType\ClearancePayerDataType $clearancePayerData = null)
    {
        // validation for constraint: choice(ClearancePayeeData, ClearancePayerData)
        if ('' !== ($clearancePayerDataChoiceErrorMessage = self::validateClearancePayerDataForChoiceConstraintsFromSetClearancePayerData($clearancePayerData))) {
            throw new \InvalidArgumentException($clearancePayerDataChoiceErrorMessage, __LINE__);
        }
        if (is_null($clearancePayerData) || (is_array($clearancePayerData) && empty($clearancePayerData))) {
            unset($this->ClearancePayerData);
        } else {
            $this->ClearancePayerData = $clearancePayerData;
        }
        return $this;
    }
}
