<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClearancePayerDataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Data defining the Clearance Payer and relevant to its operations.
 * @subpackage Structs
 */
class ClearancePayerDataType extends AbstractStructBase
{
    /**
     * The ClearancePayer
     * Meta information extracted from the WSDL
     * - documentation: The party paying funds to clear claims against itself
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ClearancePayerType
     */
    public $ClearancePayer;
    /**
     * The ClearancePayerReconciliationID
     * Meta information extracted from the WSDL
     * - documentation: Identifier provided by the Clearance Payer to support internal financial processes, for example reconciliation. If this identifier is included in the clearance request then it must be included in all messages thereafter where it is
     * provided as an option. | Airline Reference identifier is a character string that is managed by the carrier.
     * - base: xs:token
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * - pattern: ([A-Za-z0-9]{1,15})
     * @var string
     */
    public $ClearancePayerReconciliationID;
    /**
     * Constructor method for ClearancePayerDataType
     * @uses ClearancePayerDataType::setClearancePayer()
     * @uses ClearancePayerDataType::setClearancePayerReconciliationID()
     * @param \StructType\ClearancePayerType $clearancePayer
     * @param string $clearancePayerReconciliationID
     */
    public function __construct(\StructType\ClearancePayerType $clearancePayer = null, $clearancePayerReconciliationID = null)
    {
        $this
            ->setClearancePayer($clearancePayer)
            ->setClearancePayerReconciliationID($clearancePayerReconciliationID);
    }
    /**
     * Get ClearancePayer value
     * @return \StructType\ClearancePayerType
     */
    public function getClearancePayer()
    {
        return $this->ClearancePayer;
    }
    /**
     * Set ClearancePayer value
     * @param \StructType\ClearancePayerType $clearancePayer
     * @return \StructType\ClearancePayerDataType
     */
    public function setClearancePayer(\StructType\ClearancePayerType $clearancePayer = null)
    {
        $this->ClearancePayer = $clearancePayer;
        return $this;
    }
    /**
     * Get ClearancePayerReconciliationID value
     * @return string|null
     */
    public function getClearancePayerReconciliationID()
    {
        return $this->ClearancePayerReconciliationID;
    }
    /**
     * Set ClearancePayerReconciliationID value
     * @param string $clearancePayerReconciliationID
     * @return \StructType\ClearancePayerDataType
     */
    public function setClearancePayerReconciliationID($clearancePayerReconciliationID = null)
    {
        // validation for constraint: string
        if (!is_null($clearancePayerReconciliationID) && !is_string($clearancePayerReconciliationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clearancePayerReconciliationID, true), gettype($clearancePayerReconciliationID)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($clearancePayerReconciliationID) && mb_strlen($clearancePayerReconciliationID) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($clearancePayerReconciliationID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($clearancePayerReconciliationID) && mb_strlen($clearancePayerReconciliationID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($clearancePayerReconciliationID)), __LINE__);
        }
        // validation for constraint: pattern(([A-Za-z0-9]{1,15}))
        if (!is_null($clearancePayerReconciliationID) && !preg_match('/([A-Za-z0-9]{1,15})/', $clearancePayerReconciliationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Za-z0-9]{1,15})', var_export($clearancePayerReconciliationID, true)), __LINE__);
        }
        $this->ClearancePayerReconciliationID = $clearancePayerReconciliationID;
        return $this;
    }
}
