<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClassOfService StructType
 * Meta information extracted from the WSDL
 * - documentation: Booking class of service to be applied for this Segment when booked as part of this FareGroup. Example: B | Class Of Service Example "B" | Basic definition of air ClassOfService. Alpha-coded. Usually single char.
 * - base: xs:string
 * - maxLength: 2
 * - minLength: 1
 * @subpackage Structs
 */
class ClassOfService extends AbstractStructBase
{
    /**
     * The Code
     * @var \StructType\Code
     */
    public $Code;
    /**
     * The MarketingName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MarketingName
     */
    public $MarketingName;
    /**
     * The refs
     * Meta information extracted from the WSDL
     * - documentation: Object association(s) between this object and any other object or metadata instance(s). | A data type definition for Globally Unique XML Instance or Other Class Reference Association size constraint. | A data type for an
     * InstanceClassRefSimpleType Association.
     * - base: InstanceClassRefSimpleType
     * - use: optional
     * @var string
     */
    public $refs;
    /**
     * The _
     * Meta information extracted from the WSDL
     * - documentation: Basic definition of air ClassOfService. Alpha-coded. Usually single char.
     * - base: xs:string
     * - maxLength: 2
     * - minLength: 1
     * @var string
     */
    public $_;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The PriceClassName
     * Meta information extracted from the WSDL
     * - documentation: Price Class associated to this CoS, e.g. TANGO
     * - type: xs:string
     * @var string
     */
    public $PriceClassName;
    /**
     * Constructor method for ClassOfService
     * @uses ClassOfService::setCode()
     * @uses ClassOfService::setMarketingName()
     * @uses ClassOfService::setRefs()
     * @uses ClassOfService::set_()
     * @uses ClassOfService::setStatus()
     * @uses ClassOfService::setPriceClassName()
     * @param \StructType\Code $code
     * @param \StructType\MarketingName $marketingName
     * @param string $refs
     * @param string $_
     * @param string $status
     * @param string $priceClassName
     */
    public function __construct(\StructType\Code $code = null, \StructType\MarketingName $marketingName = null, $refs = null, $_ = null, $status = null, $priceClassName = null)
    {
        $this
            ->setCode($code)
            ->setMarketingName($marketingName)
            ->setRefs($refs)
            ->set_($_)
            ->setStatus($status)
            ->setPriceClassName($priceClassName);
    }
    /**
     * Get Code value
     * @return \StructType\Code|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param \StructType\Code $code
     * @return \StructType\ClassOfService
     */
    public function setCode(\StructType\Code $code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get MarketingName value
     * @return \StructType\MarketingName|null
     */
    public function getMarketingName()
    {
        return $this->MarketingName;
    }
    /**
     * Set MarketingName value
     * @param \StructType\MarketingName $marketingName
     * @return \StructType\ClassOfService
     */
    public function setMarketingName(\StructType\MarketingName $marketingName = null)
    {
        $this->MarketingName = $marketingName;
        return $this;
    }
    /**
     * Get refs value
     * @return string|null
     */
    public function getRefs()
    {
        return $this->refs;
    }
    /**
     * Set refs value
     * @param string $refs
     * @return \StructType\ClassOfService
     */
    public function setRefs($refs = null)
    {
        // validation for constraint: string
        if (!is_null($refs) && !is_string($refs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refs, true), gettype($refs)), __LINE__);
        }
        $this->refs = $refs;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\ClassOfService
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($_) && mb_strlen($_) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($_)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($_) && mb_strlen($_) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\ClassOfService
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get PriceClassName value
     * @return string|null
     */
    public function getPriceClassName()
    {
        return $this->PriceClassName;
    }
    /**
     * Set PriceClassName value
     * @param string $priceClassName
     * @return \StructType\ClassOfService
     */
    public function setPriceClassName($priceClassName = null)
    {
        // validation for constraint: string
        if (!is_null($priceClassName) && !is_string($priceClassName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceClassName, true), gettype($priceClassName)), __LINE__);
        }
        $this->PriceClassName = $priceClassName;
        return $this;
    }
}
