<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangeOperationGroupType StructType
 * Meta information extracted from the WSDL
 * - documentation: Change Operation Group is a logical grouping of one or more operations that leads to a new Order Version. Should not have multiple change operations to the same element.
 * @subpackage Structs
 */
class ChangeOperationGroupType extends AbstractStructBase
{
    /**
     * The ChangeOperation
     * Meta information extracted from the WSDL
     * - documentation: Change Operation is an Instruction on addition, replacement or deletion of elements within an Order.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\ChangeOperationType[]
     */
    public $ChangeOperation;
    /**
     * The OrderVersionNumber
     * Meta information extracted from the WSDL
     * - documentation: Version of the Order | Order version number BDT.
     * - base: xs:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrderVersionNumber;
    /**
     * The DistibutionChain
     * Meta information extracted from the WSDL
     * - documentation: An organization playing a participating role in an instance of a distribution channel.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DistributionChainLinkType[]
     */
    public $DistibutionChain;
    /**
     * Constructor method for ChangeOperationGroupType
     * @uses ChangeOperationGroupType::setChangeOperation()
     * @uses ChangeOperationGroupType::setOrderVersionNumber()
     * @uses ChangeOperationGroupType::setDistibutionChain()
     * @param \StructType\ChangeOperationType[] $changeOperation
     * @param int $orderVersionNumber
     * @param \StructType\DistributionChainLinkType[] $distibutionChain
     */
    public function __construct(array $changeOperation = array(), $orderVersionNumber = null, array $distibutionChain = array())
    {
        $this
            ->setChangeOperation($changeOperation)
            ->setOrderVersionNumber($orderVersionNumber)
            ->setDistibutionChain($distibutionChain);
    }
    /**
     * Get ChangeOperation value
     * @return \StructType\ChangeOperationType[]
     */
    public function getChangeOperation()
    {
        return $this->ChangeOperation;
    }
    /**
     * This method is responsible for validating the values passed to the setChangeOperation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setChangeOperation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChangeOperationForArrayConstraintsFromSetChangeOperation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $changeOperationGroupTypeChangeOperationItem) {
            // validation for constraint: itemType
            if (!$changeOperationGroupTypeChangeOperationItem instanceof \StructType\ChangeOperationType) {
                $invalidValues[] = is_object($changeOperationGroupTypeChangeOperationItem) ? get_class($changeOperationGroupTypeChangeOperationItem) : sprintf('%s(%s)', gettype($changeOperationGroupTypeChangeOperationItem), var_export($changeOperationGroupTypeChangeOperationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ChangeOperation property can only contain items of type \StructType\ChangeOperationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ChangeOperation value
     * @throws \InvalidArgumentException
     * @param \StructType\ChangeOperationType[] $changeOperation
     * @return \StructType\ChangeOperationGroupType
     */
    public function setChangeOperation(array $changeOperation = array())
    {
        // validation for constraint: array
        if ('' !== ($changeOperationArrayErrorMessage = self::validateChangeOperationForArrayConstraintsFromSetChangeOperation($changeOperation))) {
            throw new \InvalidArgumentException($changeOperationArrayErrorMessage, __LINE__);
        }
        $this->ChangeOperation = $changeOperation;
        return $this;
    }
    /**
     * Add item to ChangeOperation value
     * @throws \InvalidArgumentException
     * @param \StructType\ChangeOperationType $item
     * @return \StructType\ChangeOperationGroupType
     */
    public function addToChangeOperation(\StructType\ChangeOperationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ChangeOperationType) {
            throw new \InvalidArgumentException(sprintf('The ChangeOperation property can only contain items of type \StructType\ChangeOperationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ChangeOperation[] = $item;
        return $this;
    }
    /**
     * Get OrderVersionNumber value
     * @return int
     */
    public function getOrderVersionNumber()
    {
        return $this->OrderVersionNumber;
    }
    /**
     * Set OrderVersionNumber value
     * @param int $orderVersionNumber
     * @return \StructType\ChangeOperationGroupType
     */
    public function setOrderVersionNumber($orderVersionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($orderVersionNumber) && !(is_int($orderVersionNumber) || ctype_digit($orderVersionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderVersionNumber, true), gettype($orderVersionNumber)), __LINE__);
        }
        $this->OrderVersionNumber = $orderVersionNumber;
        return $this;
    }
    /**
     * Get DistibutionChain value
     * @return \StructType\DistributionChainLinkType[]|null
     */
    public function getDistibutionChain()
    {
        return $this->DistibutionChain;
    }
    /**
     * This method is responsible for validating the values passed to the setDistibutionChain method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDistibutionChain method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDistibutionChainForArrayConstraintsFromSetDistibutionChain(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $changeOperationGroupTypeDistibutionChainItem) {
            // validation for constraint: itemType
            if (!$changeOperationGroupTypeDistibutionChainItem instanceof \StructType\DistributionChainLinkType) {
                $invalidValues[] = is_object($changeOperationGroupTypeDistibutionChainItem) ? get_class($changeOperationGroupTypeDistibutionChainItem) : sprintf('%s(%s)', gettype($changeOperationGroupTypeDistibutionChainItem), var_export($changeOperationGroupTypeDistibutionChainItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DistibutionChain property can only contain items of type \StructType\DistributionChainLinkType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DistibutionChain value
     * @throws \InvalidArgumentException
     * @param \StructType\DistributionChainLinkType[] $distibutionChain
     * @return \StructType\ChangeOperationGroupType
     */
    public function setDistibutionChain(array $distibutionChain = array())
    {
        // validation for constraint: array
        if ('' !== ($distibutionChainArrayErrorMessage = self::validateDistibutionChainForArrayConstraintsFromSetDistibutionChain($distibutionChain))) {
            throw new \InvalidArgumentException($distibutionChainArrayErrorMessage, __LINE__);
        }
        $this->DistibutionChain = $distibutionChain;
        return $this;
    }
    /**
     * Add item to DistibutionChain value
     * @throws \InvalidArgumentException
     * @param \StructType\DistributionChainLinkType $item
     * @return \StructType\ChangeOperationGroupType
     */
    public function addToDistibutionChain(\StructType\DistributionChainLinkType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DistributionChainLinkType) {
            throw new \InvalidArgumentException(sprintf('The DistibutionChain property can only contain items of type \StructType\DistributionChainLinkType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DistibutionChain[] = $item;
        return $this;
    }
}
