<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CarrierType StructType
 * Meta information extracted from the WSDL
 * - documentation: The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc. | The organization which carries the
 * passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc. Business Identifier Fields: - Airline Designator Code - Duplicate Designator Indicator - Name
 * @subpackage Structs
 */
class CarrierType extends AbstractStructBase
{
    /**
     * The AirlineDesigCode
     * Meta information extracted from the WSDL
     * - documentation: Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code. | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or
     * ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName}
     * {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $AirlineDesigCode;
    /**
     * The DuplicateDesigInd
     * Meta information extracted from the WSDL
     * - documentation: Indicates that the IATA Airline Designator is a duplicate code shared by multiple airlines. To identify the airline - in this case - its name must be specified in addition to the designator. | An indicator is a list of two mutually
     * exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $DuplicateDesigInd;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Commercial name of the carrier. | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * Constructor method for CarrierType
     * @uses CarrierType::setAirlineDesigCode()
     * @uses CarrierType::setDuplicateDesigInd()
     * @uses CarrierType::setName()
     * @param string $airlineDesigCode
     * @param bool $duplicateDesigInd
     * @param string $name
     */
    public function __construct($airlineDesigCode = null, $duplicateDesigInd = null, $name = null)
    {
        $this
            ->setAirlineDesigCode($airlineDesigCode)
            ->setDuplicateDesigInd($duplicateDesigInd)
            ->setName($name);
    }
    /**
     * Get AirlineDesigCode value
     * @return string|null
     */
    public function getAirlineDesigCode()
    {
        return $this->AirlineDesigCode;
    }
    /**
     * Set AirlineDesigCode value
     * @param string $airlineDesigCode
     * @return \StructType\CarrierType
     */
    public function setAirlineDesigCode($airlineDesigCode = null)
    {
        // validation for constraint: string
        if (!is_null($airlineDesigCode) && !is_string($airlineDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airlineDesigCode, true), gettype($airlineDesigCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($airlineDesigCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $airlineDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($airlineDesigCode, true)), __LINE__);
        }
        $this->AirlineDesigCode = $airlineDesigCode;
        return $this;
    }
    /**
     * Get DuplicateDesigInd value
     * @return bool|null
     */
    public function getDuplicateDesigInd()
    {
        return $this->DuplicateDesigInd;
    }
    /**
     * Set DuplicateDesigInd value
     * @param bool $duplicateDesigInd
     * @return \StructType\CarrierType
     */
    public function setDuplicateDesigInd($duplicateDesigInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($duplicateDesigInd) && !is_bool($duplicateDesigInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($duplicateDesigInd, true), gettype($duplicateDesigInd)), __LINE__);
        }
        $this->DuplicateDesigInd = $duplicateDesigInd;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\CarrierType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
}
