<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CarrierOffersType StructType
 * Meta information extracted from the WSDL
 * - documentation: Carrier Offers grouping of Offers returned by a single ORA.
 * @subpackage Structs
 */
class CarrierOffersType extends AbstractStructBase
{
    /**
     * The ALaCarteOffer
     * Meta information extracted from the WSDL
     * - documentation: A proposal to sell a specific set of products or Services under specific conditions, for a certain price. Can be the response to a shopping request. Can be a regular Offer or an A La Carte Offer. A La Carte Offer is defined as a
     * container for A La Carte Offer Items. This supports a shopping basket concept for non-flight services. The main purpose of this structure is to reduce the size of the messages by inserting Offer Items which are applicable to multiple flight-related
     * Offers. NB. For the OfferID of the ALaCarteOffer: Default OfferID identifier for A La Carte Offer Items in a scenario where items here are not selected for a flight-related Offer above. Business Identifier Fields: - [Shopping Response] Shopping
     * Response ID - Offer ID - [Carrier] Airline Designator Code
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ALaCarteOfferType[]
     */
    public $ALaCarteOffer;
    /**
     * The CarrierOffersSummary
     * Meta information extracted from the WSDL
     * - documentation: Offer summary that includes highest, lowest, and number of matched offers included in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OffersSummaryType
     */
    public $CarrierOffersSummary;
    /**
     * The Offer
     * Meta information extracted from the WSDL
     * - documentation: New Offer: A proposal to sell a specific set of products or Services under specific conditions, for a certain price. Can be the response to a shopping request. Can be a regular Offer or an A La Carte Offer. A La Carte Offer is
     * defined as a container for A La Carte Offer Items. This supports a shopping basket concept for non-flight services. The main purpose of this structure is to reduce the size of the messages by inserting Offer Items which are applicable to multiple
     * flight-related Offers. NB. For the OfferID of the ALaCarteOffer: Default OfferID identifier for A La Carte Offer Items in a scenario where items here are not selected for a flight-related Offer above. Business Identifier Fields: - [Shopping Response]
     * Shopping Response ID - Offer ID - [Carrier] Airline Designator Code
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NewOfferType[]
     */
    public $Offer;
    /**
     * The PriceCalendar
     * Meta information extracted from the WSDL
     * - documentation: Calendar based Flight Price. This capability supports multi-day calendar shopping, e.g. returning priced flight offers for a specified period before and/or after the actual requested date.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PriceCalendarType[]
     */
    public $PriceCalendar;
    /**
     * Constructor method for CarrierOffersType
     * @uses CarrierOffersType::setALaCarteOffer()
     * @uses CarrierOffersType::setCarrierOffersSummary()
     * @uses CarrierOffersType::setOffer()
     * @uses CarrierOffersType::setPriceCalendar()
     * @param \StructType\ALaCarteOfferType[] $aLaCarteOffer
     * @param \StructType\OffersSummaryType $carrierOffersSummary
     * @param \StructType\NewOfferType[] $offer
     * @param \StructType\PriceCalendarType[] $priceCalendar
     */
    public function __construct(array $aLaCarteOffer = array(), \StructType\OffersSummaryType $carrierOffersSummary = null, array $offer = array(), array $priceCalendar = array())
    {
        $this
            ->setALaCarteOffer($aLaCarteOffer)
            ->setCarrierOffersSummary($carrierOffersSummary)
            ->setOffer($offer)
            ->setPriceCalendar($priceCalendar);
    }
    /**
     * Get ALaCarteOffer value
     * @return \StructType\ALaCarteOfferType[]|null
     */
    public function getALaCarteOffer()
    {
        return $this->ALaCarteOffer;
    }
    /**
     * This method is responsible for validating the values passed to the setALaCarteOffer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setALaCarteOffer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateALaCarteOfferForArrayConstraintsFromSetALaCarteOffer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $carrierOffersTypeALaCarteOfferItem) {
            // validation for constraint: itemType
            if (!$carrierOffersTypeALaCarteOfferItem instanceof \StructType\ALaCarteOfferType) {
                $invalidValues[] = is_object($carrierOffersTypeALaCarteOfferItem) ? get_class($carrierOffersTypeALaCarteOfferItem) : sprintf('%s(%s)', gettype($carrierOffersTypeALaCarteOfferItem), var_export($carrierOffersTypeALaCarteOfferItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ALaCarteOffer property can only contain items of type \StructType\ALaCarteOfferType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ALaCarteOffer value
     * @throws \InvalidArgumentException
     * @param \StructType\ALaCarteOfferType[] $aLaCarteOffer
     * @return \StructType\CarrierOffersType
     */
    public function setALaCarteOffer(array $aLaCarteOffer = array())
    {
        // validation for constraint: array
        if ('' !== ($aLaCarteOfferArrayErrorMessage = self::validateALaCarteOfferForArrayConstraintsFromSetALaCarteOffer($aLaCarteOffer))) {
            throw new \InvalidArgumentException($aLaCarteOfferArrayErrorMessage, __LINE__);
        }
        $this->ALaCarteOffer = $aLaCarteOffer;
        return $this;
    }
    /**
     * Add item to ALaCarteOffer value
     * @throws \InvalidArgumentException
     * @param \StructType\ALaCarteOfferType $item
     * @return \StructType\CarrierOffersType
     */
    public function addToALaCarteOffer(\StructType\ALaCarteOfferType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ALaCarteOfferType) {
            throw new \InvalidArgumentException(sprintf('The ALaCarteOffer property can only contain items of type \StructType\ALaCarteOfferType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ALaCarteOffer[] = $item;
        return $this;
    }
    /**
     * Get CarrierOffersSummary value
     * @return \StructType\OffersSummaryType|null
     */
    public function getCarrierOffersSummary()
    {
        return $this->CarrierOffersSummary;
    }
    /**
     * Set CarrierOffersSummary value
     * @param \StructType\OffersSummaryType $carrierOffersSummary
     * @return \StructType\CarrierOffersType
     */
    public function setCarrierOffersSummary(\StructType\OffersSummaryType $carrierOffersSummary = null)
    {
        $this->CarrierOffersSummary = $carrierOffersSummary;
        return $this;
    }
    /**
     * Get Offer value
     * @return \StructType\NewOfferType[]|null
     */
    public function getOffer()
    {
        return $this->Offer;
    }
    /**
     * This method is responsible for validating the values passed to the setOffer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOffer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOfferForArrayConstraintsFromSetOffer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $carrierOffersTypeOfferItem) {
            // validation for constraint: itemType
            if (!$carrierOffersTypeOfferItem instanceof \StructType\NewOfferType) {
                $invalidValues[] = is_object($carrierOffersTypeOfferItem) ? get_class($carrierOffersTypeOfferItem) : sprintf('%s(%s)', gettype($carrierOffersTypeOfferItem), var_export($carrierOffersTypeOfferItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Offer property can only contain items of type \StructType\NewOfferType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Offer value
     * @throws \InvalidArgumentException
     * @param \StructType\NewOfferType[] $offer
     * @return \StructType\CarrierOffersType
     */
    public function setOffer(array $offer = array())
    {
        // validation for constraint: array
        if ('' !== ($offerArrayErrorMessage = self::validateOfferForArrayConstraintsFromSetOffer($offer))) {
            throw new \InvalidArgumentException($offerArrayErrorMessage, __LINE__);
        }
        $this->Offer = $offer;
        return $this;
    }
    /**
     * Add item to Offer value
     * @throws \InvalidArgumentException
     * @param \StructType\NewOfferType $item
     * @return \StructType\CarrierOffersType
     */
    public function addToOffer(\StructType\NewOfferType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NewOfferType) {
            throw new \InvalidArgumentException(sprintf('The Offer property can only contain items of type \StructType\NewOfferType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Offer[] = $item;
        return $this;
    }
    /**
     * Get PriceCalendar value
     * @return \StructType\PriceCalendarType[]|null
     */
    public function getPriceCalendar()
    {
        return $this->PriceCalendar;
    }
    /**
     * This method is responsible for validating the values passed to the setPriceCalendar method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPriceCalendar method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePriceCalendarForArrayConstraintsFromSetPriceCalendar(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $carrierOffersTypePriceCalendarItem) {
            // validation for constraint: itemType
            if (!$carrierOffersTypePriceCalendarItem instanceof \StructType\PriceCalendarType) {
                $invalidValues[] = is_object($carrierOffersTypePriceCalendarItem) ? get_class($carrierOffersTypePriceCalendarItem) : sprintf('%s(%s)', gettype($carrierOffersTypePriceCalendarItem), var_export($carrierOffersTypePriceCalendarItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PriceCalendar property can only contain items of type \StructType\PriceCalendarType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PriceCalendar value
     * @throws \InvalidArgumentException
     * @param \StructType\PriceCalendarType[] $priceCalendar
     * @return \StructType\CarrierOffersType
     */
    public function setPriceCalendar(array $priceCalendar = array())
    {
        // validation for constraint: array
        if ('' !== ($priceCalendarArrayErrorMessage = self::validatePriceCalendarForArrayConstraintsFromSetPriceCalendar($priceCalendar))) {
            throw new \InvalidArgumentException($priceCalendarArrayErrorMessage, __LINE__);
        }
        $this->PriceCalendar = $priceCalendar;
        return $this;
    }
    /**
     * Add item to PriceCalendar value
     * @throws \InvalidArgumentException
     * @param \StructType\PriceCalendarType $item
     * @return \StructType\CarrierOffersType
     */
    public function addToPriceCalendar(\StructType\PriceCalendarType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PriceCalendarType) {
            throw new \InvalidArgumentException(sprintf('The PriceCalendar property can only contain items of type \StructType\PriceCalendarType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PriceCalendar[] = $item;
        return $this;
    }
}
