<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CarrierFeeType StructType
 * Meta information extracted from the WSDL
 * - documentation: Carrier imposed fee detail, typically related to booking, ticketing, or servicing.
 * @subpackage Structs
 */
class CarrierFeeType extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Fee amount and currency code.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AmountType
     */
    public $Amount;
    /**
     * The AppCode
     * Meta information extracted from the WSDL
     * - documentation: Code used to specify if the fee is non-interlineable, non-refundable, or non-commissionable. | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AppCode;
    /**
     * The PaymentTypeCode
     * Meta information extracted from the WSDL
     * - documentation: A Payment Type code assigned according to ATS Codeset PAYT. For example: 'CC' for Customer Card.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaymentTypeCode;
    /**
     * The Carrier
     * Meta information extracted from the WSDL
     * - documentation: The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc. Business Identifier Fields: - Airline
     * Designator Code - Duplicate Designator Indicator - Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CarrierType
     */
    public $Carrier;
    /**
     * The FareComponent
     * Meta information extracted from the WSDL
     * - documentation: A portion of an itinerary between two consecutive fare construction points. If the journey has only one fare component, the points of origin and destination are the only fare construction points
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FareComponentType[]
     */
    public $FareComponent;
    /**
     * The OriginDest
     * Meta information extracted from the WSDL
     * - documentation: The Origin and Destination airport/city pair which confines a passenger journey or an aircraft flight. Business Identifier Fields: - [Station] (Origin Station) IATA Location Code - [Station] (Destination Station) IATA Location Code
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OriginDestType
     */
    public $OriginDest;
    /**
     * The PaymentBrandCode
     * Meta information extracted from the WSDL
     * - documentation: A Payment Brand code assigned according to ATS Codeset PAYB. Example VI for Visa
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentBrandCode;
    /**
     * The ReportingCodeText
     * Meta information extracted from the WSDL
     * - documentation: A Reporting Code for related to booking, ticketing, or servicing. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReportingCodeText;
    /**
     * The TaxSummary
     * Meta information extracted from the WSDL
     * - documentation: Tax summary information.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TaxSummaryType
     */
    public $TaxSummary;
    /**
     * Constructor method for CarrierFeeType
     * @uses CarrierFeeType::setAmount()
     * @uses CarrierFeeType::setAppCode()
     * @uses CarrierFeeType::setPaymentTypeCode()
     * @uses CarrierFeeType::setCarrier()
     * @uses CarrierFeeType::setFareComponent()
     * @uses CarrierFeeType::setOriginDest()
     * @uses CarrierFeeType::setPaymentBrandCode()
     * @uses CarrierFeeType::setReportingCodeText()
     * @uses CarrierFeeType::setTaxSummary()
     * @param \StructType\AmountType $amount
     * @param string $appCode
     * @param string $paymentTypeCode
     * @param \StructType\CarrierType $carrier
     * @param \StructType\FareComponentType[] $fareComponent
     * @param \StructType\OriginDestType $originDest
     * @param string $paymentBrandCode
     * @param string $reportingCodeText
     * @param \StructType\TaxSummaryType $taxSummary
     */
    public function __construct(\StructType\AmountType $amount = null, $appCode = null, $paymentTypeCode = null, \StructType\CarrierType $carrier = null, array $fareComponent = array(), \StructType\OriginDestType $originDest = null, $paymentBrandCode = null, $reportingCodeText = null, \StructType\TaxSummaryType $taxSummary = null)
    {
        $this
            ->setAmount($amount)
            ->setAppCode($appCode)
            ->setPaymentTypeCode($paymentTypeCode)
            ->setCarrier($carrier)
            ->setFareComponent($fareComponent)
            ->setOriginDest($originDest)
            ->setPaymentBrandCode($paymentBrandCode)
            ->setReportingCodeText($reportingCodeText)
            ->setTaxSummary($taxSummary);
    }
    /**
     * Get Amount value
     * @return \StructType\AmountType
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \StructType\AmountType $amount
     * @return \StructType\CarrierFeeType
     */
    public function setAmount(\StructType\AmountType $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get AppCode value
     * @return string
     */
    public function getAppCode()
    {
        return $this->AppCode;
    }
    /**
     * Set AppCode value
     * @param string $appCode
     * @return \StructType\CarrierFeeType
     */
    public function setAppCode($appCode = null)
    {
        // validation for constraint: string
        if (!is_null($appCode) && !is_string($appCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appCode, true), gettype($appCode)), __LINE__);
        }
        $this->AppCode = $appCode;
        return $this;
    }
    /**
     * Get PaymentTypeCode value
     * @return string
     */
    public function getPaymentTypeCode()
    {
        return $this->PaymentTypeCode;
    }
    /**
     * Set PaymentTypeCode value
     * @param string $paymentTypeCode
     * @return \StructType\CarrierFeeType
     */
    public function setPaymentTypeCode($paymentTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTypeCode) && !is_string($paymentTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTypeCode, true), gettype($paymentTypeCode)), __LINE__);
        }
        $this->PaymentTypeCode = $paymentTypeCode;
        return $this;
    }
    /**
     * Get Carrier value
     * @return \StructType\CarrierType|null
     */
    public function getCarrier()
    {
        return $this->Carrier;
    }
    /**
     * Set Carrier value
     * @param \StructType\CarrierType $carrier
     * @return \StructType\CarrierFeeType
     */
    public function setCarrier(\StructType\CarrierType $carrier = null)
    {
        $this->Carrier = $carrier;
        return $this;
    }
    /**
     * Get FareComponent value
     * @return \StructType\FareComponentType[]|null
     */
    public function getFareComponent()
    {
        return $this->FareComponent;
    }
    /**
     * This method is responsible for validating the values passed to the setFareComponent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareComponent method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareComponentForArrayConstraintsFromSetFareComponent(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $carrierFeeTypeFareComponentItem) {
            // validation for constraint: itemType
            if (!$carrierFeeTypeFareComponentItem instanceof \StructType\FareComponentType) {
                $invalidValues[] = is_object($carrierFeeTypeFareComponentItem) ? get_class($carrierFeeTypeFareComponentItem) : sprintf('%s(%s)', gettype($carrierFeeTypeFareComponentItem), var_export($carrierFeeTypeFareComponentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareComponent property can only contain items of type \StructType\FareComponentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareComponent value
     * @throws \InvalidArgumentException
     * @param \StructType\FareComponentType[] $fareComponent
     * @return \StructType\CarrierFeeType
     */
    public function setFareComponent(array $fareComponent = array())
    {
        // validation for constraint: array
        if ('' !== ($fareComponentArrayErrorMessage = self::validateFareComponentForArrayConstraintsFromSetFareComponent($fareComponent))) {
            throw new \InvalidArgumentException($fareComponentArrayErrorMessage, __LINE__);
        }
        $this->FareComponent = $fareComponent;
        return $this;
    }
    /**
     * Add item to FareComponent value
     * @throws \InvalidArgumentException
     * @param \StructType\FareComponentType $item
     * @return \StructType\CarrierFeeType
     */
    public function addToFareComponent(\StructType\FareComponentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FareComponentType) {
            throw new \InvalidArgumentException(sprintf('The FareComponent property can only contain items of type \StructType\FareComponentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FareComponent[] = $item;
        return $this;
    }
    /**
     * Get OriginDest value
     * @return \StructType\OriginDestType|null
     */
    public function getOriginDest()
    {
        return $this->OriginDest;
    }
    /**
     * Set OriginDest value
     * @param \StructType\OriginDestType $originDest
     * @return \StructType\CarrierFeeType
     */
    public function setOriginDest(\StructType\OriginDestType $originDest = null)
    {
        $this->OriginDest = $originDest;
        return $this;
    }
    /**
     * Get PaymentBrandCode value
     * @return string|null
     */
    public function getPaymentBrandCode()
    {
        return $this->PaymentBrandCode;
    }
    /**
     * Set PaymentBrandCode value
     * @param string $paymentBrandCode
     * @return \StructType\CarrierFeeType
     */
    public function setPaymentBrandCode($paymentBrandCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentBrandCode) && !is_string($paymentBrandCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentBrandCode, true), gettype($paymentBrandCode)), __LINE__);
        }
        $this->PaymentBrandCode = $paymentBrandCode;
        return $this;
    }
    /**
     * Get ReportingCodeText value
     * @return string|null
     */
    public function getReportingCodeText()
    {
        return $this->ReportingCodeText;
    }
    /**
     * Set ReportingCodeText value
     * @param string $reportingCodeText
     * @return \StructType\CarrierFeeType
     */
    public function setReportingCodeText($reportingCodeText = null)
    {
        // validation for constraint: string
        if (!is_null($reportingCodeText) && !is_string($reportingCodeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportingCodeText, true), gettype($reportingCodeText)), __LINE__);
        }
        $this->ReportingCodeText = $reportingCodeText;
        return $this;
    }
    /**
     * Get TaxSummary value
     * @return \StructType\TaxSummaryType|null
     */
    public function getTaxSummary()
    {
        return $this->TaxSummary;
    }
    /**
     * Set TaxSummary value
     * @param \StructType\TaxSummaryType $taxSummary
     * @return \StructType\CarrierFeeType
     */
    public function setTaxSummary(\StructType\TaxSummaryType $taxSummary = null)
    {
        $this->TaxSummary = $taxSummary;
        return $this;
    }
}
