<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelRestrictions StructType
 * Meta information extracted from the WSDL
 * - documentation: These are a set of qualifying conditions/rules/restrictions that are related to a constrained priced grouping of services for the Cancellation action.
 * @subpackage Structs
 */
class CancelRestrictions extends AbstractStructBase
{
    /**
     * The AllowedModificationInd
     * Meta information extracted from the WSDL
     * - documentation: Flags if cancellation is allowed used in conjunction with defined date ranges. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - minOccurs: 0
     * @var bool
     */
    public $AllowedModificationInd;
    /**
     * The DescText
     * Meta information extracted from the WSDL
     * - documentation: Describes what this restriction is. E.G -Cancellation allowed within dates(1) specified with no fee. -Cancellation allowed within dates(2) specified with fee. -Cancellation not allowed | Text is a character string such as a finite
     * set of characters generally in the form of words of a language.
     * - base: xs:string
     * - minOccurs: 0
     * @var string
     */
    public $DescText;
    /**
     * The EffectiveDateTime
     * Meta information extracted from the WSDL
     * - documentation: This identifies the effective date used in conjunction with the Expiration date to qualify the applicability of this condition This date is relative to the first flight segment.
     * - minOccurs: 0
     * @var string
     */
    public $EffectiveDateTime;
    /**
     * The ExpirationDateTime
     * Meta information extracted from the WSDL
     * - documentation: This identifies the Expiration date used in conjunction with the Effective date to qualify the applicability of this condition This date is relative to the first flight segment.
     * - minOccurs: 0
     * @var string
     */
    public $ExpirationDateTime;
    /**
     * The Fee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Fee
     */
    public $Fee;
    /**
     * The JourneyStageCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $JourneyStageCode;
    /**
     * The PaxRefID
     * Meta information extracted from the WSDL
     * - documentation: Used to store a ref to the passenger. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - minOccurs: 0
     * @var string
     */
    public $PaxRefID;
    /**
     * The Refund
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Refund
     */
    public $Refund;
    /**
     * Constructor method for CancelRestrictions
     * @uses CancelRestrictions::setAllowedModificationInd()
     * @uses CancelRestrictions::setDescText()
     * @uses CancelRestrictions::setEffectiveDateTime()
     * @uses CancelRestrictions::setExpirationDateTime()
     * @uses CancelRestrictions::setFee()
     * @uses CancelRestrictions::setJourneyStageCode()
     * @uses CancelRestrictions::setPaxRefID()
     * @uses CancelRestrictions::setRefund()
     * @param bool $allowedModificationInd
     * @param string $descText
     * @param string $effectiveDateTime
     * @param string $expirationDateTime
     * @param \StructType\Fee $fee
     * @param string $journeyStageCode
     * @param string $paxRefID
     * @param \StructType\Refund $refund
     */
    public function __construct($allowedModificationInd = null, $descText = null, $effectiveDateTime = null, $expirationDateTime = null, \StructType\Fee $fee = null, $journeyStageCode = null, $paxRefID = null, \StructType\Refund $refund = null)
    {
        $this
            ->setAllowedModificationInd($allowedModificationInd)
            ->setDescText($descText)
            ->setEffectiveDateTime($effectiveDateTime)
            ->setExpirationDateTime($expirationDateTime)
            ->setFee($fee)
            ->setJourneyStageCode($journeyStageCode)
            ->setPaxRefID($paxRefID)
            ->setRefund($refund);
    }
    /**
     * Get AllowedModificationInd value
     * @return bool|null
     */
    public function getAllowedModificationInd()
    {
        return $this->AllowedModificationInd;
    }
    /**
     * Set AllowedModificationInd value
     * @param bool $allowedModificationInd
     * @return \StructType\CancelRestrictions
     */
    public function setAllowedModificationInd($allowedModificationInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowedModificationInd) && !is_bool($allowedModificationInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowedModificationInd, true), gettype($allowedModificationInd)), __LINE__);
        }
        $this->AllowedModificationInd = $allowedModificationInd;
        return $this;
    }
    /**
     * Get DescText value
     * @return string|null
     */
    public function getDescText()
    {
        return $this->DescText;
    }
    /**
     * Set DescText value
     * @param string $descText
     * @return \StructType\CancelRestrictions
     */
    public function setDescText($descText = null)
    {
        // validation for constraint: string
        if (!is_null($descText) && !is_string($descText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descText, true), gettype($descText)), __LINE__);
        }
        $this->DescText = $descText;
        return $this;
    }
    /**
     * Get EffectiveDateTime value
     * @return string|null
     */
    public function getEffectiveDateTime()
    {
        return $this->EffectiveDateTime;
    }
    /**
     * Set EffectiveDateTime value
     * @param string $effectiveDateTime
     * @return \StructType\CancelRestrictions
     */
    public function setEffectiveDateTime($effectiveDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDateTime) && !is_string($effectiveDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDateTime, true), gettype($effectiveDateTime)), __LINE__);
        }
        $this->EffectiveDateTime = $effectiveDateTime;
        return $this;
    }
    /**
     * Get ExpirationDateTime value
     * @return string|null
     */
    public function getExpirationDateTime()
    {
        return $this->ExpirationDateTime;
    }
    /**
     * Set ExpirationDateTime value
     * @param string $expirationDateTime
     * @return \StructType\CancelRestrictions
     */
    public function setExpirationDateTime($expirationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDateTime) && !is_string($expirationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDateTime, true), gettype($expirationDateTime)), __LINE__);
        }
        $this->ExpirationDateTime = $expirationDateTime;
        return $this;
    }
    /**
     * Get Fee value
     * @return \StructType\Fee|null
     */
    public function getFee()
    {
        return $this->Fee;
    }
    /**
     * Set Fee value
     * @param \StructType\Fee $fee
     * @return \StructType\CancelRestrictions
     */
    public function setFee(\StructType\Fee $fee = null)
    {
        $this->Fee = $fee;
        return $this;
    }
    /**
     * Get JourneyStageCode value
     * @return string|null
     */
    public function getJourneyStageCode()
    {
        return $this->JourneyStageCode;
    }
    /**
     * Set JourneyStageCode value
     * @uses \EnumType\JourneyStageCode::valueIsValid()
     * @uses \EnumType\JourneyStageCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $journeyStageCode
     * @return \StructType\CancelRestrictions
     */
    public function setJourneyStageCode($journeyStageCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JourneyStageCode::valueIsValid($journeyStageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JourneyStageCode', is_array($journeyStageCode) ? implode(', ', $journeyStageCode) : var_export($journeyStageCode, true), implode(', ', \EnumType\JourneyStageCode::getValidValues())), __LINE__);
        }
        $this->JourneyStageCode = $journeyStageCode;
        return $this;
    }
    /**
     * Get PaxRefID value
     * @return string|null
     */
    public function getPaxRefID()
    {
        return $this->PaxRefID;
    }
    /**
     * Set PaxRefID value
     * @param string $paxRefID
     * @return \StructType\CancelRestrictions
     */
    public function setPaxRefID($paxRefID = null)
    {
        // validation for constraint: string
        if (!is_null($paxRefID) && !is_string($paxRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxRefID, true), gettype($paxRefID)), __LINE__);
        }
        $this->PaxRefID = $paxRefID;
        return $this;
    }
    /**
     * Get Refund value
     * @return \StructType\Refund|null
     */
    public function getRefund()
    {
        return $this->Refund;
    }
    /**
     * Set Refund value
     * @param \StructType\Refund $refund
     * @return \StructType\CancelRestrictions
     */
    public function setRefund(\StructType\Refund $refund = null)
    {
        $this->Refund = $refund;
        return $this;
    }
}
