<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CabinTypeType StructType
 * Meta information extracted from the WSDL
 * - documentation: Type of compartment of an aircraft, offering specific services (e.g. business class, economy). Business Identifier Fields: - Cabin Type Code
 * @subpackage Structs
 */
class CabinTypeType extends AbstractStructBase
{
    /**
     * The CabinTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Cabin Type Code as defined by ATSB codeset 9873.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CabinTypeCode;
    /**
     * The CabinTypeName
     * Meta information extracted from the WSDL
     * - documentation: Name given to a cabin compartment (e.g. Business, First, Economy). | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CabinTypeName;
    /**
     * Constructor method for CabinTypeType
     * @uses CabinTypeType::setCabinTypeCode()
     * @uses CabinTypeType::setCabinTypeName()
     * @param string $cabinTypeCode
     * @param string $cabinTypeName
     */
    public function __construct($cabinTypeCode = null, $cabinTypeName = null)
    {
        $this
            ->setCabinTypeCode($cabinTypeCode)
            ->setCabinTypeName($cabinTypeName);
    }
    /**
     * Get CabinTypeCode value
     * @return string|null
     */
    public function getCabinTypeCode()
    {
        return $this->CabinTypeCode;
    }
    /**
     * Set CabinTypeCode value
     * @param string $cabinTypeCode
     * @return \StructType\CabinTypeType
     */
    public function setCabinTypeCode($cabinTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($cabinTypeCode) && !is_string($cabinTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cabinTypeCode, true), gettype($cabinTypeCode)), __LINE__);
        }
        $this->CabinTypeCode = $cabinTypeCode;
        return $this;
    }
    /**
     * Get CabinTypeName value
     * @return string|null
     */
    public function getCabinTypeName()
    {
        return $this->CabinTypeName;
    }
    /**
     * Set CabinTypeName value
     * @param string $cabinTypeName
     * @return \StructType\CabinTypeType
     */
    public function setCabinTypeName($cabinTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($cabinTypeName) && !is_string($cabinTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cabinTypeName, true), gettype($cabinTypeName)), __LINE__);
        }
        $this->CabinTypeName = $cabinTypeName;
        return $this;
    }
}
