<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CabinTypeAssociationChoiceType StructType
 * Meta information extracted from the WSDL
 * - documentation: A choice of Cabin Type Association to leg(s) or a segment
 * @subpackage Structs
 */
class CabinTypeAssociationChoiceType extends AbstractStructBase
{
    /**
     * The LegCabinAssociations
     * Meta information extracted from the WSDL
     * - documentation: A container to enable cabins to be associated with legs.
     * - choice: LegCabinAssociations | SegmentCabinType
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\LegCabinAssociationsType
     */
    public $LegCabinAssociations;
    /**
     * The SegmentCabinType
     * Meta information extracted from the WSDL
     * - documentation: Type of compartment of an aircraft, offering specific services (e.g. business class, economy). Business Identifier Fields: - Cabin Type Code
     * - choice: LegCabinAssociations | SegmentCabinType
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\CabinTypeType
     */
    public $SegmentCabinType;
    /**
     * Constructor method for CabinTypeAssociationChoiceType
     * @uses CabinTypeAssociationChoiceType::setLegCabinAssociations()
     * @uses CabinTypeAssociationChoiceType::setSegmentCabinType()
     * @param \StructType\LegCabinAssociationsType $legCabinAssociations
     * @param \StructType\CabinTypeType $segmentCabinType
     */
    public function __construct(\StructType\LegCabinAssociationsType $legCabinAssociations = null, \StructType\CabinTypeType $segmentCabinType = null)
    {
        $this
            ->setLegCabinAssociations($legCabinAssociations)
            ->setSegmentCabinType($segmentCabinType);
    }
    /**
     * Get LegCabinAssociations value
     * @return \StructType\LegCabinAssociationsType
     */
    public function getLegCabinAssociations()
    {
        return isset($this->LegCabinAssociations) ? $this->LegCabinAssociations : null;
    }
    /**
     * This method is responsible for validating the value passed to the setLegCabinAssociations method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLegCabinAssociations method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateLegCabinAssociationsForChoiceConstraintsFromSetLegCabinAssociations($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'SegmentCabinType',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property LegCabinAssociations can\'t be set as the property %s is already set. Only one property must be set among these properties: LegCabinAssociations, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set LegCabinAssociations value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\LegCabinAssociationsType $legCabinAssociations
     * @return \StructType\CabinTypeAssociationChoiceType
     */
    public function setLegCabinAssociations(\StructType\LegCabinAssociationsType $legCabinAssociations = null)
    {
        // validation for constraint: choice(LegCabinAssociations, SegmentCabinType)
        if ('' !== ($legCabinAssociationsChoiceErrorMessage = self::validateLegCabinAssociationsForChoiceConstraintsFromSetLegCabinAssociations($legCabinAssociations))) {
            throw new \InvalidArgumentException($legCabinAssociationsChoiceErrorMessage, __LINE__);
        }
        if (is_null($legCabinAssociations) || (is_array($legCabinAssociations) && empty($legCabinAssociations))) {
            unset($this->LegCabinAssociations);
        } else {
            $this->LegCabinAssociations = $legCabinAssociations;
        }
        return $this;
    }
    /**
     * Get SegmentCabinType value
     * @return \StructType\CabinTypeType
     */
    public function getSegmentCabinType()
    {
        return isset($this->SegmentCabinType) ? $this->SegmentCabinType : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSegmentCabinType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSegmentCabinType method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSegmentCabinTypeForChoiceConstraintsFromSetSegmentCabinType($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'LegCabinAssociations',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property SegmentCabinType can\'t be set as the property %s is already set. Only one property must be set among these properties: SegmentCabinType, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set SegmentCabinType value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CabinTypeType $segmentCabinType
     * @return \StructType\CabinTypeAssociationChoiceType
     */
    public function setSegmentCabinType(\StructType\CabinTypeType $segmentCabinType = null)
    {
        // validation for constraint: choice(LegCabinAssociations, SegmentCabinType)
        if ('' !== ($segmentCabinTypeChoiceErrorMessage = self::validateSegmentCabinTypeForChoiceConstraintsFromSetSegmentCabinType($segmentCabinType))) {
            throw new \InvalidArgumentException($segmentCabinTypeChoiceErrorMessage, __LINE__);
        }
        if (is_null($segmentCabinType) || (is_array($segmentCabinType) && empty($segmentCabinType))) {
            unset($this->SegmentCabinType);
        } else {
            $this->SegmentCabinType = $segmentCabinType;
        }
        return $this;
    }
}
