<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingInstructionsType StructType
 * Meta information extracted from the WSDL
 * - documentation: Optional service booking instructions to include SSR, OSI and upgrade Method.
 * @subpackage Structs
 */
class BookingInstructionsType extends AbstractStructBase
{
    /**
     * The MethodText
     * Meta information extracted from the WSDL
     * - documentation: PNR booking method. Example: AE (BY SSR - SPECIAL SERVICE REQUEST) For maximum interoperability, refer to IATA PADIS Code List for data element 9750. Select a code value or enter a value that is bilaterally agreed upon between
     * trading partners. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MethodText;
    /**
     * The OSI_Text
     * Meta information extracted from the WSDL
     * - documentation: Other service information (OSI) text. Example: PAX VIP MEMBER OF PARLIAMENT | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $OSI_Text;
    /**
     * The SpecialService
     * Meta information extracted from the WSDL
     * - documentation: Special service information
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SpecialServiceType[]
     */
    public $SpecialService;
    /**
     * The UpgradeMethodCode
     * Meta information extracted from the WSDL
     * - documentation: Upgrade method. Example: AE (BY SSR - SPECIAL SERVICE REQUEST) For maximum interoperability, refer to IATA PADIS Code List for data element 9750. Select a code value or enter a value that is bilaterally agreed upon between trading
     * partners. | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UpgradeMethodCode;
    /**
     * The UpgradeNewClassCode
     * Meta information extracted from the WSDL
     * - documentation: New Cabin Type Code related to the Upgrade Method. As defined by PADIS codeset (e.g. 1, 2, 3, etc.) | Specifies the Cabin Type Code as defined by ATSB codeset 9873 {codeListAgencyName}ATSB{/codeListAgencyName} {codeListName}Cabin
     * class of service, coded{/codeListName} {codeListIdentifier}9873{/codeListIdentifier} | Additional BDT to specify the Cabin Type Code as defined by PADIS.
     * - base: CabinTypeCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UpgradeNewClassCode;
    /**
     * Constructor method for BookingInstructionsType
     * @uses BookingInstructionsType::setMethodText()
     * @uses BookingInstructionsType::setOSI_Text()
     * @uses BookingInstructionsType::setSpecialService()
     * @uses BookingInstructionsType::setUpgradeMethodCode()
     * @uses BookingInstructionsType::setUpgradeNewClassCode()
     * @param string $methodText
     * @param string[] $oSI_Text
     * @param \StructType\SpecialServiceType[] $specialService
     * @param string $upgradeMethodCode
     * @param string $upgradeNewClassCode
     */
    public function __construct($methodText = null, array $oSI_Text = array(), array $specialService = array(), $upgradeMethodCode = null, $upgradeNewClassCode = null)
    {
        $this
            ->setMethodText($methodText)
            ->setOSI_Text($oSI_Text)
            ->setSpecialService($specialService)
            ->setUpgradeMethodCode($upgradeMethodCode)
            ->setUpgradeNewClassCode($upgradeNewClassCode);
    }
    /**
     * Get MethodText value
     * @return string|null
     */
    public function getMethodText()
    {
        return $this->MethodText;
    }
    /**
     * Set MethodText value
     * @param string $methodText
     * @return \StructType\BookingInstructionsType
     */
    public function setMethodText($methodText = null)
    {
        // validation for constraint: string
        if (!is_null($methodText) && !is_string($methodText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($methodText, true), gettype($methodText)), __LINE__);
        }
        $this->MethodText = $methodText;
        return $this;
    }
    /**
     * Get OSI_Text value
     * @return string[]|null
     */
    public function getOSI_Text()
    {
        return $this->OSI_Text;
    }
    /**
     * This method is responsible for validating the values passed to the setOSI_Text method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOSI_Text method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOSI_TextForArrayConstraintsFromSetOSI_Text(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bookingInstructionsTypeOSI_TextItem) {
            // validation for constraint: itemType
            if (!is_string($bookingInstructionsTypeOSI_TextItem)) {
                $invalidValues[] = is_object($bookingInstructionsTypeOSI_TextItem) ? get_class($bookingInstructionsTypeOSI_TextItem) : sprintf('%s(%s)', gettype($bookingInstructionsTypeOSI_TextItem), var_export($bookingInstructionsTypeOSI_TextItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OSI_Text property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OSI_Text value
     * @throws \InvalidArgumentException
     * @param string[] $oSI_Text
     * @return \StructType\BookingInstructionsType
     */
    public function setOSI_Text(array $oSI_Text = array())
    {
        // validation for constraint: array
        if ('' !== ($oSI_TextArrayErrorMessage = self::validateOSI_TextForArrayConstraintsFromSetOSI_Text($oSI_Text))) {
            throw new \InvalidArgumentException($oSI_TextArrayErrorMessage, __LINE__);
        }
        $this->OSI_Text = $oSI_Text;
        return $this;
    }
    /**
     * Add item to OSI_Text value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\BookingInstructionsType
     */
    public function addToOSI_Text($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The OSI_Text property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OSI_Text[] = $item;
        return $this;
    }
    /**
     * Get SpecialService value
     * @return \StructType\SpecialServiceType[]|null
     */
    public function getSpecialService()
    {
        return $this->SpecialService;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecialService method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecialService method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecialServiceForArrayConstraintsFromSetSpecialService(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bookingInstructionsTypeSpecialServiceItem) {
            // validation for constraint: itemType
            if (!$bookingInstructionsTypeSpecialServiceItem instanceof \StructType\SpecialServiceType) {
                $invalidValues[] = is_object($bookingInstructionsTypeSpecialServiceItem) ? get_class($bookingInstructionsTypeSpecialServiceItem) : sprintf('%s(%s)', gettype($bookingInstructionsTypeSpecialServiceItem), var_export($bookingInstructionsTypeSpecialServiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SpecialService property can only contain items of type \StructType\SpecialServiceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SpecialService value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialServiceType[] $specialService
     * @return \StructType\BookingInstructionsType
     */
    public function setSpecialService(array $specialService = array())
    {
        // validation for constraint: array
        if ('' !== ($specialServiceArrayErrorMessage = self::validateSpecialServiceForArrayConstraintsFromSetSpecialService($specialService))) {
            throw new \InvalidArgumentException($specialServiceArrayErrorMessage, __LINE__);
        }
        $this->SpecialService = $specialService;
        return $this;
    }
    /**
     * Add item to SpecialService value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialServiceType $item
     * @return \StructType\BookingInstructionsType
     */
    public function addToSpecialService(\StructType\SpecialServiceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SpecialServiceType) {
            throw new \InvalidArgumentException(sprintf('The SpecialService property can only contain items of type \StructType\SpecialServiceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SpecialService[] = $item;
        return $this;
    }
    /**
     * Get UpgradeMethodCode value
     * @return string|null
     */
    public function getUpgradeMethodCode()
    {
        return $this->UpgradeMethodCode;
    }
    /**
     * Set UpgradeMethodCode value
     * @param string $upgradeMethodCode
     * @return \StructType\BookingInstructionsType
     */
    public function setUpgradeMethodCode($upgradeMethodCode = null)
    {
        // validation for constraint: string
        if (!is_null($upgradeMethodCode) && !is_string($upgradeMethodCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upgradeMethodCode, true), gettype($upgradeMethodCode)), __LINE__);
        }
        $this->UpgradeMethodCode = $upgradeMethodCode;
        return $this;
    }
    /**
     * Get UpgradeNewClassCode value
     * @return string|null
     */
    public function getUpgradeNewClassCode()
    {
        return $this->UpgradeNewClassCode;
    }
    /**
     * Set UpgradeNewClassCode value
     * @param string $upgradeNewClassCode
     * @return \StructType\BookingInstructionsType
     */
    public function setUpgradeNewClassCode($upgradeNewClassCode = null)
    {
        // validation for constraint: string
        if (!is_null($upgradeNewClassCode) && !is_string($upgradeNewClassCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upgradeNewClassCode, true), gettype($upgradeNewClassCode)), __LINE__);
        }
        $this->UpgradeNewClassCode = $upgradeNewClassCode;
        return $this;
    }
}
