<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseFareType StructType
 * @subpackage Structs
 */
class BaseFareType extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Total base fare amount that includes surcharges (if any). Example: 200000
     * - use: required
     * @var int
     */
    public $Amount;
    /**
     * The FiledIn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: FiledIn
     * @var \StructType\FiledIn
     */
    public $FiledIn;
    /**
     * The Surcharges
     * Meta information extracted from the WSDL
     * - documentation: Surcharges group
     * - minOccurs: 0
     * @var \StructType\SurchargesType
     */
    public $Surcharges;
    /**
     * Constructor method for BaseFareType
     * @uses BaseFareType::setAmount()
     * @uses BaseFareType::setFiledIn()
     * @uses BaseFareType::setSurcharges()
     * @param int $amount
     * @param \StructType\FiledIn $filedIn
     * @param \StructType\SurchargesType $surcharges
     */
    public function __construct($amount = null, \StructType\FiledIn $filedIn = null, \StructType\SurchargesType $surcharges = null)
    {
        $this
            ->setAmount($amount)
            ->setFiledIn($filedIn)
            ->setSurcharges($surcharges);
    }
    /**
     * Get Amount value
     * @return int
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param int $amount
     * @return \StructType\BaseFareType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get FiledIn value
     * @return \StructType\FiledIn|null
     */
    public function getFiledIn()
    {
        return $this->FiledIn;
    }
    /**
     * Set FiledIn value
     * @param \StructType\FiledIn $filedIn
     * @return \StructType\BaseFareType
     */
    public function setFiledIn(\StructType\FiledIn $filedIn = null)
    {
        $this->FiledIn = $filedIn;
        return $this;
    }
    /**
     * Get Surcharges value
     * @return \StructType\SurchargesType|null
     */
    public function getSurcharges()
    {
        return $this->Surcharges;
    }
    /**
     * Set Surcharges value
     * @param \StructType\SurchargesType $surcharges
     * @return \StructType\BaseFareType
     */
    public function setSurcharges(\StructType\SurchargesType $surcharges = null)
    {
        $this->Surcharges = $surcharges;
        return $this;
    }
}
