<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaggagePricingCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Baggage pricing specific filter criteria for shopping requests, including baggage type, charges, and settlement information.
 * @subpackage Structs
 */
class BaggagePricingCriteriaType extends AbstractStructBase
{
    /**
     * The BaggageOptionCode
     * Meta information extracted from the WSDL
     * - documentation: Specifies the type of baggage (e.g. CarryOnBag, CheckedBag). | Enumeration values for Baggage Type. {codeListAgencyName}IATA Code List{/codeListAgencyName} {codeListName}Baggage Allowance Type Status, Coded.{/codeListName}
     * {codeListIdentifier}BaggageAllowanceType{/codeListIdentifier} | Additional BDT to specify baggage type code.
     * - base: BaggageTypeCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BaggageOptionCode;
    /**
     * The CommercialAgreementID
     * Meta information extracted from the WSDL
     * - documentation: Bilateral agreement identifier E.g. baggage cost, Baggage Determining Carrier, etc. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an
     * agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CommercialAgreementID;
    /**
     * The DeferralInd
     * Meta information extracted from the WSDL
     * - documentation: If TRUE, The ORA advises the POA that the POA is given the Baggage Determining Carrier designation | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $DeferralInd;
    /**
     * The FixedPrePaidInd
     * Meta information extracted from the WSDL
     * - documentation: Allows POA to tell the ORA if the ORA may alter the POA's pre-paid baggage charges. If TRUE, prepaid charge may NOT be altered If FALSE, prepaid charge MAY be altered | An indicator is a list of two mutually exclusive Boolean values
     * that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $FixedPrePaidInd;
    /**
     * The IncludeSettlementInd
     * Meta information extracted from the WSDL
     * - documentation: Boolean indicator. TRUE indicates that the settlement value for the baggage must be returned. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeSettlementInd;
    /**
     * The OptionalChargesCode
     * Meta information extracted from the WSDL
     * - documentation: Allowance catalog requested. Example: C (Catalog Only). | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OptionalChargesCode;
    /**
     * The RequestedActionCode
     * Meta information extracted from the WSDL
     * - documentation: Requested action to take for this information (example: 131 DISPLAY ONLY). | PADIS defined list of message functions. {codeListAgencyIdentifier}IATA{/codeListAgencyIdentifier} {codeListAgencyName}IATA Codeset {/codeListAgencyName}
     * {codeListName}Message function, coded{/codeListName} {codeListIdentifier}1225{/codeListIdentifier} | PADIS defined list of message functions.
     * - base: MessageFunctionCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RequestedActionCode;
    /**
     * Constructor method for BaggagePricingCriteriaType
     * @uses BaggagePricingCriteriaType::setBaggageOptionCode()
     * @uses BaggagePricingCriteriaType::setCommercialAgreementID()
     * @uses BaggagePricingCriteriaType::setDeferralInd()
     * @uses BaggagePricingCriteriaType::setFixedPrePaidInd()
     * @uses BaggagePricingCriteriaType::setIncludeSettlementInd()
     * @uses BaggagePricingCriteriaType::setOptionalChargesCode()
     * @uses BaggagePricingCriteriaType::setRequestedActionCode()
     * @param string $baggageOptionCode
     * @param string $commercialAgreementID
     * @param bool $deferralInd
     * @param bool $fixedPrePaidInd
     * @param bool $includeSettlementInd
     * @param string $optionalChargesCode
     * @param string $requestedActionCode
     */
    public function __construct($baggageOptionCode = null, $commercialAgreementID = null, $deferralInd = null, $fixedPrePaidInd = null, $includeSettlementInd = null, $optionalChargesCode = null, $requestedActionCode = null)
    {
        $this
            ->setBaggageOptionCode($baggageOptionCode)
            ->setCommercialAgreementID($commercialAgreementID)
            ->setDeferralInd($deferralInd)
            ->setFixedPrePaidInd($fixedPrePaidInd)
            ->setIncludeSettlementInd($includeSettlementInd)
            ->setOptionalChargesCode($optionalChargesCode)
            ->setRequestedActionCode($requestedActionCode);
    }
    /**
     * Get BaggageOptionCode value
     * @return string|null
     */
    public function getBaggageOptionCode()
    {
        return $this->BaggageOptionCode;
    }
    /**
     * Set BaggageOptionCode value
     * @param string $baggageOptionCode
     * @return \StructType\BaggagePricingCriteriaType
     */
    public function setBaggageOptionCode($baggageOptionCode = null)
    {
        // validation for constraint: string
        if (!is_null($baggageOptionCode) && !is_string($baggageOptionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baggageOptionCode, true), gettype($baggageOptionCode)), __LINE__);
        }
        $this->BaggageOptionCode = $baggageOptionCode;
        return $this;
    }
    /**
     * Get CommercialAgreementID value
     * @return string|null
     */
    public function getCommercialAgreementID()
    {
        return $this->CommercialAgreementID;
    }
    /**
     * Set CommercialAgreementID value
     * @param string $commercialAgreementID
     * @return \StructType\BaggagePricingCriteriaType
     */
    public function setCommercialAgreementID($commercialAgreementID = null)
    {
        // validation for constraint: string
        if (!is_null($commercialAgreementID) && !is_string($commercialAgreementID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commercialAgreementID, true), gettype($commercialAgreementID)), __LINE__);
        }
        $this->CommercialAgreementID = $commercialAgreementID;
        return $this;
    }
    /**
     * Get DeferralInd value
     * @return bool|null
     */
    public function getDeferralInd()
    {
        return $this->DeferralInd;
    }
    /**
     * Set DeferralInd value
     * @param bool $deferralInd
     * @return \StructType\BaggagePricingCriteriaType
     */
    public function setDeferralInd($deferralInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($deferralInd) && !is_bool($deferralInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($deferralInd, true), gettype($deferralInd)), __LINE__);
        }
        $this->DeferralInd = $deferralInd;
        return $this;
    }
    /**
     * Get FixedPrePaidInd value
     * @return bool|null
     */
    public function getFixedPrePaidInd()
    {
        return $this->FixedPrePaidInd;
    }
    /**
     * Set FixedPrePaidInd value
     * @param bool $fixedPrePaidInd
     * @return \StructType\BaggagePricingCriteriaType
     */
    public function setFixedPrePaidInd($fixedPrePaidInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($fixedPrePaidInd) && !is_bool($fixedPrePaidInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fixedPrePaidInd, true), gettype($fixedPrePaidInd)), __LINE__);
        }
        $this->FixedPrePaidInd = $fixedPrePaidInd;
        return $this;
    }
    /**
     * Get IncludeSettlementInd value
     * @return bool|null
     */
    public function getIncludeSettlementInd()
    {
        return $this->IncludeSettlementInd;
    }
    /**
     * Set IncludeSettlementInd value
     * @param bool $includeSettlementInd
     * @return \StructType\BaggagePricingCriteriaType
     */
    public function setIncludeSettlementInd($includeSettlementInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeSettlementInd) && !is_bool($includeSettlementInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeSettlementInd, true), gettype($includeSettlementInd)), __LINE__);
        }
        $this->IncludeSettlementInd = $includeSettlementInd;
        return $this;
    }
    /**
     * Get OptionalChargesCode value
     * @return string|null
     */
    public function getOptionalChargesCode()
    {
        return $this->OptionalChargesCode;
    }
    /**
     * Set OptionalChargesCode value
     * @param string $optionalChargesCode
     * @return \StructType\BaggagePricingCriteriaType
     */
    public function setOptionalChargesCode($optionalChargesCode = null)
    {
        // validation for constraint: string
        if (!is_null($optionalChargesCode) && !is_string($optionalChargesCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($optionalChargesCode, true), gettype($optionalChargesCode)), __LINE__);
        }
        $this->OptionalChargesCode = $optionalChargesCode;
        return $this;
    }
    /**
     * Get RequestedActionCode value
     * @return string|null
     */
    public function getRequestedActionCode()
    {
        return $this->RequestedActionCode;
    }
    /**
     * Set RequestedActionCode value
     * @param string $requestedActionCode
     * @return \StructType\BaggagePricingCriteriaType
     */
    public function setRequestedActionCode($requestedActionCode = null)
    {
        // validation for constraint: string
        if (!is_null($requestedActionCode) && !is_string($requestedActionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestedActionCode, true), gettype($requestedActionCode)), __LINE__);
        }
        $this->RequestedActionCode = $requestedActionCode;
        return $this;
    }
}
