<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaggageAllowanceType StructType
 * Meta information extracted from the WSDL
 * - documentation: The amount of checked or carry-on luggage the airline will allow per passenger.
 * @subpackage Structs
 */
class BaggageAllowanceType extends AbstractStructBase
{
    /**
     * The BaggageAllowanceID
     * Meta information extracted from the WSDL
     * - documentation: Unique identifier of this Baggage Allowance. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BaggageAllowanceID;
    /**
     * The TypeCode
     * Meta information extracted from the WSDL
     * - documentation: Type of Baggage Allowance. E.g. Checked or CarryOn. | Enumeration values for Baggage Type. {codeListAgencyName}IATA Code List{/codeListAgencyName} {codeListName}Baggage Allowance Type Status, Coded.{/codeListName}
     * {codeListIdentifier}BaggageAllowanceType{/codeListIdentifier} | Additional BDT to specify baggage type code.
     * - base: BaggageTypeCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TypeCode;
    /**
     * The AirlineTaxonomy
     * Meta information extracted from the WSDL
     * - documentation: Used in the context of the Airline Taxonomy to define a product or service to the seller or to request a collection of products and services from an airline. For more information on what values should be placed within these fields,
     * see the implementation guide at: https://guides.developer.iata.org
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AirlineTaxonomyType
     */
    public $AirlineTaxonomy;
    /**
     * The ApplicablePartyText
     * Meta information extracted from the WSDL
     * - documentation: Baggage weight restriction application. Examples: Party, Traveler. Party applies to all Travelers. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ApplicablePartyText;
    /**
     * The BDC
     * Meta information extracted from the WSDL
     * - documentation: A carrier whose baggage allowances and charges apply.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BDC_Type
     */
    public $BDC;
    /**
     * The DescText
     * Meta information extracted from the WSDL
     * - documentation: Baggage Allowance description and additional information. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $DescText;
    /**
     * The MaximumDimensionAllowance
     * Meta information extracted from the WSDL
     * - documentation: Baggage dimension allowance with application information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DimensionAllowanceType[]
     */
    public $MaximumDimensionAllowance;
    /**
     * The MinimumDimensionAllowance
     * Meta information extracted from the WSDL
     * - documentation: Baggage dimension allowance with application information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DimensionAllowanceType[]
     */
    public $MinimumDimensionAllowance;
    /**
     * The PieceAllowance
     * Meta information extracted from the WSDL
     * - documentation: Defines the maximum number of each allowable baggage type.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PieceAllowanceType
     */
    public $PieceAllowance;
    /**
     * The RFISC
     * Meta information extracted from the WSDL
     * - documentation: Reason For Issuance Sub Code. Examples: 0CC (First Checked Bag) 0B1 (In-flight Entertainment) 0BX (Lounge) | Enumeration values for Reason for Issuance sub codes. Examples: 0CC (First Checked Bag). 0B1 (In-flight Entertainment). 0BX
     * (Lounge). 0B3 (Meal/ Beverage). 0B5 (Pre-reserved Seat Assignment). 0G6 (Priority Boarding). {codeListAgencyName}ATPCo{/codeListAgencyName} {codeListName}Optional Services Industry Sub Codes{/codeListName} | Additional BDT to specify the reason for
     * issuance sub code.
     * - base: RFISC_CodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RFISC;
    /**
     * The WeightAllowance
     * Meta information extracted from the WSDL
     * - documentation: Baggage weight allowance with application information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WeightAllowanceType[]
     */
    public $WeightAllowance;
    /**
     * Constructor method for BaggageAllowanceType
     * @uses BaggageAllowanceType::setBaggageAllowanceID()
     * @uses BaggageAllowanceType::setTypeCode()
     * @uses BaggageAllowanceType::setAirlineTaxonomy()
     * @uses BaggageAllowanceType::setApplicablePartyText()
     * @uses BaggageAllowanceType::setBDC()
     * @uses BaggageAllowanceType::setDescText()
     * @uses BaggageAllowanceType::setMaximumDimensionAllowance()
     * @uses BaggageAllowanceType::setMinimumDimensionAllowance()
     * @uses BaggageAllowanceType::setPieceAllowance()
     * @uses BaggageAllowanceType::setRFISC()
     * @uses BaggageAllowanceType::setWeightAllowance()
     * @param string $baggageAllowanceID
     * @param string $typeCode
     * @param \StructType\AirlineTaxonomyType $airlineTaxonomy
     * @param string $applicablePartyText
     * @param \StructType\BDC_Type $bDC
     * @param string[] $descText
     * @param \StructType\DimensionAllowanceType[] $maximumDimensionAllowance
     * @param \StructType\DimensionAllowanceType[] $minimumDimensionAllowance
     * @param \StructType\PieceAllowanceType $pieceAllowance
     * @param string $rFISC
     * @param \StructType\WeightAllowanceType[] $weightAllowance
     */
    public function __construct($baggageAllowanceID = null, $typeCode = null, \StructType\AirlineTaxonomyType $airlineTaxonomy = null, $applicablePartyText = null, \StructType\BDC_Type $bDC = null, array $descText = array(), array $maximumDimensionAllowance = array(), array $minimumDimensionAllowance = array(), \StructType\PieceAllowanceType $pieceAllowance = null, $rFISC = null, array $weightAllowance = array())
    {
        $this
            ->setBaggageAllowanceID($baggageAllowanceID)
            ->setTypeCode($typeCode)
            ->setAirlineTaxonomy($airlineTaxonomy)
            ->setApplicablePartyText($applicablePartyText)
            ->setBDC($bDC)
            ->setDescText($descText)
            ->setMaximumDimensionAllowance($maximumDimensionAllowance)
            ->setMinimumDimensionAllowance($minimumDimensionAllowance)
            ->setPieceAllowance($pieceAllowance)
            ->setRFISC($rFISC)
            ->setWeightAllowance($weightAllowance);
    }
    /**
     * Get BaggageAllowanceID value
     * @return string
     */
    public function getBaggageAllowanceID()
    {
        return $this->BaggageAllowanceID;
    }
    /**
     * Set BaggageAllowanceID value
     * @param string $baggageAllowanceID
     * @return \StructType\BaggageAllowanceType
     */
    public function setBaggageAllowanceID($baggageAllowanceID = null)
    {
        // validation for constraint: string
        if (!is_null($baggageAllowanceID) && !is_string($baggageAllowanceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baggageAllowanceID, true), gettype($baggageAllowanceID)), __LINE__);
        }
        $this->BaggageAllowanceID = $baggageAllowanceID;
        return $this;
    }
    /**
     * Get TypeCode value
     * @return string
     */
    public function getTypeCode()
    {
        return $this->TypeCode;
    }
    /**
     * Set TypeCode value
     * @param string $typeCode
     * @return \StructType\BaggageAllowanceType
     */
    public function setTypeCode($typeCode = null)
    {
        // validation for constraint: string
        if (!is_null($typeCode) && !is_string($typeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeCode, true), gettype($typeCode)), __LINE__);
        }
        $this->TypeCode = $typeCode;
        return $this;
    }
    /**
     * Get AirlineTaxonomy value
     * @return \StructType\AirlineTaxonomyType|null
     */
    public function getAirlineTaxonomy()
    {
        return $this->AirlineTaxonomy;
    }
    /**
     * Set AirlineTaxonomy value
     * @param \StructType\AirlineTaxonomyType $airlineTaxonomy
     * @return \StructType\BaggageAllowanceType
     */
    public function setAirlineTaxonomy(\StructType\AirlineTaxonomyType $airlineTaxonomy = null)
    {
        $this->AirlineTaxonomy = $airlineTaxonomy;
        return $this;
    }
    /**
     * Get ApplicablePartyText value
     * @return string|null
     */
    public function getApplicablePartyText()
    {
        return $this->ApplicablePartyText;
    }
    /**
     * Set ApplicablePartyText value
     * @param string $applicablePartyText
     * @return \StructType\BaggageAllowanceType
     */
    public function setApplicablePartyText($applicablePartyText = null)
    {
        // validation for constraint: string
        if (!is_null($applicablePartyText) && !is_string($applicablePartyText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicablePartyText, true), gettype($applicablePartyText)), __LINE__);
        }
        $this->ApplicablePartyText = $applicablePartyText;
        return $this;
    }
    /**
     * Get BDC value
     * @return \StructType\BDC_Type|null
     */
    public function getBDC()
    {
        return $this->BDC;
    }
    /**
     * Set BDC value
     * @param \StructType\BDC_Type $bDC
     * @return \StructType\BaggageAllowanceType
     */
    public function setBDC(\StructType\BDC_Type $bDC = null)
    {
        $this->BDC = $bDC;
        return $this;
    }
    /**
     * Get DescText value
     * @return string[]|null
     */
    public function getDescText()
    {
        return $this->DescText;
    }
    /**
     * This method is responsible for validating the values passed to the setDescText method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescText method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescTextForArrayConstraintsFromSetDescText(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $baggageAllowanceTypeDescTextItem) {
            // validation for constraint: itemType
            if (!is_string($baggageAllowanceTypeDescTextItem)) {
                $invalidValues[] = is_object($baggageAllowanceTypeDescTextItem) ? get_class($baggageAllowanceTypeDescTextItem) : sprintf('%s(%s)', gettype($baggageAllowanceTypeDescTextItem), var_export($baggageAllowanceTypeDescTextItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DescText property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DescText value
     * @throws \InvalidArgumentException
     * @param string[] $descText
     * @return \StructType\BaggageAllowanceType
     */
    public function setDescText(array $descText = array())
    {
        // validation for constraint: array
        if ('' !== ($descTextArrayErrorMessage = self::validateDescTextForArrayConstraintsFromSetDescText($descText))) {
            throw new \InvalidArgumentException($descTextArrayErrorMessage, __LINE__);
        }
        $this->DescText = $descText;
        return $this;
    }
    /**
     * Add item to DescText value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\BaggageAllowanceType
     */
    public function addToDescText($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The DescText property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DescText[] = $item;
        return $this;
    }
    /**
     * Get MaximumDimensionAllowance value
     * @return \StructType\DimensionAllowanceType[]|null
     */
    public function getMaximumDimensionAllowance()
    {
        return $this->MaximumDimensionAllowance;
    }
    /**
     * This method is responsible for validating the values passed to the setMaximumDimensionAllowance method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMaximumDimensionAllowance method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMaximumDimensionAllowanceForArrayConstraintsFromSetMaximumDimensionAllowance(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $baggageAllowanceTypeMaximumDimensionAllowanceItem) {
            // validation for constraint: itemType
            if (!$baggageAllowanceTypeMaximumDimensionAllowanceItem instanceof \StructType\DimensionAllowanceType) {
                $invalidValues[] = is_object($baggageAllowanceTypeMaximumDimensionAllowanceItem) ? get_class($baggageAllowanceTypeMaximumDimensionAllowanceItem) : sprintf('%s(%s)', gettype($baggageAllowanceTypeMaximumDimensionAllowanceItem), var_export($baggageAllowanceTypeMaximumDimensionAllowanceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MaximumDimensionAllowance property can only contain items of type \StructType\DimensionAllowanceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MaximumDimensionAllowance value
     * @throws \InvalidArgumentException
     * @param \StructType\DimensionAllowanceType[] $maximumDimensionAllowance
     * @return \StructType\BaggageAllowanceType
     */
    public function setMaximumDimensionAllowance(array $maximumDimensionAllowance = array())
    {
        // validation for constraint: array
        if ('' !== ($maximumDimensionAllowanceArrayErrorMessage = self::validateMaximumDimensionAllowanceForArrayConstraintsFromSetMaximumDimensionAllowance($maximumDimensionAllowance))) {
            throw new \InvalidArgumentException($maximumDimensionAllowanceArrayErrorMessage, __LINE__);
        }
        $this->MaximumDimensionAllowance = $maximumDimensionAllowance;
        return $this;
    }
    /**
     * Add item to MaximumDimensionAllowance value
     * @throws \InvalidArgumentException
     * @param \StructType\DimensionAllowanceType $item
     * @return \StructType\BaggageAllowanceType
     */
    public function addToMaximumDimensionAllowance(\StructType\DimensionAllowanceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DimensionAllowanceType) {
            throw new \InvalidArgumentException(sprintf('The MaximumDimensionAllowance property can only contain items of type \StructType\DimensionAllowanceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MaximumDimensionAllowance[] = $item;
        return $this;
    }
    /**
     * Get MinimumDimensionAllowance value
     * @return \StructType\DimensionAllowanceType[]|null
     */
    public function getMinimumDimensionAllowance()
    {
        return $this->MinimumDimensionAllowance;
    }
    /**
     * This method is responsible for validating the values passed to the setMinimumDimensionAllowance method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMinimumDimensionAllowance method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMinimumDimensionAllowanceForArrayConstraintsFromSetMinimumDimensionAllowance(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $baggageAllowanceTypeMinimumDimensionAllowanceItem) {
            // validation for constraint: itemType
            if (!$baggageAllowanceTypeMinimumDimensionAllowanceItem instanceof \StructType\DimensionAllowanceType) {
                $invalidValues[] = is_object($baggageAllowanceTypeMinimumDimensionAllowanceItem) ? get_class($baggageAllowanceTypeMinimumDimensionAllowanceItem) : sprintf('%s(%s)', gettype($baggageAllowanceTypeMinimumDimensionAllowanceItem), var_export($baggageAllowanceTypeMinimumDimensionAllowanceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MinimumDimensionAllowance property can only contain items of type \StructType\DimensionAllowanceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MinimumDimensionAllowance value
     * @throws \InvalidArgumentException
     * @param \StructType\DimensionAllowanceType[] $minimumDimensionAllowance
     * @return \StructType\BaggageAllowanceType
     */
    public function setMinimumDimensionAllowance(array $minimumDimensionAllowance = array())
    {
        // validation for constraint: array
        if ('' !== ($minimumDimensionAllowanceArrayErrorMessage = self::validateMinimumDimensionAllowanceForArrayConstraintsFromSetMinimumDimensionAllowance($minimumDimensionAllowance))) {
            throw new \InvalidArgumentException($minimumDimensionAllowanceArrayErrorMessage, __LINE__);
        }
        $this->MinimumDimensionAllowance = $minimumDimensionAllowance;
        return $this;
    }
    /**
     * Add item to MinimumDimensionAllowance value
     * @throws \InvalidArgumentException
     * @param \StructType\DimensionAllowanceType $item
     * @return \StructType\BaggageAllowanceType
     */
    public function addToMinimumDimensionAllowance(\StructType\DimensionAllowanceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DimensionAllowanceType) {
            throw new \InvalidArgumentException(sprintf('The MinimumDimensionAllowance property can only contain items of type \StructType\DimensionAllowanceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MinimumDimensionAllowance[] = $item;
        return $this;
    }
    /**
     * Get PieceAllowance value
     * @return \StructType\PieceAllowanceType|null
     */
    public function getPieceAllowance()
    {
        return $this->PieceAllowance;
    }
    /**
     * Set PieceAllowance value
     * @param \StructType\PieceAllowanceType $pieceAllowance
     * @return \StructType\BaggageAllowanceType
     */
    public function setPieceAllowance(\StructType\PieceAllowanceType $pieceAllowance = null)
    {
        $this->PieceAllowance = $pieceAllowance;
        return $this;
    }
    /**
     * Get RFISC value
     * @return string|null
     */
    public function getRFISC()
    {
        return $this->RFISC;
    }
    /**
     * Set RFISC value
     * @param string $rFISC
     * @return \StructType\BaggageAllowanceType
     */
    public function setRFISC($rFISC = null)
    {
        // validation for constraint: string
        if (!is_null($rFISC) && !is_string($rFISC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFISC, true), gettype($rFISC)), __LINE__);
        }
        $this->RFISC = $rFISC;
        return $this;
    }
    /**
     * Get WeightAllowance value
     * @return \StructType\WeightAllowanceType[]|null
     */
    public function getWeightAllowance()
    {
        return $this->WeightAllowance;
    }
    /**
     * This method is responsible for validating the values passed to the setWeightAllowance method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWeightAllowance method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWeightAllowanceForArrayConstraintsFromSetWeightAllowance(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $baggageAllowanceTypeWeightAllowanceItem) {
            // validation for constraint: itemType
            if (!$baggageAllowanceTypeWeightAllowanceItem instanceof \StructType\WeightAllowanceType) {
                $invalidValues[] = is_object($baggageAllowanceTypeWeightAllowanceItem) ? get_class($baggageAllowanceTypeWeightAllowanceItem) : sprintf('%s(%s)', gettype($baggageAllowanceTypeWeightAllowanceItem), var_export($baggageAllowanceTypeWeightAllowanceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WeightAllowance property can only contain items of type \StructType\WeightAllowanceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WeightAllowance value
     * @throws \InvalidArgumentException
     * @param \StructType\WeightAllowanceType[] $weightAllowance
     * @return \StructType\BaggageAllowanceType
     */
    public function setWeightAllowance(array $weightAllowance = array())
    {
        // validation for constraint: array
        if ('' !== ($weightAllowanceArrayErrorMessage = self::validateWeightAllowanceForArrayConstraintsFromSetWeightAllowance($weightAllowance))) {
            throw new \InvalidArgumentException($weightAllowanceArrayErrorMessage, __LINE__);
        }
        $this->WeightAllowance = $weightAllowance;
        return $this;
    }
    /**
     * Add item to WeightAllowance value
     * @throws \InvalidArgumentException
     * @param \StructType\WeightAllowanceType $item
     * @return \StructType\BaggageAllowanceType
     */
    public function addToWeightAllowance(\StructType\WeightAllowanceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WeightAllowanceType) {
            throw new \InvalidArgumentException(sprintf('The WeightAllowance property can only contain items of type \StructType\WeightAllowanceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WeightAllowance[] = $item;
        return $this;
    }
}
