<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BagItemDetailsType StructType
 * Meta information extracted from the WSDL
 * - documentation: Additional disclosure and allowance information for Bag Items used in Long Sells.
 * @subpackage Structs
 */
class BagItemDetailsType extends AbstractStructBase
{
    /**
     * The BaggageAllowanceRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Baggage Allowance instance within this message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BaggageAllowanceRefID;
    /**
     * The BaggageDisclosureRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Baggage Disclosure instance within this message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BaggageDisclosureRefID;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - documentation: The amount of money expected, required, or given in payment for something.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PriceType
     */
    public $Price;
    /**
     * The ValidatingCarrierCode
     * Meta information extracted from the WSDL
     * - documentation: Airline designator or CRS code of the owner/ assigner of the Offer ID, typically used for offer ordering purposes. Example: UA, BA Encoding Scheme: IATA/ A4A (two or three character) Airline or CRS Designator Code | The codelist
     * contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution
     * 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined
     * 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $ValidatingCarrierCode;
    /**
     * Constructor method for BagItemDetailsType
     * @uses BagItemDetailsType::setBaggageAllowanceRefID()
     * @uses BagItemDetailsType::setBaggageDisclosureRefID()
     * @uses BagItemDetailsType::setPrice()
     * @uses BagItemDetailsType::setValidatingCarrierCode()
     * @param string $baggageAllowanceRefID
     * @param string $baggageDisclosureRefID
     * @param \StructType\PriceType $price
     * @param string $validatingCarrierCode
     */
    public function __construct($baggageAllowanceRefID = null, $baggageDisclosureRefID = null, \StructType\PriceType $price = null, $validatingCarrierCode = null)
    {
        $this
            ->setBaggageAllowanceRefID($baggageAllowanceRefID)
            ->setBaggageDisclosureRefID($baggageDisclosureRefID)
            ->setPrice($price)
            ->setValidatingCarrierCode($validatingCarrierCode);
    }
    /**
     * Get BaggageAllowanceRefID value
     * @return string
     */
    public function getBaggageAllowanceRefID()
    {
        return $this->BaggageAllowanceRefID;
    }
    /**
     * Set BaggageAllowanceRefID value
     * @param string $baggageAllowanceRefID
     * @return \StructType\BagItemDetailsType
     */
    public function setBaggageAllowanceRefID($baggageAllowanceRefID = null)
    {
        // validation for constraint: string
        if (!is_null($baggageAllowanceRefID) && !is_string($baggageAllowanceRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baggageAllowanceRefID, true), gettype($baggageAllowanceRefID)), __LINE__);
        }
        $this->BaggageAllowanceRefID = $baggageAllowanceRefID;
        return $this;
    }
    /**
     * Get BaggageDisclosureRefID value
     * @return string|null
     */
    public function getBaggageDisclosureRefID()
    {
        return $this->BaggageDisclosureRefID;
    }
    /**
     * Set BaggageDisclosureRefID value
     * @param string $baggageDisclosureRefID
     * @return \StructType\BagItemDetailsType
     */
    public function setBaggageDisclosureRefID($baggageDisclosureRefID = null)
    {
        // validation for constraint: string
        if (!is_null($baggageDisclosureRefID) && !is_string($baggageDisclosureRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baggageDisclosureRefID, true), gettype($baggageDisclosureRefID)), __LINE__);
        }
        $this->BaggageDisclosureRefID = $baggageDisclosureRefID;
        return $this;
    }
    /**
     * Get Price value
     * @return \StructType\PriceType|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \StructType\PriceType $price
     * @return \StructType\BagItemDetailsType
     */
    public function setPrice(\StructType\PriceType $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get ValidatingCarrierCode value
     * @return string|null
     */
    public function getValidatingCarrierCode()
    {
        return $this->ValidatingCarrierCode;
    }
    /**
     * Set ValidatingCarrierCode value
     * @param string $validatingCarrierCode
     * @return \StructType\BagItemDetailsType
     */
    public function setValidatingCarrierCode($validatingCarrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($validatingCarrierCode) && !is_string($validatingCarrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validatingCarrierCode, true), gettype($validatingCarrierCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($validatingCarrierCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $validatingCarrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($validatingCarrierCode, true)), __LINE__);
        }
        $this->ValidatingCarrierCode = $validatingCarrierCode;
        return $this;
    }
}
