<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AvailableSeatType StructType
 * Meta information extracted from the WSDL
 * - documentation: A sitting place for a passenger or crew in a cabin compartment on a transport vehicle.
 * @subpackage Structs
 */
class AvailableSeatType extends AbstractStructBase
{
    /**
     * The ColumnID
     * Meta information extracted from the WSDL
     * - documentation: Alphabetic character identifying a seat within a row. | Specifies a column (e.g. A, B, C, etc.).
     * - base: xs:token
     * - length: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [A-Z]
     * @var string
     */
    public $ColumnID;
    /**
     * The RowNumber
     * Meta information extracted from the WSDL
     * - documentation: DEPRECATED - This element is deprecated as of 24.1 and will be decommissioned in a future release. Please consult implementation guidance on alternatives to this element. Ordinal number identifying a seat row in an aircraft. | A
     * mathematical number used for counting (positive whole number or integer).
     * - base: xs:integer
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 1
     * @var int
     */
    public $RowNumber;
    /**
     * The OccupationStatusCode
     * Meta information extracted from the WSDL
     * - documentation: Information related to the availability of a particular Seat on Leg. | Seat status. Examples: SA (Seats are available) WO (Seats waitlist open for segment) WC (Seats waitlist closed for segment) OR (Seats on request only to airline)
     * {codeListAgencyName}PADIS{/codeListAgencyName} {codeListName}Seat occupation{/codeListName} {codeListIdentifier}9865{/codeListIdentifier} | Additional BDT to specify the seat status code.
     * - base: SeatStatusCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OccupationStatusCode;
    /**
     * The OfferItemRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to the price point applicable to this individual seat. Multiple seats can reference the same OfferItem. | An identifier is a character string used to uniquely identify one instance of an object within an identification
     * scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $OfferItemRefID;
    /**
     * The SeatCharacteristicCode
     * Meta information extracted from the WSDL
     * - documentation: Characteristic of an aircraft seat e.g. A (Aisle seat), E (Exit and emergency exit),..., according to PADIS code list 9825. | Refers to aircraft seat characteristic codes e.g. A (Aisle seat), E (Exit and emergency exit). See PADIS
     * code list 9825. {codeListAgencyName}PADIS{/codeListAgencyName} {codeListName}Seat characteristic,coded{/codeListName} {codeListIdentifier}9825{/codeListIdentifier} | Specifies a Seat Characteristic code.
     * - base: SeatCharacteristicCodeContentType
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $SeatCharacteristicCode;
    /**
     * The SeatProfileRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Seat Profile ID within this message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SeatProfileRefID;
    /**
     * Constructor method for AvailableSeatType
     * @uses AvailableSeatType::setColumnID()
     * @uses AvailableSeatType::setRowNumber()
     * @uses AvailableSeatType::setOccupationStatusCode()
     * @uses AvailableSeatType::setOfferItemRefID()
     * @uses AvailableSeatType::setSeatCharacteristicCode()
     * @uses AvailableSeatType::setSeatProfileRefID()
     * @param string $columnID
     * @param int $rowNumber
     * @param string $occupationStatusCode
     * @param string[] $offerItemRefID
     * @param string[] $seatCharacteristicCode
     * @param string $seatProfileRefID
     */
    public function __construct($columnID = null, $rowNumber = null, $occupationStatusCode = null, array $offerItemRefID = array(), array $seatCharacteristicCode = array(), $seatProfileRefID = null)
    {
        $this
            ->setColumnID($columnID)
            ->setRowNumber($rowNumber)
            ->setOccupationStatusCode($occupationStatusCode)
            ->setOfferItemRefID($offerItemRefID)
            ->setSeatCharacteristicCode($seatCharacteristicCode)
            ->setSeatProfileRefID($seatProfileRefID);
    }
    /**
     * Get ColumnID value
     * @return string
     */
    public function getColumnID()
    {
        return $this->ColumnID;
    }
    /**
     * Set ColumnID value
     * @param string $columnID
     * @return \StructType\AvailableSeatType
     */
    public function setColumnID($columnID = null)
    {
        // validation for constraint: string
        if (!is_null($columnID) && !is_string($columnID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($columnID, true), gettype($columnID)), __LINE__);
        }
        // validation for constraint: length(1)
        if (!is_null($columnID) && mb_strlen($columnID) !== 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 1', mb_strlen($columnID)), __LINE__);
        }
        // validation for constraint: pattern([A-Z])
        if (!is_null($columnID) && !preg_match('/[A-Z]/', $columnID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]', var_export($columnID, true)), __LINE__);
        }
        $this->ColumnID = $columnID;
        return $this;
    }
    /**
     * Get RowNumber value
     * @return int
     */
    public function getRowNumber()
    {
        return $this->RowNumber;
    }
    /**
     * Set RowNumber value
     * @param int $rowNumber
     * @return \StructType\AvailableSeatType
     */
    public function setRowNumber($rowNumber = null)
    {
        // validation for constraint: int
        if (!is_null($rowNumber) && !(is_int($rowNumber) || ctype_digit($rowNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowNumber, true), gettype($rowNumber)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($rowNumber) && $rowNumber < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($rowNumber, true)), __LINE__);
        }
        $this->RowNumber = $rowNumber;
        return $this;
    }
    /**
     * Get OccupationStatusCode value
     * @return string|null
     */
    public function getOccupationStatusCode()
    {
        return $this->OccupationStatusCode;
    }
    /**
     * Set OccupationStatusCode value
     * @param string $occupationStatusCode
     * @return \StructType\AvailableSeatType
     */
    public function setOccupationStatusCode($occupationStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($occupationStatusCode) && !is_string($occupationStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($occupationStatusCode, true), gettype($occupationStatusCode)), __LINE__);
        }
        $this->OccupationStatusCode = $occupationStatusCode;
        return $this;
    }
    /**
     * Get OfferItemRefID value
     * @return string[]|null
     */
    public function getOfferItemRefID()
    {
        return $this->OfferItemRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setOfferItemRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOfferItemRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOfferItemRefIDForArrayConstraintsFromSetOfferItemRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $availableSeatTypeOfferItemRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($availableSeatTypeOfferItemRefIDItem)) {
                $invalidValues[] = is_object($availableSeatTypeOfferItemRefIDItem) ? get_class($availableSeatTypeOfferItemRefIDItem) : sprintf('%s(%s)', gettype($availableSeatTypeOfferItemRefIDItem), var_export($availableSeatTypeOfferItemRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OfferItemRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OfferItemRefID value
     * @throws \InvalidArgumentException
     * @param string[] $offerItemRefID
     * @return \StructType\AvailableSeatType
     */
    public function setOfferItemRefID(array $offerItemRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($offerItemRefIDArrayErrorMessage = self::validateOfferItemRefIDForArrayConstraintsFromSetOfferItemRefID($offerItemRefID))) {
            throw new \InvalidArgumentException($offerItemRefIDArrayErrorMessage, __LINE__);
        }
        $this->OfferItemRefID = $offerItemRefID;
        return $this;
    }
    /**
     * Add item to OfferItemRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\AvailableSeatType
     */
    public function addToOfferItemRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The OfferItemRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OfferItemRefID[] = $item;
        return $this;
    }
    /**
     * Get SeatCharacteristicCode value
     * @return string[]|null
     */
    public function getSeatCharacteristicCode()
    {
        return $this->SeatCharacteristicCode;
    }
    /**
     * This method is responsible for validating the values passed to the setSeatCharacteristicCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeatCharacteristicCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSeatCharacteristicCodeForArrayConstraintsFromSetSeatCharacteristicCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $availableSeatTypeSeatCharacteristicCodeItem) {
            // validation for constraint: itemType
            if (!is_string($availableSeatTypeSeatCharacteristicCodeItem)) {
                $invalidValues[] = is_object($availableSeatTypeSeatCharacteristicCodeItem) ? get_class($availableSeatTypeSeatCharacteristicCodeItem) : sprintf('%s(%s)', gettype($availableSeatTypeSeatCharacteristicCodeItem), var_export($availableSeatTypeSeatCharacteristicCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SeatCharacteristicCode property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SeatCharacteristicCode value
     * @throws \InvalidArgumentException
     * @param string[] $seatCharacteristicCode
     * @return \StructType\AvailableSeatType
     */
    public function setSeatCharacteristicCode(array $seatCharacteristicCode = array())
    {
        // validation for constraint: array
        if ('' !== ($seatCharacteristicCodeArrayErrorMessage = self::validateSeatCharacteristicCodeForArrayConstraintsFromSetSeatCharacteristicCode($seatCharacteristicCode))) {
            throw new \InvalidArgumentException($seatCharacteristicCodeArrayErrorMessage, __LINE__);
        }
        $this->SeatCharacteristicCode = $seatCharacteristicCode;
        return $this;
    }
    /**
     * Add item to SeatCharacteristicCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\AvailableSeatType
     */
    public function addToSeatCharacteristicCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The SeatCharacteristicCode property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SeatCharacteristicCode[] = $item;
        return $this;
    }
    /**
     * Get SeatProfileRefID value
     * @return string|null
     */
    public function getSeatProfileRefID()
    {
        return $this->SeatProfileRefID;
    }
    /**
     * Set SeatProfileRefID value
     * @param string $seatProfileRefID
     * @return \StructType\AvailableSeatType
     */
    public function setSeatProfileRefID($seatProfileRefID = null)
    {
        // validation for constraint: string
        if (!is_null($seatProfileRefID) && !is_string($seatProfileRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatProfileRefID, true), gettype($seatProfileRefID)), __LINE__);
        }
        $this->SeatProfileRefID = $seatProfileRefID;
        return $this;
    }
}
