<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AugPoint StructType
 * @subpackage Structs
 */
class AugPoint extends AbstractStructBase
{
    /**
     * The Association
     * @var \StructType\Association
     */
    public $Association;
    /**
     * The AliasCVV
     * Meta information extracted from the WSDL
     * - choice: AliasCVV | Amex | ATPCO | CCApprovalCode | ClassOfService | Combinability | Commission | CompanyIndexText | CustomParams | Diagnostics | DisplayFareComponentPenalty | DisplayFareComponentPrice | FullCalendarOffer | NumberOfSegments |
     * LoyaltyAccrual | OnTimePerformance | OriginalPriceCalendar | Redemption | ReferenceNumber | UATPReportingData | UseDocument | UserInput | Vouchers | FareCodePriceIndicator | OCNContents | ServiceQualifier | AoaPriceDifferential | CarrierFee |
     * AccountedOrderVersionNumber | SSRText | OtherServiceInformation | TrackID | EquivID | VoucherPin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * - ref: q1:AliasCVV
     * @var string
     */
    public $AliasCVV;
    /**
     * The Amex
     * Meta information extracted from the WSDL
     * - choice: AliasCVV | Amex | ATPCO | CCApprovalCode | ClassOfService | Combinability | Commission | CompanyIndexText | CustomParams | Diagnostics | DisplayFareComponentPenalty | DisplayFareComponentPrice | FullCalendarOffer | NumberOfSegments |
     * LoyaltyAccrual | OnTimePerformance | OriginalPriceCalendar | Redemption | ReferenceNumber | UATPReportingData | UseDocument | UserInput | Vouchers | FareCodePriceIndicator | OCNContents | ServiceQualifier | AoaPriceDifferential | CarrierFee |
     * AccountedOrderVersionNumber | SSRText | OtherServiceInformation | TrackID | EquivID | VoucherPin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * - ref: q2:Amex
     * @var \StructType\Amex
     */
    public $Amex;
    /**
     * The ATPCO
     * Meta information extracted from the WSDL
     * - choice: AliasCVV | Amex | ATPCO | CCApprovalCode | ClassOfService | Combinability | Commission | CompanyIndexText | CustomParams | Diagnostics | DisplayFareComponentPenalty | DisplayFareComponentPrice | FullCalendarOffer | NumberOfSegments |
     * LoyaltyAccrual | OnTimePerformance | OriginalPriceCalendar | Redemption | ReferenceNumber | UATPReportingData | UseDocument | UserInput | Vouchers | FareCodePriceIndicator | OCNContents | ServiceQualifier | AoaPriceDifferential | CarrierFee |
     * AccountedOrderVersionNumber | SSRText | OtherServiceInformation | TrackID | EquivID | VoucherPin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * - ref: q3:ATPCO
     * @var \StructType\ATPCO
     */
    public $ATPCO;
    /**
     * The CCApprovalCode
     * Meta information extracted from the WSDL
     * - choice: AliasCVV | Amex | ATPCO | CCApprovalCode | ClassOfService | Combinability | Commission | CompanyIndexText | CustomParams | Diagnostics | DisplayFareComponentPenalty | DisplayFareComponentPrice | FullCalendarOffer | NumberOfSegments |
     * LoyaltyAccrual | OnTimePerformance | OriginalPriceCalendar | Redemption | ReferenceNumber | UATPReportingData | UseDocument | UserInput | Vouchers | FareCodePriceIndicator | OCNContents | ServiceQualifier | AoaPriceDifferential | CarrierFee |
     * AccountedOrderVersionNumber | SSRText | OtherServiceInformation | TrackID | EquivID | VoucherPin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * - ref: q4:CCApprovalCode
     * @var \StructType\CCApprovalCode
     */
    public $CCApprovalCode;
    /**
     * The ClassOfService
     * Meta information extracted from the WSDL
     * - choice: AliasCVV | Amex | ATPCO | CCApprovalCode | ClassOfService | Combinability | Commission | CompanyIndexText | CustomParams | Diagnostics | DisplayFareComponentPenalty | DisplayFareComponentPrice | FullCalendarOffer | NumberOfSegments |
     * LoyaltyAccrual | OnTimePerformance | OriginalPriceCalendar | Redemption | ReferenceNumber | UATPReportingData | UseDocument | UserInput | Vouchers | FareCodePriceIndicator | OCNContents | ServiceQualifier | AoaPriceDifferential | CarrierFee |
     * AccountedOrderVersionNumber | SSRText | OtherServiceInformation | TrackID | EquivID | VoucherPin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * - ref: q5:ClassOfService
     * @var \StructType\ClassOfService
     */
    public $ClassOfService;
    /**
     * The Combinability
     * Meta information extracted from the WSDL
     * - choice: AliasCVV | Amex | ATPCO | CCApprovalCode | ClassOfService | Combinability | Commission | CompanyIndexText | CustomParams | Diagnostics | DisplayFareComponentPenalty | DisplayFareComponentPrice | FullCalendarOffer | NumberOfSegments |
     * LoyaltyAccrual | OnTimePerformance | OriginalPriceCalendar | Redemption | ReferenceNumber | UATPReportingData | UseDocument | UserInput | Vouchers | FareCodePriceIndicator | OCNContents | ServiceQualifier | AoaPriceDifferential | CarrierFee |
     * AccountedOrderVersionNumber | SSRText | OtherServiceInformation | TrackID | EquivID | VoucherPin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * - ref: q6:Combinability
     * @var \StructType\Combinability
     */
    public $Combinability;
    /**
     * The Commission
     * Meta information extracted from the WSDL
     * - choice: AliasCVV | Amex | ATPCO | CCApprovalCode | ClassOfService | Combinability | Commission | CompanyIndexText | CustomParams | Diagnostics | DisplayFareComponentPenalty | DisplayFareComponentPrice | FullCalendarOffer | NumberOfSegments |
     * LoyaltyAccrual | OnTimePerformance | OriginalPriceCalendar | Redemption | ReferenceNumber | UATPReportingData | UseDocument | UserInput | Vouchers | FareCodePriceIndicator | OCNContents | ServiceQualifier | AoaPriceDifferential | CarrierFee |
     * AccountedOrderVersionNumber | SSRText | OtherServiceInformation | TrackID | EquivID | VoucherPin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * - ref: q7:Commission
     * @var \StructType\Commission
     */
    public $Commission;
    /**
     * The CompanyIndexText
     * Meta information extracted from the WSDL
     * - choice: AliasCVV | Amex | ATPCO | CCApprovalCode | ClassOfService | Combinability | Commission | CompanyIndexText | CustomParams | Diagnostics | DisplayFareComponentPenalty | DisplayFareComponentPrice | FullCalendarOffer | NumberOfSegments |
     * LoyaltyAccrual | OnTimePerformance | OriginalPriceCalendar | Redemption | ReferenceNumber | UATPReportingData | UseDocument | UserInput | Vouchers | FareCodePriceIndicator | OCNContents | ServiceQualifier | AoaPriceDifferential | CarrierFee |
     * AccountedOrderVersionNumber | SSRText | OtherServiceInformation | TrackID | EquivID | VoucherPin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * - ref: q8:CompanyIndexText
     * @var string
     */
    public $CompanyIndexText;
    /**
     * The CustomParams
     * Meta information extracted from the WSDL
     * - choice: AliasCVV | Amex | ATPCO | CCApprovalCode | ClassOfService | Combinability | Commission | CompanyIndexText | CustomParams | Diagnostics | DisplayFareComponentPenalty | DisplayFareComponentPrice | FullCalendarOffer | NumberOfSegments |
     * LoyaltyAccrual | OnTimePerformance | OriginalPriceCalendar | Redemption | ReferenceNumber | UATPReportingData | UseDocument | UserInput | Vouchers | FareCodePriceIndicator | OCNContents | ServiceQualifier | AoaPriceDifferential | CarrierFee |
     * AccountedOrderVersionNumber | SSRText | OtherServiceInformation | TrackID | EquivID | VoucherPin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * - ref: q9:CustomParams
     * @var \StructType\CustomParams
     */
    public $CustomParams;
    /**
     * The Diagnostics
     * Meta information extracted from the WSDL
     * - choice: AliasCVV | Amex | ATPCO | CCApprovalCode | ClassOfService | Combinability | Commission | CompanyIndexText | CustomParams | Diagnostics | DisplayFareComponentPenalty | DisplayFareComponentPrice | FullCalendarOffer | NumberOfSegments |
     * LoyaltyAccrual | OnTimePerformance | OriginalPriceCalendar | Redemption | ReferenceNumber | UATPReportingData | UseDocument | UserInput | Vouchers | FareCodePriceIndicator | OCNContents | ServiceQualifier | AoaPriceDifferential | CarrierFee |
     * AccountedOrderVersionNumber | SSRText | OtherServiceInformation | TrackID | EquivID | VoucherPin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * - ref: q10:Diagnostics
     * @var \StructType\Diagnostics
     */
    public $Diagnostics;
    /**
     * The DisplayFareComponentPenalty
     * Meta information extracted from the WSDL
     * - choice: AliasCVV | Amex | ATPCO | CCApprovalCode | ClassOfService | Combinability | Commission | CompanyIndexText | CustomParams | Diagnostics | DisplayFareComponentPenalty | DisplayFareComponentPrice | FullCalendarOffer | NumberOfSegments |
     * LoyaltyAccrual | OnTimePerformance | OriginalPriceCalendar | Redemption | ReferenceNumber | UATPReportingData | UseDocument | UserInput | Vouchers | FareCodePriceIndicator | OCNContents | ServiceQualifier | AoaPriceDifferential | CarrierFee |
     * AccountedOrderVersionNumber | SSRText | OtherServiceInformation | TrackID | EquivID | VoucherPin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * - ref: q11:DisplayFareComponentPenalty
     * @var mixed
     */
    public $DisplayFareComponentPenalty;
    /**
     * The DisplayFareComponentPrice
     * Meta information extracted from the WSDL
     * - choice: AliasCVV | Amex | ATPCO | CCApprovalCode | ClassOfService | Combinability | Commission | CompanyIndexText | CustomParams | Diagnostics | DisplayFareComponentPenalty | DisplayFareComponentPrice | FullCalendarOffer | NumberOfSegments |
     * LoyaltyAccrual | OnTimePerformance | OriginalPriceCalendar | Redemption | ReferenceNumber | UATPReportingData | UseDocument | UserInput | Vouchers | FareCodePriceIndicator | OCNContents | ServiceQualifier | AoaPriceDifferential | CarrierFee |
     * AccountedOrderVersionNumber | SSRText | OtherServiceInformation | TrackID | EquivID | VoucherPin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * - ref: q12:DisplayFareComponentPrice
     * @var mixed
     */
    public $DisplayFareComponentPrice;
    /**
     * The FullCalendarOffer
     * Meta information extracted from the WSDL
     * - choice: AliasCVV | Amex | ATPCO | CCApprovalCode | ClassOfService | Combinability | Commission | CompanyIndexText | CustomParams | Diagnostics | DisplayFareComponentPenalty | DisplayFareComponentPrice | FullCalendarOffer | NumberOfSegments |
     * LoyaltyAccrual | OnTimePerformance | OriginalPriceCalendar | Redemption | ReferenceNumber | UATPReportingData | UseDocument | UserInput | Vouchers | FareCodePriceIndicator | OCNContents | ServiceQualifier | AoaPriceDifferential | CarrierFee |
     * AccountedOrderVersionNumber | SSRText | OtherServiceInformation | TrackID | EquivID | VoucherPin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * - ref: q13:FullCalendarOffer
     * @var string
     */
    public $FullCalendarOffer;
    /**
     * The NumberOfSegments
     * Meta information extracted from the WSDL
     * - documentation: The number of segments in the calendar shopping solution. Example: 1: direct flight>1: indicates connections 
     * - base: xs:integer
     * - choice: AliasCVV | Amex | ATPCO | CCApprovalCode | ClassOfService | Combinability | Commission | CompanyIndexText | CustomParams | Diagnostics | DisplayFareComponentPenalty | DisplayFareComponentPrice | FullCalendarOffer | NumberOfSegments |
     * LoyaltyAccrual | OnTimePerformance | OriginalPriceCalendar | Redemption | ReferenceNumber | UATPReportingData | UseDocument | UserInput | Vouchers | FareCodePriceIndicator | OCNContents | ServiceQualifier | AoaPriceDifferential | CarrierFee |
     * AccountedOrderVersionNumber | SSRText | OtherServiceInformation | TrackID | EquivID | VoucherPin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * - ref: q14:NumberOfSegments
     * - totalDigits: 1
     * @var int
     */
    public $NumberOfSegments;
    /**
     * The LoyaltyAccrual
     * Meta information extracted from the WSDL
     * - choice: AliasCVV | Amex | ATPCO | CCApprovalCode | ClassOfService | Combinability | Commission | CompanyIndexText | CustomParams | Diagnostics | DisplayFareComponentPenalty | DisplayFareComponentPrice | FullCalendarOffer | NumberOfSegments |
     * LoyaltyAccrual | OnTimePerformance | OriginalPriceCalendar | Redemption | ReferenceNumber | UATPReportingData | UseDocument | UserInput | Vouchers | FareCodePriceIndicator | OCNContents | ServiceQualifier | AoaPriceDifferential | CarrierFee |
     * AccountedOrderVersionNumber | SSRText | OtherServiceInformation | TrackID | EquivID | VoucherPin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * - ref: q15:LoyaltyAccrual
     * @var \StructType\LoyaltyAccrual
     */
    public $LoyaltyAccrual;
    /**
     * The OnTimePerformance
     * Meta information extracted from the WSDL
     * - choice: AliasCVV | Amex | ATPCO | CCApprovalCode | ClassOfService | Combinability | Commission | CompanyIndexText | CustomParams | Diagnostics | DisplayFareComponentPenalty | DisplayFareComponentPrice | FullCalendarOffer | NumberOfSegments |
     * LoyaltyAccrual | OnTimePerformance | OriginalPriceCalendar | Redemption | ReferenceNumber | UATPReportingData | UseDocument | UserInput | Vouchers | FareCodePriceIndicator | OCNContents | ServiceQualifier | AoaPriceDifferential | CarrierFee |
     * AccountedOrderVersionNumber | SSRText | OtherServiceInformation | TrackID | EquivID | VoucherPin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * - ref: q16:OnTimePerformance
     * @var \StructType\OnTimePerformance
     */
    public $OnTimePerformance;
    /**
     * The OriginalPriceCalendar
     * Meta information extracted from the WSDL
     * - choice: AliasCVV | Amex | ATPCO | CCApprovalCode | ClassOfService | Combinability | Commission | CompanyIndexText | CustomParams | Diagnostics | DisplayFareComponentPenalty | DisplayFareComponentPrice | FullCalendarOffer | NumberOfSegments |
     * LoyaltyAccrual | OnTimePerformance | OriginalPriceCalendar | Redemption | ReferenceNumber | UATPReportingData | UseDocument | UserInput | Vouchers | FareCodePriceIndicator | OCNContents | ServiceQualifier | AoaPriceDifferential | CarrierFee |
     * AccountedOrderVersionNumber | SSRText | OtherServiceInformation | TrackID | EquivID | VoucherPin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * - ref: q17:OriginalPriceCalendar
     * @var string
     */
    public $OriginalPriceCalendar;
    /**
     * The Redemption
     * Meta information extracted from the WSDL
     * - choice: AliasCVV | Amex | ATPCO | CCApprovalCode | ClassOfService | Combinability | Commission | CompanyIndexText | CustomParams | Diagnostics | DisplayFareComponentPenalty | DisplayFareComponentPrice | FullCalendarOffer | NumberOfSegments |
     * LoyaltyAccrual | OnTimePerformance | OriginalPriceCalendar | Redemption | ReferenceNumber | UATPReportingData | UseDocument | UserInput | Vouchers | FareCodePriceIndicator | OCNContents | ServiceQualifier | AoaPriceDifferential | CarrierFee |
     * AccountedOrderVersionNumber | SSRText | OtherServiceInformation | TrackID | EquivID | VoucherPin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * - ref: q18:Redemption
     * @var \StructType\Redemption
     */
    public $Redemption;
    /**
     * The ReferenceNumber
     * Meta information extracted from the WSDL
     * - documentation: Reference number associated with TokenizedCardNumberExample: 12345
     * - base: xs:string
     * - choice: AliasCVV | Amex | ATPCO | CCApprovalCode | ClassOfService | Combinability | Commission | CompanyIndexText | CustomParams | Diagnostics | DisplayFareComponentPenalty | DisplayFareComponentPrice | FullCalendarOffer | NumberOfSegments |
     * LoyaltyAccrual | OnTimePerformance | OriginalPriceCalendar | Redemption | ReferenceNumber | UATPReportingData | UseDocument | UserInput | Vouchers | FareCodePriceIndicator | OCNContents | ServiceQualifier | AoaPriceDifferential | CarrierFee |
     * AccountedOrderVersionNumber | SSRText | OtherServiceInformation | TrackID | EquivID | VoucherPin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * - pattern: ([a-zA-Z0-9])*
     * - ref: q19:ReferenceNumber
     * @var string
     */
    public $ReferenceNumber;
    /**
     * The UATPReportingData
     * Meta information extracted from the WSDL
     * - choice: AliasCVV | Amex | ATPCO | CCApprovalCode | ClassOfService | Combinability | Commission | CompanyIndexText | CustomParams | Diagnostics | DisplayFareComponentPenalty | DisplayFareComponentPrice | FullCalendarOffer | NumberOfSegments |
     * LoyaltyAccrual | OnTimePerformance | OriginalPriceCalendar | Redemption | ReferenceNumber | UATPReportingData | UseDocument | UserInput | Vouchers | FareCodePriceIndicator | OCNContents | ServiceQualifier | AoaPriceDifferential | CarrierFee |
     * AccountedOrderVersionNumber | SSRText | OtherServiceInformation | TrackID | EquivID | VoucherPin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * - ref: q20:UATPReportingData
     * @var \StructType\UATPReportingData
     */
    public $UATPReportingData;
    /**
     * The UseDocument
     * Meta information extracted from the WSDL
     * - choice: AliasCVV | Amex | ATPCO | CCApprovalCode | ClassOfService | Combinability | Commission | CompanyIndexText | CustomParams | Diagnostics | DisplayFareComponentPenalty | DisplayFareComponentPrice | FullCalendarOffer | NumberOfSegments |
     * LoyaltyAccrual | OnTimePerformance | OriginalPriceCalendar | Redemption | ReferenceNumber | UATPReportingData | UseDocument | UserInput | Vouchers | FareCodePriceIndicator | OCNContents | ServiceQualifier | AoaPriceDifferential | CarrierFee |
     * AccountedOrderVersionNumber | SSRText | OtherServiceInformation | TrackID | EquivID | VoucherPin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * - ref: q21:UseDocument
     * @var \StructType\UseDocument
     */
    public $UseDocument;
    /**
     * The UserInput
     * Meta information extracted from the WSDL
     * - choice: AliasCVV | Amex | ATPCO | CCApprovalCode | ClassOfService | Combinability | Commission | CompanyIndexText | CustomParams | Diagnostics | DisplayFareComponentPenalty | DisplayFareComponentPrice | FullCalendarOffer | NumberOfSegments |
     * LoyaltyAccrual | OnTimePerformance | OriginalPriceCalendar | Redemption | ReferenceNumber | UATPReportingData | UseDocument | UserInput | Vouchers | FareCodePriceIndicator | OCNContents | ServiceQualifier | AoaPriceDifferential | CarrierFee |
     * AccountedOrderVersionNumber | SSRText | OtherServiceInformation | TrackID | EquivID | VoucherPin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * - ref: q22:UserInput
     * @var \StructType\UserInput
     */
    public $UserInput;
    /**
     * The Vouchers
     * Meta information extracted from the WSDL
     * - choice: AliasCVV | Amex | ATPCO | CCApprovalCode | ClassOfService | Combinability | Commission | CompanyIndexText | CustomParams | Diagnostics | DisplayFareComponentPenalty | DisplayFareComponentPrice | FullCalendarOffer | NumberOfSegments |
     * LoyaltyAccrual | OnTimePerformance | OriginalPriceCalendar | Redemption | ReferenceNumber | UATPReportingData | UseDocument | UserInput | Vouchers | FareCodePriceIndicator | OCNContents | ServiceQualifier | AoaPriceDifferential | CarrierFee |
     * AccountedOrderVersionNumber | SSRText | OtherServiceInformation | TrackID | EquivID | VoucherPin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * - ref: q23:Vouchers
     * @var \StructType\Vouchers
     */
    public $Vouchers;
    /**
     * The FareCodePriceIndicator
     * Meta information extracted from the WSDL
     * - choice: AliasCVV | Amex | ATPCO | CCApprovalCode | ClassOfService | Combinability | Commission | CompanyIndexText | CustomParams | Diagnostics | DisplayFareComponentPenalty | DisplayFareComponentPrice | FullCalendarOffer | NumberOfSegments |
     * LoyaltyAccrual | OnTimePerformance | OriginalPriceCalendar | Redemption | ReferenceNumber | UATPReportingData | UseDocument | UserInput | Vouchers | FareCodePriceIndicator | OCNContents | ServiceQualifier | AoaPriceDifferential | CarrierFee |
     * AccountedOrderVersionNumber | SSRText | OtherServiceInformation | TrackID | EquivID | VoucherPin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * - ref: q24:FareCodePriceIndicator
     * @var string
     */
    public $FareCodePriceIndicator;
    /**
     * The OCNContents
     * Meta information extracted from the WSDL
     * - choice: AliasCVV | Amex | ATPCO | CCApprovalCode | ClassOfService | Combinability | Commission | CompanyIndexText | CustomParams | Diagnostics | DisplayFareComponentPenalty | DisplayFareComponentPrice | FullCalendarOffer | NumberOfSegments |
     * LoyaltyAccrual | OnTimePerformance | OriginalPriceCalendar | Redemption | ReferenceNumber | UATPReportingData | UseDocument | UserInput | Vouchers | FareCodePriceIndicator | OCNContents | ServiceQualifier | AoaPriceDifferential | CarrierFee |
     * AccountedOrderVersionNumber | SSRText | OtherServiceInformation | TrackID | EquivID | VoucherPin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * - ref: q25:OCNContents
     * @var \StructType\OCNContents
     */
    public $OCNContents;
    /**
     * The ServiceQualifier
     * Meta information extracted from the WSDL
     * - choice: AliasCVV | Amex | ATPCO | CCApprovalCode | ClassOfService | Combinability | Commission | CompanyIndexText | CustomParams | Diagnostics | DisplayFareComponentPenalty | DisplayFareComponentPrice | FullCalendarOffer | NumberOfSegments |
     * LoyaltyAccrual | OnTimePerformance | OriginalPriceCalendar | Redemption | ReferenceNumber | UATPReportingData | UseDocument | UserInput | Vouchers | FareCodePriceIndicator | OCNContents | ServiceQualifier | AoaPriceDifferential | CarrierFee |
     * AccountedOrderVersionNumber | SSRText | OtherServiceInformation | TrackID | EquivID | VoucherPin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * - ref: q26:ServiceQualifier
     * @var string
     */
    public $ServiceQualifier;
    /**
     * The AoaPriceDifferential
     * Meta information extracted from the WSDL
     * - choice: AliasCVV | Amex | ATPCO | CCApprovalCode | ClassOfService | Combinability | Commission | CompanyIndexText | CustomParams | Diagnostics | DisplayFareComponentPenalty | DisplayFareComponentPrice | FullCalendarOffer | NumberOfSegments |
     * LoyaltyAccrual | OnTimePerformance | OriginalPriceCalendar | Redemption | ReferenceNumber | UATPReportingData | UseDocument | UserInput | Vouchers | FareCodePriceIndicator | OCNContents | ServiceQualifier | AoaPriceDifferential | CarrierFee |
     * AccountedOrderVersionNumber | SSRText | OtherServiceInformation | TrackID | EquivID | VoucherPin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * - ref: q27:AoaPriceDifferential
     * @var \StructType\PriceDifferentialType
     */
    public $AoaPriceDifferential;
    /**
     * The CarrierFee
     * Meta information extracted from the WSDL
     * - choice: AliasCVV | Amex | ATPCO | CCApprovalCode | ClassOfService | Combinability | Commission | CompanyIndexText | CustomParams | Diagnostics | DisplayFareComponentPenalty | DisplayFareComponentPrice | FullCalendarOffer | NumberOfSegments |
     * LoyaltyAccrual | OnTimePerformance | OriginalPriceCalendar | Redemption | ReferenceNumber | UATPReportingData | UseDocument | UserInput | Vouchers | FareCodePriceIndicator | OCNContents | ServiceQualifier | AoaPriceDifferential | CarrierFee |
     * AccountedOrderVersionNumber | SSRText | OtherServiceInformation | TrackID | EquivID | VoucherPin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q28:CarrierFee
     * @var \StructType\CarrierFeeType[]
     */
    public $CarrierFee;
    /**
     * The AccountedOrderVersionNumber
     * Meta information extracted from the WSDL
     * - documentation: Accounted Order Version Number for the Order
     * - base: xs:integer
     * - choice: AliasCVV | Amex | ATPCO | CCApprovalCode | ClassOfService | Combinability | Commission | CompanyIndexText | CustomParams | Diagnostics | DisplayFareComponentPenalty | DisplayFareComponentPrice | FullCalendarOffer | NumberOfSegments |
     * LoyaltyAccrual | OnTimePerformance | OriginalPriceCalendar | Redemption | ReferenceNumber | UATPReportingData | UseDocument | UserInput | Vouchers | FareCodePriceIndicator | OCNContents | ServiceQualifier | AoaPriceDifferential | CarrierFee |
     * AccountedOrderVersionNumber | SSRText | OtherServiceInformation | TrackID | EquivID | VoucherPin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minInclusive: 1
     * - minOccurs: 0
     * - ref: q29:AccountedOrderVersionNumber
     * @var int
     */
    public $AccountedOrderVersionNumber;
    /**
     * The SSRText
     * Meta information extracted from the WSDL
     * - choice: AliasCVV | Amex | ATPCO | CCApprovalCode | ClassOfService | Combinability | Commission | CompanyIndexText | CustomParams | Diagnostics | DisplayFareComponentPenalty | DisplayFareComponentPrice | FullCalendarOffer | NumberOfSegments |
     * LoyaltyAccrual | OnTimePerformance | OriginalPriceCalendar | Redemption | ReferenceNumber | UATPReportingData | UseDocument | UserInput | Vouchers | FareCodePriceIndicator | OCNContents | ServiceQualifier | AoaPriceDifferential | CarrierFee |
     * AccountedOrderVersionNumber | SSRText | OtherServiceInformation | TrackID | EquivID | VoucherPin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * - ref: q30:SSRText
     * @var string
     */
    public $SSRText;
    /**
     * The OtherServiceInformation
     * Meta information extracted from the WSDL
     * - choice: AliasCVV | Amex | ATPCO | CCApprovalCode | ClassOfService | Combinability | Commission | CompanyIndexText | CustomParams | Diagnostics | DisplayFareComponentPenalty | DisplayFareComponentPrice | FullCalendarOffer | NumberOfSegments |
     * LoyaltyAccrual | OnTimePerformance | OriginalPriceCalendar | Redemption | ReferenceNumber | UATPReportingData | UseDocument | UserInput | Vouchers | FareCodePriceIndicator | OCNContents | ServiceQualifier | AoaPriceDifferential | CarrierFee |
     * AccountedOrderVersionNumber | SSRText | OtherServiceInformation | TrackID | EquivID | VoucherPin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * - ref: q31:OtherServiceInformation
     * @var \StructType\OtherServiceInformation
     */
    public $OtherServiceInformation;
    /**
     * The TrackID
     * Meta information extracted from the WSDL
     * - choice: AliasCVV | Amex | ATPCO | CCApprovalCode | ClassOfService | Combinability | Commission | CompanyIndexText | CustomParams | Diagnostics | DisplayFareComponentPenalty | DisplayFareComponentPrice | FullCalendarOffer | NumberOfSegments |
     * LoyaltyAccrual | OnTimePerformance | OriginalPriceCalendar | Redemption | ReferenceNumber | UATPReportingData | UseDocument | UserInput | Vouchers | FareCodePriceIndicator | OCNContents | ServiceQualifier | AoaPriceDifferential | CarrierFee |
     * AccountedOrderVersionNumber | SSRText | OtherServiceInformation | TrackID | EquivID | VoucherPin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * - ref: q32:TrackID
     * @var string
     */
    public $TrackID;
    /**
     * The EquivID
     * Meta information extracted from the WSDL
     * - choice: AliasCVV | Amex | ATPCO | CCApprovalCode | ClassOfService | Combinability | Commission | CompanyIndexText | CustomParams | Diagnostics | DisplayFareComponentPenalty | DisplayFareComponentPrice | FullCalendarOffer | NumberOfSegments |
     * LoyaltyAccrual | OnTimePerformance | OriginalPriceCalendar | Redemption | ReferenceNumber | UATPReportingData | UseDocument | UserInput | Vouchers | FareCodePriceIndicator | OCNContents | ServiceQualifier | AoaPriceDifferential | CarrierFee |
     * AccountedOrderVersionNumber | SSRText | OtherServiceInformation | TrackID | EquivID | VoucherPin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * - ref: q33:EquivID
     * @var \StructType\EquivID
     */
    public $EquivID;
    /**
     * The VoucherPin
     * Meta information extracted from the WSDL
     * - choice: AliasCVV | Amex | ATPCO | CCApprovalCode | ClassOfService | Combinability | Commission | CompanyIndexText | CustomParams | Diagnostics | DisplayFareComponentPenalty | DisplayFareComponentPrice | FullCalendarOffer | NumberOfSegments |
     * LoyaltyAccrual | OnTimePerformance | OriginalPriceCalendar | Redemption | ReferenceNumber | UATPReportingData | UseDocument | UserInput | Vouchers | FareCodePriceIndicator | OCNContents | ServiceQualifier | AoaPriceDifferential | CarrierFee |
     * AccountedOrderVersionNumber | SSRText | OtherServiceInformation | TrackID | EquivID | VoucherPin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * - ref: q34:VoucherPin
     * @var \StructType\VoucherPin
     */
    public $VoucherPin;
    /**
     * Constructor method for AugPoint
     * @uses AugPoint::setAssociation()
     * @uses AugPoint::setAliasCVV()
     * @uses AugPoint::setAmex()
     * @uses AugPoint::setATPCO()
     * @uses AugPoint::setCCApprovalCode()
     * @uses AugPoint::setClassOfService()
     * @uses AugPoint::setCombinability()
     * @uses AugPoint::setCommission()
     * @uses AugPoint::setCompanyIndexText()
     * @uses AugPoint::setCustomParams()
     * @uses AugPoint::setDiagnostics()
     * @uses AugPoint::setDisplayFareComponentPenalty()
     * @uses AugPoint::setDisplayFareComponentPrice()
     * @uses AugPoint::setFullCalendarOffer()
     * @uses AugPoint::setNumberOfSegments()
     * @uses AugPoint::setLoyaltyAccrual()
     * @uses AugPoint::setOnTimePerformance()
     * @uses AugPoint::setOriginalPriceCalendar()
     * @uses AugPoint::setRedemption()
     * @uses AugPoint::setReferenceNumber()
     * @uses AugPoint::setUATPReportingData()
     * @uses AugPoint::setUseDocument()
     * @uses AugPoint::setUserInput()
     * @uses AugPoint::setVouchers()
     * @uses AugPoint::setFareCodePriceIndicator()
     * @uses AugPoint::setOCNContents()
     * @uses AugPoint::setServiceQualifier()
     * @uses AugPoint::setAoaPriceDifferential()
     * @uses AugPoint::setCarrierFee()
     * @uses AugPoint::setAccountedOrderVersionNumber()
     * @uses AugPoint::setSSRText()
     * @uses AugPoint::setOtherServiceInformation()
     * @uses AugPoint::setTrackID()
     * @uses AugPoint::setEquivID()
     * @uses AugPoint::setVoucherPin()
     * @param \StructType\Association $association
     * @param string $aliasCVV
     * @param \StructType\Amex $amex
     * @param \StructType\ATPCO $aTPCO
     * @param \StructType\CCApprovalCode $cCApprovalCode
     * @param \StructType\ClassOfService $classOfService
     * @param \StructType\Combinability $combinability
     * @param \StructType\Commission $commission
     * @param string $companyIndexText
     * @param \StructType\CustomParams $customParams
     * @param \StructType\Diagnostics $diagnostics
     * @param mixed $displayFareComponentPenalty
     * @param mixed $displayFareComponentPrice
     * @param string $fullCalendarOffer
     * @param int $numberOfSegments
     * @param \StructType\LoyaltyAccrual $loyaltyAccrual
     * @param \StructType\OnTimePerformance $onTimePerformance
     * @param string $originalPriceCalendar
     * @param \StructType\Redemption $redemption
     * @param string $referenceNumber
     * @param \StructType\UATPReportingData $uATPReportingData
     * @param \StructType\UseDocument $useDocument
     * @param \StructType\UserInput $userInput
     * @param \StructType\Vouchers $vouchers
     * @param string $fareCodePriceIndicator
     * @param \StructType\OCNContents $oCNContents
     * @param string $serviceQualifier
     * @param \StructType\PriceDifferentialType $aoaPriceDifferential
     * @param \StructType\CarrierFeeType[] $carrierFee
     * @param int $accountedOrderVersionNumber
     * @param string $sSRText
     * @param \StructType\OtherServiceInformation $otherServiceInformation
     * @param string $trackID
     * @param \StructType\EquivID $equivID
     * @param \StructType\VoucherPin $voucherPin
     */
    public function __construct(\StructType\Association $association = null, $aliasCVV = null, \StructType\Amex $amex = null, \StructType\ATPCO $aTPCO = null, \StructType\CCApprovalCode $cCApprovalCode = null, \StructType\ClassOfService $classOfService = null, \StructType\Combinability $combinability = null, \StructType\Commission $commission = null, $companyIndexText = null, \StructType\CustomParams $customParams = null, \StructType\Diagnostics $diagnostics = null, $displayFareComponentPenalty = null, $displayFareComponentPrice = null, $fullCalendarOffer = null, $numberOfSegments = null, \StructType\LoyaltyAccrual $loyaltyAccrual = null, \StructType\OnTimePerformance $onTimePerformance = null, $originalPriceCalendar = null, \StructType\Redemption $redemption = null, $referenceNumber = null, \StructType\UATPReportingData $uATPReportingData = null, \StructType\UseDocument $useDocument = null, \StructType\UserInput $userInput = null, \StructType\Vouchers $vouchers = null, $fareCodePriceIndicator = null, \StructType\OCNContents $oCNContents = null, $serviceQualifier = null, \StructType\PriceDifferentialType $aoaPriceDifferential = null, array $carrierFee = array(), $accountedOrderVersionNumber = null, $sSRText = null, \StructType\OtherServiceInformation $otherServiceInformation = null, $trackID = null, \StructType\EquivID $equivID = null, \StructType\VoucherPin $voucherPin = null)
    {
        $this
            ->setAssociation($association)
            ->setAliasCVV($aliasCVV)
            ->setAmex($amex)
            ->setATPCO($aTPCO)
            ->setCCApprovalCode($cCApprovalCode)
            ->setClassOfService($classOfService)
            ->setCombinability($combinability)
            ->setCommission($commission)
            ->setCompanyIndexText($companyIndexText)
            ->setCustomParams($customParams)
            ->setDiagnostics($diagnostics)
            ->setDisplayFareComponentPenalty($displayFareComponentPenalty)
            ->setDisplayFareComponentPrice($displayFareComponentPrice)
            ->setFullCalendarOffer($fullCalendarOffer)
            ->setNumberOfSegments($numberOfSegments)
            ->setLoyaltyAccrual($loyaltyAccrual)
            ->setOnTimePerformance($onTimePerformance)
            ->setOriginalPriceCalendar($originalPriceCalendar)
            ->setRedemption($redemption)
            ->setReferenceNumber($referenceNumber)
            ->setUATPReportingData($uATPReportingData)
            ->setUseDocument($useDocument)
            ->setUserInput($userInput)
            ->setVouchers($vouchers)
            ->setFareCodePriceIndicator($fareCodePriceIndicator)
            ->setOCNContents($oCNContents)
            ->setServiceQualifier($serviceQualifier)
            ->setAoaPriceDifferential($aoaPriceDifferential)
            ->setCarrierFee($carrierFee)
            ->setAccountedOrderVersionNumber($accountedOrderVersionNumber)
            ->setSSRText($sSRText)
            ->setOtherServiceInformation($otherServiceInformation)
            ->setTrackID($trackID)
            ->setEquivID($equivID)
            ->setVoucherPin($voucherPin);
    }
    /**
     * Get Association value
     * @return \StructType\Association|null
     */
    public function getAssociation()
    {
        return $this->Association;
    }
    /**
     * Set Association value
     * @param \StructType\Association $association
     * @return \StructType\AugPoint
     */
    public function setAssociation(\StructType\Association $association = null)
    {
        $this->Association = $association;
        return $this;
    }
    /**
     * Get AliasCVV value
     * @return string|null
     */
    public function getAliasCVV()
    {
        return isset($this->AliasCVV) ? $this->AliasCVV : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAliasCVV method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAliasCVV method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAliasCVVForChoiceConstraintsFromSetAliasCVV($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Amex',
            'ATPCO',
            'CCApprovalCode',
            'ClassOfService',
            'Combinability',
            'Commission',
            'CompanyIndexText',
            'CustomParams',
            'Diagnostics',
            'DisplayFareComponentPenalty',
            'DisplayFareComponentPrice',
            'FullCalendarOffer',
            'NumberOfSegments',
            'LoyaltyAccrual',
            'OnTimePerformance',
            'OriginalPriceCalendar',
            'Redemption',
            'ReferenceNumber',
            'UATPReportingData',
            'UseDocument',
            'UserInput',
            'Vouchers',
            'FareCodePriceIndicator',
            'OCNContents',
            'ServiceQualifier',
            'AoaPriceDifferential',
            'CarrierFee',
            'AccountedOrderVersionNumber',
            'SSRText',
            'OtherServiceInformation',
            'TrackID',
            'EquivID',
            'VoucherPin',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property AliasCVV can\'t be set as the property %s is already set. Only one property must be set among these properties: AliasCVV, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set AliasCVV value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $aliasCVV
     * @return \StructType\AugPoint
     */
    public function setAliasCVV($aliasCVV = null)
    {
        // validation for constraint: string
        if (!is_null($aliasCVV) && !is_string($aliasCVV)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aliasCVV, true), gettype($aliasCVV)), __LINE__);
        }
        // validation for constraint: choice(AliasCVV, Amex, ATPCO, CCApprovalCode, ClassOfService, Combinability, Commission, CompanyIndexText, CustomParams, Diagnostics, DisplayFareComponentPenalty, DisplayFareComponentPrice, FullCalendarOffer, NumberOfSegments, LoyaltyAccrual, OnTimePerformance, OriginalPriceCalendar, Redemption, ReferenceNumber, UATPReportingData, UseDocument, UserInput, Vouchers, FareCodePriceIndicator, OCNContents, ServiceQualifier, AoaPriceDifferential, CarrierFee, AccountedOrderVersionNumber, SSRText, OtherServiceInformation, TrackID, EquivID, VoucherPin)
        if ('' !== ($aliasCVVChoiceErrorMessage = self::validateAliasCVVForChoiceConstraintsFromSetAliasCVV($aliasCVV))) {
            throw new \InvalidArgumentException($aliasCVVChoiceErrorMessage, __LINE__);
        }
        if (is_null($aliasCVV) || (is_array($aliasCVV) && empty($aliasCVV))) {
            unset($this->AliasCVV);
        } else {
            $this->AliasCVV = $aliasCVV;
        }
        return $this;
    }
    /**
     * Get Amex value
     * @return \StructType\Amex|null
     */
    public function getAmex()
    {
        return isset($this->Amex) ? $this->Amex : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAmex method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAmex method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAmexForChoiceConstraintsFromSetAmex($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AliasCVV',
            'ATPCO',
            'CCApprovalCode',
            'ClassOfService',
            'Combinability',
            'Commission',
            'CompanyIndexText',
            'CustomParams',
            'Diagnostics',
            'DisplayFareComponentPenalty',
            'DisplayFareComponentPrice',
            'FullCalendarOffer',
            'NumberOfSegments',
            'LoyaltyAccrual',
            'OnTimePerformance',
            'OriginalPriceCalendar',
            'Redemption',
            'ReferenceNumber',
            'UATPReportingData',
            'UseDocument',
            'UserInput',
            'Vouchers',
            'FareCodePriceIndicator',
            'OCNContents',
            'ServiceQualifier',
            'AoaPriceDifferential',
            'CarrierFee',
            'AccountedOrderVersionNumber',
            'SSRText',
            'OtherServiceInformation',
            'TrackID',
            'EquivID',
            'VoucherPin',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Amex can\'t be set as the property %s is already set. Only one property must be set among these properties: Amex, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Amex value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Amex $amex
     * @return \StructType\AugPoint
     */
    public function setAmex(\StructType\Amex $amex = null)
    {
        // validation for constraint: choice(AliasCVV, Amex, ATPCO, CCApprovalCode, ClassOfService, Combinability, Commission, CompanyIndexText, CustomParams, Diagnostics, DisplayFareComponentPenalty, DisplayFareComponentPrice, FullCalendarOffer, NumberOfSegments, LoyaltyAccrual, OnTimePerformance, OriginalPriceCalendar, Redemption, ReferenceNumber, UATPReportingData, UseDocument, UserInput, Vouchers, FareCodePriceIndicator, OCNContents, ServiceQualifier, AoaPriceDifferential, CarrierFee, AccountedOrderVersionNumber, SSRText, OtherServiceInformation, TrackID, EquivID, VoucherPin)
        if ('' !== ($amexChoiceErrorMessage = self::validateAmexForChoiceConstraintsFromSetAmex($amex))) {
            throw new \InvalidArgumentException($amexChoiceErrorMessage, __LINE__);
        }
        if (is_null($amex) || (is_array($amex) && empty($amex))) {
            unset($this->Amex);
        } else {
            $this->Amex = $amex;
        }
        return $this;
    }
    /**
     * Get ATPCO value
     * @return \StructType\ATPCO|null
     */
    public function getATPCO()
    {
        return isset($this->ATPCO) ? $this->ATPCO : null;
    }
    /**
     * This method is responsible for validating the value passed to the setATPCO method
     * This method is willingly generated in order to preserve the one-line inline validation within the setATPCO method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateATPCOForChoiceConstraintsFromSetATPCO($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AliasCVV',
            'Amex',
            'CCApprovalCode',
            'ClassOfService',
            'Combinability',
            'Commission',
            'CompanyIndexText',
            'CustomParams',
            'Diagnostics',
            'DisplayFareComponentPenalty',
            'DisplayFareComponentPrice',
            'FullCalendarOffer',
            'NumberOfSegments',
            'LoyaltyAccrual',
            'OnTimePerformance',
            'OriginalPriceCalendar',
            'Redemption',
            'ReferenceNumber',
            'UATPReportingData',
            'UseDocument',
            'UserInput',
            'Vouchers',
            'FareCodePriceIndicator',
            'OCNContents',
            'ServiceQualifier',
            'AoaPriceDifferential',
            'CarrierFee',
            'AccountedOrderVersionNumber',
            'SSRText',
            'OtherServiceInformation',
            'TrackID',
            'EquivID',
            'VoucherPin',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ATPCO can\'t be set as the property %s is already set. Only one property must be set among these properties: ATPCO, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ATPCO value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ATPCO $aTPCO
     * @return \StructType\AugPoint
     */
    public function setATPCO(\StructType\ATPCO $aTPCO = null)
    {
        // validation for constraint: choice(AliasCVV, Amex, ATPCO, CCApprovalCode, ClassOfService, Combinability, Commission, CompanyIndexText, CustomParams, Diagnostics, DisplayFareComponentPenalty, DisplayFareComponentPrice, FullCalendarOffer, NumberOfSegments, LoyaltyAccrual, OnTimePerformance, OriginalPriceCalendar, Redemption, ReferenceNumber, UATPReportingData, UseDocument, UserInput, Vouchers, FareCodePriceIndicator, OCNContents, ServiceQualifier, AoaPriceDifferential, CarrierFee, AccountedOrderVersionNumber, SSRText, OtherServiceInformation, TrackID, EquivID, VoucherPin)
        if ('' !== ($aTPCOChoiceErrorMessage = self::validateATPCOForChoiceConstraintsFromSetATPCO($aTPCO))) {
            throw new \InvalidArgumentException($aTPCOChoiceErrorMessage, __LINE__);
        }
        if (is_null($aTPCO) || (is_array($aTPCO) && empty($aTPCO))) {
            unset($this->ATPCO);
        } else {
            $this->ATPCO = $aTPCO;
        }
        return $this;
    }
    /**
     * Get CCApprovalCode value
     * @return \StructType\CCApprovalCode|null
     */
    public function getCCApprovalCode()
    {
        return isset($this->CCApprovalCode) ? $this->CCApprovalCode : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCCApprovalCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCCApprovalCode method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCCApprovalCodeForChoiceConstraintsFromSetCCApprovalCode($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AliasCVV',
            'Amex',
            'ATPCO',
            'ClassOfService',
            'Combinability',
            'Commission',
            'CompanyIndexText',
            'CustomParams',
            'Diagnostics',
            'DisplayFareComponentPenalty',
            'DisplayFareComponentPrice',
            'FullCalendarOffer',
            'NumberOfSegments',
            'LoyaltyAccrual',
            'OnTimePerformance',
            'OriginalPriceCalendar',
            'Redemption',
            'ReferenceNumber',
            'UATPReportingData',
            'UseDocument',
            'UserInput',
            'Vouchers',
            'FareCodePriceIndicator',
            'OCNContents',
            'ServiceQualifier',
            'AoaPriceDifferential',
            'CarrierFee',
            'AccountedOrderVersionNumber',
            'SSRText',
            'OtherServiceInformation',
            'TrackID',
            'EquivID',
            'VoucherPin',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CCApprovalCode can\'t be set as the property %s is already set. Only one property must be set among these properties: CCApprovalCode, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CCApprovalCode value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CCApprovalCode $cCApprovalCode
     * @return \StructType\AugPoint
     */
    public function setCCApprovalCode(\StructType\CCApprovalCode $cCApprovalCode = null)
    {
        // validation for constraint: choice(AliasCVV, Amex, ATPCO, CCApprovalCode, ClassOfService, Combinability, Commission, CompanyIndexText, CustomParams, Diagnostics, DisplayFareComponentPenalty, DisplayFareComponentPrice, FullCalendarOffer, NumberOfSegments, LoyaltyAccrual, OnTimePerformance, OriginalPriceCalendar, Redemption, ReferenceNumber, UATPReportingData, UseDocument, UserInput, Vouchers, FareCodePriceIndicator, OCNContents, ServiceQualifier, AoaPriceDifferential, CarrierFee, AccountedOrderVersionNumber, SSRText, OtherServiceInformation, TrackID, EquivID, VoucherPin)
        if ('' !== ($cCApprovalCodeChoiceErrorMessage = self::validateCCApprovalCodeForChoiceConstraintsFromSetCCApprovalCode($cCApprovalCode))) {
            throw new \InvalidArgumentException($cCApprovalCodeChoiceErrorMessage, __LINE__);
        }
        if (is_null($cCApprovalCode) || (is_array($cCApprovalCode) && empty($cCApprovalCode))) {
            unset($this->CCApprovalCode);
        } else {
            $this->CCApprovalCode = $cCApprovalCode;
        }
        return $this;
    }
    /**
     * Get ClassOfService value
     * @return \StructType\ClassOfService|null
     */
    public function getClassOfService()
    {
        return isset($this->ClassOfService) ? $this->ClassOfService : null;
    }
    /**
     * This method is responsible for validating the value passed to the setClassOfService method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClassOfService method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateClassOfServiceForChoiceConstraintsFromSetClassOfService($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AliasCVV',
            'Amex',
            'ATPCO',
            'CCApprovalCode',
            'Combinability',
            'Commission',
            'CompanyIndexText',
            'CustomParams',
            'Diagnostics',
            'DisplayFareComponentPenalty',
            'DisplayFareComponentPrice',
            'FullCalendarOffer',
            'NumberOfSegments',
            'LoyaltyAccrual',
            'OnTimePerformance',
            'OriginalPriceCalendar',
            'Redemption',
            'ReferenceNumber',
            'UATPReportingData',
            'UseDocument',
            'UserInput',
            'Vouchers',
            'FareCodePriceIndicator',
            'OCNContents',
            'ServiceQualifier',
            'AoaPriceDifferential',
            'CarrierFee',
            'AccountedOrderVersionNumber',
            'SSRText',
            'OtherServiceInformation',
            'TrackID',
            'EquivID',
            'VoucherPin',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ClassOfService can\'t be set as the property %s is already set. Only one property must be set among these properties: ClassOfService, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ClassOfService value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ClassOfService $classOfService
     * @return \StructType\AugPoint
     */
    public function setClassOfService(\StructType\ClassOfService $classOfService = null)
    {
        // validation for constraint: choice(AliasCVV, Amex, ATPCO, CCApprovalCode, ClassOfService, Combinability, Commission, CompanyIndexText, CustomParams, Diagnostics, DisplayFareComponentPenalty, DisplayFareComponentPrice, FullCalendarOffer, NumberOfSegments, LoyaltyAccrual, OnTimePerformance, OriginalPriceCalendar, Redemption, ReferenceNumber, UATPReportingData, UseDocument, UserInput, Vouchers, FareCodePriceIndicator, OCNContents, ServiceQualifier, AoaPriceDifferential, CarrierFee, AccountedOrderVersionNumber, SSRText, OtherServiceInformation, TrackID, EquivID, VoucherPin)
        if ('' !== ($classOfServiceChoiceErrorMessage = self::validateClassOfServiceForChoiceConstraintsFromSetClassOfService($classOfService))) {
            throw new \InvalidArgumentException($classOfServiceChoiceErrorMessage, __LINE__);
        }
        if (is_null($classOfService) || (is_array($classOfService) && empty($classOfService))) {
            unset($this->ClassOfService);
        } else {
            $this->ClassOfService = $classOfService;
        }
        return $this;
    }
    /**
     * Get Combinability value
     * @return \StructType\Combinability|null
     */
    public function getCombinability()
    {
        return isset($this->Combinability) ? $this->Combinability : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCombinability method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCombinability method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCombinabilityForChoiceConstraintsFromSetCombinability($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AliasCVV',
            'Amex',
            'ATPCO',
            'CCApprovalCode',
            'ClassOfService',
            'Commission',
            'CompanyIndexText',
            'CustomParams',
            'Diagnostics',
            'DisplayFareComponentPenalty',
            'DisplayFareComponentPrice',
            'FullCalendarOffer',
            'NumberOfSegments',
            'LoyaltyAccrual',
            'OnTimePerformance',
            'OriginalPriceCalendar',
            'Redemption',
            'ReferenceNumber',
            'UATPReportingData',
            'UseDocument',
            'UserInput',
            'Vouchers',
            'FareCodePriceIndicator',
            'OCNContents',
            'ServiceQualifier',
            'AoaPriceDifferential',
            'CarrierFee',
            'AccountedOrderVersionNumber',
            'SSRText',
            'OtherServiceInformation',
            'TrackID',
            'EquivID',
            'VoucherPin',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Combinability can\'t be set as the property %s is already set. Only one property must be set among these properties: Combinability, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Combinability value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Combinability $combinability
     * @return \StructType\AugPoint
     */
    public function setCombinability(\StructType\Combinability $combinability = null)
    {
        // validation for constraint: choice(AliasCVV, Amex, ATPCO, CCApprovalCode, ClassOfService, Combinability, Commission, CompanyIndexText, CustomParams, Diagnostics, DisplayFareComponentPenalty, DisplayFareComponentPrice, FullCalendarOffer, NumberOfSegments, LoyaltyAccrual, OnTimePerformance, OriginalPriceCalendar, Redemption, ReferenceNumber, UATPReportingData, UseDocument, UserInput, Vouchers, FareCodePriceIndicator, OCNContents, ServiceQualifier, AoaPriceDifferential, CarrierFee, AccountedOrderVersionNumber, SSRText, OtherServiceInformation, TrackID, EquivID, VoucherPin)
        if ('' !== ($combinabilityChoiceErrorMessage = self::validateCombinabilityForChoiceConstraintsFromSetCombinability($combinability))) {
            throw new \InvalidArgumentException($combinabilityChoiceErrorMessage, __LINE__);
        }
        if (is_null($combinability) || (is_array($combinability) && empty($combinability))) {
            unset($this->Combinability);
        } else {
            $this->Combinability = $combinability;
        }
        return $this;
    }
    /**
     * Get Commission value
     * @return \StructType\Commission|null
     */
    public function getCommission()
    {
        return isset($this->Commission) ? $this->Commission : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCommission method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommission method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCommissionForChoiceConstraintsFromSetCommission($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AliasCVV',
            'Amex',
            'ATPCO',
            'CCApprovalCode',
            'ClassOfService',
            'Combinability',
            'CompanyIndexText',
            'CustomParams',
            'Diagnostics',
            'DisplayFareComponentPenalty',
            'DisplayFareComponentPrice',
            'FullCalendarOffer',
            'NumberOfSegments',
            'LoyaltyAccrual',
            'OnTimePerformance',
            'OriginalPriceCalendar',
            'Redemption',
            'ReferenceNumber',
            'UATPReportingData',
            'UseDocument',
            'UserInput',
            'Vouchers',
            'FareCodePriceIndicator',
            'OCNContents',
            'ServiceQualifier',
            'AoaPriceDifferential',
            'CarrierFee',
            'AccountedOrderVersionNumber',
            'SSRText',
            'OtherServiceInformation',
            'TrackID',
            'EquivID',
            'VoucherPin',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Commission can\'t be set as the property %s is already set. Only one property must be set among these properties: Commission, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Commission value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Commission $commission
     * @return \StructType\AugPoint
     */
    public function setCommission(\StructType\Commission $commission = null)
    {
        // validation for constraint: choice(AliasCVV, Amex, ATPCO, CCApprovalCode, ClassOfService, Combinability, Commission, CompanyIndexText, CustomParams, Diagnostics, DisplayFareComponentPenalty, DisplayFareComponentPrice, FullCalendarOffer, NumberOfSegments, LoyaltyAccrual, OnTimePerformance, OriginalPriceCalendar, Redemption, ReferenceNumber, UATPReportingData, UseDocument, UserInput, Vouchers, FareCodePriceIndicator, OCNContents, ServiceQualifier, AoaPriceDifferential, CarrierFee, AccountedOrderVersionNumber, SSRText, OtherServiceInformation, TrackID, EquivID, VoucherPin)
        if ('' !== ($commissionChoiceErrorMessage = self::validateCommissionForChoiceConstraintsFromSetCommission($commission))) {
            throw new \InvalidArgumentException($commissionChoiceErrorMessage, __LINE__);
        }
        if (is_null($commission) || (is_array($commission) && empty($commission))) {
            unset($this->Commission);
        } else {
            $this->Commission = $commission;
        }
        return $this;
    }
    /**
     * Get CompanyIndexText value
     * @return string|null
     */
    public function getCompanyIndexText()
    {
        return isset($this->CompanyIndexText) ? $this->CompanyIndexText : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCompanyIndexText method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompanyIndexText method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCompanyIndexTextForChoiceConstraintsFromSetCompanyIndexText($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AliasCVV',
            'Amex',
            'ATPCO',
            'CCApprovalCode',
            'ClassOfService',
            'Combinability',
            'Commission',
            'CustomParams',
            'Diagnostics',
            'DisplayFareComponentPenalty',
            'DisplayFareComponentPrice',
            'FullCalendarOffer',
            'NumberOfSegments',
            'LoyaltyAccrual',
            'OnTimePerformance',
            'OriginalPriceCalendar',
            'Redemption',
            'ReferenceNumber',
            'UATPReportingData',
            'UseDocument',
            'UserInput',
            'Vouchers',
            'FareCodePriceIndicator',
            'OCNContents',
            'ServiceQualifier',
            'AoaPriceDifferential',
            'CarrierFee',
            'AccountedOrderVersionNumber',
            'SSRText',
            'OtherServiceInformation',
            'TrackID',
            'EquivID',
            'VoucherPin',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CompanyIndexText can\'t be set as the property %s is already set. Only one property must be set among these properties: CompanyIndexText, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CompanyIndexText value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $companyIndexText
     * @return \StructType\AugPoint
     */
    public function setCompanyIndexText($companyIndexText = null)
    {
        // validation for constraint: string
        if (!is_null($companyIndexText) && !is_string($companyIndexText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyIndexText, true), gettype($companyIndexText)), __LINE__);
        }
        // validation for constraint: choice(AliasCVV, Amex, ATPCO, CCApprovalCode, ClassOfService, Combinability, Commission, CompanyIndexText, CustomParams, Diagnostics, DisplayFareComponentPenalty, DisplayFareComponentPrice, FullCalendarOffer, NumberOfSegments, LoyaltyAccrual, OnTimePerformance, OriginalPriceCalendar, Redemption, ReferenceNumber, UATPReportingData, UseDocument, UserInput, Vouchers, FareCodePriceIndicator, OCNContents, ServiceQualifier, AoaPriceDifferential, CarrierFee, AccountedOrderVersionNumber, SSRText, OtherServiceInformation, TrackID, EquivID, VoucherPin)
        if ('' !== ($companyIndexTextChoiceErrorMessage = self::validateCompanyIndexTextForChoiceConstraintsFromSetCompanyIndexText($companyIndexText))) {
            throw new \InvalidArgumentException($companyIndexTextChoiceErrorMessage, __LINE__);
        }
        if (is_null($companyIndexText) || (is_array($companyIndexText) && empty($companyIndexText))) {
            unset($this->CompanyIndexText);
        } else {
            $this->CompanyIndexText = $companyIndexText;
        }
        return $this;
    }
    /**
     * Get CustomParams value
     * @return \StructType\CustomParams|null
     */
    public function getCustomParams()
    {
        return isset($this->CustomParams) ? $this->CustomParams : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCustomParams method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomParams method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCustomParamsForChoiceConstraintsFromSetCustomParams($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AliasCVV',
            'Amex',
            'ATPCO',
            'CCApprovalCode',
            'ClassOfService',
            'Combinability',
            'Commission',
            'CompanyIndexText',
            'Diagnostics',
            'DisplayFareComponentPenalty',
            'DisplayFareComponentPrice',
            'FullCalendarOffer',
            'NumberOfSegments',
            'LoyaltyAccrual',
            'OnTimePerformance',
            'OriginalPriceCalendar',
            'Redemption',
            'ReferenceNumber',
            'UATPReportingData',
            'UseDocument',
            'UserInput',
            'Vouchers',
            'FareCodePriceIndicator',
            'OCNContents',
            'ServiceQualifier',
            'AoaPriceDifferential',
            'CarrierFee',
            'AccountedOrderVersionNumber',
            'SSRText',
            'OtherServiceInformation',
            'TrackID',
            'EquivID',
            'VoucherPin',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CustomParams can\'t be set as the property %s is already set. Only one property must be set among these properties: CustomParams, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CustomParams value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CustomParams $customParams
     * @return \StructType\AugPoint
     */
    public function setCustomParams(\StructType\CustomParams $customParams = null)
    {
        // validation for constraint: choice(AliasCVV, Amex, ATPCO, CCApprovalCode, ClassOfService, Combinability, Commission, CompanyIndexText, CustomParams, Diagnostics, DisplayFareComponentPenalty, DisplayFareComponentPrice, FullCalendarOffer, NumberOfSegments, LoyaltyAccrual, OnTimePerformance, OriginalPriceCalendar, Redemption, ReferenceNumber, UATPReportingData, UseDocument, UserInput, Vouchers, FareCodePriceIndicator, OCNContents, ServiceQualifier, AoaPriceDifferential, CarrierFee, AccountedOrderVersionNumber, SSRText, OtherServiceInformation, TrackID, EquivID, VoucherPin)
        if ('' !== ($customParamsChoiceErrorMessage = self::validateCustomParamsForChoiceConstraintsFromSetCustomParams($customParams))) {
            throw new \InvalidArgumentException($customParamsChoiceErrorMessage, __LINE__);
        }
        if (is_null($customParams) || (is_array($customParams) && empty($customParams))) {
            unset($this->CustomParams);
        } else {
            $this->CustomParams = $customParams;
        }
        return $this;
    }
    /**
     * Get Diagnostics value
     * @return \StructType\Diagnostics|null
     */
    public function getDiagnostics()
    {
        return isset($this->Diagnostics) ? $this->Diagnostics : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDiagnostics method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDiagnostics method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDiagnosticsForChoiceConstraintsFromSetDiagnostics($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AliasCVV',
            'Amex',
            'ATPCO',
            'CCApprovalCode',
            'ClassOfService',
            'Combinability',
            'Commission',
            'CompanyIndexText',
            'CustomParams',
            'DisplayFareComponentPenalty',
            'DisplayFareComponentPrice',
            'FullCalendarOffer',
            'NumberOfSegments',
            'LoyaltyAccrual',
            'OnTimePerformance',
            'OriginalPriceCalendar',
            'Redemption',
            'ReferenceNumber',
            'UATPReportingData',
            'UseDocument',
            'UserInput',
            'Vouchers',
            'FareCodePriceIndicator',
            'OCNContents',
            'ServiceQualifier',
            'AoaPriceDifferential',
            'CarrierFee',
            'AccountedOrderVersionNumber',
            'SSRText',
            'OtherServiceInformation',
            'TrackID',
            'EquivID',
            'VoucherPin',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Diagnostics can\'t be set as the property %s is already set. Only one property must be set among these properties: Diagnostics, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Diagnostics value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Diagnostics $diagnostics
     * @return \StructType\AugPoint
     */
    public function setDiagnostics(\StructType\Diagnostics $diagnostics = null)
    {
        // validation for constraint: choice(AliasCVV, Amex, ATPCO, CCApprovalCode, ClassOfService, Combinability, Commission, CompanyIndexText, CustomParams, Diagnostics, DisplayFareComponentPenalty, DisplayFareComponentPrice, FullCalendarOffer, NumberOfSegments, LoyaltyAccrual, OnTimePerformance, OriginalPriceCalendar, Redemption, ReferenceNumber, UATPReportingData, UseDocument, UserInput, Vouchers, FareCodePriceIndicator, OCNContents, ServiceQualifier, AoaPriceDifferential, CarrierFee, AccountedOrderVersionNumber, SSRText, OtherServiceInformation, TrackID, EquivID, VoucherPin)
        if ('' !== ($diagnosticsChoiceErrorMessage = self::validateDiagnosticsForChoiceConstraintsFromSetDiagnostics($diagnostics))) {
            throw new \InvalidArgumentException($diagnosticsChoiceErrorMessage, __LINE__);
        }
        if (is_null($diagnostics) || (is_array($diagnostics) && empty($diagnostics))) {
            unset($this->Diagnostics);
        } else {
            $this->Diagnostics = $diagnostics;
        }
        return $this;
    }
    /**
     * Get DisplayFareComponentPenalty value
     * @return mixed|null
     */
    public function getDisplayFareComponentPenalty()
    {
        return isset($this->DisplayFareComponentPenalty) ? $this->DisplayFareComponentPenalty : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDisplayFareComponentPenalty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDisplayFareComponentPenalty method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDisplayFareComponentPenaltyForChoiceConstraintsFromSetDisplayFareComponentPenalty($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AliasCVV',
            'Amex',
            'ATPCO',
            'CCApprovalCode',
            'ClassOfService',
            'Combinability',
            'Commission',
            'CompanyIndexText',
            'CustomParams',
            'Diagnostics',
            'DisplayFareComponentPrice',
            'FullCalendarOffer',
            'NumberOfSegments',
            'LoyaltyAccrual',
            'OnTimePerformance',
            'OriginalPriceCalendar',
            'Redemption',
            'ReferenceNumber',
            'UATPReportingData',
            'UseDocument',
            'UserInput',
            'Vouchers',
            'FareCodePriceIndicator',
            'OCNContents',
            'ServiceQualifier',
            'AoaPriceDifferential',
            'CarrierFee',
            'AccountedOrderVersionNumber',
            'SSRText',
            'OtherServiceInformation',
            'TrackID',
            'EquivID',
            'VoucherPin',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DisplayFareComponentPenalty can\'t be set as the property %s is already set. Only one property must be set among these properties: DisplayFareComponentPenalty, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DisplayFareComponentPenalty value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed $displayFareComponentPenalty
     * @return \StructType\AugPoint
     */
    public function setDisplayFareComponentPenalty($displayFareComponentPenalty = null)
    {
        // validation for constraint: choice(AliasCVV, Amex, ATPCO, CCApprovalCode, ClassOfService, Combinability, Commission, CompanyIndexText, CustomParams, Diagnostics, DisplayFareComponentPenalty, DisplayFareComponentPrice, FullCalendarOffer, NumberOfSegments, LoyaltyAccrual, OnTimePerformance, OriginalPriceCalendar, Redemption, ReferenceNumber, UATPReportingData, UseDocument, UserInput, Vouchers, FareCodePriceIndicator, OCNContents, ServiceQualifier, AoaPriceDifferential, CarrierFee, AccountedOrderVersionNumber, SSRText, OtherServiceInformation, TrackID, EquivID, VoucherPin)
        if ('' !== ($displayFareComponentPenaltyChoiceErrorMessage = self::validateDisplayFareComponentPenaltyForChoiceConstraintsFromSetDisplayFareComponentPenalty($displayFareComponentPenalty))) {
            throw new \InvalidArgumentException($displayFareComponentPenaltyChoiceErrorMessage, __LINE__);
        }
        if (is_null($displayFareComponentPenalty) || (is_array($displayFareComponentPenalty) && empty($displayFareComponentPenalty))) {
            unset($this->DisplayFareComponentPenalty);
        } else {
            $this->DisplayFareComponentPenalty = $displayFareComponentPenalty;
        }
        return $this;
    }
    /**
     * Get DisplayFareComponentPrice value
     * @return mixed|null
     */
    public function getDisplayFareComponentPrice()
    {
        return isset($this->DisplayFareComponentPrice) ? $this->DisplayFareComponentPrice : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDisplayFareComponentPrice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDisplayFareComponentPrice method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDisplayFareComponentPriceForChoiceConstraintsFromSetDisplayFareComponentPrice($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AliasCVV',
            'Amex',
            'ATPCO',
            'CCApprovalCode',
            'ClassOfService',
            'Combinability',
            'Commission',
            'CompanyIndexText',
            'CustomParams',
            'Diagnostics',
            'DisplayFareComponentPenalty',
            'FullCalendarOffer',
            'NumberOfSegments',
            'LoyaltyAccrual',
            'OnTimePerformance',
            'OriginalPriceCalendar',
            'Redemption',
            'ReferenceNumber',
            'UATPReportingData',
            'UseDocument',
            'UserInput',
            'Vouchers',
            'FareCodePriceIndicator',
            'OCNContents',
            'ServiceQualifier',
            'AoaPriceDifferential',
            'CarrierFee',
            'AccountedOrderVersionNumber',
            'SSRText',
            'OtherServiceInformation',
            'TrackID',
            'EquivID',
            'VoucherPin',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DisplayFareComponentPrice can\'t be set as the property %s is already set. Only one property must be set among these properties: DisplayFareComponentPrice, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DisplayFareComponentPrice value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed $displayFareComponentPrice
     * @return \StructType\AugPoint
     */
    public function setDisplayFareComponentPrice($displayFareComponentPrice = null)
    {
        // validation for constraint: choice(AliasCVV, Amex, ATPCO, CCApprovalCode, ClassOfService, Combinability, Commission, CompanyIndexText, CustomParams, Diagnostics, DisplayFareComponentPenalty, DisplayFareComponentPrice, FullCalendarOffer, NumberOfSegments, LoyaltyAccrual, OnTimePerformance, OriginalPriceCalendar, Redemption, ReferenceNumber, UATPReportingData, UseDocument, UserInput, Vouchers, FareCodePriceIndicator, OCNContents, ServiceQualifier, AoaPriceDifferential, CarrierFee, AccountedOrderVersionNumber, SSRText, OtherServiceInformation, TrackID, EquivID, VoucherPin)
        if ('' !== ($displayFareComponentPriceChoiceErrorMessage = self::validateDisplayFareComponentPriceForChoiceConstraintsFromSetDisplayFareComponentPrice($displayFareComponentPrice))) {
            throw new \InvalidArgumentException($displayFareComponentPriceChoiceErrorMessage, __LINE__);
        }
        if (is_null($displayFareComponentPrice) || (is_array($displayFareComponentPrice) && empty($displayFareComponentPrice))) {
            unset($this->DisplayFareComponentPrice);
        } else {
            $this->DisplayFareComponentPrice = $displayFareComponentPrice;
        }
        return $this;
    }
    /**
     * Get FullCalendarOffer value
     * @return string|null
     */
    public function getFullCalendarOffer()
    {
        return isset($this->FullCalendarOffer) ? $this->FullCalendarOffer : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFullCalendarOffer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFullCalendarOffer method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFullCalendarOfferForChoiceConstraintsFromSetFullCalendarOffer($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AliasCVV',
            'Amex',
            'ATPCO',
            'CCApprovalCode',
            'ClassOfService',
            'Combinability',
            'Commission',
            'CompanyIndexText',
            'CustomParams',
            'Diagnostics',
            'DisplayFareComponentPenalty',
            'DisplayFareComponentPrice',
            'NumberOfSegments',
            'LoyaltyAccrual',
            'OnTimePerformance',
            'OriginalPriceCalendar',
            'Redemption',
            'ReferenceNumber',
            'UATPReportingData',
            'UseDocument',
            'UserInput',
            'Vouchers',
            'FareCodePriceIndicator',
            'OCNContents',
            'ServiceQualifier',
            'AoaPriceDifferential',
            'CarrierFee',
            'AccountedOrderVersionNumber',
            'SSRText',
            'OtherServiceInformation',
            'TrackID',
            'EquivID',
            'VoucherPin',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property FullCalendarOffer can\'t be set as the property %s is already set. Only one property must be set among these properties: FullCalendarOffer, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set FullCalendarOffer value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $fullCalendarOffer
     * @return \StructType\AugPoint
     */
    public function setFullCalendarOffer($fullCalendarOffer = null)
    {
        // validation for constraint: string
        if (!is_null($fullCalendarOffer) && !is_string($fullCalendarOffer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullCalendarOffer, true), gettype($fullCalendarOffer)), __LINE__);
        }
        // validation for constraint: choice(AliasCVV, Amex, ATPCO, CCApprovalCode, ClassOfService, Combinability, Commission, CompanyIndexText, CustomParams, Diagnostics, DisplayFareComponentPenalty, DisplayFareComponentPrice, FullCalendarOffer, NumberOfSegments, LoyaltyAccrual, OnTimePerformance, OriginalPriceCalendar, Redemption, ReferenceNumber, UATPReportingData, UseDocument, UserInput, Vouchers, FareCodePriceIndicator, OCNContents, ServiceQualifier, AoaPriceDifferential, CarrierFee, AccountedOrderVersionNumber, SSRText, OtherServiceInformation, TrackID, EquivID, VoucherPin)
        if ('' !== ($fullCalendarOfferChoiceErrorMessage = self::validateFullCalendarOfferForChoiceConstraintsFromSetFullCalendarOffer($fullCalendarOffer))) {
            throw new \InvalidArgumentException($fullCalendarOfferChoiceErrorMessage, __LINE__);
        }
        if (is_null($fullCalendarOffer) || (is_array($fullCalendarOffer) && empty($fullCalendarOffer))) {
            unset($this->FullCalendarOffer);
        } else {
            $this->FullCalendarOffer = $fullCalendarOffer;
        }
        return $this;
    }
    /**
     * Get NumberOfSegments value
     * @return int|null
     */
    public function getNumberOfSegments()
    {
        return isset($this->NumberOfSegments) ? $this->NumberOfSegments : null;
    }
    /**
     * This method is responsible for validating the value passed to the setNumberOfSegments method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNumberOfSegments method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateNumberOfSegmentsForChoiceConstraintsFromSetNumberOfSegments($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AliasCVV',
            'Amex',
            'ATPCO',
            'CCApprovalCode',
            'ClassOfService',
            'Combinability',
            'Commission',
            'CompanyIndexText',
            'CustomParams',
            'Diagnostics',
            'DisplayFareComponentPenalty',
            'DisplayFareComponentPrice',
            'FullCalendarOffer',
            'LoyaltyAccrual',
            'OnTimePerformance',
            'OriginalPriceCalendar',
            'Redemption',
            'ReferenceNumber',
            'UATPReportingData',
            'UseDocument',
            'UserInput',
            'Vouchers',
            'FareCodePriceIndicator',
            'OCNContents',
            'ServiceQualifier',
            'AoaPriceDifferential',
            'CarrierFee',
            'AccountedOrderVersionNumber',
            'SSRText',
            'OtherServiceInformation',
            'TrackID',
            'EquivID',
            'VoucherPin',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property NumberOfSegments can\'t be set as the property %s is already set. Only one property must be set among these properties: NumberOfSegments, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set NumberOfSegments value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param int $numberOfSegments
     * @return \StructType\AugPoint
     */
    public function setNumberOfSegments($numberOfSegments = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfSegments) && !(is_int($numberOfSegments) || ctype_digit($numberOfSegments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfSegments, true), gettype($numberOfSegments)), __LINE__);
        }
        // validation for constraint: choice(AliasCVV, Amex, ATPCO, CCApprovalCode, ClassOfService, Combinability, Commission, CompanyIndexText, CustomParams, Diagnostics, DisplayFareComponentPenalty, DisplayFareComponentPrice, FullCalendarOffer, NumberOfSegments, LoyaltyAccrual, OnTimePerformance, OriginalPriceCalendar, Redemption, ReferenceNumber, UATPReportingData, UseDocument, UserInput, Vouchers, FareCodePriceIndicator, OCNContents, ServiceQualifier, AoaPriceDifferential, CarrierFee, AccountedOrderVersionNumber, SSRText, OtherServiceInformation, TrackID, EquivID, VoucherPin)
        if ('' !== ($numberOfSegmentsChoiceErrorMessage = self::validateNumberOfSegmentsForChoiceConstraintsFromSetNumberOfSegments($numberOfSegments))) {
            throw new \InvalidArgumentException($numberOfSegmentsChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: totalDigits(1)
        if (!is_null($numberOfSegments) && mb_strlen(preg_replace('/(\D)/', '', $numberOfSegments)) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 1 digits, "%d" given', var_export($numberOfSegments, true), mb_strlen(preg_replace('/(\D)/', '', $numberOfSegments))), __LINE__);
        }
        if (is_null($numberOfSegments) || (is_array($numberOfSegments) && empty($numberOfSegments))) {
            unset($this->NumberOfSegments);
        } else {
            $this->NumberOfSegments = $numberOfSegments;
        }
        return $this;
    }
    /**
     * Get LoyaltyAccrual value
     * @return \StructType\LoyaltyAccrual|null
     */
    public function getLoyaltyAccrual()
    {
        return isset($this->LoyaltyAccrual) ? $this->LoyaltyAccrual : null;
    }
    /**
     * This method is responsible for validating the value passed to the setLoyaltyAccrual method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLoyaltyAccrual method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateLoyaltyAccrualForChoiceConstraintsFromSetLoyaltyAccrual($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AliasCVV',
            'Amex',
            'ATPCO',
            'CCApprovalCode',
            'ClassOfService',
            'Combinability',
            'Commission',
            'CompanyIndexText',
            'CustomParams',
            'Diagnostics',
            'DisplayFareComponentPenalty',
            'DisplayFareComponentPrice',
            'FullCalendarOffer',
            'NumberOfSegments',
            'OnTimePerformance',
            'OriginalPriceCalendar',
            'Redemption',
            'ReferenceNumber',
            'UATPReportingData',
            'UseDocument',
            'UserInput',
            'Vouchers',
            'FareCodePriceIndicator',
            'OCNContents',
            'ServiceQualifier',
            'AoaPriceDifferential',
            'CarrierFee',
            'AccountedOrderVersionNumber',
            'SSRText',
            'OtherServiceInformation',
            'TrackID',
            'EquivID',
            'VoucherPin',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property LoyaltyAccrual can\'t be set as the property %s is already set. Only one property must be set among these properties: LoyaltyAccrual, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set LoyaltyAccrual value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\LoyaltyAccrual $loyaltyAccrual
     * @return \StructType\AugPoint
     */
    public function setLoyaltyAccrual(\StructType\LoyaltyAccrual $loyaltyAccrual = null)
    {
        // validation for constraint: choice(AliasCVV, Amex, ATPCO, CCApprovalCode, ClassOfService, Combinability, Commission, CompanyIndexText, CustomParams, Diagnostics, DisplayFareComponentPenalty, DisplayFareComponentPrice, FullCalendarOffer, NumberOfSegments, LoyaltyAccrual, OnTimePerformance, OriginalPriceCalendar, Redemption, ReferenceNumber, UATPReportingData, UseDocument, UserInput, Vouchers, FareCodePriceIndicator, OCNContents, ServiceQualifier, AoaPriceDifferential, CarrierFee, AccountedOrderVersionNumber, SSRText, OtherServiceInformation, TrackID, EquivID, VoucherPin)
        if ('' !== ($loyaltyAccrualChoiceErrorMessage = self::validateLoyaltyAccrualForChoiceConstraintsFromSetLoyaltyAccrual($loyaltyAccrual))) {
            throw new \InvalidArgumentException($loyaltyAccrualChoiceErrorMessage, __LINE__);
        }
        if (is_null($loyaltyAccrual) || (is_array($loyaltyAccrual) && empty($loyaltyAccrual))) {
            unset($this->LoyaltyAccrual);
        } else {
            $this->LoyaltyAccrual = $loyaltyAccrual;
        }
        return $this;
    }
    /**
     * Get OnTimePerformance value
     * @return \StructType\OnTimePerformance|null
     */
    public function getOnTimePerformance()
    {
        return isset($this->OnTimePerformance) ? $this->OnTimePerformance : null;
    }
    /**
     * This method is responsible for validating the value passed to the setOnTimePerformance method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOnTimePerformance method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateOnTimePerformanceForChoiceConstraintsFromSetOnTimePerformance($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AliasCVV',
            'Amex',
            'ATPCO',
            'CCApprovalCode',
            'ClassOfService',
            'Combinability',
            'Commission',
            'CompanyIndexText',
            'CustomParams',
            'Diagnostics',
            'DisplayFareComponentPenalty',
            'DisplayFareComponentPrice',
            'FullCalendarOffer',
            'NumberOfSegments',
            'LoyaltyAccrual',
            'OriginalPriceCalendar',
            'Redemption',
            'ReferenceNumber',
            'UATPReportingData',
            'UseDocument',
            'UserInput',
            'Vouchers',
            'FareCodePriceIndicator',
            'OCNContents',
            'ServiceQualifier',
            'AoaPriceDifferential',
            'CarrierFee',
            'AccountedOrderVersionNumber',
            'SSRText',
            'OtherServiceInformation',
            'TrackID',
            'EquivID',
            'VoucherPin',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property OnTimePerformance can\'t be set as the property %s is already set. Only one property must be set among these properties: OnTimePerformance, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set OnTimePerformance value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OnTimePerformance $onTimePerformance
     * @return \StructType\AugPoint
     */
    public function setOnTimePerformance(\StructType\OnTimePerformance $onTimePerformance = null)
    {
        // validation for constraint: choice(AliasCVV, Amex, ATPCO, CCApprovalCode, ClassOfService, Combinability, Commission, CompanyIndexText, CustomParams, Diagnostics, DisplayFareComponentPenalty, DisplayFareComponentPrice, FullCalendarOffer, NumberOfSegments, LoyaltyAccrual, OnTimePerformance, OriginalPriceCalendar, Redemption, ReferenceNumber, UATPReportingData, UseDocument, UserInput, Vouchers, FareCodePriceIndicator, OCNContents, ServiceQualifier, AoaPriceDifferential, CarrierFee, AccountedOrderVersionNumber, SSRText, OtherServiceInformation, TrackID, EquivID, VoucherPin)
        if ('' !== ($onTimePerformanceChoiceErrorMessage = self::validateOnTimePerformanceForChoiceConstraintsFromSetOnTimePerformance($onTimePerformance))) {
            throw new \InvalidArgumentException($onTimePerformanceChoiceErrorMessage, __LINE__);
        }
        if (is_null($onTimePerformance) || (is_array($onTimePerformance) && empty($onTimePerformance))) {
            unset($this->OnTimePerformance);
        } else {
            $this->OnTimePerformance = $onTimePerformance;
        }
        return $this;
    }
    /**
     * Get OriginalPriceCalendar value
     * @return string|null
     */
    public function getOriginalPriceCalendar()
    {
        return isset($this->OriginalPriceCalendar) ? $this->OriginalPriceCalendar : null;
    }
    /**
     * This method is responsible for validating the value passed to the setOriginalPriceCalendar method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOriginalPriceCalendar method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateOriginalPriceCalendarForChoiceConstraintsFromSetOriginalPriceCalendar($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AliasCVV',
            'Amex',
            'ATPCO',
            'CCApprovalCode',
            'ClassOfService',
            'Combinability',
            'Commission',
            'CompanyIndexText',
            'CustomParams',
            'Diagnostics',
            'DisplayFareComponentPenalty',
            'DisplayFareComponentPrice',
            'FullCalendarOffer',
            'NumberOfSegments',
            'LoyaltyAccrual',
            'OnTimePerformance',
            'Redemption',
            'ReferenceNumber',
            'UATPReportingData',
            'UseDocument',
            'UserInput',
            'Vouchers',
            'FareCodePriceIndicator',
            'OCNContents',
            'ServiceQualifier',
            'AoaPriceDifferential',
            'CarrierFee',
            'AccountedOrderVersionNumber',
            'SSRText',
            'OtherServiceInformation',
            'TrackID',
            'EquivID',
            'VoucherPin',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property OriginalPriceCalendar can\'t be set as the property %s is already set. Only one property must be set among these properties: OriginalPriceCalendar, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set OriginalPriceCalendar value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $originalPriceCalendar
     * @return \StructType\AugPoint
     */
    public function setOriginalPriceCalendar($originalPriceCalendar = null)
    {
        // validation for constraint: string
        if (!is_null($originalPriceCalendar) && !is_string($originalPriceCalendar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalPriceCalendar, true), gettype($originalPriceCalendar)), __LINE__);
        }
        // validation for constraint: choice(AliasCVV, Amex, ATPCO, CCApprovalCode, ClassOfService, Combinability, Commission, CompanyIndexText, CustomParams, Diagnostics, DisplayFareComponentPenalty, DisplayFareComponentPrice, FullCalendarOffer, NumberOfSegments, LoyaltyAccrual, OnTimePerformance, OriginalPriceCalendar, Redemption, ReferenceNumber, UATPReportingData, UseDocument, UserInput, Vouchers, FareCodePriceIndicator, OCNContents, ServiceQualifier, AoaPriceDifferential, CarrierFee, AccountedOrderVersionNumber, SSRText, OtherServiceInformation, TrackID, EquivID, VoucherPin)
        if ('' !== ($originalPriceCalendarChoiceErrorMessage = self::validateOriginalPriceCalendarForChoiceConstraintsFromSetOriginalPriceCalendar($originalPriceCalendar))) {
            throw new \InvalidArgumentException($originalPriceCalendarChoiceErrorMessage, __LINE__);
        }
        if (is_null($originalPriceCalendar) || (is_array($originalPriceCalendar) && empty($originalPriceCalendar))) {
            unset($this->OriginalPriceCalendar);
        } else {
            $this->OriginalPriceCalendar = $originalPriceCalendar;
        }
        return $this;
    }
    /**
     * Get Redemption value
     * @return \StructType\Redemption|null
     */
    public function getRedemption()
    {
        return isset($this->Redemption) ? $this->Redemption : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRedemption method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRedemption method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRedemptionForChoiceConstraintsFromSetRedemption($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AliasCVV',
            'Amex',
            'ATPCO',
            'CCApprovalCode',
            'ClassOfService',
            'Combinability',
            'Commission',
            'CompanyIndexText',
            'CustomParams',
            'Diagnostics',
            'DisplayFareComponentPenalty',
            'DisplayFareComponentPrice',
            'FullCalendarOffer',
            'NumberOfSegments',
            'LoyaltyAccrual',
            'OnTimePerformance',
            'OriginalPriceCalendar',
            'ReferenceNumber',
            'UATPReportingData',
            'UseDocument',
            'UserInput',
            'Vouchers',
            'FareCodePriceIndicator',
            'OCNContents',
            'ServiceQualifier',
            'AoaPriceDifferential',
            'CarrierFee',
            'AccountedOrderVersionNumber',
            'SSRText',
            'OtherServiceInformation',
            'TrackID',
            'EquivID',
            'VoucherPin',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Redemption can\'t be set as the property %s is already set. Only one property must be set among these properties: Redemption, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Redemption value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Redemption $redemption
     * @return \StructType\AugPoint
     */
    public function setRedemption(\StructType\Redemption $redemption = null)
    {
        // validation for constraint: choice(AliasCVV, Amex, ATPCO, CCApprovalCode, ClassOfService, Combinability, Commission, CompanyIndexText, CustomParams, Diagnostics, DisplayFareComponentPenalty, DisplayFareComponentPrice, FullCalendarOffer, NumberOfSegments, LoyaltyAccrual, OnTimePerformance, OriginalPriceCalendar, Redemption, ReferenceNumber, UATPReportingData, UseDocument, UserInput, Vouchers, FareCodePriceIndicator, OCNContents, ServiceQualifier, AoaPriceDifferential, CarrierFee, AccountedOrderVersionNumber, SSRText, OtherServiceInformation, TrackID, EquivID, VoucherPin)
        if ('' !== ($redemptionChoiceErrorMessage = self::validateRedemptionForChoiceConstraintsFromSetRedemption($redemption))) {
            throw new \InvalidArgumentException($redemptionChoiceErrorMessage, __LINE__);
        }
        if (is_null($redemption) || (is_array($redemption) && empty($redemption))) {
            unset($this->Redemption);
        } else {
            $this->Redemption = $redemption;
        }
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return isset($this->ReferenceNumber) ? $this->ReferenceNumber : null;
    }
    /**
     * This method is responsible for validating the value passed to the setReferenceNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReferenceNumber method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateReferenceNumberForChoiceConstraintsFromSetReferenceNumber($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AliasCVV',
            'Amex',
            'ATPCO',
            'CCApprovalCode',
            'ClassOfService',
            'Combinability',
            'Commission',
            'CompanyIndexText',
            'CustomParams',
            'Diagnostics',
            'DisplayFareComponentPenalty',
            'DisplayFareComponentPrice',
            'FullCalendarOffer',
            'NumberOfSegments',
            'LoyaltyAccrual',
            'OnTimePerformance',
            'OriginalPriceCalendar',
            'Redemption',
            'UATPReportingData',
            'UseDocument',
            'UserInput',
            'Vouchers',
            'FareCodePriceIndicator',
            'OCNContents',
            'ServiceQualifier',
            'AoaPriceDifferential',
            'CarrierFee',
            'AccountedOrderVersionNumber',
            'SSRText',
            'OtherServiceInformation',
            'TrackID',
            'EquivID',
            'VoucherPin',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ReferenceNumber can\'t be set as the property %s is already set. Only one property must be set among these properties: ReferenceNumber, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ReferenceNumber value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $referenceNumber
     * @return \StructType\AugPoint
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber) && !is_string($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        // validation for constraint: choice(AliasCVV, Amex, ATPCO, CCApprovalCode, ClassOfService, Combinability, Commission, CompanyIndexText, CustomParams, Diagnostics, DisplayFareComponentPenalty, DisplayFareComponentPrice, FullCalendarOffer, NumberOfSegments, LoyaltyAccrual, OnTimePerformance, OriginalPriceCalendar, Redemption, ReferenceNumber, UATPReportingData, UseDocument, UserInput, Vouchers, FareCodePriceIndicator, OCNContents, ServiceQualifier, AoaPriceDifferential, CarrierFee, AccountedOrderVersionNumber, SSRText, OtherServiceInformation, TrackID, EquivID, VoucherPin)
        if ('' !== ($referenceNumberChoiceErrorMessage = self::validateReferenceNumberForChoiceConstraintsFromSetReferenceNumber($referenceNumber))) {
            throw new \InvalidArgumentException($referenceNumberChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(([a-zA-Z0-9])*)
        if (!is_null($referenceNumber) && !preg_match('/([a-zA-Z0-9])*/', $referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([a-zA-Z0-9])*', var_export($referenceNumber, true)), __LINE__);
        }
        if (is_null($referenceNumber) || (is_array($referenceNumber) && empty($referenceNumber))) {
            unset($this->ReferenceNumber);
        } else {
            $this->ReferenceNumber = $referenceNumber;
        }
        return $this;
    }
    /**
     * Get UATPReportingData value
     * @return \StructType\UATPReportingData|null
     */
    public function getUATPReportingData()
    {
        return isset($this->UATPReportingData) ? $this->UATPReportingData : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUATPReportingData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUATPReportingData method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUATPReportingDataForChoiceConstraintsFromSetUATPReportingData($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AliasCVV',
            'Amex',
            'ATPCO',
            'CCApprovalCode',
            'ClassOfService',
            'Combinability',
            'Commission',
            'CompanyIndexText',
            'CustomParams',
            'Diagnostics',
            'DisplayFareComponentPenalty',
            'DisplayFareComponentPrice',
            'FullCalendarOffer',
            'NumberOfSegments',
            'LoyaltyAccrual',
            'OnTimePerformance',
            'OriginalPriceCalendar',
            'Redemption',
            'ReferenceNumber',
            'UseDocument',
            'UserInput',
            'Vouchers',
            'FareCodePriceIndicator',
            'OCNContents',
            'ServiceQualifier',
            'AoaPriceDifferential',
            'CarrierFee',
            'AccountedOrderVersionNumber',
            'SSRText',
            'OtherServiceInformation',
            'TrackID',
            'EquivID',
            'VoucherPin',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property UATPReportingData can\'t be set as the property %s is already set. Only one property must be set among these properties: UATPReportingData, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set UATPReportingData value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\UATPReportingData $uATPReportingData
     * @return \StructType\AugPoint
     */
    public function setUATPReportingData(\StructType\UATPReportingData $uATPReportingData = null)
    {
        // validation for constraint: choice(AliasCVV, Amex, ATPCO, CCApprovalCode, ClassOfService, Combinability, Commission, CompanyIndexText, CustomParams, Diagnostics, DisplayFareComponentPenalty, DisplayFareComponentPrice, FullCalendarOffer, NumberOfSegments, LoyaltyAccrual, OnTimePerformance, OriginalPriceCalendar, Redemption, ReferenceNumber, UATPReportingData, UseDocument, UserInput, Vouchers, FareCodePriceIndicator, OCNContents, ServiceQualifier, AoaPriceDifferential, CarrierFee, AccountedOrderVersionNumber, SSRText, OtherServiceInformation, TrackID, EquivID, VoucherPin)
        if ('' !== ($uATPReportingDataChoiceErrorMessage = self::validateUATPReportingDataForChoiceConstraintsFromSetUATPReportingData($uATPReportingData))) {
            throw new \InvalidArgumentException($uATPReportingDataChoiceErrorMessage, __LINE__);
        }
        if (is_null($uATPReportingData) || (is_array($uATPReportingData) && empty($uATPReportingData))) {
            unset($this->UATPReportingData);
        } else {
            $this->UATPReportingData = $uATPReportingData;
        }
        return $this;
    }
    /**
     * Get UseDocument value
     * @return \StructType\UseDocument|null
     */
    public function getUseDocument()
    {
        return isset($this->UseDocument) ? $this->UseDocument : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUseDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUseDocument method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUseDocumentForChoiceConstraintsFromSetUseDocument($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AliasCVV',
            'Amex',
            'ATPCO',
            'CCApprovalCode',
            'ClassOfService',
            'Combinability',
            'Commission',
            'CompanyIndexText',
            'CustomParams',
            'Diagnostics',
            'DisplayFareComponentPenalty',
            'DisplayFareComponentPrice',
            'FullCalendarOffer',
            'NumberOfSegments',
            'LoyaltyAccrual',
            'OnTimePerformance',
            'OriginalPriceCalendar',
            'Redemption',
            'ReferenceNumber',
            'UATPReportingData',
            'UserInput',
            'Vouchers',
            'FareCodePriceIndicator',
            'OCNContents',
            'ServiceQualifier',
            'AoaPriceDifferential',
            'CarrierFee',
            'AccountedOrderVersionNumber',
            'SSRText',
            'OtherServiceInformation',
            'TrackID',
            'EquivID',
            'VoucherPin',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property UseDocument can\'t be set as the property %s is already set. Only one property must be set among these properties: UseDocument, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set UseDocument value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\UseDocument $useDocument
     * @return \StructType\AugPoint
     */
    public function setUseDocument(\StructType\UseDocument $useDocument = null)
    {
        // validation for constraint: choice(AliasCVV, Amex, ATPCO, CCApprovalCode, ClassOfService, Combinability, Commission, CompanyIndexText, CustomParams, Diagnostics, DisplayFareComponentPenalty, DisplayFareComponentPrice, FullCalendarOffer, NumberOfSegments, LoyaltyAccrual, OnTimePerformance, OriginalPriceCalendar, Redemption, ReferenceNumber, UATPReportingData, UseDocument, UserInput, Vouchers, FareCodePriceIndicator, OCNContents, ServiceQualifier, AoaPriceDifferential, CarrierFee, AccountedOrderVersionNumber, SSRText, OtherServiceInformation, TrackID, EquivID, VoucherPin)
        if ('' !== ($useDocumentChoiceErrorMessage = self::validateUseDocumentForChoiceConstraintsFromSetUseDocument($useDocument))) {
            throw new \InvalidArgumentException($useDocumentChoiceErrorMessage, __LINE__);
        }
        if (is_null($useDocument) || (is_array($useDocument) && empty($useDocument))) {
            unset($this->UseDocument);
        } else {
            $this->UseDocument = $useDocument;
        }
        return $this;
    }
    /**
     * Get UserInput value
     * @return \StructType\UserInput|null
     */
    public function getUserInput()
    {
        return isset($this->UserInput) ? $this->UserInput : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUserInput method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUserInput method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUserInputForChoiceConstraintsFromSetUserInput($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AliasCVV',
            'Amex',
            'ATPCO',
            'CCApprovalCode',
            'ClassOfService',
            'Combinability',
            'Commission',
            'CompanyIndexText',
            'CustomParams',
            'Diagnostics',
            'DisplayFareComponentPenalty',
            'DisplayFareComponentPrice',
            'FullCalendarOffer',
            'NumberOfSegments',
            'LoyaltyAccrual',
            'OnTimePerformance',
            'OriginalPriceCalendar',
            'Redemption',
            'ReferenceNumber',
            'UATPReportingData',
            'UseDocument',
            'Vouchers',
            'FareCodePriceIndicator',
            'OCNContents',
            'ServiceQualifier',
            'AoaPriceDifferential',
            'CarrierFee',
            'AccountedOrderVersionNumber',
            'SSRText',
            'OtherServiceInformation',
            'TrackID',
            'EquivID',
            'VoucherPin',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property UserInput can\'t be set as the property %s is already set. Only one property must be set among these properties: UserInput, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set UserInput value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\UserInput $userInput
     * @return \StructType\AugPoint
     */
    public function setUserInput(\StructType\UserInput $userInput = null)
    {
        // validation for constraint: choice(AliasCVV, Amex, ATPCO, CCApprovalCode, ClassOfService, Combinability, Commission, CompanyIndexText, CustomParams, Diagnostics, DisplayFareComponentPenalty, DisplayFareComponentPrice, FullCalendarOffer, NumberOfSegments, LoyaltyAccrual, OnTimePerformance, OriginalPriceCalendar, Redemption, ReferenceNumber, UATPReportingData, UseDocument, UserInput, Vouchers, FareCodePriceIndicator, OCNContents, ServiceQualifier, AoaPriceDifferential, CarrierFee, AccountedOrderVersionNumber, SSRText, OtherServiceInformation, TrackID, EquivID, VoucherPin)
        if ('' !== ($userInputChoiceErrorMessage = self::validateUserInputForChoiceConstraintsFromSetUserInput($userInput))) {
            throw new \InvalidArgumentException($userInputChoiceErrorMessage, __LINE__);
        }
        if (is_null($userInput) || (is_array($userInput) && empty($userInput))) {
            unset($this->UserInput);
        } else {
            $this->UserInput = $userInput;
        }
        return $this;
    }
    /**
     * Get Vouchers value
     * @return \StructType\Vouchers|null
     */
    public function getVouchers()
    {
        return isset($this->Vouchers) ? $this->Vouchers : null;
    }
    /**
     * This method is responsible for validating the value passed to the setVouchers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVouchers method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateVouchersForChoiceConstraintsFromSetVouchers($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AliasCVV',
            'Amex',
            'ATPCO',
            'CCApprovalCode',
            'ClassOfService',
            'Combinability',
            'Commission',
            'CompanyIndexText',
            'CustomParams',
            'Diagnostics',
            'DisplayFareComponentPenalty',
            'DisplayFareComponentPrice',
            'FullCalendarOffer',
            'NumberOfSegments',
            'LoyaltyAccrual',
            'OnTimePerformance',
            'OriginalPriceCalendar',
            'Redemption',
            'ReferenceNumber',
            'UATPReportingData',
            'UseDocument',
            'UserInput',
            'FareCodePriceIndicator',
            'OCNContents',
            'ServiceQualifier',
            'AoaPriceDifferential',
            'CarrierFee',
            'AccountedOrderVersionNumber',
            'SSRText',
            'OtherServiceInformation',
            'TrackID',
            'EquivID',
            'VoucherPin',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Vouchers can\'t be set as the property %s is already set. Only one property must be set among these properties: Vouchers, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Vouchers value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Vouchers $vouchers
     * @return \StructType\AugPoint
     */
    public function setVouchers(\StructType\Vouchers $vouchers = null)
    {
        // validation for constraint: choice(AliasCVV, Amex, ATPCO, CCApprovalCode, ClassOfService, Combinability, Commission, CompanyIndexText, CustomParams, Diagnostics, DisplayFareComponentPenalty, DisplayFareComponentPrice, FullCalendarOffer, NumberOfSegments, LoyaltyAccrual, OnTimePerformance, OriginalPriceCalendar, Redemption, ReferenceNumber, UATPReportingData, UseDocument, UserInput, Vouchers, FareCodePriceIndicator, OCNContents, ServiceQualifier, AoaPriceDifferential, CarrierFee, AccountedOrderVersionNumber, SSRText, OtherServiceInformation, TrackID, EquivID, VoucherPin)
        if ('' !== ($vouchersChoiceErrorMessage = self::validateVouchersForChoiceConstraintsFromSetVouchers($vouchers))) {
            throw new \InvalidArgumentException($vouchersChoiceErrorMessage, __LINE__);
        }
        if (is_null($vouchers) || (is_array($vouchers) && empty($vouchers))) {
            unset($this->Vouchers);
        } else {
            $this->Vouchers = $vouchers;
        }
        return $this;
    }
    /**
     * Get FareCodePriceIndicator value
     * @return string|null
     */
    public function getFareCodePriceIndicator()
    {
        return isset($this->FareCodePriceIndicator) ? $this->FareCodePriceIndicator : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFareCodePriceIndicator method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareCodePriceIndicator method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFareCodePriceIndicatorForChoiceConstraintsFromSetFareCodePriceIndicator($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AliasCVV',
            'Amex',
            'ATPCO',
            'CCApprovalCode',
            'ClassOfService',
            'Combinability',
            'Commission',
            'CompanyIndexText',
            'CustomParams',
            'Diagnostics',
            'DisplayFareComponentPenalty',
            'DisplayFareComponentPrice',
            'FullCalendarOffer',
            'NumberOfSegments',
            'LoyaltyAccrual',
            'OnTimePerformance',
            'OriginalPriceCalendar',
            'Redemption',
            'ReferenceNumber',
            'UATPReportingData',
            'UseDocument',
            'UserInput',
            'Vouchers',
            'OCNContents',
            'ServiceQualifier',
            'AoaPriceDifferential',
            'CarrierFee',
            'AccountedOrderVersionNumber',
            'SSRText',
            'OtherServiceInformation',
            'TrackID',
            'EquivID',
            'VoucherPin',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property FareCodePriceIndicator can\'t be set as the property %s is already set. Only one property must be set among these properties: FareCodePriceIndicator, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set FareCodePriceIndicator value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @uses \EnumType\FareCodePriceIndicator::valueIsValid()
     * @uses \EnumType\FareCodePriceIndicator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fareCodePriceIndicator
     * @return \StructType\AugPoint
     */
    public function setFareCodePriceIndicator($fareCodePriceIndicator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FareCodePriceIndicator::valueIsValid($fareCodePriceIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\FareCodePriceIndicator', is_array($fareCodePriceIndicator) ? implode(', ', $fareCodePriceIndicator) : var_export($fareCodePriceIndicator, true), implode(', ', \EnumType\FareCodePriceIndicator::getValidValues())), __LINE__);
        }
        // validation for constraint: choice(AliasCVV, Amex, ATPCO, CCApprovalCode, ClassOfService, Combinability, Commission, CompanyIndexText, CustomParams, Diagnostics, DisplayFareComponentPenalty, DisplayFareComponentPrice, FullCalendarOffer, NumberOfSegments, LoyaltyAccrual, OnTimePerformance, OriginalPriceCalendar, Redemption, ReferenceNumber, UATPReportingData, UseDocument, UserInput, Vouchers, FareCodePriceIndicator, OCNContents, ServiceQualifier, AoaPriceDifferential, CarrierFee, AccountedOrderVersionNumber, SSRText, OtherServiceInformation, TrackID, EquivID, VoucherPin)
        if ('' !== ($fareCodePriceIndicatorChoiceErrorMessage = self::validateFareCodePriceIndicatorForChoiceConstraintsFromSetFareCodePriceIndicator($fareCodePriceIndicator))) {
            throw new \InvalidArgumentException($fareCodePriceIndicatorChoiceErrorMessage, __LINE__);
        }
        if (is_null($fareCodePriceIndicator) || (is_array($fareCodePriceIndicator) && empty($fareCodePriceIndicator))) {
            unset($this->FareCodePriceIndicator);
        } else {
            $this->FareCodePriceIndicator = $fareCodePriceIndicator;
        }
        return $this;
    }
    /**
     * Get OCNContents value
     * @return \StructType\OCNContents|null
     */
    public function getOCNContents()
    {
        return isset($this->OCNContents) ? $this->OCNContents : null;
    }
    /**
     * This method is responsible for validating the value passed to the setOCNContents method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOCNContents method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateOCNContentsForChoiceConstraintsFromSetOCNContents($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AliasCVV',
            'Amex',
            'ATPCO',
            'CCApprovalCode',
            'ClassOfService',
            'Combinability',
            'Commission',
            'CompanyIndexText',
            'CustomParams',
            'Diagnostics',
            'DisplayFareComponentPenalty',
            'DisplayFareComponentPrice',
            'FullCalendarOffer',
            'NumberOfSegments',
            'LoyaltyAccrual',
            'OnTimePerformance',
            'OriginalPriceCalendar',
            'Redemption',
            'ReferenceNumber',
            'UATPReportingData',
            'UseDocument',
            'UserInput',
            'Vouchers',
            'FareCodePriceIndicator',
            'ServiceQualifier',
            'AoaPriceDifferential',
            'CarrierFee',
            'AccountedOrderVersionNumber',
            'SSRText',
            'OtherServiceInformation',
            'TrackID',
            'EquivID',
            'VoucherPin',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property OCNContents can\'t be set as the property %s is already set. Only one property must be set among these properties: OCNContents, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set OCNContents value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OCNContents $oCNContents
     * @return \StructType\AugPoint
     */
    public function setOCNContents(\StructType\OCNContents $oCNContents = null)
    {
        // validation for constraint: choice(AliasCVV, Amex, ATPCO, CCApprovalCode, ClassOfService, Combinability, Commission, CompanyIndexText, CustomParams, Diagnostics, DisplayFareComponentPenalty, DisplayFareComponentPrice, FullCalendarOffer, NumberOfSegments, LoyaltyAccrual, OnTimePerformance, OriginalPriceCalendar, Redemption, ReferenceNumber, UATPReportingData, UseDocument, UserInput, Vouchers, FareCodePriceIndicator, OCNContents, ServiceQualifier, AoaPriceDifferential, CarrierFee, AccountedOrderVersionNumber, SSRText, OtherServiceInformation, TrackID, EquivID, VoucherPin)
        if ('' !== ($oCNContentsChoiceErrorMessage = self::validateOCNContentsForChoiceConstraintsFromSetOCNContents($oCNContents))) {
            throw new \InvalidArgumentException($oCNContentsChoiceErrorMessage, __LINE__);
        }
        if (is_null($oCNContents) || (is_array($oCNContents) && empty($oCNContents))) {
            unset($this->OCNContents);
        } else {
            $this->OCNContents = $oCNContents;
        }
        return $this;
    }
    /**
     * Get ServiceQualifier value
     * @return string|null
     */
    public function getServiceQualifier()
    {
        return isset($this->ServiceQualifier) ? $this->ServiceQualifier : null;
    }
    /**
     * This method is responsible for validating the value passed to the setServiceQualifier method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceQualifier method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateServiceQualifierForChoiceConstraintsFromSetServiceQualifier($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AliasCVV',
            'Amex',
            'ATPCO',
            'CCApprovalCode',
            'ClassOfService',
            'Combinability',
            'Commission',
            'CompanyIndexText',
            'CustomParams',
            'Diagnostics',
            'DisplayFareComponentPenalty',
            'DisplayFareComponentPrice',
            'FullCalendarOffer',
            'NumberOfSegments',
            'LoyaltyAccrual',
            'OnTimePerformance',
            'OriginalPriceCalendar',
            'Redemption',
            'ReferenceNumber',
            'UATPReportingData',
            'UseDocument',
            'UserInput',
            'Vouchers',
            'FareCodePriceIndicator',
            'OCNContents',
            'AoaPriceDifferential',
            'CarrierFee',
            'AccountedOrderVersionNumber',
            'SSRText',
            'OtherServiceInformation',
            'TrackID',
            'EquivID',
            'VoucherPin',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ServiceQualifier can\'t be set as the property %s is already set. Only one property must be set among these properties: ServiceQualifier, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ServiceQualifier value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @uses \EnumType\ServiceQualifier::valueIsValid()
     * @uses \EnumType\ServiceQualifier::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceQualifier
     * @return \StructType\AugPoint
     */
    public function setServiceQualifier($serviceQualifier = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceQualifier::valueIsValid($serviceQualifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ServiceQualifier', is_array($serviceQualifier) ? implode(', ', $serviceQualifier) : var_export($serviceQualifier, true), implode(', ', \EnumType\ServiceQualifier::getValidValues())), __LINE__);
        }
        // validation for constraint: choice(AliasCVV, Amex, ATPCO, CCApprovalCode, ClassOfService, Combinability, Commission, CompanyIndexText, CustomParams, Diagnostics, DisplayFareComponentPenalty, DisplayFareComponentPrice, FullCalendarOffer, NumberOfSegments, LoyaltyAccrual, OnTimePerformance, OriginalPriceCalendar, Redemption, ReferenceNumber, UATPReportingData, UseDocument, UserInput, Vouchers, FareCodePriceIndicator, OCNContents, ServiceQualifier, AoaPriceDifferential, CarrierFee, AccountedOrderVersionNumber, SSRText, OtherServiceInformation, TrackID, EquivID, VoucherPin)
        if ('' !== ($serviceQualifierChoiceErrorMessage = self::validateServiceQualifierForChoiceConstraintsFromSetServiceQualifier($serviceQualifier))) {
            throw new \InvalidArgumentException($serviceQualifierChoiceErrorMessage, __LINE__);
        }
        if (is_null($serviceQualifier) || (is_array($serviceQualifier) && empty($serviceQualifier))) {
            unset($this->ServiceQualifier);
        } else {
            $this->ServiceQualifier = $serviceQualifier;
        }
        return $this;
    }
    /**
     * Get AoaPriceDifferential value
     * @return \StructType\PriceDifferentialType|null
     */
    public function getAoaPriceDifferential()
    {
        return isset($this->AoaPriceDifferential) ? $this->AoaPriceDifferential : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAoaPriceDifferential method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAoaPriceDifferential method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAoaPriceDifferentialForChoiceConstraintsFromSetAoaPriceDifferential($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AliasCVV',
            'Amex',
            'ATPCO',
            'CCApprovalCode',
            'ClassOfService',
            'Combinability',
            'Commission',
            'CompanyIndexText',
            'CustomParams',
            'Diagnostics',
            'DisplayFareComponentPenalty',
            'DisplayFareComponentPrice',
            'FullCalendarOffer',
            'NumberOfSegments',
            'LoyaltyAccrual',
            'OnTimePerformance',
            'OriginalPriceCalendar',
            'Redemption',
            'ReferenceNumber',
            'UATPReportingData',
            'UseDocument',
            'UserInput',
            'Vouchers',
            'FareCodePriceIndicator',
            'OCNContents',
            'ServiceQualifier',
            'CarrierFee',
            'AccountedOrderVersionNumber',
            'SSRText',
            'OtherServiceInformation',
            'TrackID',
            'EquivID',
            'VoucherPin',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property AoaPriceDifferential can\'t be set as the property %s is already set. Only one property must be set among these properties: AoaPriceDifferential, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set AoaPriceDifferential value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PriceDifferentialType $aoaPriceDifferential
     * @return \StructType\AugPoint
     */
    public function setAoaPriceDifferential(\StructType\PriceDifferentialType $aoaPriceDifferential = null)
    {
        // validation for constraint: choice(AliasCVV, Amex, ATPCO, CCApprovalCode, ClassOfService, Combinability, Commission, CompanyIndexText, CustomParams, Diagnostics, DisplayFareComponentPenalty, DisplayFareComponentPrice, FullCalendarOffer, NumberOfSegments, LoyaltyAccrual, OnTimePerformance, OriginalPriceCalendar, Redemption, ReferenceNumber, UATPReportingData, UseDocument, UserInput, Vouchers, FareCodePriceIndicator, OCNContents, ServiceQualifier, AoaPriceDifferential, CarrierFee, AccountedOrderVersionNumber, SSRText, OtherServiceInformation, TrackID, EquivID, VoucherPin)
        if ('' !== ($aoaPriceDifferentialChoiceErrorMessage = self::validateAoaPriceDifferentialForChoiceConstraintsFromSetAoaPriceDifferential($aoaPriceDifferential))) {
            throw new \InvalidArgumentException($aoaPriceDifferentialChoiceErrorMessage, __LINE__);
        }
        if (is_null($aoaPriceDifferential) || (is_array($aoaPriceDifferential) && empty($aoaPriceDifferential))) {
            unset($this->AoaPriceDifferential);
        } else {
            $this->AoaPriceDifferential = $aoaPriceDifferential;
        }
        return $this;
    }
    /**
     * Get CarrierFee value
     * @return \StructType\CarrierFeeType[]|null
     */
    public function getCarrierFee()
    {
        return isset($this->CarrierFee) ? $this->CarrierFee : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCarrierFee method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCarrierFee method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCarrierFeeForArrayConstraintsFromSetCarrierFee(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $augPointCarrierFeeItem) {
            // validation for constraint: itemType
            if (!$augPointCarrierFeeItem instanceof \StructType\CarrierFeeType) {
                $invalidValues[] = is_object($augPointCarrierFeeItem) ? get_class($augPointCarrierFeeItem) : sprintf('%s(%s)', gettype($augPointCarrierFeeItem), var_export($augPointCarrierFeeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CarrierFee property can only contain items of type \StructType\CarrierFeeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setCarrierFee method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCarrierFee method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCarrierFeeForChoiceConstraintsFromSetCarrierFee($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AliasCVV',
            'Amex',
            'ATPCO',
            'CCApprovalCode',
            'ClassOfService',
            'Combinability',
            'Commission',
            'CompanyIndexText',
            'CustomParams',
            'Diagnostics',
            'DisplayFareComponentPenalty',
            'DisplayFareComponentPrice',
            'FullCalendarOffer',
            'NumberOfSegments',
            'LoyaltyAccrual',
            'OnTimePerformance',
            'OriginalPriceCalendar',
            'Redemption',
            'ReferenceNumber',
            'UATPReportingData',
            'UseDocument',
            'UserInput',
            'Vouchers',
            'FareCodePriceIndicator',
            'OCNContents',
            'ServiceQualifier',
            'AoaPriceDifferential',
            'AccountedOrderVersionNumber',
            'SSRText',
            'OtherServiceInformation',
            'TrackID',
            'EquivID',
            'VoucherPin',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CarrierFee can\'t be set as the property %s is already set. Only one property must be set among these properties: CarrierFee, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CarrierFee value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\CarrierFeeType[] $carrierFee
     * @return \StructType\AugPoint
     */
    public function setCarrierFee(array $carrierFee = array())
    {
        // validation for constraint: array
        if ('' !== ($carrierFeeArrayErrorMessage = self::validateCarrierFeeForArrayConstraintsFromSetCarrierFee($carrierFee))) {
            throw new \InvalidArgumentException($carrierFeeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(AliasCVV, Amex, ATPCO, CCApprovalCode, ClassOfService, Combinability, Commission, CompanyIndexText, CustomParams, Diagnostics, DisplayFareComponentPenalty, DisplayFareComponentPrice, FullCalendarOffer, NumberOfSegments, LoyaltyAccrual, OnTimePerformance, OriginalPriceCalendar, Redemption, ReferenceNumber, UATPReportingData, UseDocument, UserInput, Vouchers, FareCodePriceIndicator, OCNContents, ServiceQualifier, AoaPriceDifferential, CarrierFee, AccountedOrderVersionNumber, SSRText, OtherServiceInformation, TrackID, EquivID, VoucherPin)
        if ('' !== ($carrierFeeChoiceErrorMessage = self::validateCarrierFeeForChoiceConstraintsFromSetCarrierFee($carrierFee))) {
            throw new \InvalidArgumentException($carrierFeeChoiceErrorMessage, __LINE__);
        }
        if (is_null($carrierFee) || (is_array($carrierFee) && empty($carrierFee))) {
            unset($this->CarrierFee);
        } else {
            $this->CarrierFee = $carrierFee;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToCarrierFee method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToCarrierFee method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToCarrierFee($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AliasCVV',
            'Amex',
            'ATPCO',
            'CCApprovalCode',
            'ClassOfService',
            'Combinability',
            'Commission',
            'CompanyIndexText',
            'CustomParams',
            'Diagnostics',
            'DisplayFareComponentPenalty',
            'DisplayFareComponentPrice',
            'FullCalendarOffer',
            'NumberOfSegments',
            'LoyaltyAccrual',
            'OnTimePerformance',
            'OriginalPriceCalendar',
            'Redemption',
            'ReferenceNumber',
            'UATPReportingData',
            'UseDocument',
            'UserInput',
            'Vouchers',
            'FareCodePriceIndicator',
            'OCNContents',
            'ServiceQualifier',
            'AoaPriceDifferential',
            'AccountedOrderVersionNumber',
            'SSRText',
            'OtherServiceInformation',
            'TrackID',
            'EquivID',
            'VoucherPin',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CarrierFee can\'t be set as the property %s is already set. Only one property must be set among these properties: CarrierFee, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to CarrierFee value
     * @throws \InvalidArgumentException
     * @param \StructType\CarrierFeeType $item
     * @return \StructType\AugPoint
     */
    public function addToCarrierFee(\StructType\CarrierFeeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CarrierFeeType) {
            throw new \InvalidArgumentException(sprintf('The CarrierFee property can only contain items of type \StructType\CarrierFeeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(AliasCVV, Amex, ATPCO, CCApprovalCode, ClassOfService, Combinability, Commission, CompanyIndexText, CustomParams, Diagnostics, DisplayFareComponentPenalty, DisplayFareComponentPrice, FullCalendarOffer, NumberOfSegments, LoyaltyAccrual, OnTimePerformance, OriginalPriceCalendar, Redemption, ReferenceNumber, UATPReportingData, UseDocument, UserInput, Vouchers, FareCodePriceIndicator, OCNContents, ServiceQualifier, AoaPriceDifferential, CarrierFee, AccountedOrderVersionNumber, SSRText, OtherServiceInformation, TrackID, EquivID, VoucherPin)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToCarrierFee($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->CarrierFee[] = $item;
        return $this;
    }
    /**
     * Get AccountedOrderVersionNumber value
     * @return int|null
     */
    public function getAccountedOrderVersionNumber()
    {
        return isset($this->AccountedOrderVersionNumber) ? $this->AccountedOrderVersionNumber : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAccountedOrderVersionNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountedOrderVersionNumber method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAccountedOrderVersionNumberForChoiceConstraintsFromSetAccountedOrderVersionNumber($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AliasCVV',
            'Amex',
            'ATPCO',
            'CCApprovalCode',
            'ClassOfService',
            'Combinability',
            'Commission',
            'CompanyIndexText',
            'CustomParams',
            'Diagnostics',
            'DisplayFareComponentPenalty',
            'DisplayFareComponentPrice',
            'FullCalendarOffer',
            'NumberOfSegments',
            'LoyaltyAccrual',
            'OnTimePerformance',
            'OriginalPriceCalendar',
            'Redemption',
            'ReferenceNumber',
            'UATPReportingData',
            'UseDocument',
            'UserInput',
            'Vouchers',
            'FareCodePriceIndicator',
            'OCNContents',
            'ServiceQualifier',
            'AoaPriceDifferential',
            'CarrierFee',
            'SSRText',
            'OtherServiceInformation',
            'TrackID',
            'EquivID',
            'VoucherPin',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property AccountedOrderVersionNumber can\'t be set as the property %s is already set. Only one property must be set among these properties: AccountedOrderVersionNumber, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set AccountedOrderVersionNumber value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param int $accountedOrderVersionNumber
     * @return \StructType\AugPoint
     */
    public function setAccountedOrderVersionNumber($accountedOrderVersionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($accountedOrderVersionNumber) && !(is_int($accountedOrderVersionNumber) || ctype_digit($accountedOrderVersionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountedOrderVersionNumber, true), gettype($accountedOrderVersionNumber)), __LINE__);
        }
        // validation for constraint: choice(AliasCVV, Amex, ATPCO, CCApprovalCode, ClassOfService, Combinability, Commission, CompanyIndexText, CustomParams, Diagnostics, DisplayFareComponentPenalty, DisplayFareComponentPrice, FullCalendarOffer, NumberOfSegments, LoyaltyAccrual, OnTimePerformance, OriginalPriceCalendar, Redemption, ReferenceNumber, UATPReportingData, UseDocument, UserInput, Vouchers, FareCodePriceIndicator, OCNContents, ServiceQualifier, AoaPriceDifferential, CarrierFee, AccountedOrderVersionNumber, SSRText, OtherServiceInformation, TrackID, EquivID, VoucherPin)
        if ('' !== ($accountedOrderVersionNumberChoiceErrorMessage = self::validateAccountedOrderVersionNumberForChoiceConstraintsFromSetAccountedOrderVersionNumber($accountedOrderVersionNumber))) {
            throw new \InvalidArgumentException($accountedOrderVersionNumberChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($accountedOrderVersionNumber) && $accountedOrderVersionNumber < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($accountedOrderVersionNumber, true)), __LINE__);
        }
        if (is_null($accountedOrderVersionNumber) || (is_array($accountedOrderVersionNumber) && empty($accountedOrderVersionNumber))) {
            unset($this->AccountedOrderVersionNumber);
        } else {
            $this->AccountedOrderVersionNumber = $accountedOrderVersionNumber;
        }
        return $this;
    }
    /**
     * Get SSRText value
     * @return string|null
     */
    public function getSSRText()
    {
        return isset($this->SSRText) ? $this->SSRText : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSSRText method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSSRText method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSSRTextForChoiceConstraintsFromSetSSRText($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AliasCVV',
            'Amex',
            'ATPCO',
            'CCApprovalCode',
            'ClassOfService',
            'Combinability',
            'Commission',
            'CompanyIndexText',
            'CustomParams',
            'Diagnostics',
            'DisplayFareComponentPenalty',
            'DisplayFareComponentPrice',
            'FullCalendarOffer',
            'NumberOfSegments',
            'LoyaltyAccrual',
            'OnTimePerformance',
            'OriginalPriceCalendar',
            'Redemption',
            'ReferenceNumber',
            'UATPReportingData',
            'UseDocument',
            'UserInput',
            'Vouchers',
            'FareCodePriceIndicator',
            'OCNContents',
            'ServiceQualifier',
            'AoaPriceDifferential',
            'CarrierFee',
            'AccountedOrderVersionNumber',
            'OtherServiceInformation',
            'TrackID',
            'EquivID',
            'VoucherPin',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property SSRText can\'t be set as the property %s is already set. Only one property must be set among these properties: SSRText, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set SSRText value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $sSRText
     * @return \StructType\AugPoint
     */
    public function setSSRText($sSRText = null)
    {
        // validation for constraint: string
        if (!is_null($sSRText) && !is_string($sSRText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sSRText, true), gettype($sSRText)), __LINE__);
        }
        // validation for constraint: choice(AliasCVV, Amex, ATPCO, CCApprovalCode, ClassOfService, Combinability, Commission, CompanyIndexText, CustomParams, Diagnostics, DisplayFareComponentPenalty, DisplayFareComponentPrice, FullCalendarOffer, NumberOfSegments, LoyaltyAccrual, OnTimePerformance, OriginalPriceCalendar, Redemption, ReferenceNumber, UATPReportingData, UseDocument, UserInput, Vouchers, FareCodePriceIndicator, OCNContents, ServiceQualifier, AoaPriceDifferential, CarrierFee, AccountedOrderVersionNumber, SSRText, OtherServiceInformation, TrackID, EquivID, VoucherPin)
        if ('' !== ($sSRTextChoiceErrorMessage = self::validateSSRTextForChoiceConstraintsFromSetSSRText($sSRText))) {
            throw new \InvalidArgumentException($sSRTextChoiceErrorMessage, __LINE__);
        }
        if (is_null($sSRText) || (is_array($sSRText) && empty($sSRText))) {
            unset($this->SSRText);
        } else {
            $this->SSRText = $sSRText;
        }
        return $this;
    }
    /**
     * Get OtherServiceInformation value
     * @return \StructType\OtherServiceInformation|null
     */
    public function getOtherServiceInformation()
    {
        return isset($this->OtherServiceInformation) ? $this->OtherServiceInformation : null;
    }
    /**
     * This method is responsible for validating the value passed to the setOtherServiceInformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOtherServiceInformation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateOtherServiceInformationForChoiceConstraintsFromSetOtherServiceInformation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AliasCVV',
            'Amex',
            'ATPCO',
            'CCApprovalCode',
            'ClassOfService',
            'Combinability',
            'Commission',
            'CompanyIndexText',
            'CustomParams',
            'Diagnostics',
            'DisplayFareComponentPenalty',
            'DisplayFareComponentPrice',
            'FullCalendarOffer',
            'NumberOfSegments',
            'LoyaltyAccrual',
            'OnTimePerformance',
            'OriginalPriceCalendar',
            'Redemption',
            'ReferenceNumber',
            'UATPReportingData',
            'UseDocument',
            'UserInput',
            'Vouchers',
            'FareCodePriceIndicator',
            'OCNContents',
            'ServiceQualifier',
            'AoaPriceDifferential',
            'CarrierFee',
            'AccountedOrderVersionNumber',
            'SSRText',
            'TrackID',
            'EquivID',
            'VoucherPin',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property OtherServiceInformation can\'t be set as the property %s is already set. Only one property must be set among these properties: OtherServiceInformation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set OtherServiceInformation value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OtherServiceInformation $otherServiceInformation
     * @return \StructType\AugPoint
     */
    public function setOtherServiceInformation(\StructType\OtherServiceInformation $otherServiceInformation = null)
    {
        // validation for constraint: choice(AliasCVV, Amex, ATPCO, CCApprovalCode, ClassOfService, Combinability, Commission, CompanyIndexText, CustomParams, Diagnostics, DisplayFareComponentPenalty, DisplayFareComponentPrice, FullCalendarOffer, NumberOfSegments, LoyaltyAccrual, OnTimePerformance, OriginalPriceCalendar, Redemption, ReferenceNumber, UATPReportingData, UseDocument, UserInput, Vouchers, FareCodePriceIndicator, OCNContents, ServiceQualifier, AoaPriceDifferential, CarrierFee, AccountedOrderVersionNumber, SSRText, OtherServiceInformation, TrackID, EquivID, VoucherPin)
        if ('' !== ($otherServiceInformationChoiceErrorMessage = self::validateOtherServiceInformationForChoiceConstraintsFromSetOtherServiceInformation($otherServiceInformation))) {
            throw new \InvalidArgumentException($otherServiceInformationChoiceErrorMessage, __LINE__);
        }
        if (is_null($otherServiceInformation) || (is_array($otherServiceInformation) && empty($otherServiceInformation))) {
            unset($this->OtherServiceInformation);
        } else {
            $this->OtherServiceInformation = $otherServiceInformation;
        }
        return $this;
    }
    /**
     * Get TrackID value
     * @return string|null
     */
    public function getTrackID()
    {
        return isset($this->TrackID) ? $this->TrackID : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTrackID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTrackID method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTrackIDForChoiceConstraintsFromSetTrackID($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AliasCVV',
            'Amex',
            'ATPCO',
            'CCApprovalCode',
            'ClassOfService',
            'Combinability',
            'Commission',
            'CompanyIndexText',
            'CustomParams',
            'Diagnostics',
            'DisplayFareComponentPenalty',
            'DisplayFareComponentPrice',
            'FullCalendarOffer',
            'NumberOfSegments',
            'LoyaltyAccrual',
            'OnTimePerformance',
            'OriginalPriceCalendar',
            'Redemption',
            'ReferenceNumber',
            'UATPReportingData',
            'UseDocument',
            'UserInput',
            'Vouchers',
            'FareCodePriceIndicator',
            'OCNContents',
            'ServiceQualifier',
            'AoaPriceDifferential',
            'CarrierFee',
            'AccountedOrderVersionNumber',
            'SSRText',
            'OtherServiceInformation',
            'EquivID',
            'VoucherPin',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property TrackID can\'t be set as the property %s is already set. Only one property must be set among these properties: TrackID, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set TrackID value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $trackID
     * @return \StructType\AugPoint
     */
    public function setTrackID($trackID = null)
    {
        // validation for constraint: string
        if (!is_null($trackID) && !is_string($trackID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackID, true), gettype($trackID)), __LINE__);
        }
        // validation for constraint: choice(AliasCVV, Amex, ATPCO, CCApprovalCode, ClassOfService, Combinability, Commission, CompanyIndexText, CustomParams, Diagnostics, DisplayFareComponentPenalty, DisplayFareComponentPrice, FullCalendarOffer, NumberOfSegments, LoyaltyAccrual, OnTimePerformance, OriginalPriceCalendar, Redemption, ReferenceNumber, UATPReportingData, UseDocument, UserInput, Vouchers, FareCodePriceIndicator, OCNContents, ServiceQualifier, AoaPriceDifferential, CarrierFee, AccountedOrderVersionNumber, SSRText, OtherServiceInformation, TrackID, EquivID, VoucherPin)
        if ('' !== ($trackIDChoiceErrorMessage = self::validateTrackIDForChoiceConstraintsFromSetTrackID($trackID))) {
            throw new \InvalidArgumentException($trackIDChoiceErrorMessage, __LINE__);
        }
        if (is_null($trackID) || (is_array($trackID) && empty($trackID))) {
            unset($this->TrackID);
        } else {
            $this->TrackID = $trackID;
        }
        return $this;
    }
    /**
     * Get EquivID value
     * @return \StructType\EquivID|null
     */
    public function getEquivID()
    {
        return isset($this->EquivID) ? $this->EquivID : null;
    }
    /**
     * This method is responsible for validating the value passed to the setEquivID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEquivID method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateEquivIDForChoiceConstraintsFromSetEquivID($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AliasCVV',
            'Amex',
            'ATPCO',
            'CCApprovalCode',
            'ClassOfService',
            'Combinability',
            'Commission',
            'CompanyIndexText',
            'CustomParams',
            'Diagnostics',
            'DisplayFareComponentPenalty',
            'DisplayFareComponentPrice',
            'FullCalendarOffer',
            'NumberOfSegments',
            'LoyaltyAccrual',
            'OnTimePerformance',
            'OriginalPriceCalendar',
            'Redemption',
            'ReferenceNumber',
            'UATPReportingData',
            'UseDocument',
            'UserInput',
            'Vouchers',
            'FareCodePriceIndicator',
            'OCNContents',
            'ServiceQualifier',
            'AoaPriceDifferential',
            'CarrierFee',
            'AccountedOrderVersionNumber',
            'SSRText',
            'OtherServiceInformation',
            'TrackID',
            'VoucherPin',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property EquivID can\'t be set as the property %s is already set. Only one property must be set among these properties: EquivID, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set EquivID value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EquivID $equivID
     * @return \StructType\AugPoint
     */
    public function setEquivID(\StructType\EquivID $equivID = null)
    {
        // validation for constraint: choice(AliasCVV, Amex, ATPCO, CCApprovalCode, ClassOfService, Combinability, Commission, CompanyIndexText, CustomParams, Diagnostics, DisplayFareComponentPenalty, DisplayFareComponentPrice, FullCalendarOffer, NumberOfSegments, LoyaltyAccrual, OnTimePerformance, OriginalPriceCalendar, Redemption, ReferenceNumber, UATPReportingData, UseDocument, UserInput, Vouchers, FareCodePriceIndicator, OCNContents, ServiceQualifier, AoaPriceDifferential, CarrierFee, AccountedOrderVersionNumber, SSRText, OtherServiceInformation, TrackID, EquivID, VoucherPin)
        if ('' !== ($equivIDChoiceErrorMessage = self::validateEquivIDForChoiceConstraintsFromSetEquivID($equivID))) {
            throw new \InvalidArgumentException($equivIDChoiceErrorMessage, __LINE__);
        }
        if (is_null($equivID) || (is_array($equivID) && empty($equivID))) {
            unset($this->EquivID);
        } else {
            $this->EquivID = $equivID;
        }
        return $this;
    }
    /**
     * Get VoucherPin value
     * @return \StructType\VoucherPin|null
     */
    public function getVoucherPin()
    {
        return isset($this->VoucherPin) ? $this->VoucherPin : null;
    }
    /**
     * This method is responsible for validating the value passed to the setVoucherPin method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVoucherPin method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateVoucherPinForChoiceConstraintsFromSetVoucherPin($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AliasCVV',
            'Amex',
            'ATPCO',
            'CCApprovalCode',
            'ClassOfService',
            'Combinability',
            'Commission',
            'CompanyIndexText',
            'CustomParams',
            'Diagnostics',
            'DisplayFareComponentPenalty',
            'DisplayFareComponentPrice',
            'FullCalendarOffer',
            'NumberOfSegments',
            'LoyaltyAccrual',
            'OnTimePerformance',
            'OriginalPriceCalendar',
            'Redemption',
            'ReferenceNumber',
            'UATPReportingData',
            'UseDocument',
            'UserInput',
            'Vouchers',
            'FareCodePriceIndicator',
            'OCNContents',
            'ServiceQualifier',
            'AoaPriceDifferential',
            'CarrierFee',
            'AccountedOrderVersionNumber',
            'SSRText',
            'OtherServiceInformation',
            'TrackID',
            'EquivID',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property VoucherPin can\'t be set as the property %s is already set. Only one property must be set among these properties: VoucherPin, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set VoucherPin value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\VoucherPin $voucherPin
     * @return \StructType\AugPoint
     */
    public function setVoucherPin(\StructType\VoucherPin $voucherPin = null)
    {
        // validation for constraint: choice(AliasCVV, Amex, ATPCO, CCApprovalCode, ClassOfService, Combinability, Commission, CompanyIndexText, CustomParams, Diagnostics, DisplayFareComponentPenalty, DisplayFareComponentPrice, FullCalendarOffer, NumberOfSegments, LoyaltyAccrual, OnTimePerformance, OriginalPriceCalendar, Redemption, ReferenceNumber, UATPReportingData, UseDocument, UserInput, Vouchers, FareCodePriceIndicator, OCNContents, ServiceQualifier, AoaPriceDifferential, CarrierFee, AccountedOrderVersionNumber, SSRText, OtherServiceInformation, TrackID, EquivID, VoucherPin)
        if ('' !== ($voucherPinChoiceErrorMessage = self::validateVoucherPinForChoiceConstraintsFromSetVoucherPin($voucherPin))) {
            throw new \InvalidArgumentException($voucherPinChoiceErrorMessage, __LINE__);
        }
        if (is_null($voucherPin) || (is_array($voucherPin) && empty($voucherPin))) {
            unset($this->VoucherPin);
        } else {
            $this->VoucherPin = $voucherPin;
        }
        return $this;
    }
}
