<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Association StructType
 * Meta information extracted from the WSDL
 * - documentation: Combinability Association Detail.
 * @subpackage Structs
 */
class Association extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: Named association type. Examples: ServiceBundle, MediaGroup
     * @var string
     */
    public $Type;
    /**
     * The ReferenceValue
     * Meta information extracted from the WSDL
     * - documentation: Associated object instance value. Example: mediagrp1
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $ReferenceValue;
    /**
     * The ServiceRefID
     * Meta information extracted from the WSDL
     * - documentation: Association to one Service instance. Example: srvc1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ServiceRefID;
    /**
     * The OfferItemRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to an Offer Item ID. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - choice: OfferItemRefID | OrderItemRefID | OriginDestRefID | PaxRefID | PaxSegmentRef | PaymentRefID | PriceClassRefID | ServiceDefinitionRef | FareBasisCode | DatedMarketingSegmentRef | TicketNumber | NotAssociated
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $OfferItemRefID;
    /**
     * The OrderItemRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to an Order Item ID for which this payment method applies. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - choice: OfferItemRefID | OrderItemRefID | OriginDestRefID | PaxRefID | PaxSegmentRef | PaymentRefID | PriceClassRefID | ServiceDefinitionRef | FareBasisCode | DatedMarketingSegmentRef | TicketNumber | NotAssociated
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $OrderItemRefID;
    /**
     * The OriginDestRefID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely identifies an Origin Destination within the context of one message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - choice: OfferItemRefID | OrderItemRefID | OriginDestRefID | PaxRefID | PaxSegmentRef | PaymentRefID | PriceClassRefID | ServiceDefinitionRef | FareBasisCode | DatedMarketingSegmentRef | TicketNumber | NotAssociated
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $OriginDestRefID;
    /**
     * The PaxRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Passenger ID within this message | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - choice: OfferItemRefID | OrderItemRefID | OriginDestRefID | PaxRefID | PaxSegmentRef | PaymentRefID | PriceClassRefID | ServiceDefinitionRef | FareBasisCode | DatedMarketingSegmentRef | TicketNumber | NotAssociated
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PaxRefID;
    /**
     * The PaxSegmentRef
     * Meta information extracted from the WSDL
     * - documentation: Reference to a PaxSegmentID . This will be a reference to a single passenger segment that will be defined in a data list or pax segment list in the contained message.
     * - choice: OfferItemRefID | OrderItemRefID | OriginDestRefID | PaxRefID | PaxSegmentRef | PaymentRefID | PriceClassRefID | ServiceDefinitionRef | FareBasisCode | DatedMarketingSegmentRef | TicketNumber | NotAssociated
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaxSegmentRefType[]
     */
    public $PaxSegmentRef;
    /**
     * The PaymentRefID
     * Meta information extracted from the WSDL
     * - documentation: If creating the order after payment authorization it is a way of linking an order to an existing payment reference. not triggering the whole process again. | An identifier is a character string used to uniquely identify one instance
     * of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - choice: OfferItemRefID | OrderItemRefID | OriginDestRefID | PaxRefID | PaxSegmentRef | PaymentRefID | PriceClassRefID | ServiceDefinitionRef | FareBasisCode | DatedMarketingSegmentRef | TicketNumber | NotAssociated
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PaymentRefID;
    /**
     * The PriceClassRefID
     * Meta information extracted from the WSDL
     * - documentation: A price point within a particular Cabin Type (sometimes referred to as 'Fare Families'). | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an
     * agency.
     * - base: xs:token
     * - choice: OfferItemRefID | OrderItemRefID | OriginDestRefID | PaxRefID | PaxSegmentRef | PaymentRefID | PriceClassRefID | ServiceDefinitionRef | FareBasisCode | DatedMarketingSegmentRef | TicketNumber | NotAssociated
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PriceClassRefID;
    /**
     * The ServiceDefinitionRef
     * Meta information extracted from the WSDL
     * - documentation: Airline specific definition of a product or service (excluding flights) that can be separately sold and delivered. e.g. bag, seat, meal on a flight
     * - choice: OfferItemRefID | OrderItemRefID | OriginDestRefID | PaxRefID | PaxSegmentRef | PaymentRefID | PriceClassRefID | ServiceDefinitionRef | FareBasisCode | DatedMarketingSegmentRef | TicketNumber | NotAssociated
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrderServiceDefinitionRefType[]
     */
    public $ServiceDefinitionRef;
    /**
     * The FareBasisCode
     * Meta information extracted from the WSDL
     * - documentation: Fare basis code. Example: Y26 | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - choice: OfferItemRefID | OrderItemRefID | OriginDestRefID | PaxRefID | PaxSegmentRef | PaymentRefID | PriceClassRefID | ServiceDefinitionRef | FareBasisCode | DatedMarketingSegmentRef | TicketNumber | NotAssociated
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FareBasisCode;
    /**
     * The DatedMarketingSegmentRef
     * Meta information extracted from the WSDL
     * - choice: OfferItemRefID | OrderItemRefID | OriginDestRefID | PaxRefID | PaxSegmentRef | PaymentRefID | PriceClassRefID | ServiceDefinitionRef | FareBasisCode | DatedMarketingSegmentRef | TicketNumber | NotAssociated
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DatedMarketingSegmentRef[]
     */
    public $DatedMarketingSegmentRef;
    /**
     * The TicketNumber
     * Meta information extracted from the WSDL
     * - documentation: The document number comprised of the airline code, form code, and serial number.
     * - choice: OfferItemRefID | OrderItemRefID | OriginDestRefID | PaxRefID | PaxSegmentRef | PaymentRefID | PriceClassRefID | ServiceDefinitionRef | FareBasisCode | DatedMarketingSegmentRef | TicketNumber | NotAssociated
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $TicketNumber;
    /**
     * The NotAssociated
     * Meta information extracted from the WSDL
     * - documentation: Use when item being passed in the aug point is not associated to anything. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - choice: OfferItemRefID | OrderItemRefID | OriginDestRefID | PaxRefID | PaxSegmentRef | PaymentRefID | PriceClassRefID | ServiceDefinitionRef | FareBasisCode | DatedMarketingSegmentRef | TicketNumber | NotAssociated
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - default: true
     * @var bool
     */
    public $NotAssociated;
    /**
     * Constructor method for Association
     * @uses Association::setType()
     * @uses Association::setReferenceValue()
     * @uses Association::setServiceRefID()
     * @uses Association::setOfferItemRefID()
     * @uses Association::setOrderItemRefID()
     * @uses Association::setOriginDestRefID()
     * @uses Association::setPaxRefID()
     * @uses Association::setPaxSegmentRef()
     * @uses Association::setPaymentRefID()
     * @uses Association::setPriceClassRefID()
     * @uses Association::setServiceDefinitionRef()
     * @uses Association::setFareBasisCode()
     * @uses Association::setDatedMarketingSegmentRef()
     * @uses Association::setTicketNumber()
     * @uses Association::setNotAssociated()
     * @param string $type
     * @param string[] $referenceValue
     * @param string[] $serviceRefID
     * @param string[] $offerItemRefID
     * @param string[] $orderItemRefID
     * @param string[] $originDestRefID
     * @param string[] $paxRefID
     * @param \StructType\PaxSegmentRefType[] $paxSegmentRef
     * @param string[] $paymentRefID
     * @param string $priceClassRefID
     * @param \StructType\OrderServiceDefinitionRefType[] $serviceDefinitionRef
     * @param string $fareBasisCode
     * @param \StructType\DatedMarketingSegmentRef[] $datedMarketingSegmentRef
     * @param string[] $ticketNumber
     * @param bool $notAssociated
     */
    public function __construct($type = null, array $referenceValue = array(), array $serviceRefID = array(), array $offerItemRefID = array(), array $orderItemRefID = array(), array $originDestRefID = array(), array $paxRefID = array(), array $paxSegmentRef = array(), array $paymentRefID = array(), $priceClassRefID = null, array $serviceDefinitionRef = array(), $fareBasisCode = null, array $datedMarketingSegmentRef = array(), array $ticketNumber = array(), $notAssociated = true)
    {
        $this
            ->setType($type)
            ->setReferenceValue($referenceValue)
            ->setServiceRefID($serviceRefID)
            ->setOfferItemRefID($offerItemRefID)
            ->setOrderItemRefID($orderItemRefID)
            ->setOriginDestRefID($originDestRefID)
            ->setPaxRefID($paxRefID)
            ->setPaxSegmentRef($paxSegmentRef)
            ->setPaymentRefID($paymentRefID)
            ->setPriceClassRefID($priceClassRefID)
            ->setServiceDefinitionRef($serviceDefinitionRef)
            ->setFareBasisCode($fareBasisCode)
            ->setDatedMarketingSegmentRef($datedMarketingSegmentRef)
            ->setTicketNumber($ticketNumber)
            ->setNotAssociated($notAssociated);
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\Association
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get ReferenceValue value
     * @return string[]|null
     */
    public function getReferenceValue()
    {
        return $this->ReferenceValue;
    }
    /**
     * This method is responsible for validating the values passed to the setReferenceValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReferenceValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReferenceValueForArrayConstraintsFromSetReferenceValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $associationReferenceValueItem) {
            // validation for constraint: itemType
            if (!is_string($associationReferenceValueItem)) {
                $invalidValues[] = is_object($associationReferenceValueItem) ? get_class($associationReferenceValueItem) : sprintf('%s(%s)', gettype($associationReferenceValueItem), var_export($associationReferenceValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReferenceValue property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReferenceValue value
     * @throws \InvalidArgumentException
     * @param string[] $referenceValue
     * @return \StructType\Association
     */
    public function setReferenceValue(array $referenceValue = array())
    {
        // validation for constraint: array
        if ('' !== ($referenceValueArrayErrorMessage = self::validateReferenceValueForArrayConstraintsFromSetReferenceValue($referenceValue))) {
            throw new \InvalidArgumentException($referenceValueArrayErrorMessage, __LINE__);
        }
        $this->ReferenceValue = $referenceValue;
        return $this;
    }
    /**
     * Add item to ReferenceValue value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Association
     */
    public function addToReferenceValue($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ReferenceValue property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ReferenceValue[] = $item;
        return $this;
    }
    /**
     * Get ServiceRefID value
     * @return string[]|null
     */
    public function getServiceRefID()
    {
        return $this->ServiceRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceRefIDForArrayConstraintsFromSetServiceRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $associationServiceRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($associationServiceRefIDItem)) {
                $invalidValues[] = is_object($associationServiceRefIDItem) ? get_class($associationServiceRefIDItem) : sprintf('%s(%s)', gettype($associationServiceRefIDItem), var_export($associationServiceRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ServiceRefID property can only contain items of type IDREF, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ServiceRefID value
     * @throws \InvalidArgumentException
     * @param string[] $serviceRefID
     * @return \StructType\Association
     */
    public function setServiceRefID(array $serviceRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceRefIDArrayErrorMessage = self::validateServiceRefIDForArrayConstraintsFromSetServiceRefID($serviceRefID))) {
            throw new \InvalidArgumentException($serviceRefIDArrayErrorMessage, __LINE__);
        }
        $this->ServiceRefID = $serviceRefID;
        return $this;
    }
    /**
     * Add item to ServiceRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Association
     */
    public function addToServiceRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ServiceRefID property can only contain items of type IDREF, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ServiceRefID[] = $item;
        return $this;
    }
    /**
     * Get OfferItemRefID value
     * @return string[]|null
     */
    public function getOfferItemRefID()
    {
        return isset($this->OfferItemRefID) ? $this->OfferItemRefID : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOfferItemRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOfferItemRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOfferItemRefIDForArrayConstraintsFromSetOfferItemRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $associationOfferItemRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($associationOfferItemRefIDItem)) {
                $invalidValues[] = is_object($associationOfferItemRefIDItem) ? get_class($associationOfferItemRefIDItem) : sprintf('%s(%s)', gettype($associationOfferItemRefIDItem), var_export($associationOfferItemRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OfferItemRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setOfferItemRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOfferItemRefID method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateOfferItemRefIDForChoiceConstraintsFromSetOfferItemRefID($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'OrderItemRefID',
            'OriginDestRefID',
            'PaxRefID',
            'PaxSegmentRef',
            'PaymentRefID',
            'PriceClassRefID',
            'ServiceDefinitionRef',
            'FareBasisCode',
            'DatedMarketingSegmentRef',
            'TicketNumber',
            'NotAssociated',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property OfferItemRefID can\'t be set as the property %s is already set. Only one property must be set among these properties: OfferItemRefID, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set OfferItemRefID value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param string[] $offerItemRefID
     * @return \StructType\Association
     */
    public function setOfferItemRefID(array $offerItemRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($offerItemRefIDArrayErrorMessage = self::validateOfferItemRefIDForArrayConstraintsFromSetOfferItemRefID($offerItemRefID))) {
            throw new \InvalidArgumentException($offerItemRefIDArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(OfferItemRefID, OrderItemRefID, OriginDestRefID, PaxRefID, PaxSegmentRef, PaymentRefID, PriceClassRefID, ServiceDefinitionRef, FareBasisCode, DatedMarketingSegmentRef, TicketNumber, NotAssociated)
        if ('' !== ($offerItemRefIDChoiceErrorMessage = self::validateOfferItemRefIDForChoiceConstraintsFromSetOfferItemRefID($offerItemRefID))) {
            throw new \InvalidArgumentException($offerItemRefIDChoiceErrorMessage, __LINE__);
        }
        if (is_null($offerItemRefID) || (is_array($offerItemRefID) && empty($offerItemRefID))) {
            unset($this->OfferItemRefID);
        } else {
            $this->OfferItemRefID = $offerItemRefID;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToOfferItemRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToOfferItemRefID method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToOfferItemRefID($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'OrderItemRefID',
            'OriginDestRefID',
            'PaxRefID',
            'PaxSegmentRef',
            'PaymentRefID',
            'PriceClassRefID',
            'ServiceDefinitionRef',
            'FareBasisCode',
            'DatedMarketingSegmentRef',
            'TicketNumber',
            'NotAssociated',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property OfferItemRefID can\'t be set as the property %s is already set. Only one property must be set among these properties: OfferItemRefID, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to OfferItemRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Association
     */
    public function addToOfferItemRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The OfferItemRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(OfferItemRefID, OrderItemRefID, OriginDestRefID, PaxRefID, PaxSegmentRef, PaymentRefID, PriceClassRefID, ServiceDefinitionRef, FareBasisCode, DatedMarketingSegmentRef, TicketNumber, NotAssociated)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToOfferItemRefID($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->OfferItemRefID[] = $item;
        return $this;
    }
    /**
     * Get OrderItemRefID value
     * @return string[]|null
     */
    public function getOrderItemRefID()
    {
        return isset($this->OrderItemRefID) ? $this->OrderItemRefID : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderItemRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderItemRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderItemRefIDForArrayConstraintsFromSetOrderItemRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $associationOrderItemRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($associationOrderItemRefIDItem)) {
                $invalidValues[] = is_object($associationOrderItemRefIDItem) ? get_class($associationOrderItemRefIDItem) : sprintf('%s(%s)', gettype($associationOrderItemRefIDItem), var_export($associationOrderItemRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OrderItemRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setOrderItemRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderItemRefID method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateOrderItemRefIDForChoiceConstraintsFromSetOrderItemRefID($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'OfferItemRefID',
            'OriginDestRefID',
            'PaxRefID',
            'PaxSegmentRef',
            'PaymentRefID',
            'PriceClassRefID',
            'ServiceDefinitionRef',
            'FareBasisCode',
            'DatedMarketingSegmentRef',
            'TicketNumber',
            'NotAssociated',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property OrderItemRefID can\'t be set as the property %s is already set. Only one property must be set among these properties: OrderItemRefID, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set OrderItemRefID value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param string[] $orderItemRefID
     * @return \StructType\Association
     */
    public function setOrderItemRefID(array $orderItemRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($orderItemRefIDArrayErrorMessage = self::validateOrderItemRefIDForArrayConstraintsFromSetOrderItemRefID($orderItemRefID))) {
            throw new \InvalidArgumentException($orderItemRefIDArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(OfferItemRefID, OrderItemRefID, OriginDestRefID, PaxRefID, PaxSegmentRef, PaymentRefID, PriceClassRefID, ServiceDefinitionRef, FareBasisCode, DatedMarketingSegmentRef, TicketNumber, NotAssociated)
        if ('' !== ($orderItemRefIDChoiceErrorMessage = self::validateOrderItemRefIDForChoiceConstraintsFromSetOrderItemRefID($orderItemRefID))) {
            throw new \InvalidArgumentException($orderItemRefIDChoiceErrorMessage, __LINE__);
        }
        if (is_null($orderItemRefID) || (is_array($orderItemRefID) && empty($orderItemRefID))) {
            unset($this->OrderItemRefID);
        } else {
            $this->OrderItemRefID = $orderItemRefID;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToOrderItemRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToOrderItemRefID method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToOrderItemRefID($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'OfferItemRefID',
            'OriginDestRefID',
            'PaxRefID',
            'PaxSegmentRef',
            'PaymentRefID',
            'PriceClassRefID',
            'ServiceDefinitionRef',
            'FareBasisCode',
            'DatedMarketingSegmentRef',
            'TicketNumber',
            'NotAssociated',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property OrderItemRefID can\'t be set as the property %s is already set. Only one property must be set among these properties: OrderItemRefID, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to OrderItemRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Association
     */
    public function addToOrderItemRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The OrderItemRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(OfferItemRefID, OrderItemRefID, OriginDestRefID, PaxRefID, PaxSegmentRef, PaymentRefID, PriceClassRefID, ServiceDefinitionRef, FareBasisCode, DatedMarketingSegmentRef, TicketNumber, NotAssociated)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToOrderItemRefID($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->OrderItemRefID[] = $item;
        return $this;
    }
    /**
     * Get OriginDestRefID value
     * @return string[]|null
     */
    public function getOriginDestRefID()
    {
        return isset($this->OriginDestRefID) ? $this->OriginDestRefID : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOriginDestRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOriginDestRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOriginDestRefIDForArrayConstraintsFromSetOriginDestRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $associationOriginDestRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($associationOriginDestRefIDItem)) {
                $invalidValues[] = is_object($associationOriginDestRefIDItem) ? get_class($associationOriginDestRefIDItem) : sprintf('%s(%s)', gettype($associationOriginDestRefIDItem), var_export($associationOriginDestRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OriginDestRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setOriginDestRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOriginDestRefID method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateOriginDestRefIDForChoiceConstraintsFromSetOriginDestRefID($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'OfferItemRefID',
            'OrderItemRefID',
            'PaxRefID',
            'PaxSegmentRef',
            'PaymentRefID',
            'PriceClassRefID',
            'ServiceDefinitionRef',
            'FareBasisCode',
            'DatedMarketingSegmentRef',
            'TicketNumber',
            'NotAssociated',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property OriginDestRefID can\'t be set as the property %s is already set. Only one property must be set among these properties: OriginDestRefID, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set OriginDestRefID value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param string[] $originDestRefID
     * @return \StructType\Association
     */
    public function setOriginDestRefID(array $originDestRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($originDestRefIDArrayErrorMessage = self::validateOriginDestRefIDForArrayConstraintsFromSetOriginDestRefID($originDestRefID))) {
            throw new \InvalidArgumentException($originDestRefIDArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(OfferItemRefID, OrderItemRefID, OriginDestRefID, PaxRefID, PaxSegmentRef, PaymentRefID, PriceClassRefID, ServiceDefinitionRef, FareBasisCode, DatedMarketingSegmentRef, TicketNumber, NotAssociated)
        if ('' !== ($originDestRefIDChoiceErrorMessage = self::validateOriginDestRefIDForChoiceConstraintsFromSetOriginDestRefID($originDestRefID))) {
            throw new \InvalidArgumentException($originDestRefIDChoiceErrorMessage, __LINE__);
        }
        if (is_null($originDestRefID) || (is_array($originDestRefID) && empty($originDestRefID))) {
            unset($this->OriginDestRefID);
        } else {
            $this->OriginDestRefID = $originDestRefID;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToOriginDestRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToOriginDestRefID method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToOriginDestRefID($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'OfferItemRefID',
            'OrderItemRefID',
            'PaxRefID',
            'PaxSegmentRef',
            'PaymentRefID',
            'PriceClassRefID',
            'ServiceDefinitionRef',
            'FareBasisCode',
            'DatedMarketingSegmentRef',
            'TicketNumber',
            'NotAssociated',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property OriginDestRefID can\'t be set as the property %s is already set. Only one property must be set among these properties: OriginDestRefID, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to OriginDestRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Association
     */
    public function addToOriginDestRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The OriginDestRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(OfferItemRefID, OrderItemRefID, OriginDestRefID, PaxRefID, PaxSegmentRef, PaymentRefID, PriceClassRefID, ServiceDefinitionRef, FareBasisCode, DatedMarketingSegmentRef, TicketNumber, NotAssociated)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToOriginDestRefID($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->OriginDestRefID[] = $item;
        return $this;
    }
    /**
     * Get PaxRefID value
     * @return string[]|null
     */
    public function getPaxRefID()
    {
        return isset($this->PaxRefID) ? $this->PaxRefID : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPaxRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaxRefIDForArrayConstraintsFromSetPaxRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $associationPaxRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($associationPaxRefIDItem)) {
                $invalidValues[] = is_object($associationPaxRefIDItem) ? get_class($associationPaxRefIDItem) : sprintf('%s(%s)', gettype($associationPaxRefIDItem), var_export($associationPaxRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaxRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setPaxRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxRefID method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePaxRefIDForChoiceConstraintsFromSetPaxRefID($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'OfferItemRefID',
            'OrderItemRefID',
            'OriginDestRefID',
            'PaxSegmentRef',
            'PaymentRefID',
            'PriceClassRefID',
            'ServiceDefinitionRef',
            'FareBasisCode',
            'DatedMarketingSegmentRef',
            'TicketNumber',
            'NotAssociated',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PaxRefID can\'t be set as the property %s is already set. Only one property must be set among these properties: PaxRefID, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PaxRefID value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param string[] $paxRefID
     * @return \StructType\Association
     */
    public function setPaxRefID(array $paxRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($paxRefIDArrayErrorMessage = self::validatePaxRefIDForArrayConstraintsFromSetPaxRefID($paxRefID))) {
            throw new \InvalidArgumentException($paxRefIDArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(OfferItemRefID, OrderItemRefID, OriginDestRefID, PaxRefID, PaxSegmentRef, PaymentRefID, PriceClassRefID, ServiceDefinitionRef, FareBasisCode, DatedMarketingSegmentRef, TicketNumber, NotAssociated)
        if ('' !== ($paxRefIDChoiceErrorMessage = self::validatePaxRefIDForChoiceConstraintsFromSetPaxRefID($paxRefID))) {
            throw new \InvalidArgumentException($paxRefIDChoiceErrorMessage, __LINE__);
        }
        if (is_null($paxRefID) || (is_array($paxRefID) && empty($paxRefID))) {
            unset($this->PaxRefID);
        } else {
            $this->PaxRefID = $paxRefID;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToPaxRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToPaxRefID method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToPaxRefID($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'OfferItemRefID',
            'OrderItemRefID',
            'OriginDestRefID',
            'PaxSegmentRef',
            'PaymentRefID',
            'PriceClassRefID',
            'ServiceDefinitionRef',
            'FareBasisCode',
            'DatedMarketingSegmentRef',
            'TicketNumber',
            'NotAssociated',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PaxRefID can\'t be set as the property %s is already set. Only one property must be set among these properties: PaxRefID, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to PaxRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Association
     */
    public function addToPaxRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PaxRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(OfferItemRefID, OrderItemRefID, OriginDestRefID, PaxRefID, PaxSegmentRef, PaymentRefID, PriceClassRefID, ServiceDefinitionRef, FareBasisCode, DatedMarketingSegmentRef, TicketNumber, NotAssociated)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToPaxRefID($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->PaxRefID[] = $item;
        return $this;
    }
    /**
     * Get PaxSegmentRef value
     * @return \StructType\PaxSegmentRefType[]|null
     */
    public function getPaxSegmentRef()
    {
        return isset($this->PaxSegmentRef) ? $this->PaxSegmentRef : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPaxSegmentRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxSegmentRef method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaxSegmentRefForArrayConstraintsFromSetPaxSegmentRef(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $associationPaxSegmentRefItem) {
            // validation for constraint: itemType
            if (!$associationPaxSegmentRefItem instanceof \StructType\PaxSegmentRefType) {
                $invalidValues[] = is_object($associationPaxSegmentRefItem) ? get_class($associationPaxSegmentRefItem) : sprintf('%s(%s)', gettype($associationPaxSegmentRefItem), var_export($associationPaxSegmentRefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaxSegmentRef property can only contain items of type \StructType\PaxSegmentRefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setPaxSegmentRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxSegmentRef method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePaxSegmentRefForChoiceConstraintsFromSetPaxSegmentRef($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'OfferItemRefID',
            'OrderItemRefID',
            'OriginDestRefID',
            'PaxRefID',
            'PaymentRefID',
            'PriceClassRefID',
            'ServiceDefinitionRef',
            'FareBasisCode',
            'DatedMarketingSegmentRef',
            'TicketNumber',
            'NotAssociated',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PaxSegmentRef can\'t be set as the property %s is already set. Only one property must be set among these properties: PaxSegmentRef, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PaxSegmentRef value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\PaxSegmentRefType[] $paxSegmentRef
     * @return \StructType\Association
     */
    public function setPaxSegmentRef(array $paxSegmentRef = array())
    {
        // validation for constraint: array
        if ('' !== ($paxSegmentRefArrayErrorMessage = self::validatePaxSegmentRefForArrayConstraintsFromSetPaxSegmentRef($paxSegmentRef))) {
            throw new \InvalidArgumentException($paxSegmentRefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(OfferItemRefID, OrderItemRefID, OriginDestRefID, PaxRefID, PaxSegmentRef, PaymentRefID, PriceClassRefID, ServiceDefinitionRef, FareBasisCode, DatedMarketingSegmentRef, TicketNumber, NotAssociated)
        if ('' !== ($paxSegmentRefChoiceErrorMessage = self::validatePaxSegmentRefForChoiceConstraintsFromSetPaxSegmentRef($paxSegmentRef))) {
            throw new \InvalidArgumentException($paxSegmentRefChoiceErrorMessage, __LINE__);
        }
        if (is_null($paxSegmentRef) || (is_array($paxSegmentRef) && empty($paxSegmentRef))) {
            unset($this->PaxSegmentRef);
        } else {
            $this->PaxSegmentRef = $paxSegmentRef;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToPaxSegmentRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToPaxSegmentRef method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToPaxSegmentRef($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'OfferItemRefID',
            'OrderItemRefID',
            'OriginDestRefID',
            'PaxRefID',
            'PaymentRefID',
            'PriceClassRefID',
            'ServiceDefinitionRef',
            'FareBasisCode',
            'DatedMarketingSegmentRef',
            'TicketNumber',
            'NotAssociated',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PaxSegmentRef can\'t be set as the property %s is already set. Only one property must be set among these properties: PaxSegmentRef, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to PaxSegmentRef value
     * @throws \InvalidArgumentException
     * @param \StructType\PaxSegmentRefType $item
     * @return \StructType\Association
     */
    public function addToPaxSegmentRef(\StructType\PaxSegmentRefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaxSegmentRefType) {
            throw new \InvalidArgumentException(sprintf('The PaxSegmentRef property can only contain items of type \StructType\PaxSegmentRefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(OfferItemRefID, OrderItemRefID, OriginDestRefID, PaxRefID, PaxSegmentRef, PaymentRefID, PriceClassRefID, ServiceDefinitionRef, FareBasisCode, DatedMarketingSegmentRef, TicketNumber, NotAssociated)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToPaxSegmentRef($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->PaxSegmentRef[] = $item;
        return $this;
    }
    /**
     * Get PaymentRefID value
     * @return string[]|null
     */
    public function getPaymentRefID()
    {
        return isset($this->PaymentRefID) ? $this->PaymentRefID : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentRefIDForArrayConstraintsFromSetPaymentRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $associationPaymentRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($associationPaymentRefIDItem)) {
                $invalidValues[] = is_object($associationPaymentRefIDItem) ? get_class($associationPaymentRefIDItem) : sprintf('%s(%s)', gettype($associationPaymentRefIDItem), var_export($associationPaymentRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setPaymentRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentRefID method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePaymentRefIDForChoiceConstraintsFromSetPaymentRefID($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'OfferItemRefID',
            'OrderItemRefID',
            'OriginDestRefID',
            'PaxRefID',
            'PaxSegmentRef',
            'PriceClassRefID',
            'ServiceDefinitionRef',
            'FareBasisCode',
            'DatedMarketingSegmentRef',
            'TicketNumber',
            'NotAssociated',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PaymentRefID can\'t be set as the property %s is already set. Only one property must be set among these properties: PaymentRefID, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PaymentRefID value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param string[] $paymentRefID
     * @return \StructType\Association
     */
    public function setPaymentRefID(array $paymentRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentRefIDArrayErrorMessage = self::validatePaymentRefIDForArrayConstraintsFromSetPaymentRefID($paymentRefID))) {
            throw new \InvalidArgumentException($paymentRefIDArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(OfferItemRefID, OrderItemRefID, OriginDestRefID, PaxRefID, PaxSegmentRef, PaymentRefID, PriceClassRefID, ServiceDefinitionRef, FareBasisCode, DatedMarketingSegmentRef, TicketNumber, NotAssociated)
        if ('' !== ($paymentRefIDChoiceErrorMessage = self::validatePaymentRefIDForChoiceConstraintsFromSetPaymentRefID($paymentRefID))) {
            throw new \InvalidArgumentException($paymentRefIDChoiceErrorMessage, __LINE__);
        }
        if (is_null($paymentRefID) || (is_array($paymentRefID) && empty($paymentRefID))) {
            unset($this->PaymentRefID);
        } else {
            $this->PaymentRefID = $paymentRefID;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToPaymentRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToPaymentRefID method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToPaymentRefID($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'OfferItemRefID',
            'OrderItemRefID',
            'OriginDestRefID',
            'PaxRefID',
            'PaxSegmentRef',
            'PriceClassRefID',
            'ServiceDefinitionRef',
            'FareBasisCode',
            'DatedMarketingSegmentRef',
            'TicketNumber',
            'NotAssociated',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PaymentRefID can\'t be set as the property %s is already set. Only one property must be set among these properties: PaymentRefID, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to PaymentRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Association
     */
    public function addToPaymentRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PaymentRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(OfferItemRefID, OrderItemRefID, OriginDestRefID, PaxRefID, PaxSegmentRef, PaymentRefID, PriceClassRefID, ServiceDefinitionRef, FareBasisCode, DatedMarketingSegmentRef, TicketNumber, NotAssociated)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToPaymentRefID($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->PaymentRefID[] = $item;
        return $this;
    }
    /**
     * Get PriceClassRefID value
     * @return string|null
     */
    public function getPriceClassRefID()
    {
        return isset($this->PriceClassRefID) ? $this->PriceClassRefID : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPriceClassRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPriceClassRefID method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePriceClassRefIDForChoiceConstraintsFromSetPriceClassRefID($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'OfferItemRefID',
            'OrderItemRefID',
            'OriginDestRefID',
            'PaxRefID',
            'PaxSegmentRef',
            'PaymentRefID',
            'ServiceDefinitionRef',
            'FareBasisCode',
            'DatedMarketingSegmentRef',
            'TicketNumber',
            'NotAssociated',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PriceClassRefID can\'t be set as the property %s is already set. Only one property must be set among these properties: PriceClassRefID, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PriceClassRefID value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $priceClassRefID
     * @return \StructType\Association
     */
    public function setPriceClassRefID($priceClassRefID = null)
    {
        // validation for constraint: string
        if (!is_null($priceClassRefID) && !is_string($priceClassRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceClassRefID, true), gettype($priceClassRefID)), __LINE__);
        }
        // validation for constraint: choice(OfferItemRefID, OrderItemRefID, OriginDestRefID, PaxRefID, PaxSegmentRef, PaymentRefID, PriceClassRefID, ServiceDefinitionRef, FareBasisCode, DatedMarketingSegmentRef, TicketNumber, NotAssociated)
        if ('' !== ($priceClassRefIDChoiceErrorMessage = self::validatePriceClassRefIDForChoiceConstraintsFromSetPriceClassRefID($priceClassRefID))) {
            throw new \InvalidArgumentException($priceClassRefIDChoiceErrorMessage, __LINE__);
        }
        if (is_null($priceClassRefID) || (is_array($priceClassRefID) && empty($priceClassRefID))) {
            unset($this->PriceClassRefID);
        } else {
            $this->PriceClassRefID = $priceClassRefID;
        }
        return $this;
    }
    /**
     * Get ServiceDefinitionRef value
     * @return \StructType\OrderServiceDefinitionRefType[]|null
     */
    public function getServiceDefinitionRef()
    {
        return isset($this->ServiceDefinitionRef) ? $this->ServiceDefinitionRef : null;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceDefinitionRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceDefinitionRef method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceDefinitionRefForArrayConstraintsFromSetServiceDefinitionRef(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $associationServiceDefinitionRefItem) {
            // validation for constraint: itemType
            if (!$associationServiceDefinitionRefItem instanceof \StructType\OrderServiceDefinitionRefType) {
                $invalidValues[] = is_object($associationServiceDefinitionRefItem) ? get_class($associationServiceDefinitionRefItem) : sprintf('%s(%s)', gettype($associationServiceDefinitionRefItem), var_export($associationServiceDefinitionRefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ServiceDefinitionRef property can only contain items of type \StructType\OrderServiceDefinitionRefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setServiceDefinitionRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceDefinitionRef method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateServiceDefinitionRefForChoiceConstraintsFromSetServiceDefinitionRef($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'OfferItemRefID',
            'OrderItemRefID',
            'OriginDestRefID',
            'PaxRefID',
            'PaxSegmentRef',
            'PaymentRefID',
            'PriceClassRefID',
            'FareBasisCode',
            'DatedMarketingSegmentRef',
            'TicketNumber',
            'NotAssociated',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ServiceDefinitionRef can\'t be set as the property %s is already set. Only one property must be set among these properties: ServiceDefinitionRef, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ServiceDefinitionRef value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\OrderServiceDefinitionRefType[] $serviceDefinitionRef
     * @return \StructType\Association
     */
    public function setServiceDefinitionRef(array $serviceDefinitionRef = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceDefinitionRefArrayErrorMessage = self::validateServiceDefinitionRefForArrayConstraintsFromSetServiceDefinitionRef($serviceDefinitionRef))) {
            throw new \InvalidArgumentException($serviceDefinitionRefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(OfferItemRefID, OrderItemRefID, OriginDestRefID, PaxRefID, PaxSegmentRef, PaymentRefID, PriceClassRefID, ServiceDefinitionRef, FareBasisCode, DatedMarketingSegmentRef, TicketNumber, NotAssociated)
        if ('' !== ($serviceDefinitionRefChoiceErrorMessage = self::validateServiceDefinitionRefForChoiceConstraintsFromSetServiceDefinitionRef($serviceDefinitionRef))) {
            throw new \InvalidArgumentException($serviceDefinitionRefChoiceErrorMessage, __LINE__);
        }
        if (is_null($serviceDefinitionRef) || (is_array($serviceDefinitionRef) && empty($serviceDefinitionRef))) {
            unset($this->ServiceDefinitionRef);
        } else {
            $this->ServiceDefinitionRef = $serviceDefinitionRef;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToServiceDefinitionRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToServiceDefinitionRef method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToServiceDefinitionRef($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'OfferItemRefID',
            'OrderItemRefID',
            'OriginDestRefID',
            'PaxRefID',
            'PaxSegmentRef',
            'PaymentRefID',
            'PriceClassRefID',
            'FareBasisCode',
            'DatedMarketingSegmentRef',
            'TicketNumber',
            'NotAssociated',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ServiceDefinitionRef can\'t be set as the property %s is already set. Only one property must be set among these properties: ServiceDefinitionRef, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to ServiceDefinitionRef value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderServiceDefinitionRefType $item
     * @return \StructType\Association
     */
    public function addToServiceDefinitionRef(\StructType\OrderServiceDefinitionRefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderServiceDefinitionRefType) {
            throw new \InvalidArgumentException(sprintf('The ServiceDefinitionRef property can only contain items of type \StructType\OrderServiceDefinitionRefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(OfferItemRefID, OrderItemRefID, OriginDestRefID, PaxRefID, PaxSegmentRef, PaymentRefID, PriceClassRefID, ServiceDefinitionRef, FareBasisCode, DatedMarketingSegmentRef, TicketNumber, NotAssociated)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToServiceDefinitionRef($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->ServiceDefinitionRef[] = $item;
        return $this;
    }
    /**
     * Get FareBasisCode value
     * @return string|null
     */
    public function getFareBasisCode()
    {
        return isset($this->FareBasisCode) ? $this->FareBasisCode : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFareBasisCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareBasisCode method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFareBasisCodeForChoiceConstraintsFromSetFareBasisCode($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'OfferItemRefID',
            'OrderItemRefID',
            'OriginDestRefID',
            'PaxRefID',
            'PaxSegmentRef',
            'PaymentRefID',
            'PriceClassRefID',
            'ServiceDefinitionRef',
            'DatedMarketingSegmentRef',
            'TicketNumber',
            'NotAssociated',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property FareBasisCode can\'t be set as the property %s is already set. Only one property must be set among these properties: FareBasisCode, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set FareBasisCode value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $fareBasisCode
     * @return \StructType\Association
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisCode) && !is_string($fareBasisCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareBasisCode, true), gettype($fareBasisCode)), __LINE__);
        }
        // validation for constraint: choice(OfferItemRefID, OrderItemRefID, OriginDestRefID, PaxRefID, PaxSegmentRef, PaymentRefID, PriceClassRefID, ServiceDefinitionRef, FareBasisCode, DatedMarketingSegmentRef, TicketNumber, NotAssociated)
        if ('' !== ($fareBasisCodeChoiceErrorMessage = self::validateFareBasisCodeForChoiceConstraintsFromSetFareBasisCode($fareBasisCode))) {
            throw new \InvalidArgumentException($fareBasisCodeChoiceErrorMessage, __LINE__);
        }
        if (is_null($fareBasisCode) || (is_array($fareBasisCode) && empty($fareBasisCode))) {
            unset($this->FareBasisCode);
        } else {
            $this->FareBasisCode = $fareBasisCode;
        }
        return $this;
    }
    /**
     * Get DatedMarketingSegmentRef value
     * @return \StructType\DatedMarketingSegmentRef[]|null
     */
    public function getDatedMarketingSegmentRef()
    {
        return isset($this->DatedMarketingSegmentRef) ? $this->DatedMarketingSegmentRef : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDatedMarketingSegmentRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDatedMarketingSegmentRef method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDatedMarketingSegmentRefForArrayConstraintsFromSetDatedMarketingSegmentRef(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $associationDatedMarketingSegmentRefItem) {
            // validation for constraint: itemType
            if (!$associationDatedMarketingSegmentRefItem instanceof \StructType\DatedMarketingSegmentRef) {
                $invalidValues[] = is_object($associationDatedMarketingSegmentRefItem) ? get_class($associationDatedMarketingSegmentRefItem) : sprintf('%s(%s)', gettype($associationDatedMarketingSegmentRefItem), var_export($associationDatedMarketingSegmentRefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DatedMarketingSegmentRef property can only contain items of type \StructType\DatedMarketingSegmentRef, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setDatedMarketingSegmentRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDatedMarketingSegmentRef method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDatedMarketingSegmentRefForChoiceConstraintsFromSetDatedMarketingSegmentRef($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'OfferItemRefID',
            'OrderItemRefID',
            'OriginDestRefID',
            'PaxRefID',
            'PaxSegmentRef',
            'PaymentRefID',
            'PriceClassRefID',
            'ServiceDefinitionRef',
            'FareBasisCode',
            'TicketNumber',
            'NotAssociated',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DatedMarketingSegmentRef can\'t be set as the property %s is already set. Only one property must be set among these properties: DatedMarketingSegmentRef, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DatedMarketingSegmentRef value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\DatedMarketingSegmentRef[] $datedMarketingSegmentRef
     * @return \StructType\Association
     */
    public function setDatedMarketingSegmentRef(array $datedMarketingSegmentRef = array())
    {
        // validation for constraint: array
        if ('' !== ($datedMarketingSegmentRefArrayErrorMessage = self::validateDatedMarketingSegmentRefForArrayConstraintsFromSetDatedMarketingSegmentRef($datedMarketingSegmentRef))) {
            throw new \InvalidArgumentException($datedMarketingSegmentRefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(OfferItemRefID, OrderItemRefID, OriginDestRefID, PaxRefID, PaxSegmentRef, PaymentRefID, PriceClassRefID, ServiceDefinitionRef, FareBasisCode, DatedMarketingSegmentRef, TicketNumber, NotAssociated)
        if ('' !== ($datedMarketingSegmentRefChoiceErrorMessage = self::validateDatedMarketingSegmentRefForChoiceConstraintsFromSetDatedMarketingSegmentRef($datedMarketingSegmentRef))) {
            throw new \InvalidArgumentException($datedMarketingSegmentRefChoiceErrorMessage, __LINE__);
        }
        if (is_null($datedMarketingSegmentRef) || (is_array($datedMarketingSegmentRef) && empty($datedMarketingSegmentRef))) {
            unset($this->DatedMarketingSegmentRef);
        } else {
            $this->DatedMarketingSegmentRef = $datedMarketingSegmentRef;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToDatedMarketingSegmentRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToDatedMarketingSegmentRef method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToDatedMarketingSegmentRef($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'OfferItemRefID',
            'OrderItemRefID',
            'OriginDestRefID',
            'PaxRefID',
            'PaxSegmentRef',
            'PaymentRefID',
            'PriceClassRefID',
            'ServiceDefinitionRef',
            'FareBasisCode',
            'TicketNumber',
            'NotAssociated',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DatedMarketingSegmentRef can\'t be set as the property %s is already set. Only one property must be set among these properties: DatedMarketingSegmentRef, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to DatedMarketingSegmentRef value
     * @throws \InvalidArgumentException
     * @param \StructType\DatedMarketingSegmentRef $item
     * @return \StructType\Association
     */
    public function addToDatedMarketingSegmentRef(\StructType\DatedMarketingSegmentRef $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DatedMarketingSegmentRef) {
            throw new \InvalidArgumentException(sprintf('The DatedMarketingSegmentRef property can only contain items of type \StructType\DatedMarketingSegmentRef, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(OfferItemRefID, OrderItemRefID, OriginDestRefID, PaxRefID, PaxSegmentRef, PaymentRefID, PriceClassRefID, ServiceDefinitionRef, FareBasisCode, DatedMarketingSegmentRef, TicketNumber, NotAssociated)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToDatedMarketingSegmentRef($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->DatedMarketingSegmentRef[] = $item;
        return $this;
    }
    /**
     * Get TicketNumber value
     * @return string[]|null
     */
    public function getTicketNumber()
    {
        return isset($this->TicketNumber) ? $this->TicketNumber : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTicketNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTicketNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTicketNumberForArrayConstraintsFromSetTicketNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $associationTicketNumberItem) {
            // validation for constraint: itemType
            if (!is_string($associationTicketNumberItem)) {
                $invalidValues[] = is_object($associationTicketNumberItem) ? get_class($associationTicketNumberItem) : sprintf('%s(%s)', gettype($associationTicketNumberItem), var_export($associationTicketNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TicketNumber property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setTicketNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTicketNumber method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTicketNumberForChoiceConstraintsFromSetTicketNumber($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'OfferItemRefID',
            'OrderItemRefID',
            'OriginDestRefID',
            'PaxRefID',
            'PaxSegmentRef',
            'PaymentRefID',
            'PriceClassRefID',
            'ServiceDefinitionRef',
            'FareBasisCode',
            'DatedMarketingSegmentRef',
            'NotAssociated',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property TicketNumber can\'t be set as the property %s is already set. Only one property must be set among these properties: TicketNumber, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set TicketNumber value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param string[] $ticketNumber
     * @return \StructType\Association
     */
    public function setTicketNumber(array $ticketNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($ticketNumberArrayErrorMessage = self::validateTicketNumberForArrayConstraintsFromSetTicketNumber($ticketNumber))) {
            throw new \InvalidArgumentException($ticketNumberArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(OfferItemRefID, OrderItemRefID, OriginDestRefID, PaxRefID, PaxSegmentRef, PaymentRefID, PriceClassRefID, ServiceDefinitionRef, FareBasisCode, DatedMarketingSegmentRef, TicketNumber, NotAssociated)
        if ('' !== ($ticketNumberChoiceErrorMessage = self::validateTicketNumberForChoiceConstraintsFromSetTicketNumber($ticketNumber))) {
            throw new \InvalidArgumentException($ticketNumberChoiceErrorMessage, __LINE__);
        }
        if (is_null($ticketNumber) || (is_array($ticketNumber) && empty($ticketNumber))) {
            unset($this->TicketNumber);
        } else {
            $this->TicketNumber = $ticketNumber;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToTicketNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToTicketNumber method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToTicketNumber($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'OfferItemRefID',
            'OrderItemRefID',
            'OriginDestRefID',
            'PaxRefID',
            'PaxSegmentRef',
            'PaymentRefID',
            'PriceClassRefID',
            'ServiceDefinitionRef',
            'FareBasisCode',
            'DatedMarketingSegmentRef',
            'NotAssociated',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property TicketNumber can\'t be set as the property %s is already set. Only one property must be set among these properties: TicketNumber, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to TicketNumber value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Association
     */
    public function addToTicketNumber($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The TicketNumber property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(OfferItemRefID, OrderItemRefID, OriginDestRefID, PaxRefID, PaxSegmentRef, PaymentRefID, PriceClassRefID, ServiceDefinitionRef, FareBasisCode, DatedMarketingSegmentRef, TicketNumber, NotAssociated)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToTicketNumber($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->TicketNumber[] = $item;
        return $this;
    }
    /**
     * Get NotAssociated value
     * @return bool|null
     */
    public function getNotAssociated()
    {
        return isset($this->NotAssociated) ? $this->NotAssociated : null;
    }
    /**
     * This method is responsible for validating the value passed to the setNotAssociated method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNotAssociated method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateNotAssociatedForChoiceConstraintsFromSetNotAssociated($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'OfferItemRefID',
            'OrderItemRefID',
            'OriginDestRefID',
            'PaxRefID',
            'PaxSegmentRef',
            'PaymentRefID',
            'PriceClassRefID',
            'ServiceDefinitionRef',
            'FareBasisCode',
            'DatedMarketingSegmentRef',
            'TicketNumber',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property NotAssociated can\'t be set as the property %s is already set. Only one property must be set among these properties: NotAssociated, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set NotAssociated value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $notAssociated
     * @return \StructType\Association
     */
    public function setNotAssociated($notAssociated = true)
    {
        // validation for constraint: boolean
        if (!is_null($notAssociated) && !is_bool($notAssociated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($notAssociated, true), gettype($notAssociated)), __LINE__);
        }
        // validation for constraint: choice(OfferItemRefID, OrderItemRefID, OriginDestRefID, PaxRefID, PaxSegmentRef, PaymentRefID, PriceClassRefID, ServiceDefinitionRef, FareBasisCode, DatedMarketingSegmentRef, TicketNumber, NotAssociated)
        if ('' !== ($notAssociatedChoiceErrorMessage = self::validateNotAssociatedForChoiceConstraintsFromSetNotAssociated($notAssociated))) {
            throw new \InvalidArgumentException($notAssociatedChoiceErrorMessage, __LINE__);
        }
        if (is_null($notAssociated) || (is_array($notAssociated) && empty($notAssociated))) {
            unset($this->NotAssociated);
        } else {
            $this->NotAssociated = $notAssociated;
        }
        return $this;
    }
}
