<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirlineProfileType StructType
 * Meta information extracted from the WSDL
 * - documentation: Distribution profile of an airline which describes which types of shopping requests may be processed by a particular carrier.
 * @subpackage Structs
 */
class AirlineProfileType extends AbstractStructBase
{
    /**
     * The ProfileOwner
     * Meta information extracted from the WSDL
     * - documentation: The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc. Business Identifier Fields: - Airline
     * Designator Code - Duplicate Designator Indicator - Name
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\CarrierType
     */
    public $ProfileOwner;
    /**
     * The AirlineProfileDataItem
     * Meta information extracted from the WSDL
     * - documentation: Single set of data elements contained within the airline profile.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AirlineProfileDataItemType[]
     */
    public $AirlineProfileDataItem;
    /**
     * The AirlineProfileURL
     * Meta information extracted from the WSDL
     * - documentation: Link to Airline Profile Source File. Alows a large Airline Profile file to be distributed over FTP, FTPS, as agreed bilaterally with Profile Owner. Note, this element should not be used if explicitly providing the Airline Profile
     * Data Items. | A string of characters used to identify a resource. Such identification enables interaction with representations of the resource over a network, typically the World Wide Web, using specific protocols.
     * - base: xs:anyURI
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AirlineProfileURL;
    /**
     * The AssociatedMediaURL
     * Meta information extracted from the WSDL
     * - documentation: URL used to retrieve media associated with the airline profile, including the airline logo. | A string of characters used to identify a resource. Such identification enables interaction with representations of the resource over a
     * network, typically the World Wide Web, using specific protocols.
     * - base: xs:anyURI
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AssociatedMediaURL;
    /**
     * The AssociationMembershipText
     * Meta information extracted from the WSDL
     * - documentation: Free text description of group or alliance for which the profile is related. E.g. 'Member of Star Alliance'. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AssociationMembershipText;
    /**
     * The ContactInfo
     * Meta information extracted from the WSDL
     * - documentation: The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContactInfoType[]
     */
    public $ContactInfo;
    /**
     * The SupportedMessageInfo
     * Meta information extracted from the WSDL
     * - documentation: Contextual information to further describe something using a key-value pair.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\KeyValuePropertyType[]
     */
    public $SupportedMessageInfo;
    /**
     * Constructor method for AirlineProfileType
     * @uses AirlineProfileType::setProfileOwner()
     * @uses AirlineProfileType::setAirlineProfileDataItem()
     * @uses AirlineProfileType::setAirlineProfileURL()
     * @uses AirlineProfileType::setAssociatedMediaURL()
     * @uses AirlineProfileType::setAssociationMembershipText()
     * @uses AirlineProfileType::setContactInfo()
     * @uses AirlineProfileType::setSupportedMessageInfo()
     * @param \StructType\CarrierType $profileOwner
     * @param \StructType\AirlineProfileDataItemType[] $airlineProfileDataItem
     * @param string $airlineProfileURL
     * @param string $associatedMediaURL
     * @param string $associationMembershipText
     * @param \StructType\ContactInfoType[] $contactInfo
     * @param \StructType\KeyValuePropertyType[] $supportedMessageInfo
     */
    public function __construct(\StructType\CarrierType $profileOwner = null, array $airlineProfileDataItem = array(), $airlineProfileURL = null, $associatedMediaURL = null, $associationMembershipText = null, array $contactInfo = array(), array $supportedMessageInfo = array())
    {
        $this
            ->setProfileOwner($profileOwner)
            ->setAirlineProfileDataItem($airlineProfileDataItem)
            ->setAirlineProfileURL($airlineProfileURL)
            ->setAssociatedMediaURL($associatedMediaURL)
            ->setAssociationMembershipText($associationMembershipText)
            ->setContactInfo($contactInfo)
            ->setSupportedMessageInfo($supportedMessageInfo);
    }
    /**
     * Get ProfileOwner value
     * @return \StructType\CarrierType
     */
    public function getProfileOwner()
    {
        return $this->ProfileOwner;
    }
    /**
     * Set ProfileOwner value
     * @param \StructType\CarrierType $profileOwner
     * @return \StructType\AirlineProfileType
     */
    public function setProfileOwner(\StructType\CarrierType $profileOwner = null)
    {
        $this->ProfileOwner = $profileOwner;
        return $this;
    }
    /**
     * Get AirlineProfileDataItem value
     * @return \StructType\AirlineProfileDataItemType[]|null
     */
    public function getAirlineProfileDataItem()
    {
        return $this->AirlineProfileDataItem;
    }
    /**
     * This method is responsible for validating the values passed to the setAirlineProfileDataItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirlineProfileDataItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirlineProfileDataItemForArrayConstraintsFromSetAirlineProfileDataItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlineProfileTypeAirlineProfileDataItemItem) {
            // validation for constraint: itemType
            if (!$airlineProfileTypeAirlineProfileDataItemItem instanceof \StructType\AirlineProfileDataItemType) {
                $invalidValues[] = is_object($airlineProfileTypeAirlineProfileDataItemItem) ? get_class($airlineProfileTypeAirlineProfileDataItemItem) : sprintf('%s(%s)', gettype($airlineProfileTypeAirlineProfileDataItemItem), var_export($airlineProfileTypeAirlineProfileDataItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AirlineProfileDataItem property can only contain items of type \StructType\AirlineProfileDataItemType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AirlineProfileDataItem value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineProfileDataItemType[] $airlineProfileDataItem
     * @return \StructType\AirlineProfileType
     */
    public function setAirlineProfileDataItem(array $airlineProfileDataItem = array())
    {
        // validation for constraint: array
        if ('' !== ($airlineProfileDataItemArrayErrorMessage = self::validateAirlineProfileDataItemForArrayConstraintsFromSetAirlineProfileDataItem($airlineProfileDataItem))) {
            throw new \InvalidArgumentException($airlineProfileDataItemArrayErrorMessage, __LINE__);
        }
        $this->AirlineProfileDataItem = $airlineProfileDataItem;
        return $this;
    }
    /**
     * Add item to AirlineProfileDataItem value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineProfileDataItemType $item
     * @return \StructType\AirlineProfileType
     */
    public function addToAirlineProfileDataItem(\StructType\AirlineProfileDataItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AirlineProfileDataItemType) {
            throw new \InvalidArgumentException(sprintf('The AirlineProfileDataItem property can only contain items of type \StructType\AirlineProfileDataItemType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AirlineProfileDataItem[] = $item;
        return $this;
    }
    /**
     * Get AirlineProfileURL value
     * @return string|null
     */
    public function getAirlineProfileURL()
    {
        return $this->AirlineProfileURL;
    }
    /**
     * Set AirlineProfileURL value
     * @param string $airlineProfileURL
     * @return \StructType\AirlineProfileType
     */
    public function setAirlineProfileURL($airlineProfileURL = null)
    {
        // validation for constraint: string
        if (!is_null($airlineProfileURL) && !is_string($airlineProfileURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airlineProfileURL, true), gettype($airlineProfileURL)), __LINE__);
        }
        $this->AirlineProfileURL = $airlineProfileURL;
        return $this;
    }
    /**
     * Get AssociatedMediaURL value
     * @return string|null
     */
    public function getAssociatedMediaURL()
    {
        return $this->AssociatedMediaURL;
    }
    /**
     * Set AssociatedMediaURL value
     * @param string $associatedMediaURL
     * @return \StructType\AirlineProfileType
     */
    public function setAssociatedMediaURL($associatedMediaURL = null)
    {
        // validation for constraint: string
        if (!is_null($associatedMediaURL) && !is_string($associatedMediaURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($associatedMediaURL, true), gettype($associatedMediaURL)), __LINE__);
        }
        $this->AssociatedMediaURL = $associatedMediaURL;
        return $this;
    }
    /**
     * Get AssociationMembershipText value
     * @return string|null
     */
    public function getAssociationMembershipText()
    {
        return $this->AssociationMembershipText;
    }
    /**
     * Set AssociationMembershipText value
     * @param string $associationMembershipText
     * @return \StructType\AirlineProfileType
     */
    public function setAssociationMembershipText($associationMembershipText = null)
    {
        // validation for constraint: string
        if (!is_null($associationMembershipText) && !is_string($associationMembershipText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($associationMembershipText, true), gettype($associationMembershipText)), __LINE__);
        }
        $this->AssociationMembershipText = $associationMembershipText;
        return $this;
    }
    /**
     * Get ContactInfo value
     * @return \StructType\ContactInfoType[]|null
     */
    public function getContactInfo()
    {
        return $this->ContactInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setContactInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactInfoForArrayConstraintsFromSetContactInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlineProfileTypeContactInfoItem) {
            // validation for constraint: itemType
            if (!$airlineProfileTypeContactInfoItem instanceof \StructType\ContactInfoType) {
                $invalidValues[] = is_object($airlineProfileTypeContactInfoItem) ? get_class($airlineProfileTypeContactInfoItem) : sprintf('%s(%s)', gettype($airlineProfileTypeContactInfoItem), var_export($airlineProfileTypeContactInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContactInfo property can only contain items of type \StructType\ContactInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContactInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactInfoType[] $contactInfo
     * @return \StructType\AirlineProfileType
     */
    public function setContactInfo(array $contactInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($contactInfoArrayErrorMessage = self::validateContactInfoForArrayConstraintsFromSetContactInfo($contactInfo))) {
            throw new \InvalidArgumentException($contactInfoArrayErrorMessage, __LINE__);
        }
        $this->ContactInfo = $contactInfo;
        return $this;
    }
    /**
     * Add item to ContactInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactInfoType $item
     * @return \StructType\AirlineProfileType
     */
    public function addToContactInfo(\StructType\ContactInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactInfoType) {
            throw new \InvalidArgumentException(sprintf('The ContactInfo property can only contain items of type \StructType\ContactInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContactInfo[] = $item;
        return $this;
    }
    /**
     * Get SupportedMessageInfo value
     * @return \StructType\KeyValuePropertyType[]|null
     */
    public function getSupportedMessageInfo()
    {
        return $this->SupportedMessageInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setSupportedMessageInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupportedMessageInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupportedMessageInfoForArrayConstraintsFromSetSupportedMessageInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlineProfileTypeSupportedMessageInfoItem) {
            // validation for constraint: itemType
            if (!$airlineProfileTypeSupportedMessageInfoItem instanceof \StructType\KeyValuePropertyType) {
                $invalidValues[] = is_object($airlineProfileTypeSupportedMessageInfoItem) ? get_class($airlineProfileTypeSupportedMessageInfoItem) : sprintf('%s(%s)', gettype($airlineProfileTypeSupportedMessageInfoItem), var_export($airlineProfileTypeSupportedMessageInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SupportedMessageInfo property can only contain items of type \StructType\KeyValuePropertyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SupportedMessageInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValuePropertyType[] $supportedMessageInfo
     * @return \StructType\AirlineProfileType
     */
    public function setSupportedMessageInfo(array $supportedMessageInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($supportedMessageInfoArrayErrorMessage = self::validateSupportedMessageInfoForArrayConstraintsFromSetSupportedMessageInfo($supportedMessageInfo))) {
            throw new \InvalidArgumentException($supportedMessageInfoArrayErrorMessage, __LINE__);
        }
        $this->SupportedMessageInfo = $supportedMessageInfo;
        return $this;
    }
    /**
     * Add item to SupportedMessageInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValuePropertyType $item
     * @return \StructType\AirlineProfileType
     */
    public function addToSupportedMessageInfo(\StructType\KeyValuePropertyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KeyValuePropertyType) {
            throw new \InvalidArgumentException(sprintf('The SupportedMessageInfo property can only contain items of type \StructType\KeyValuePropertyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SupportedMessageInfo[] = $item;
        return $this;
    }
}
