<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirlineProfileDataItemType StructType
 * Meta information extracted from the WSDL
 * - documentation: Single set of data elements contained within the airline profile.
 * @subpackage Structs
 */
class AirlineProfileDataItemType extends AbstractStructBase
{
    /**
     * The SeqNumber
     * Meta information extracted from the WSDL
     * - documentation: Global sequence number of this record in the Airline Profile. | A mathematical number that is assigned or is determined by calculation.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $SeqNumber;
    /**
     * The ActionTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Action Type Code | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ActionTypeCode;
    /**
     * The OfferFilterCriteria
     * Meta information extracted from the WSDL
     * - documentation: A set of filter criteria based on offer preferences/criteria. Technical specialized to use a choice.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OfferFilterCriteriaType[]
     */
    public $OfferFilterCriteria;
    /**
     * The POS_FilterCriteria
     * Meta information extracted from the WSDL
     * - documentation: Criteria used to filter results based on point of sale information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\POS_FilterCriteriaType[]
     */
    public $POS_FilterCriteria;
    /**
     * The POS_GeographicFilterCriteria
     * Meta information extracted from the WSDL
     * - documentation: Criteria used to filter results based on geographic preferences, including Area, State, City, Airport, or Geospatial information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GeographicFilterCriteriaType[]
     */
    public $POS_GeographicFilterCriteria;
    /**
     * The ServiceCriteria
     * Meta information extracted from the WSDL
     * - documentation: Reason for Issuance Group and Subgroup code(s) that specify the requested categories of Optional Services to be returned in the results.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ServiceCriteriaType[]
     */
    public $ServiceCriteria;
    /**
     * Constructor method for AirlineProfileDataItemType
     * @uses AirlineProfileDataItemType::setSeqNumber()
     * @uses AirlineProfileDataItemType::setActionTypeCode()
     * @uses AirlineProfileDataItemType::setOfferFilterCriteria()
     * @uses AirlineProfileDataItemType::setPOS_FilterCriteria()
     * @uses AirlineProfileDataItemType::setPOS_GeographicFilterCriteria()
     * @uses AirlineProfileDataItemType::setServiceCriteria()
     * @param float $seqNumber
     * @param string $actionTypeCode
     * @param \StructType\OfferFilterCriteriaType[] $offerFilterCriteria
     * @param \StructType\POS_FilterCriteriaType[] $pOS_FilterCriteria
     * @param \StructType\GeographicFilterCriteriaType[] $pOS_GeographicFilterCriteria
     * @param \StructType\ServiceCriteriaType[] $serviceCriteria
     */
    public function __construct($seqNumber = null, $actionTypeCode = null, array $offerFilterCriteria = array(), array $pOS_FilterCriteria = array(), array $pOS_GeographicFilterCriteria = array(), array $serviceCriteria = array())
    {
        $this
            ->setSeqNumber($seqNumber)
            ->setActionTypeCode($actionTypeCode)
            ->setOfferFilterCriteria($offerFilterCriteria)
            ->setPOS_FilterCriteria($pOS_FilterCriteria)
            ->setPOS_GeographicFilterCriteria($pOS_GeographicFilterCriteria)
            ->setServiceCriteria($serviceCriteria);
    }
    /**
     * Get SeqNumber value
     * @return float
     */
    public function getSeqNumber()
    {
        return $this->SeqNumber;
    }
    /**
     * Set SeqNumber value
     * @param float $seqNumber
     * @return \StructType\AirlineProfileDataItemType
     */
    public function setSeqNumber($seqNumber = null)
    {
        // validation for constraint: float
        if (!is_null($seqNumber) && !(is_float($seqNumber) || is_numeric($seqNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($seqNumber, true), gettype($seqNumber)), __LINE__);
        }
        $this->SeqNumber = $seqNumber;
        return $this;
    }
    /**
     * Get ActionTypeCode value
     * @return string|null
     */
    public function getActionTypeCode()
    {
        return $this->ActionTypeCode;
    }
    /**
     * Set ActionTypeCode value
     * @param string $actionTypeCode
     * @return \StructType\AirlineProfileDataItemType
     */
    public function setActionTypeCode($actionTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($actionTypeCode) && !is_string($actionTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionTypeCode, true), gettype($actionTypeCode)), __LINE__);
        }
        $this->ActionTypeCode = $actionTypeCode;
        return $this;
    }
    /**
     * Get OfferFilterCriteria value
     * @return \StructType\OfferFilterCriteriaType[]|null
     */
    public function getOfferFilterCriteria()
    {
        return $this->OfferFilterCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setOfferFilterCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOfferFilterCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOfferFilterCriteriaForArrayConstraintsFromSetOfferFilterCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlineProfileDataItemTypeOfferFilterCriteriaItem) {
            // validation for constraint: itemType
            if (!$airlineProfileDataItemTypeOfferFilterCriteriaItem instanceof \StructType\OfferFilterCriteriaType) {
                $invalidValues[] = is_object($airlineProfileDataItemTypeOfferFilterCriteriaItem) ? get_class($airlineProfileDataItemTypeOfferFilterCriteriaItem) : sprintf('%s(%s)', gettype($airlineProfileDataItemTypeOfferFilterCriteriaItem), var_export($airlineProfileDataItemTypeOfferFilterCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OfferFilterCriteria property can only contain items of type \StructType\OfferFilterCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OfferFilterCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\OfferFilterCriteriaType[] $offerFilterCriteria
     * @return \StructType\AirlineProfileDataItemType
     */
    public function setOfferFilterCriteria(array $offerFilterCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($offerFilterCriteriaArrayErrorMessage = self::validateOfferFilterCriteriaForArrayConstraintsFromSetOfferFilterCriteria($offerFilterCriteria))) {
            throw new \InvalidArgumentException($offerFilterCriteriaArrayErrorMessage, __LINE__);
        }
        $this->OfferFilterCriteria = $offerFilterCriteria;
        return $this;
    }
    /**
     * Add item to OfferFilterCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\OfferFilterCriteriaType $item
     * @return \StructType\AirlineProfileDataItemType
     */
    public function addToOfferFilterCriteria(\StructType\OfferFilterCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OfferFilterCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The OfferFilterCriteria property can only contain items of type \StructType\OfferFilterCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OfferFilterCriteria[] = $item;
        return $this;
    }
    /**
     * Get POS_FilterCriteria value
     * @return \StructType\POS_FilterCriteriaType[]|null
     */
    public function getPOS_FilterCriteria()
    {
        return $this->POS_FilterCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setPOS_FilterCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPOS_FilterCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePOS_FilterCriteriaForArrayConstraintsFromSetPOS_FilterCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlineProfileDataItemTypePOS_FilterCriteriaItem) {
            // validation for constraint: itemType
            if (!$airlineProfileDataItemTypePOS_FilterCriteriaItem instanceof \StructType\POS_FilterCriteriaType) {
                $invalidValues[] = is_object($airlineProfileDataItemTypePOS_FilterCriteriaItem) ? get_class($airlineProfileDataItemTypePOS_FilterCriteriaItem) : sprintf('%s(%s)', gettype($airlineProfileDataItemTypePOS_FilterCriteriaItem), var_export($airlineProfileDataItemTypePOS_FilterCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The POS_FilterCriteria property can only contain items of type \StructType\POS_FilterCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set POS_FilterCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\POS_FilterCriteriaType[] $pOS_FilterCriteria
     * @return \StructType\AirlineProfileDataItemType
     */
    public function setPOS_FilterCriteria(array $pOS_FilterCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($pOS_FilterCriteriaArrayErrorMessage = self::validatePOS_FilterCriteriaForArrayConstraintsFromSetPOS_FilterCriteria($pOS_FilterCriteria))) {
            throw new \InvalidArgumentException($pOS_FilterCriteriaArrayErrorMessage, __LINE__);
        }
        $this->POS_FilterCriteria = $pOS_FilterCriteria;
        return $this;
    }
    /**
     * Add item to POS_FilterCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\POS_FilterCriteriaType $item
     * @return \StructType\AirlineProfileDataItemType
     */
    public function addToPOS_FilterCriteria(\StructType\POS_FilterCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\POS_FilterCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The POS_FilterCriteria property can only contain items of type \StructType\POS_FilterCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->POS_FilterCriteria[] = $item;
        return $this;
    }
    /**
     * Get POS_GeographicFilterCriteria value
     * @return \StructType\GeographicFilterCriteriaType[]|null
     */
    public function getPOS_GeographicFilterCriteria()
    {
        return $this->POS_GeographicFilterCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setPOS_GeographicFilterCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPOS_GeographicFilterCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePOS_GeographicFilterCriteriaForArrayConstraintsFromSetPOS_GeographicFilterCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlineProfileDataItemTypePOS_GeographicFilterCriteriaItem) {
            // validation for constraint: itemType
            if (!$airlineProfileDataItemTypePOS_GeographicFilterCriteriaItem instanceof \StructType\GeographicFilterCriteriaType) {
                $invalidValues[] = is_object($airlineProfileDataItemTypePOS_GeographicFilterCriteriaItem) ? get_class($airlineProfileDataItemTypePOS_GeographicFilterCriteriaItem) : sprintf('%s(%s)', gettype($airlineProfileDataItemTypePOS_GeographicFilterCriteriaItem), var_export($airlineProfileDataItemTypePOS_GeographicFilterCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The POS_GeographicFilterCriteria property can only contain items of type \StructType\GeographicFilterCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set POS_GeographicFilterCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\GeographicFilterCriteriaType[] $pOS_GeographicFilterCriteria
     * @return \StructType\AirlineProfileDataItemType
     */
    public function setPOS_GeographicFilterCriteria(array $pOS_GeographicFilterCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($pOS_GeographicFilterCriteriaArrayErrorMessage = self::validatePOS_GeographicFilterCriteriaForArrayConstraintsFromSetPOS_GeographicFilterCriteria($pOS_GeographicFilterCriteria))) {
            throw new \InvalidArgumentException($pOS_GeographicFilterCriteriaArrayErrorMessage, __LINE__);
        }
        $this->POS_GeographicFilterCriteria = $pOS_GeographicFilterCriteria;
        return $this;
    }
    /**
     * Add item to POS_GeographicFilterCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\GeographicFilterCriteriaType $item
     * @return \StructType\AirlineProfileDataItemType
     */
    public function addToPOS_GeographicFilterCriteria(\StructType\GeographicFilterCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GeographicFilterCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The POS_GeographicFilterCriteria property can only contain items of type \StructType\GeographicFilterCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->POS_GeographicFilterCriteria[] = $item;
        return $this;
    }
    /**
     * Get ServiceCriteria value
     * @return \StructType\ServiceCriteriaType[]|null
     */
    public function getServiceCriteria()
    {
        return $this->ServiceCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceCriteriaForArrayConstraintsFromSetServiceCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlineProfileDataItemTypeServiceCriteriaItem) {
            // validation for constraint: itemType
            if (!$airlineProfileDataItemTypeServiceCriteriaItem instanceof \StructType\ServiceCriteriaType) {
                $invalidValues[] = is_object($airlineProfileDataItemTypeServiceCriteriaItem) ? get_class($airlineProfileDataItemTypeServiceCriteriaItem) : sprintf('%s(%s)', gettype($airlineProfileDataItemTypeServiceCriteriaItem), var_export($airlineProfileDataItemTypeServiceCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ServiceCriteria property can only contain items of type \StructType\ServiceCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ServiceCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceCriteriaType[] $serviceCriteria
     * @return \StructType\AirlineProfileDataItemType
     */
    public function setServiceCriteria(array $serviceCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceCriteriaArrayErrorMessage = self::validateServiceCriteriaForArrayConstraintsFromSetServiceCriteria($serviceCriteria))) {
            throw new \InvalidArgumentException($serviceCriteriaArrayErrorMessage, __LINE__);
        }
        $this->ServiceCriteria = $serviceCriteria;
        return $this;
    }
    /**
     * Add item to ServiceCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceCriteriaType $item
     * @return \StructType\AirlineProfileDataItemType
     */
    public function addToServiceCriteria(\StructType\ServiceCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The ServiceCriteria property can only contain items of type \StructType\ServiceCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ServiceCriteria[] = $item;
        return $this;
    }
}
