<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AggregatorType StructType
 * Meta information extracted from the WSDL
 * - documentation: An entity who distributes a Seller's shopping request to multiple Airlines and aggregates subsequent responses.
 * @subpackage Structs
 */
class AggregatorType extends AbstractStructBase
{
    /**
     * The AggregatorID
     * Meta information extracted from the WSDL
     * - documentation: Identifier of the aggregator organization. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AggregatorID;
    /**
     * The ContactInfo
     * Meta information extracted from the WSDL
     * - documentation: The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContactInfoType[]
     */
    public $ContactInfo;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Aggregator Name. | BDT with value constraints for proper, regular names (e.g. Individual Surname, Individual First Name, Company Name, etc.).
     * - base: xs:token
     * - maxLength: 64
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * Constructor method for AggregatorType
     * @uses AggregatorType::setAggregatorID()
     * @uses AggregatorType::setContactInfo()
     * @uses AggregatorType::setName()
     * @param string $aggregatorID
     * @param \StructType\ContactInfoType[] $contactInfo
     * @param string $name
     */
    public function __construct($aggregatorID = null, array $contactInfo = array(), $name = null)
    {
        $this
            ->setAggregatorID($aggregatorID)
            ->setContactInfo($contactInfo)
            ->setName($name);
    }
    /**
     * Get AggregatorID value
     * @return string
     */
    public function getAggregatorID()
    {
        return $this->AggregatorID;
    }
    /**
     * Set AggregatorID value
     * @param string $aggregatorID
     * @return \StructType\AggregatorType
     */
    public function setAggregatorID($aggregatorID = null)
    {
        // validation for constraint: string
        if (!is_null($aggregatorID) && !is_string($aggregatorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aggregatorID, true), gettype($aggregatorID)), __LINE__);
        }
        $this->AggregatorID = $aggregatorID;
        return $this;
    }
    /**
     * Get ContactInfo value
     * @return \StructType\ContactInfoType[]|null
     */
    public function getContactInfo()
    {
        return $this->ContactInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setContactInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactInfoForArrayConstraintsFromSetContactInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $aggregatorTypeContactInfoItem) {
            // validation for constraint: itemType
            if (!$aggregatorTypeContactInfoItem instanceof \StructType\ContactInfoType) {
                $invalidValues[] = is_object($aggregatorTypeContactInfoItem) ? get_class($aggregatorTypeContactInfoItem) : sprintf('%s(%s)', gettype($aggregatorTypeContactInfoItem), var_export($aggregatorTypeContactInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContactInfo property can only contain items of type \StructType\ContactInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContactInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactInfoType[] $contactInfo
     * @return \StructType\AggregatorType
     */
    public function setContactInfo(array $contactInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($contactInfoArrayErrorMessage = self::validateContactInfoForArrayConstraintsFromSetContactInfo($contactInfo))) {
            throw new \InvalidArgumentException($contactInfoArrayErrorMessage, __LINE__);
        }
        $this->ContactInfo = $contactInfo;
        return $this;
    }
    /**
     * Add item to ContactInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactInfoType $item
     * @return \StructType\AggregatorType
     */
    public function addToContactInfo(\StructType\ContactInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactInfoType) {
            throw new \InvalidArgumentException(sprintf('The ContactInfo property can only contain items of type \StructType\ContactInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContactInfo[] = $item;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\AggregatorType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($name) && mb_strlen($name) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($name)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($name) && mb_strlen($name) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
}
