<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AffectedOrderItemRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains affected existing order items and related services to retain that will be impacted by any new offers in the message. The primary use case is when an existing order item is to be deleted or partial deletion either with a
 * replacement in a new offer or a an offer to be used for the deletion.
 * @subpackage Structs
 */
class AffectedOrderItemRequestType extends AbstractStructBase
{
    /**
     * The OrderItemRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Order Item requested for deletion. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderItemRefID;
    /**
     * The RespendInd
     * Meta information extracted from the WSDL
     * - documentation: Use by Seller to inform the Airline whether the cancellation of an OrderItem should be followed by an immediate Refund or whether the Seller wishes to retain any potentially reusable amounts on the cancelled OrderItem for subsequent
     * Reshopping. If set to 'true', indicates that the Seller wishes to ReSpend. If set to 'false', indicates the Seller wishes to get a Refund. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a
     * property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $RespendInd;
    /**
     * The RetainServiceID
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Service within the specified Order Item which the Passenger would like the Airline to retain and return within the proposed Offer Item(s) in the OrderReshopRS. | An identifier is a character string used to uniquely
     * identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $RetainServiceID;
    /**
     * Constructor method for AffectedOrderItemRequestType
     * @uses AffectedOrderItemRequestType::setOrderItemRefID()
     * @uses AffectedOrderItemRequestType::setRespendInd()
     * @uses AffectedOrderItemRequestType::setRetainServiceID()
     * @param string $orderItemRefID
     * @param bool $respendInd
     * @param string[] $retainServiceID
     */
    public function __construct($orderItemRefID = null, $respendInd = null, array $retainServiceID = array())
    {
        $this
            ->setOrderItemRefID($orderItemRefID)
            ->setRespendInd($respendInd)
            ->setRetainServiceID($retainServiceID);
    }
    /**
     * Get OrderItemRefID value
     * @return string
     */
    public function getOrderItemRefID()
    {
        return $this->OrderItemRefID;
    }
    /**
     * Set OrderItemRefID value
     * @param string $orderItemRefID
     * @return \StructType\AffectedOrderItemRequestType
     */
    public function setOrderItemRefID($orderItemRefID = null)
    {
        // validation for constraint: string
        if (!is_null($orderItemRefID) && !is_string($orderItemRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderItemRefID, true), gettype($orderItemRefID)), __LINE__);
        }
        $this->OrderItemRefID = $orderItemRefID;
        return $this;
    }
    /**
     * Get RespendInd value
     * @return bool|null
     */
    public function getRespendInd()
    {
        return $this->RespendInd;
    }
    /**
     * Set RespendInd value
     * @param bool $respendInd
     * @return \StructType\AffectedOrderItemRequestType
     */
    public function setRespendInd($respendInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($respendInd) && !is_bool($respendInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($respendInd, true), gettype($respendInd)), __LINE__);
        }
        $this->RespendInd = $respendInd;
        return $this;
    }
    /**
     * Get RetainServiceID value
     * @return string[]|null
     */
    public function getRetainServiceID()
    {
        return $this->RetainServiceID;
    }
    /**
     * This method is responsible for validating the values passed to the setRetainServiceID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRetainServiceID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRetainServiceIDForArrayConstraintsFromSetRetainServiceID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $affectedOrderItemRequestTypeRetainServiceIDItem) {
            // validation for constraint: itemType
            if (!is_string($affectedOrderItemRequestTypeRetainServiceIDItem)) {
                $invalidValues[] = is_object($affectedOrderItemRequestTypeRetainServiceIDItem) ? get_class($affectedOrderItemRequestTypeRetainServiceIDItem) : sprintf('%s(%s)', gettype($affectedOrderItemRequestTypeRetainServiceIDItem), var_export($affectedOrderItemRequestTypeRetainServiceIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RetainServiceID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RetainServiceID value
     * @throws \InvalidArgumentException
     * @param string[] $retainServiceID
     * @return \StructType\AffectedOrderItemRequestType
     */
    public function setRetainServiceID(array $retainServiceID = array())
    {
        // validation for constraint: array
        if ('' !== ($retainServiceIDArrayErrorMessage = self::validateRetainServiceIDForArrayConstraintsFromSetRetainServiceID($retainServiceID))) {
            throw new \InvalidArgumentException($retainServiceIDArrayErrorMessage, __LINE__);
        }
        $this->RetainServiceID = $retainServiceID;
        return $this;
    }
    /**
     * Add item to RetainServiceID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\AffectedOrderItemRequestType
     */
    public function addToRetainServiceID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The RetainServiceID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RetainServiceID[] = $item;
        return $this;
    }
}
