<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AckType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Acknowledgement document is a simple notification from party to party acknowledging the receipt of another transaction such as an inventory release or an updated order It may also provide information indicating the status of the
 * document. This document is used consistently as an optional response to a notification transaction.
 * @subpackage Structs
 */
class AckType extends AbstractStructBase
{
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - documentation: Status Code. Example: OK | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StatusCode;
    /**
     * The StatusMessageText
     * Meta information extracted from the WSDL
     * - documentation: Additional status message information. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusMessageText;
    /**
     * The WarningCode
     * Meta information extracted from the WSDL
     * - documentation: The code corresponding to the processing status if not OK. e.g FAILED. | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WarningCode;
    /**
     * Constructor method for AckType
     * @uses AckType::setStatusCode()
     * @uses AckType::setStatusMessageText()
     * @uses AckType::setWarningCode()
     * @param string $statusCode
     * @param string $statusMessageText
     * @param string $warningCode
     */
    public function __construct($statusCode = null, $statusMessageText = null, $warningCode = null)
    {
        $this
            ->setStatusCode($statusCode)
            ->setStatusMessageText($statusMessageText)
            ->setWarningCode($warningCode);
    }
    /**
     * Get StatusCode value
     * @return string
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \StructType\AckType
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get StatusMessageText value
     * @return string|null
     */
    public function getStatusMessageText()
    {
        return $this->StatusMessageText;
    }
    /**
     * Set StatusMessageText value
     * @param string $statusMessageText
     * @return \StructType\AckType
     */
    public function setStatusMessageText($statusMessageText = null)
    {
        // validation for constraint: string
        if (!is_null($statusMessageText) && !is_string($statusMessageText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusMessageText, true), gettype($statusMessageText)), __LINE__);
        }
        $this->StatusMessageText = $statusMessageText;
        return $this;
    }
    /**
     * Get WarningCode value
     * @return string|null
     */
    public function getWarningCode()
    {
        return $this->WarningCode;
    }
    /**
     * Set WarningCode value
     * @param string $warningCode
     * @return \StructType\AckType
     */
    public function setWarningCode($warningCode = null)
    {
        // validation for constraint: string
        if (!is_null($warningCode) && !is_string($warningCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($warningCode, true), gettype($warningCode)), __LINE__);
        }
        $this->WarningCode = $warningCode;
        return $this;
    }
}
