<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountedPenaltyInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information related to a penalty applied to an OrderItem following a servicing operation.
 * @subpackage Structs
 */
class AccountedPenaltyInfoType extends AbstractStructBase
{
    /**
     * The OrderItemRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to an Order Item ID to which the penalty was first applied. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderItemRefID;
    /**
     * The PenaltyDetails
     * Meta information extracted from the WSDL
     * - documentation: Information related to a penalty applied to the requested servicing operations.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PenaltyDetailsType
     */
    public $PenaltyDetails;
    /**
     * The PenaltyInfoID
     * Meta information extracted from the WSDL
     * - documentation: Identifier for Penalty Info. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PenaltyInfoID;
    /**
     * The ServiceRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Service to which the Penalty is expected to be recognized. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceRefID;
    /**
     * The CreationDateTime
     * Meta information extracted from the WSDL
     * - documentation: Penalty creation timestamp | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreationDateTime;
    /**
     * The PaxRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Passenger ID to which the penalty has been applied. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaxRefID;
    /**
     * Constructor method for AccountedPenaltyInfoType
     * @uses AccountedPenaltyInfoType::setOrderItemRefID()
     * @uses AccountedPenaltyInfoType::setPenaltyDetails()
     * @uses AccountedPenaltyInfoType::setPenaltyInfoID()
     * @uses AccountedPenaltyInfoType::setServiceRefID()
     * @uses AccountedPenaltyInfoType::setCreationDateTime()
     * @uses AccountedPenaltyInfoType::setPaxRefID()
     * @param string $orderItemRefID
     * @param \StructType\PenaltyDetailsType $penaltyDetails
     * @param string $penaltyInfoID
     * @param string $serviceRefID
     * @param string $creationDateTime
     * @param string $paxRefID
     */
    public function __construct($orderItemRefID = null, \StructType\PenaltyDetailsType $penaltyDetails = null, $penaltyInfoID = null, $serviceRefID = null, $creationDateTime = null, $paxRefID = null)
    {
        $this
            ->setOrderItemRefID($orderItemRefID)
            ->setPenaltyDetails($penaltyDetails)
            ->setPenaltyInfoID($penaltyInfoID)
            ->setServiceRefID($serviceRefID)
            ->setCreationDateTime($creationDateTime)
            ->setPaxRefID($paxRefID);
    }
    /**
     * Get OrderItemRefID value
     * @return string
     */
    public function getOrderItemRefID()
    {
        return $this->OrderItemRefID;
    }
    /**
     * Set OrderItemRefID value
     * @param string $orderItemRefID
     * @return \StructType\AccountedPenaltyInfoType
     */
    public function setOrderItemRefID($orderItemRefID = null)
    {
        // validation for constraint: string
        if (!is_null($orderItemRefID) && !is_string($orderItemRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderItemRefID, true), gettype($orderItemRefID)), __LINE__);
        }
        $this->OrderItemRefID = $orderItemRefID;
        return $this;
    }
    /**
     * Get PenaltyDetails value
     * @return \StructType\PenaltyDetailsType
     */
    public function getPenaltyDetails()
    {
        return $this->PenaltyDetails;
    }
    /**
     * Set PenaltyDetails value
     * @param \StructType\PenaltyDetailsType $penaltyDetails
     * @return \StructType\AccountedPenaltyInfoType
     */
    public function setPenaltyDetails(\StructType\PenaltyDetailsType $penaltyDetails = null)
    {
        $this->PenaltyDetails = $penaltyDetails;
        return $this;
    }
    /**
     * Get PenaltyInfoID value
     * @return string
     */
    public function getPenaltyInfoID()
    {
        return $this->PenaltyInfoID;
    }
    /**
     * Set PenaltyInfoID value
     * @param string $penaltyInfoID
     * @return \StructType\AccountedPenaltyInfoType
     */
    public function setPenaltyInfoID($penaltyInfoID = null)
    {
        // validation for constraint: string
        if (!is_null($penaltyInfoID) && !is_string($penaltyInfoID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($penaltyInfoID, true), gettype($penaltyInfoID)), __LINE__);
        }
        $this->PenaltyInfoID = $penaltyInfoID;
        return $this;
    }
    /**
     * Get ServiceRefID value
     * @return string
     */
    public function getServiceRefID()
    {
        return $this->ServiceRefID;
    }
    /**
     * Set ServiceRefID value
     * @param string $serviceRefID
     * @return \StructType\AccountedPenaltyInfoType
     */
    public function setServiceRefID($serviceRefID = null)
    {
        // validation for constraint: string
        if (!is_null($serviceRefID) && !is_string($serviceRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceRefID, true), gettype($serviceRefID)), __LINE__);
        }
        $this->ServiceRefID = $serviceRefID;
        return $this;
    }
    /**
     * Get CreationDateTime value
     * @return string|null
     */
    public function getCreationDateTime()
    {
        return $this->CreationDateTime;
    }
    /**
     * Set CreationDateTime value
     * @param string $creationDateTime
     * @return \StructType\AccountedPenaltyInfoType
     */
    public function setCreationDateTime($creationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTime) && !is_string($creationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateTime, true), gettype($creationDateTime)), __LINE__);
        }
        $this->CreationDateTime = $creationDateTime;
        return $this;
    }
    /**
     * Get PaxRefID value
     * @return string|null
     */
    public function getPaxRefID()
    {
        return $this->PaxRefID;
    }
    /**
     * Set PaxRefID value
     * @param string $paxRefID
     * @return \StructType\AccountedPenaltyInfoType
     */
    public function setPaxRefID($paxRefID = null)
    {
        // validation for constraint: string
        if (!is_null($paxRefID) && !is_string($paxRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxRefID, true), gettype($paxRefID)), __LINE__);
        }
        $this->PaxRefID = $paxRefID;
        return $this;
    }
}
