<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountedOrderItemType StructType
 * Meta information extracted from the WSDL
 * - documentation: An individually priced item within an Order, made up of one or more Services. May or may not be a selected Offer Item (e.g. non-chargeable Services available on request such as a wheelchair).
 * @subpackage Structs
 */
class AccountedOrderItemType extends AbstractStructBase
{
    /**
     * The OrderItemID
     * Meta information extracted from the WSDL
     * - documentation: Carrier assigned ID which exists uniquely within an Order. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderItemID;
    /**
     * The OwnerCode
     * Meta information extracted from the WSDL
     * - documentation: Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code. | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or
     * ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName}
     * {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $OwnerCode;
    /**
     * The Service
     * Meta information extracted from the WSDL
     * - documentation: An Order is the instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order. At the time of shopping, a service can be sold to
     * multiple passengers on a given journey. At time of order, the services should be applied to a single passenger on a single segment.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\AccountedServiceType[]
     */
    public $Service;
    /**
     * The AccountedOrderInstruction
     * Meta information extracted from the WSDL
     * - documentation: Accounted Order Instruction
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AccountedOrderInstructionType
     */
    public $AccountedOrderInstruction;
    /**
     * The BilateralTimeLimit
     * Meta information extracted from the WSDL
     * - documentation: A bilaterally agreed limitation or restriction of time.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BilateralTimeLimitType[]
     */
    public $BilateralTimeLimit;
    /**
     * The CancelRestrictions
     * Meta information extracted from the WSDL
     * - documentation: These are a set of qualifying conditions/rules/restrictions that are related to a constrained priced grouping of services for the Cancellation action.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CancelRestrictionsType[]
     */
    public $CancelRestrictions;
    /**
     * The ChangeGroupID
     * Meta information extracted from the WSDL
     * - documentation: Reference to one Order Item that are going to be replaced, unique within Order | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChangeGroupID;
    /**
     * The ChangeRestrictions
     * Meta information extracted from the WSDL
     * - documentation: These are a set of qualifying conditions/rules/restriction that are related to a constrained priced grouping of services for a Change/modification action.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ChangeRestrictionsType[]
     */
    public $ChangeRestrictions;
    /**
     * The ChangeTypeText
     * Meta information extracted from the WSDL
     * - documentation: indicates whether the Order Item is the old or the new Order Item | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChangeTypeText;
    /**
     * The Commission
     * Meta information extracted from the WSDL
     * - documentation: An amount of money, typically a set percentage of the value involved, paid to an agent in a commercial transaction.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CommissionType[]
     */
    public $Commission;
    /**
     * The CreationDateTime
     * Meta information extracted from the WSDL
     * - documentation: Order Item creation Timestamp. | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreationDateTime;
    /**
     * The DepositTimeLimitDateTime
     * Meta information extracted from the WSDL
     * - documentation: The date by which a deposit must be paid for an order item. Examples: 2015-01-13T13:59:38Z | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of
     * second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DepositTimeLimitDateTime;
    /**
     * The DisclosureRefID
     * Meta information extracted from the WSDL
     * - documentation: References a Disclosure ID. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $DisclosureRefID;
    /**
     * The ExistingOrderItemID
     * Meta information extracted from the WSDL
     * - documentation: Reference to the previous order item id that was exchanged. Carrier assigned ID which exists uniquely within an Order. | An identifier is a character string used to uniquely identify one instance of an object within an identification
     * scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ExistingOrderItemID;
    /**
     * The FareDetail
     * Meta information extracted from the WSDL
     * - documentation: The amount charged by the carrier for the carriage of a passenger and his allowable free baggage.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AccountedFareDetailType[]
     */
    public $FareDetail;
    /**
     * The GrandTotalAmount
     * Meta information extracted from the WSDL
     * - documentation: Reflects the Differential Total Amount and the Penalty Total Amount, if netted.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $GrandTotalAmount;
    /**
     * The NamingTimeLimitDateTime
     * Meta information extracted from the WSDL
     * - documentation: The time by which an Order Item must be completed with individual passenger names. Examples: 2015-01-13T13:59:38Z | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute,
     * second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NamingTimeLimitDateTime;
    /**
     * The NetInd
     * Meta information extracted from the WSDL
     * - documentation: The airline informs the seller if the penalty is netted (True) (i.e. taken from any amount that airline will owe to customer consequently to the servicing) or to be paid (False) (i.e. charged to customer upfront any servicing action,
     * and even if customer benefits from a subsequent refund/ residual value). | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $NetInd;
    /**
     * The OrderItemTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Specify the type of Order Item being presented to the Customer. Using new PADIS codeset -initial content -RET - Retail -WHO - Wholesale -COR - Corporate | A code is a character string of letters, numbers, special characters (except
     * escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderItemTypeCode;
    /**
     * The PaymentTimeLimitDateTime
     * Meta information extracted from the WSDL
     * - documentation: The time limit by which a commitment to pay must be made for the given Order Item. Upon expiry it is expected that the Order item is removed from the Order. If no value is returned, then no advice has been given. For example:
     * PaymentTimeLimitDateTime: 2015-01-01T12:53:12Z - indicates the date time by which payment commitment is required. | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and
     * fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentTimeLimitDateTime;
    /**
     * The PenaltyRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Penalty ID. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PenaltyRefID;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - documentation: An amount of money expected, required, or given in payment for something.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AccountedPriceType
     */
    public $Price;
    /**
     * The PriceDifferential
     * Meta information extracted from the WSDL
     * - documentation: For each OfferItem, this function allows the airline to inform the seller about amount differential type if this OfferItem is chosen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AccountedPriceDifferentialType
     */
    public $PriceDifferential;
    /**
     * The PriceGuaranteeTimeLimitDateTime
     * Meta information extracted from the WSDL
     * - documentation: The length of time the price of an Order Item is guaranteed. In the absence of the price guarantee time limit, the price is not guaranteed. Upon expiry, the price may no longer be guaranteed and either the Order should be repriced,
     * which may result in a new RepricedOffer, or a new shopping process may begin. | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PriceGuaranteeTimeLimitDateTime;
    /**
     * The ReusableInd
     * Meta information extracted from the WSDL
     * - documentation: If Reusable = true, indicates that part of the value of the OrderItem may be reused for reshopping or refund. Exact reusable amount is unknown until Seller requests to reshop or to process a refund for this OrderItem. | An indicator
     * is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ReusableInd;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - documentation: Status of the Order Item Status instance. See ATSB Codeset OrderItem for possible values. | The possible statuses of an Order Item {codeListAgencyName}IATA Code List{/codeListAgencyName} {codeListName}Ordered Item Status,
     * Coded.{/codeListName} {codeListIdentifier}ORDERITEM{/codeListIdentifier} | represents the status of an Order Item
     * - base: OrderItemStatusCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * The WebAddressURI
     * Meta information extracted from the WSDL
     * - documentation: Deep linking into another site to complete the transaction. E.g. to bring the customer directly to a page to continue with a purchase of a specific offer. | A string of characters used to identify a resource. Such identification
     * enables interaction with representations of the resource over a network, typically the World Wide Web, using specific protocols.
     * - base: xs:anyURI
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WebAddressURI;
    /**
     * Constructor method for AccountedOrderItemType
     * @uses AccountedOrderItemType::setOrderItemID()
     * @uses AccountedOrderItemType::setOwnerCode()
     * @uses AccountedOrderItemType::setService()
     * @uses AccountedOrderItemType::setAccountedOrderInstruction()
     * @uses AccountedOrderItemType::setBilateralTimeLimit()
     * @uses AccountedOrderItemType::setCancelRestrictions()
     * @uses AccountedOrderItemType::setChangeGroupID()
     * @uses AccountedOrderItemType::setChangeRestrictions()
     * @uses AccountedOrderItemType::setChangeTypeText()
     * @uses AccountedOrderItemType::setCommission()
     * @uses AccountedOrderItemType::setCreationDateTime()
     * @uses AccountedOrderItemType::setDepositTimeLimitDateTime()
     * @uses AccountedOrderItemType::setDisclosureRefID()
     * @uses AccountedOrderItemType::setExistingOrderItemID()
     * @uses AccountedOrderItemType::setFareDetail()
     * @uses AccountedOrderItemType::setGrandTotalAmount()
     * @uses AccountedOrderItemType::setNamingTimeLimitDateTime()
     * @uses AccountedOrderItemType::setNetInd()
     * @uses AccountedOrderItemType::setOrderItemTypeCode()
     * @uses AccountedOrderItemType::setPaymentTimeLimitDateTime()
     * @uses AccountedOrderItemType::setPenaltyRefID()
     * @uses AccountedOrderItemType::setPrice()
     * @uses AccountedOrderItemType::setPriceDifferential()
     * @uses AccountedOrderItemType::setPriceGuaranteeTimeLimitDateTime()
     * @uses AccountedOrderItemType::setReusableInd()
     * @uses AccountedOrderItemType::setStatusCode()
     * @uses AccountedOrderItemType::setWebAddressURI()
     * @param string $orderItemID
     * @param string $ownerCode
     * @param \StructType\AccountedServiceType[] $service
     * @param \StructType\AccountedOrderInstructionType $accountedOrderInstruction
     * @param \StructType\BilateralTimeLimitType[] $bilateralTimeLimit
     * @param \StructType\CancelRestrictionsType[] $cancelRestrictions
     * @param string $changeGroupID
     * @param \StructType\ChangeRestrictionsType[] $changeRestrictions
     * @param string $changeTypeText
     * @param \StructType\CommissionType[] $commission
     * @param string $creationDateTime
     * @param string $depositTimeLimitDateTime
     * @param string[] $disclosureRefID
     * @param string[] $existingOrderItemID
     * @param \StructType\AccountedFareDetailType[] $fareDetail
     * @param \StructType\AmountType $grandTotalAmount
     * @param string $namingTimeLimitDateTime
     * @param bool $netInd
     * @param string $orderItemTypeCode
     * @param string $paymentTimeLimitDateTime
     * @param string[] $penaltyRefID
     * @param \StructType\AccountedPriceType $price
     * @param \StructType\AccountedPriceDifferentialType $priceDifferential
     * @param string $priceGuaranteeTimeLimitDateTime
     * @param bool $reusableInd
     * @param string $statusCode
     * @param string $webAddressURI
     */
    public function __construct($orderItemID = null, $ownerCode = null, array $service = array(), \StructType\AccountedOrderInstructionType $accountedOrderInstruction = null, array $bilateralTimeLimit = array(), array $cancelRestrictions = array(), $changeGroupID = null, array $changeRestrictions = array(), $changeTypeText = null, array $commission = array(), $creationDateTime = null, $depositTimeLimitDateTime = null, array $disclosureRefID = array(), array $existingOrderItemID = array(), array $fareDetail = array(), \StructType\AmountType $grandTotalAmount = null, $namingTimeLimitDateTime = null, $netInd = null, $orderItemTypeCode = null, $paymentTimeLimitDateTime = null, array $penaltyRefID = array(), \StructType\AccountedPriceType $price = null, \StructType\AccountedPriceDifferentialType $priceDifferential = null, $priceGuaranteeTimeLimitDateTime = null, $reusableInd = null, $statusCode = null, $webAddressURI = null)
    {
        $this
            ->setOrderItemID($orderItemID)
            ->setOwnerCode($ownerCode)
            ->setService($service)
            ->setAccountedOrderInstruction($accountedOrderInstruction)
            ->setBilateralTimeLimit($bilateralTimeLimit)
            ->setCancelRestrictions($cancelRestrictions)
            ->setChangeGroupID($changeGroupID)
            ->setChangeRestrictions($changeRestrictions)
            ->setChangeTypeText($changeTypeText)
            ->setCommission($commission)
            ->setCreationDateTime($creationDateTime)
            ->setDepositTimeLimitDateTime($depositTimeLimitDateTime)
            ->setDisclosureRefID($disclosureRefID)
            ->setExistingOrderItemID($existingOrderItemID)
            ->setFareDetail($fareDetail)
            ->setGrandTotalAmount($grandTotalAmount)
            ->setNamingTimeLimitDateTime($namingTimeLimitDateTime)
            ->setNetInd($netInd)
            ->setOrderItemTypeCode($orderItemTypeCode)
            ->setPaymentTimeLimitDateTime($paymentTimeLimitDateTime)
            ->setPenaltyRefID($penaltyRefID)
            ->setPrice($price)
            ->setPriceDifferential($priceDifferential)
            ->setPriceGuaranteeTimeLimitDateTime($priceGuaranteeTimeLimitDateTime)
            ->setReusableInd($reusableInd)
            ->setStatusCode($statusCode)
            ->setWebAddressURI($webAddressURI);
    }
    /**
     * Get OrderItemID value
     * @return string
     */
    public function getOrderItemID()
    {
        return $this->OrderItemID;
    }
    /**
     * Set OrderItemID value
     * @param string $orderItemID
     * @return \StructType\AccountedOrderItemType
     */
    public function setOrderItemID($orderItemID = null)
    {
        // validation for constraint: string
        if (!is_null($orderItemID) && !is_string($orderItemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderItemID, true), gettype($orderItemID)), __LINE__);
        }
        $this->OrderItemID = $orderItemID;
        return $this;
    }
    /**
     * Get OwnerCode value
     * @return string
     */
    public function getOwnerCode()
    {
        return $this->OwnerCode;
    }
    /**
     * Set OwnerCode value
     * @param string $ownerCode
     * @return \StructType\AccountedOrderItemType
     */
    public function setOwnerCode($ownerCode = null)
    {
        // validation for constraint: string
        if (!is_null($ownerCode) && !is_string($ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerCode, true), gettype($ownerCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($ownerCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($ownerCode, true)), __LINE__);
        }
        $this->OwnerCode = $ownerCode;
        return $this;
    }
    /**
     * Get Service value
     * @return \StructType\AccountedServiceType[]
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * This method is responsible for validating the values passed to the setService method
     * This method is willingly generated in order to preserve the one-line inline validation within the setService method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceForArrayConstraintsFromSetService(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountedOrderItemTypeServiceItem) {
            // validation for constraint: itemType
            if (!$accountedOrderItemTypeServiceItem instanceof \StructType\AccountedServiceType) {
                $invalidValues[] = is_object($accountedOrderItemTypeServiceItem) ? get_class($accountedOrderItemTypeServiceItem) : sprintf('%s(%s)', gettype($accountedOrderItemTypeServiceItem), var_export($accountedOrderItemTypeServiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Service property can only contain items of type \StructType\AccountedServiceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Service value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountedServiceType[] $service
     * @return \StructType\AccountedOrderItemType
     */
    public function setService(array $service = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceArrayErrorMessage = self::validateServiceForArrayConstraintsFromSetService($service))) {
            throw new \InvalidArgumentException($serviceArrayErrorMessage, __LINE__);
        }
        $this->Service = $service;
        return $this;
    }
    /**
     * Add item to Service value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountedServiceType $item
     * @return \StructType\AccountedOrderItemType
     */
    public function addToService(\StructType\AccountedServiceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AccountedServiceType) {
            throw new \InvalidArgumentException(sprintf('The Service property can only contain items of type \StructType\AccountedServiceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Service[] = $item;
        return $this;
    }
    /**
     * Get AccountedOrderInstruction value
     * @return \StructType\AccountedOrderInstructionType|null
     */
    public function getAccountedOrderInstruction()
    {
        return $this->AccountedOrderInstruction;
    }
    /**
     * Set AccountedOrderInstruction value
     * @param \StructType\AccountedOrderInstructionType $accountedOrderInstruction
     * @return \StructType\AccountedOrderItemType
     */
    public function setAccountedOrderInstruction(\StructType\AccountedOrderInstructionType $accountedOrderInstruction = null)
    {
        $this->AccountedOrderInstruction = $accountedOrderInstruction;
        return $this;
    }
    /**
     * Get BilateralTimeLimit value
     * @return \StructType\BilateralTimeLimitType[]|null
     */
    public function getBilateralTimeLimit()
    {
        return $this->BilateralTimeLimit;
    }
    /**
     * This method is responsible for validating the values passed to the setBilateralTimeLimit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBilateralTimeLimit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBilateralTimeLimitForArrayConstraintsFromSetBilateralTimeLimit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountedOrderItemTypeBilateralTimeLimitItem) {
            // validation for constraint: itemType
            if (!$accountedOrderItemTypeBilateralTimeLimitItem instanceof \StructType\BilateralTimeLimitType) {
                $invalidValues[] = is_object($accountedOrderItemTypeBilateralTimeLimitItem) ? get_class($accountedOrderItemTypeBilateralTimeLimitItem) : sprintf('%s(%s)', gettype($accountedOrderItemTypeBilateralTimeLimitItem), var_export($accountedOrderItemTypeBilateralTimeLimitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BilateralTimeLimit property can only contain items of type \StructType\BilateralTimeLimitType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BilateralTimeLimit value
     * @throws \InvalidArgumentException
     * @param \StructType\BilateralTimeLimitType[] $bilateralTimeLimit
     * @return \StructType\AccountedOrderItemType
     */
    public function setBilateralTimeLimit(array $bilateralTimeLimit = array())
    {
        // validation for constraint: array
        if ('' !== ($bilateralTimeLimitArrayErrorMessage = self::validateBilateralTimeLimitForArrayConstraintsFromSetBilateralTimeLimit($bilateralTimeLimit))) {
            throw new \InvalidArgumentException($bilateralTimeLimitArrayErrorMessage, __LINE__);
        }
        $this->BilateralTimeLimit = $bilateralTimeLimit;
        return $this;
    }
    /**
     * Add item to BilateralTimeLimit value
     * @throws \InvalidArgumentException
     * @param \StructType\BilateralTimeLimitType $item
     * @return \StructType\AccountedOrderItemType
     */
    public function addToBilateralTimeLimit(\StructType\BilateralTimeLimitType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BilateralTimeLimitType) {
            throw new \InvalidArgumentException(sprintf('The BilateralTimeLimit property can only contain items of type \StructType\BilateralTimeLimitType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BilateralTimeLimit[] = $item;
        return $this;
    }
    /**
     * Get CancelRestrictions value
     * @return \StructType\CancelRestrictionsType[]|null
     */
    public function getCancelRestrictions()
    {
        return $this->CancelRestrictions;
    }
    /**
     * This method is responsible for validating the values passed to the setCancelRestrictions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCancelRestrictions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCancelRestrictionsForArrayConstraintsFromSetCancelRestrictions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountedOrderItemTypeCancelRestrictionsItem) {
            // validation for constraint: itemType
            if (!$accountedOrderItemTypeCancelRestrictionsItem instanceof \StructType\CancelRestrictionsType) {
                $invalidValues[] = is_object($accountedOrderItemTypeCancelRestrictionsItem) ? get_class($accountedOrderItemTypeCancelRestrictionsItem) : sprintf('%s(%s)', gettype($accountedOrderItemTypeCancelRestrictionsItem), var_export($accountedOrderItemTypeCancelRestrictionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CancelRestrictions property can only contain items of type \StructType\CancelRestrictionsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CancelRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\CancelRestrictionsType[] $cancelRestrictions
     * @return \StructType\AccountedOrderItemType
     */
    public function setCancelRestrictions(array $cancelRestrictions = array())
    {
        // validation for constraint: array
        if ('' !== ($cancelRestrictionsArrayErrorMessage = self::validateCancelRestrictionsForArrayConstraintsFromSetCancelRestrictions($cancelRestrictions))) {
            throw new \InvalidArgumentException($cancelRestrictionsArrayErrorMessage, __LINE__);
        }
        $this->CancelRestrictions = $cancelRestrictions;
        return $this;
    }
    /**
     * Add item to CancelRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\CancelRestrictionsType $item
     * @return \StructType\AccountedOrderItemType
     */
    public function addToCancelRestrictions(\StructType\CancelRestrictionsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CancelRestrictionsType) {
            throw new \InvalidArgumentException(sprintf('The CancelRestrictions property can only contain items of type \StructType\CancelRestrictionsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CancelRestrictions[] = $item;
        return $this;
    }
    /**
     * Get ChangeGroupID value
     * @return string|null
     */
    public function getChangeGroupID()
    {
        return $this->ChangeGroupID;
    }
    /**
     * Set ChangeGroupID value
     * @param string $changeGroupID
     * @return \StructType\AccountedOrderItemType
     */
    public function setChangeGroupID($changeGroupID = null)
    {
        // validation for constraint: string
        if (!is_null($changeGroupID) && !is_string($changeGroupID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($changeGroupID, true), gettype($changeGroupID)), __LINE__);
        }
        $this->ChangeGroupID = $changeGroupID;
        return $this;
    }
    /**
     * Get ChangeRestrictions value
     * @return \StructType\ChangeRestrictionsType[]|null
     */
    public function getChangeRestrictions()
    {
        return $this->ChangeRestrictions;
    }
    /**
     * This method is responsible for validating the values passed to the setChangeRestrictions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setChangeRestrictions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChangeRestrictionsForArrayConstraintsFromSetChangeRestrictions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountedOrderItemTypeChangeRestrictionsItem) {
            // validation for constraint: itemType
            if (!$accountedOrderItemTypeChangeRestrictionsItem instanceof \StructType\ChangeRestrictionsType) {
                $invalidValues[] = is_object($accountedOrderItemTypeChangeRestrictionsItem) ? get_class($accountedOrderItemTypeChangeRestrictionsItem) : sprintf('%s(%s)', gettype($accountedOrderItemTypeChangeRestrictionsItem), var_export($accountedOrderItemTypeChangeRestrictionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ChangeRestrictions property can only contain items of type \StructType\ChangeRestrictionsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ChangeRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\ChangeRestrictionsType[] $changeRestrictions
     * @return \StructType\AccountedOrderItemType
     */
    public function setChangeRestrictions(array $changeRestrictions = array())
    {
        // validation for constraint: array
        if ('' !== ($changeRestrictionsArrayErrorMessage = self::validateChangeRestrictionsForArrayConstraintsFromSetChangeRestrictions($changeRestrictions))) {
            throw new \InvalidArgumentException($changeRestrictionsArrayErrorMessage, __LINE__);
        }
        $this->ChangeRestrictions = $changeRestrictions;
        return $this;
    }
    /**
     * Add item to ChangeRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\ChangeRestrictionsType $item
     * @return \StructType\AccountedOrderItemType
     */
    public function addToChangeRestrictions(\StructType\ChangeRestrictionsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ChangeRestrictionsType) {
            throw new \InvalidArgumentException(sprintf('The ChangeRestrictions property can only contain items of type \StructType\ChangeRestrictionsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ChangeRestrictions[] = $item;
        return $this;
    }
    /**
     * Get ChangeTypeText value
     * @return string|null
     */
    public function getChangeTypeText()
    {
        return $this->ChangeTypeText;
    }
    /**
     * Set ChangeTypeText value
     * @param string $changeTypeText
     * @return \StructType\AccountedOrderItemType
     */
    public function setChangeTypeText($changeTypeText = null)
    {
        // validation for constraint: string
        if (!is_null($changeTypeText) && !is_string($changeTypeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($changeTypeText, true), gettype($changeTypeText)), __LINE__);
        }
        $this->ChangeTypeText = $changeTypeText;
        return $this;
    }
    /**
     * Get Commission value
     * @return \StructType\CommissionType[]|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * This method is responsible for validating the values passed to the setCommission method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommission method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommissionForArrayConstraintsFromSetCommission(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountedOrderItemTypeCommissionItem) {
            // validation for constraint: itemType
            if (!$accountedOrderItemTypeCommissionItem instanceof \StructType\CommissionType) {
                $invalidValues[] = is_object($accountedOrderItemTypeCommissionItem) ? get_class($accountedOrderItemTypeCommissionItem) : sprintf('%s(%s)', gettype($accountedOrderItemTypeCommissionItem), var_export($accountedOrderItemTypeCommissionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Commission property can only contain items of type \StructType\CommissionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Commission value
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionType[] $commission
     * @return \StructType\AccountedOrderItemType
     */
    public function setCommission(array $commission = array())
    {
        // validation for constraint: array
        if ('' !== ($commissionArrayErrorMessage = self::validateCommissionForArrayConstraintsFromSetCommission($commission))) {
            throw new \InvalidArgumentException($commissionArrayErrorMessage, __LINE__);
        }
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Add item to Commission value
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionType $item
     * @return \StructType\AccountedOrderItemType
     */
    public function addToCommission(\StructType\CommissionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CommissionType) {
            throw new \InvalidArgumentException(sprintf('The Commission property can only contain items of type \StructType\CommissionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Commission[] = $item;
        return $this;
    }
    /**
     * Get CreationDateTime value
     * @return string|null
     */
    public function getCreationDateTime()
    {
        return $this->CreationDateTime;
    }
    /**
     * Set CreationDateTime value
     * @param string $creationDateTime
     * @return \StructType\AccountedOrderItemType
     */
    public function setCreationDateTime($creationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTime) && !is_string($creationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateTime, true), gettype($creationDateTime)), __LINE__);
        }
        $this->CreationDateTime = $creationDateTime;
        return $this;
    }
    /**
     * Get DepositTimeLimitDateTime value
     * @return string|null
     */
    public function getDepositTimeLimitDateTime()
    {
        return $this->DepositTimeLimitDateTime;
    }
    /**
     * Set DepositTimeLimitDateTime value
     * @param string $depositTimeLimitDateTime
     * @return \StructType\AccountedOrderItemType
     */
    public function setDepositTimeLimitDateTime($depositTimeLimitDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($depositTimeLimitDateTime) && !is_string($depositTimeLimitDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depositTimeLimitDateTime, true), gettype($depositTimeLimitDateTime)), __LINE__);
        }
        $this->DepositTimeLimitDateTime = $depositTimeLimitDateTime;
        return $this;
    }
    /**
     * Get DisclosureRefID value
     * @return string[]|null
     */
    public function getDisclosureRefID()
    {
        return $this->DisclosureRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setDisclosureRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDisclosureRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDisclosureRefIDForArrayConstraintsFromSetDisclosureRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountedOrderItemTypeDisclosureRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($accountedOrderItemTypeDisclosureRefIDItem)) {
                $invalidValues[] = is_object($accountedOrderItemTypeDisclosureRefIDItem) ? get_class($accountedOrderItemTypeDisclosureRefIDItem) : sprintf('%s(%s)', gettype($accountedOrderItemTypeDisclosureRefIDItem), var_export($accountedOrderItemTypeDisclosureRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DisclosureRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DisclosureRefID value
     * @throws \InvalidArgumentException
     * @param string[] $disclosureRefID
     * @return \StructType\AccountedOrderItemType
     */
    public function setDisclosureRefID(array $disclosureRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($disclosureRefIDArrayErrorMessage = self::validateDisclosureRefIDForArrayConstraintsFromSetDisclosureRefID($disclosureRefID))) {
            throw new \InvalidArgumentException($disclosureRefIDArrayErrorMessage, __LINE__);
        }
        $this->DisclosureRefID = $disclosureRefID;
        return $this;
    }
    /**
     * Add item to DisclosureRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\AccountedOrderItemType
     */
    public function addToDisclosureRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The DisclosureRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DisclosureRefID[] = $item;
        return $this;
    }
    /**
     * Get ExistingOrderItemID value
     * @return string[]|null
     */
    public function getExistingOrderItemID()
    {
        return $this->ExistingOrderItemID;
    }
    /**
     * This method is responsible for validating the values passed to the setExistingOrderItemID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExistingOrderItemID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExistingOrderItemIDForArrayConstraintsFromSetExistingOrderItemID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountedOrderItemTypeExistingOrderItemIDItem) {
            // validation for constraint: itemType
            if (!is_string($accountedOrderItemTypeExistingOrderItemIDItem)) {
                $invalidValues[] = is_object($accountedOrderItemTypeExistingOrderItemIDItem) ? get_class($accountedOrderItemTypeExistingOrderItemIDItem) : sprintf('%s(%s)', gettype($accountedOrderItemTypeExistingOrderItemIDItem), var_export($accountedOrderItemTypeExistingOrderItemIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ExistingOrderItemID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ExistingOrderItemID value
     * @throws \InvalidArgumentException
     * @param string[] $existingOrderItemID
     * @return \StructType\AccountedOrderItemType
     */
    public function setExistingOrderItemID(array $existingOrderItemID = array())
    {
        // validation for constraint: array
        if ('' !== ($existingOrderItemIDArrayErrorMessage = self::validateExistingOrderItemIDForArrayConstraintsFromSetExistingOrderItemID($existingOrderItemID))) {
            throw new \InvalidArgumentException($existingOrderItemIDArrayErrorMessage, __LINE__);
        }
        $this->ExistingOrderItemID = $existingOrderItemID;
        return $this;
    }
    /**
     * Add item to ExistingOrderItemID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\AccountedOrderItemType
     */
    public function addToExistingOrderItemID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ExistingOrderItemID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ExistingOrderItemID[] = $item;
        return $this;
    }
    /**
     * Get FareDetail value
     * @return \StructType\AccountedFareDetailType[]|null
     */
    public function getFareDetail()
    {
        return $this->FareDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setFareDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareDetailForArrayConstraintsFromSetFareDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountedOrderItemTypeFareDetailItem) {
            // validation for constraint: itemType
            if (!$accountedOrderItemTypeFareDetailItem instanceof \StructType\AccountedFareDetailType) {
                $invalidValues[] = is_object($accountedOrderItemTypeFareDetailItem) ? get_class($accountedOrderItemTypeFareDetailItem) : sprintf('%s(%s)', gettype($accountedOrderItemTypeFareDetailItem), var_export($accountedOrderItemTypeFareDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareDetail property can only contain items of type \StructType\AccountedFareDetailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountedFareDetailType[] $fareDetail
     * @return \StructType\AccountedOrderItemType
     */
    public function setFareDetail(array $fareDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($fareDetailArrayErrorMessage = self::validateFareDetailForArrayConstraintsFromSetFareDetail($fareDetail))) {
            throw new \InvalidArgumentException($fareDetailArrayErrorMessage, __LINE__);
        }
        $this->FareDetail = $fareDetail;
        return $this;
    }
    /**
     * Add item to FareDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountedFareDetailType $item
     * @return \StructType\AccountedOrderItemType
     */
    public function addToFareDetail(\StructType\AccountedFareDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AccountedFareDetailType) {
            throw new \InvalidArgumentException(sprintf('The FareDetail property can only contain items of type \StructType\AccountedFareDetailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FareDetail[] = $item;
        return $this;
    }
    /**
     * Get GrandTotalAmount value
     * @return \StructType\AmountType|null
     */
    public function getGrandTotalAmount()
    {
        return $this->GrandTotalAmount;
    }
    /**
     * Set GrandTotalAmount value
     * @param \StructType\AmountType $grandTotalAmount
     * @return \StructType\AccountedOrderItemType
     */
    public function setGrandTotalAmount(\StructType\AmountType $grandTotalAmount = null)
    {
        $this->GrandTotalAmount = $grandTotalAmount;
        return $this;
    }
    /**
     * Get NamingTimeLimitDateTime value
     * @return string|null
     */
    public function getNamingTimeLimitDateTime()
    {
        return $this->NamingTimeLimitDateTime;
    }
    /**
     * Set NamingTimeLimitDateTime value
     * @param string $namingTimeLimitDateTime
     * @return \StructType\AccountedOrderItemType
     */
    public function setNamingTimeLimitDateTime($namingTimeLimitDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($namingTimeLimitDateTime) && !is_string($namingTimeLimitDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($namingTimeLimitDateTime, true), gettype($namingTimeLimitDateTime)), __LINE__);
        }
        $this->NamingTimeLimitDateTime = $namingTimeLimitDateTime;
        return $this;
    }
    /**
     * Get NetInd value
     * @return bool|null
     */
    public function getNetInd()
    {
        return $this->NetInd;
    }
    /**
     * Set NetInd value
     * @param bool $netInd
     * @return \StructType\AccountedOrderItemType
     */
    public function setNetInd($netInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($netInd) && !is_bool($netInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($netInd, true), gettype($netInd)), __LINE__);
        }
        $this->NetInd = $netInd;
        return $this;
    }
    /**
     * Get OrderItemTypeCode value
     * @return string|null
     */
    public function getOrderItemTypeCode()
    {
        return $this->OrderItemTypeCode;
    }
    /**
     * Set OrderItemTypeCode value
     * @param string $orderItemTypeCode
     * @return \StructType\AccountedOrderItemType
     */
    public function setOrderItemTypeCode($orderItemTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($orderItemTypeCode) && !is_string($orderItemTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderItemTypeCode, true), gettype($orderItemTypeCode)), __LINE__);
        }
        $this->OrderItemTypeCode = $orderItemTypeCode;
        return $this;
    }
    /**
     * Get PaymentTimeLimitDateTime value
     * @return string|null
     */
    public function getPaymentTimeLimitDateTime()
    {
        return $this->PaymentTimeLimitDateTime;
    }
    /**
     * Set PaymentTimeLimitDateTime value
     * @param string $paymentTimeLimitDateTime
     * @return \StructType\AccountedOrderItemType
     */
    public function setPaymentTimeLimitDateTime($paymentTimeLimitDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTimeLimitDateTime) && !is_string($paymentTimeLimitDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTimeLimitDateTime, true), gettype($paymentTimeLimitDateTime)), __LINE__);
        }
        $this->PaymentTimeLimitDateTime = $paymentTimeLimitDateTime;
        return $this;
    }
    /**
     * Get PenaltyRefID value
     * @return string[]|null
     */
    public function getPenaltyRefID()
    {
        return $this->PenaltyRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setPenaltyRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPenaltyRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePenaltyRefIDForArrayConstraintsFromSetPenaltyRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountedOrderItemTypePenaltyRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($accountedOrderItemTypePenaltyRefIDItem)) {
                $invalidValues[] = is_object($accountedOrderItemTypePenaltyRefIDItem) ? get_class($accountedOrderItemTypePenaltyRefIDItem) : sprintf('%s(%s)', gettype($accountedOrderItemTypePenaltyRefIDItem), var_export($accountedOrderItemTypePenaltyRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PenaltyRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PenaltyRefID value
     * @throws \InvalidArgumentException
     * @param string[] $penaltyRefID
     * @return \StructType\AccountedOrderItemType
     */
    public function setPenaltyRefID(array $penaltyRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($penaltyRefIDArrayErrorMessage = self::validatePenaltyRefIDForArrayConstraintsFromSetPenaltyRefID($penaltyRefID))) {
            throw new \InvalidArgumentException($penaltyRefIDArrayErrorMessage, __LINE__);
        }
        $this->PenaltyRefID = $penaltyRefID;
        return $this;
    }
    /**
     * Add item to PenaltyRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\AccountedOrderItemType
     */
    public function addToPenaltyRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PenaltyRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PenaltyRefID[] = $item;
        return $this;
    }
    /**
     * Get Price value
     * @return \StructType\AccountedPriceType|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \StructType\AccountedPriceType $price
     * @return \StructType\AccountedOrderItemType
     */
    public function setPrice(\StructType\AccountedPriceType $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get PriceDifferential value
     * @return \StructType\AccountedPriceDifferentialType|null
     */
    public function getPriceDifferential()
    {
        return $this->PriceDifferential;
    }
    /**
     * Set PriceDifferential value
     * @param \StructType\AccountedPriceDifferentialType $priceDifferential
     * @return \StructType\AccountedOrderItemType
     */
    public function setPriceDifferential(\StructType\AccountedPriceDifferentialType $priceDifferential = null)
    {
        $this->PriceDifferential = $priceDifferential;
        return $this;
    }
    /**
     * Get PriceGuaranteeTimeLimitDateTime value
     * @return string|null
     */
    public function getPriceGuaranteeTimeLimitDateTime()
    {
        return $this->PriceGuaranteeTimeLimitDateTime;
    }
    /**
     * Set PriceGuaranteeTimeLimitDateTime value
     * @param string $priceGuaranteeTimeLimitDateTime
     * @return \StructType\AccountedOrderItemType
     */
    public function setPriceGuaranteeTimeLimitDateTime($priceGuaranteeTimeLimitDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($priceGuaranteeTimeLimitDateTime) && !is_string($priceGuaranteeTimeLimitDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceGuaranteeTimeLimitDateTime, true), gettype($priceGuaranteeTimeLimitDateTime)), __LINE__);
        }
        $this->PriceGuaranteeTimeLimitDateTime = $priceGuaranteeTimeLimitDateTime;
        return $this;
    }
    /**
     * Get ReusableInd value
     * @return bool|null
     */
    public function getReusableInd()
    {
        return $this->ReusableInd;
    }
    /**
     * Set ReusableInd value
     * @param bool $reusableInd
     * @return \StructType\AccountedOrderItemType
     */
    public function setReusableInd($reusableInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($reusableInd) && !is_bool($reusableInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reusableInd, true), gettype($reusableInd)), __LINE__);
        }
        $this->ReusableInd = $reusableInd;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \StructType\AccountedOrderItemType
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get WebAddressURI value
     * @return string|null
     */
    public function getWebAddressURI()
    {
        return $this->WebAddressURI;
    }
    /**
     * Set WebAddressURI value
     * @param string $webAddressURI
     * @return \StructType\AccountedOrderItemType
     */
    public function setWebAddressURI($webAddressURI = null)
    {
        // validation for constraint: string
        if (!is_null($webAddressURI) && !is_string($webAddressURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webAddressURI, true), gettype($webAddressURI)), __LINE__);
        }
        $this->WebAddressURI = $webAddressURI;
        return $this;
    }
}
