<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountedOrderInstructionType StructType
 * Meta information extracted from the WSDL
 * - documentation: Accounted Order Instruction
 * @subpackage Structs
 */
class AccountedOrderInstructionType extends AbstractStructBase
{
    /**
     * The CabinTypeList
     * Meta information extracted from the WSDL
     * - documentation: List of Cabin Types Technical object only
     * - choice: CabinTypeList | CommissionList | SpecialServiceList
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\CabinTypeListType
     */
    public $CabinTypeList;
    /**
     * The CommissionList
     * Meta information extracted from the WSDL
     * - documentation: List of Commission types Technical only element used to contain multiple items.
     * - choice: CabinTypeList | CommissionList | SpecialServiceList
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\CommissionListType
     */
    public $CommissionList;
    /**
     * The SpecialServiceList
     * Meta information extracted from the WSDL
     * - documentation: List of Special service types. Technical object only
     * - choice: CabinTypeList | CommissionList | SpecialServiceList
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\SpecialServiceListType
     */
    public $SpecialServiceList;
    /**
     * Constructor method for AccountedOrderInstructionType
     * @uses AccountedOrderInstructionType::setCabinTypeList()
     * @uses AccountedOrderInstructionType::setCommissionList()
     * @uses AccountedOrderInstructionType::setSpecialServiceList()
     * @param \StructType\CabinTypeListType $cabinTypeList
     * @param \StructType\CommissionListType $commissionList
     * @param \StructType\SpecialServiceListType $specialServiceList
     */
    public function __construct(\StructType\CabinTypeListType $cabinTypeList = null, \StructType\CommissionListType $commissionList = null, \StructType\SpecialServiceListType $specialServiceList = null)
    {
        $this
            ->setCabinTypeList($cabinTypeList)
            ->setCommissionList($commissionList)
            ->setSpecialServiceList($specialServiceList);
    }
    /**
     * Get CabinTypeList value
     * @return \StructType\CabinTypeListType
     */
    public function getCabinTypeList()
    {
        return isset($this->CabinTypeList) ? $this->CabinTypeList : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCabinTypeList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCabinTypeList method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCabinTypeListForChoiceConstraintsFromSetCabinTypeList($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CommissionList',
            'SpecialServiceList',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CabinTypeList can\'t be set as the property %s is already set. Only one property must be set among these properties: CabinTypeList, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CabinTypeList value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CabinTypeListType $cabinTypeList
     * @return \StructType\AccountedOrderInstructionType
     */
    public function setCabinTypeList(\StructType\CabinTypeListType $cabinTypeList = null)
    {
        // validation for constraint: choice(CabinTypeList, CommissionList, SpecialServiceList)
        if ('' !== ($cabinTypeListChoiceErrorMessage = self::validateCabinTypeListForChoiceConstraintsFromSetCabinTypeList($cabinTypeList))) {
            throw new \InvalidArgumentException($cabinTypeListChoiceErrorMessage, __LINE__);
        }
        if (is_null($cabinTypeList) || (is_array($cabinTypeList) && empty($cabinTypeList))) {
            unset($this->CabinTypeList);
        } else {
            $this->CabinTypeList = $cabinTypeList;
        }
        return $this;
    }
    /**
     * Get CommissionList value
     * @return \StructType\CommissionListType
     */
    public function getCommissionList()
    {
        return isset($this->CommissionList) ? $this->CommissionList : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCommissionList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommissionList method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCommissionListForChoiceConstraintsFromSetCommissionList($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CabinTypeList',
            'SpecialServiceList',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CommissionList can\'t be set as the property %s is already set. Only one property must be set among these properties: CommissionList, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CommissionList value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionListType $commissionList
     * @return \StructType\AccountedOrderInstructionType
     */
    public function setCommissionList(\StructType\CommissionListType $commissionList = null)
    {
        // validation for constraint: choice(CabinTypeList, CommissionList, SpecialServiceList)
        if ('' !== ($commissionListChoiceErrorMessage = self::validateCommissionListForChoiceConstraintsFromSetCommissionList($commissionList))) {
            throw new \InvalidArgumentException($commissionListChoiceErrorMessage, __LINE__);
        }
        if (is_null($commissionList) || (is_array($commissionList) && empty($commissionList))) {
            unset($this->CommissionList);
        } else {
            $this->CommissionList = $commissionList;
        }
        return $this;
    }
    /**
     * Get SpecialServiceList value
     * @return \StructType\SpecialServiceListType
     */
    public function getSpecialServiceList()
    {
        return isset($this->SpecialServiceList) ? $this->SpecialServiceList : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSpecialServiceList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecialServiceList method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSpecialServiceListForChoiceConstraintsFromSetSpecialServiceList($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CabinTypeList',
            'CommissionList',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property SpecialServiceList can\'t be set as the property %s is already set. Only one property must be set among these properties: SpecialServiceList, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set SpecialServiceList value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialServiceListType $specialServiceList
     * @return \StructType\AccountedOrderInstructionType
     */
    public function setSpecialServiceList(\StructType\SpecialServiceListType $specialServiceList = null)
    {
        // validation for constraint: choice(CabinTypeList, CommissionList, SpecialServiceList)
        if ('' !== ($specialServiceListChoiceErrorMessage = self::validateSpecialServiceListForChoiceConstraintsFromSetSpecialServiceList($specialServiceList))) {
            throw new \InvalidArgumentException($specialServiceListChoiceErrorMessage, __LINE__);
        }
        if (is_null($specialServiceList) || (is_array($specialServiceList) && empty($specialServiceList))) {
            unset($this->SpecialServiceList);
        } else {
            $this->SpecialServiceList = $specialServiceList;
        }
        return $this;
    }
}
