<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountedFareComponentType StructType
 * Meta information extracted from the WSDL
 * - documentation: A portion of an itinerary between two consecutive fare construction points. If the journey has only one fare component, the points of origin and destination are the only fare construction points
 * @subpackage Structs
 */
class AccountedFareComponentType extends AbstractStructBase
{
    /**
     * The CabinType
     * Meta information extracted from the WSDL
     * - documentation: Type of compartment of an aircraft, offering specific services (e.g. business class, economy). Business Identifier Fields: - Cabin Type Code
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CabinTypeType
     */
    public $CabinType;
    /**
     * The CancelRestrictions
     * Meta information extracted from the WSDL
     * - documentation: These are a set of qualifying conditions/rules/restrictions that are related to a constrained priced grouping of services for the Cancellation action.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CancelRestrictionsType[]
     */
    public $CancelRestrictions;
    /**
     * The ChangeRestrictions
     * Meta information extracted from the WSDL
     * - documentation: These are a set of qualifying conditions/rules/restriction that are related to a constrained priced grouping of services for a Change/modification action.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ChangeRestrictionsType[]
     */
    public $ChangeRestrictions;
    /**
     * The FareBasisAppCode
     * Meta information extracted from the WSDL
     * - documentation: Indicates how the fare basis was applied. E.g. Requested, Ticketed, Other. | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FareBasisAppCode;
    /**
     * The FareBasisCityPairText
     * Meta information extracted from the WSDL
     * - documentation: Identified published fare. Origin and destination city codes and two character designator of fare owning airline associated with Fare Basis Code. Example: MIANCEDL | Text is a character string such as a finite set of characters
     * generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FareBasisCityPairText;
    /**
     * The FareBasisCode
     * Meta information extracted from the WSDL
     * - documentation: Fare basis code. Example: Y26 | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FareBasisCode;
    /**
     * The FareRule
     * Meta information extracted from the WSDL
     * - documentation: Special purchasing rules and restrictions used to differentiate fare levels from one another.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FareRuleType[]
     */
    public $FareRule;
    /**
     * The FareTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Fare Amount Type Code, ex: ADC (Additional Charge), IT (Tour Inclusive), NOADC (No additional charge). | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FareTypeCode;
    /**
     * The NegotiatedCode
     * Meta information extracted from the WSDL
     * - documentation: Identifies the Negotiated code/fare qualifier PADIS codeset 9910 | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NegotiatedCode;
    /**
     * The PaxSegmentRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Pax Segment ID. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PaxSegmentRefID;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - documentation: An amount of money expected, required, or given in payment for something.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AccountedPriceType
     */
    public $Price;
    /**
     * The PriceClassRefID
     * Meta information extracted from the WSDL
     * - documentation: A price point within a particular Cabin Type (sometimes referred to as 'Fare Families'). | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an
     * agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PriceClassRefID;
    /**
     * The RBD
     * Meta information extracted from the WSDL
     * - documentation: Reservation Booking Designator. A categorization used to facilitate access to inventory, application of filed fares, and to identify cabin entitlement. Identified using a single alpha character. E.g. 'J' for Business Class Premium,
     * 'D' for Business Discounted. There will typically be several RBDs defined for a given Cabin Type. Business Identifier Fields: - RBD Code
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RBD_Type
     */
    public $RBD;
    /**
     * The TicketDesigCode
     * Meta information extracted from the WSDL
     * - documentation: The Fare Basis Code Designator shall be placed within this element and removed from the Fare Basis Code element. For example, if the Airline has a fare basis code with a designator like 'JFBC/WO'. The Fare basis Code element should
     * contain 'JFBC' and this element should contain'WO'. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TicketDesigCode;
    /**
     * Constructor method for AccountedFareComponentType
     * @uses AccountedFareComponentType::setCabinType()
     * @uses AccountedFareComponentType::setCancelRestrictions()
     * @uses AccountedFareComponentType::setChangeRestrictions()
     * @uses AccountedFareComponentType::setFareBasisAppCode()
     * @uses AccountedFareComponentType::setFareBasisCityPairText()
     * @uses AccountedFareComponentType::setFareBasisCode()
     * @uses AccountedFareComponentType::setFareRule()
     * @uses AccountedFareComponentType::setFareTypeCode()
     * @uses AccountedFareComponentType::setNegotiatedCode()
     * @uses AccountedFareComponentType::setPaxSegmentRefID()
     * @uses AccountedFareComponentType::setPrice()
     * @uses AccountedFareComponentType::setPriceClassRefID()
     * @uses AccountedFareComponentType::setRBD()
     * @uses AccountedFareComponentType::setTicketDesigCode()
     * @param \StructType\CabinTypeType $cabinType
     * @param \StructType\CancelRestrictionsType[] $cancelRestrictions
     * @param \StructType\ChangeRestrictionsType[] $changeRestrictions
     * @param string $fareBasisAppCode
     * @param string $fareBasisCityPairText
     * @param string $fareBasisCode
     * @param \StructType\FareRuleType[] $fareRule
     * @param string $fareTypeCode
     * @param string $negotiatedCode
     * @param string[] $paxSegmentRefID
     * @param \StructType\AccountedPriceType $price
     * @param string $priceClassRefID
     * @param \StructType\RBD_Type $rBD
     * @param string $ticketDesigCode
     */
    public function __construct(\StructType\CabinTypeType $cabinType = null, array $cancelRestrictions = array(), array $changeRestrictions = array(), $fareBasisAppCode = null, $fareBasisCityPairText = null, $fareBasisCode = null, array $fareRule = array(), $fareTypeCode = null, $negotiatedCode = null, array $paxSegmentRefID = array(), \StructType\AccountedPriceType $price = null, $priceClassRefID = null, \StructType\RBD_Type $rBD = null, $ticketDesigCode = null)
    {
        $this
            ->setCabinType($cabinType)
            ->setCancelRestrictions($cancelRestrictions)
            ->setChangeRestrictions($changeRestrictions)
            ->setFareBasisAppCode($fareBasisAppCode)
            ->setFareBasisCityPairText($fareBasisCityPairText)
            ->setFareBasisCode($fareBasisCode)
            ->setFareRule($fareRule)
            ->setFareTypeCode($fareTypeCode)
            ->setNegotiatedCode($negotiatedCode)
            ->setPaxSegmentRefID($paxSegmentRefID)
            ->setPrice($price)
            ->setPriceClassRefID($priceClassRefID)
            ->setRBD($rBD)
            ->setTicketDesigCode($ticketDesigCode);
    }
    /**
     * Get CabinType value
     * @return \StructType\CabinTypeType|null
     */
    public function getCabinType()
    {
        return $this->CabinType;
    }
    /**
     * Set CabinType value
     * @param \StructType\CabinTypeType $cabinType
     * @return \StructType\AccountedFareComponentType
     */
    public function setCabinType(\StructType\CabinTypeType $cabinType = null)
    {
        $this->CabinType = $cabinType;
        return $this;
    }
    /**
     * Get CancelRestrictions value
     * @return \StructType\CancelRestrictionsType[]|null
     */
    public function getCancelRestrictions()
    {
        return $this->CancelRestrictions;
    }
    /**
     * This method is responsible for validating the values passed to the setCancelRestrictions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCancelRestrictions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCancelRestrictionsForArrayConstraintsFromSetCancelRestrictions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountedFareComponentTypeCancelRestrictionsItem) {
            // validation for constraint: itemType
            if (!$accountedFareComponentTypeCancelRestrictionsItem instanceof \StructType\CancelRestrictionsType) {
                $invalidValues[] = is_object($accountedFareComponentTypeCancelRestrictionsItem) ? get_class($accountedFareComponentTypeCancelRestrictionsItem) : sprintf('%s(%s)', gettype($accountedFareComponentTypeCancelRestrictionsItem), var_export($accountedFareComponentTypeCancelRestrictionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CancelRestrictions property can only contain items of type \StructType\CancelRestrictionsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CancelRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\CancelRestrictionsType[] $cancelRestrictions
     * @return \StructType\AccountedFareComponentType
     */
    public function setCancelRestrictions(array $cancelRestrictions = array())
    {
        // validation for constraint: array
        if ('' !== ($cancelRestrictionsArrayErrorMessage = self::validateCancelRestrictionsForArrayConstraintsFromSetCancelRestrictions($cancelRestrictions))) {
            throw new \InvalidArgumentException($cancelRestrictionsArrayErrorMessage, __LINE__);
        }
        $this->CancelRestrictions = $cancelRestrictions;
        return $this;
    }
    /**
     * Add item to CancelRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\CancelRestrictionsType $item
     * @return \StructType\AccountedFareComponentType
     */
    public function addToCancelRestrictions(\StructType\CancelRestrictionsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CancelRestrictionsType) {
            throw new \InvalidArgumentException(sprintf('The CancelRestrictions property can only contain items of type \StructType\CancelRestrictionsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CancelRestrictions[] = $item;
        return $this;
    }
    /**
     * Get ChangeRestrictions value
     * @return \StructType\ChangeRestrictionsType[]|null
     */
    public function getChangeRestrictions()
    {
        return $this->ChangeRestrictions;
    }
    /**
     * This method is responsible for validating the values passed to the setChangeRestrictions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setChangeRestrictions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChangeRestrictionsForArrayConstraintsFromSetChangeRestrictions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountedFareComponentTypeChangeRestrictionsItem) {
            // validation for constraint: itemType
            if (!$accountedFareComponentTypeChangeRestrictionsItem instanceof \StructType\ChangeRestrictionsType) {
                $invalidValues[] = is_object($accountedFareComponentTypeChangeRestrictionsItem) ? get_class($accountedFareComponentTypeChangeRestrictionsItem) : sprintf('%s(%s)', gettype($accountedFareComponentTypeChangeRestrictionsItem), var_export($accountedFareComponentTypeChangeRestrictionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ChangeRestrictions property can only contain items of type \StructType\ChangeRestrictionsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ChangeRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\ChangeRestrictionsType[] $changeRestrictions
     * @return \StructType\AccountedFareComponentType
     */
    public function setChangeRestrictions(array $changeRestrictions = array())
    {
        // validation for constraint: array
        if ('' !== ($changeRestrictionsArrayErrorMessage = self::validateChangeRestrictionsForArrayConstraintsFromSetChangeRestrictions($changeRestrictions))) {
            throw new \InvalidArgumentException($changeRestrictionsArrayErrorMessage, __LINE__);
        }
        $this->ChangeRestrictions = $changeRestrictions;
        return $this;
    }
    /**
     * Add item to ChangeRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\ChangeRestrictionsType $item
     * @return \StructType\AccountedFareComponentType
     */
    public function addToChangeRestrictions(\StructType\ChangeRestrictionsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ChangeRestrictionsType) {
            throw new \InvalidArgumentException(sprintf('The ChangeRestrictions property can only contain items of type \StructType\ChangeRestrictionsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ChangeRestrictions[] = $item;
        return $this;
    }
    /**
     * Get FareBasisAppCode value
     * @return string|null
     */
    public function getFareBasisAppCode()
    {
        return $this->FareBasisAppCode;
    }
    /**
     * Set FareBasisAppCode value
     * @param string $fareBasisAppCode
     * @return \StructType\AccountedFareComponentType
     */
    public function setFareBasisAppCode($fareBasisAppCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisAppCode) && !is_string($fareBasisAppCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareBasisAppCode, true), gettype($fareBasisAppCode)), __LINE__);
        }
        $this->FareBasisAppCode = $fareBasisAppCode;
        return $this;
    }
    /**
     * Get FareBasisCityPairText value
     * @return string|null
     */
    public function getFareBasisCityPairText()
    {
        return $this->FareBasisCityPairText;
    }
    /**
     * Set FareBasisCityPairText value
     * @param string $fareBasisCityPairText
     * @return \StructType\AccountedFareComponentType
     */
    public function setFareBasisCityPairText($fareBasisCityPairText = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisCityPairText) && !is_string($fareBasisCityPairText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareBasisCityPairText, true), gettype($fareBasisCityPairText)), __LINE__);
        }
        $this->FareBasisCityPairText = $fareBasisCityPairText;
        return $this;
    }
    /**
     * Get FareBasisCode value
     * @return string|null
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * Set FareBasisCode value
     * @param string $fareBasisCode
     * @return \StructType\AccountedFareComponentType
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisCode) && !is_string($fareBasisCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareBasisCode, true), gettype($fareBasisCode)), __LINE__);
        }
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Get FareRule value
     * @return \StructType\FareRuleType[]|null
     */
    public function getFareRule()
    {
        return $this->FareRule;
    }
    /**
     * This method is responsible for validating the values passed to the setFareRule method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareRule method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareRuleForArrayConstraintsFromSetFareRule(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountedFareComponentTypeFareRuleItem) {
            // validation for constraint: itemType
            if (!$accountedFareComponentTypeFareRuleItem instanceof \StructType\FareRuleType) {
                $invalidValues[] = is_object($accountedFareComponentTypeFareRuleItem) ? get_class($accountedFareComponentTypeFareRuleItem) : sprintf('%s(%s)', gettype($accountedFareComponentTypeFareRuleItem), var_export($accountedFareComponentTypeFareRuleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareRule property can only contain items of type \StructType\FareRuleType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareRule value
     * @throws \InvalidArgumentException
     * @param \StructType\FareRuleType[] $fareRule
     * @return \StructType\AccountedFareComponentType
     */
    public function setFareRule(array $fareRule = array())
    {
        // validation for constraint: array
        if ('' !== ($fareRuleArrayErrorMessage = self::validateFareRuleForArrayConstraintsFromSetFareRule($fareRule))) {
            throw new \InvalidArgumentException($fareRuleArrayErrorMessage, __LINE__);
        }
        $this->FareRule = $fareRule;
        return $this;
    }
    /**
     * Add item to FareRule value
     * @throws \InvalidArgumentException
     * @param \StructType\FareRuleType $item
     * @return \StructType\AccountedFareComponentType
     */
    public function addToFareRule(\StructType\FareRuleType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FareRuleType) {
            throw new \InvalidArgumentException(sprintf('The FareRule property can only contain items of type \StructType\FareRuleType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FareRule[] = $item;
        return $this;
    }
    /**
     * Get FareTypeCode value
     * @return string|null
     */
    public function getFareTypeCode()
    {
        return $this->FareTypeCode;
    }
    /**
     * Set FareTypeCode value
     * @param string $fareTypeCode
     * @return \StructType\AccountedFareComponentType
     */
    public function setFareTypeCode($fareTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareTypeCode) && !is_string($fareTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareTypeCode, true), gettype($fareTypeCode)), __LINE__);
        }
        $this->FareTypeCode = $fareTypeCode;
        return $this;
    }
    /**
     * Get NegotiatedCode value
     * @return string|null
     */
    public function getNegotiatedCode()
    {
        return $this->NegotiatedCode;
    }
    /**
     * Set NegotiatedCode value
     * @param string $negotiatedCode
     * @return \StructType\AccountedFareComponentType
     */
    public function setNegotiatedCode($negotiatedCode = null)
    {
        // validation for constraint: string
        if (!is_null($negotiatedCode) && !is_string($negotiatedCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($negotiatedCode, true), gettype($negotiatedCode)), __LINE__);
        }
        $this->NegotiatedCode = $negotiatedCode;
        return $this;
    }
    /**
     * Get PaxSegmentRefID value
     * @return string[]|null
     */
    public function getPaxSegmentRefID()
    {
        return $this->PaxSegmentRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setPaxSegmentRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxSegmentRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaxSegmentRefIDForArrayConstraintsFromSetPaxSegmentRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountedFareComponentTypePaxSegmentRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($accountedFareComponentTypePaxSegmentRefIDItem)) {
                $invalidValues[] = is_object($accountedFareComponentTypePaxSegmentRefIDItem) ? get_class($accountedFareComponentTypePaxSegmentRefIDItem) : sprintf('%s(%s)', gettype($accountedFareComponentTypePaxSegmentRefIDItem), var_export($accountedFareComponentTypePaxSegmentRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaxSegmentRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaxSegmentRefID value
     * @throws \InvalidArgumentException
     * @param string[] $paxSegmentRefID
     * @return \StructType\AccountedFareComponentType
     */
    public function setPaxSegmentRefID(array $paxSegmentRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($paxSegmentRefIDArrayErrorMessage = self::validatePaxSegmentRefIDForArrayConstraintsFromSetPaxSegmentRefID($paxSegmentRefID))) {
            throw new \InvalidArgumentException($paxSegmentRefIDArrayErrorMessage, __LINE__);
        }
        $this->PaxSegmentRefID = $paxSegmentRefID;
        return $this;
    }
    /**
     * Add item to PaxSegmentRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\AccountedFareComponentType
     */
    public function addToPaxSegmentRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PaxSegmentRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaxSegmentRefID[] = $item;
        return $this;
    }
    /**
     * Get Price value
     * @return \StructType\AccountedPriceType|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \StructType\AccountedPriceType $price
     * @return \StructType\AccountedFareComponentType
     */
    public function setPrice(\StructType\AccountedPriceType $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get PriceClassRefID value
     * @return string|null
     */
    public function getPriceClassRefID()
    {
        return $this->PriceClassRefID;
    }
    /**
     * Set PriceClassRefID value
     * @param string $priceClassRefID
     * @return \StructType\AccountedFareComponentType
     */
    public function setPriceClassRefID($priceClassRefID = null)
    {
        // validation for constraint: string
        if (!is_null($priceClassRefID) && !is_string($priceClassRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceClassRefID, true), gettype($priceClassRefID)), __LINE__);
        }
        $this->PriceClassRefID = $priceClassRefID;
        return $this;
    }
    /**
     * Get RBD value
     * @return \StructType\RBD_Type|null
     */
    public function getRBD()
    {
        return $this->RBD;
    }
    /**
     * Set RBD value
     * @param \StructType\RBD_Type $rBD
     * @return \StructType\AccountedFareComponentType
     */
    public function setRBD(\StructType\RBD_Type $rBD = null)
    {
        $this->RBD = $rBD;
        return $this;
    }
    /**
     * Get TicketDesigCode value
     * @return string|null
     */
    public function getTicketDesigCode()
    {
        return $this->TicketDesigCode;
    }
    /**
     * Set TicketDesigCode value
     * @param string $ticketDesigCode
     * @return \StructType\AccountedFareComponentType
     */
    public function setTicketDesigCode($ticketDesigCode = null)
    {
        // validation for constraint: string
        if (!is_null($ticketDesigCode) && !is_string($ticketDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketDesigCode, true), gettype($ticketDesigCode)), __LINE__);
        }
        $this->TicketDesigCode = $ticketDesigCode;
        return $this;
    }
}
