<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AcceptSelectedQuotedOfferListType StructType
 * Meta information extracted from the WSDL
 * - documentation: An ability to accept selected offer items from a Quoted Offer.
 * @subpackage Structs
 */
class AcceptSelectedQuotedOfferListType extends AbstractStructBase
{
    /**
     * The SelectedPricedOffer
     * Meta information extracted from the WSDL
     * - documentation: Offer selected by the Passenger for requesting an Order to be created. Multiple Offers can be requested at the same time, each of which could originate from different shopping responses (each with their own ResponseIDs). Each Offer
     * selected could reference (via the OfferID) either standard Offers from an AirShoppingRS message (potentially with Flight-related services) or A-La-Carte Offers (containing optional ancillary services). These standard Offers and 'a-la-carte' Offers
     * would need to be consistent with the applicability rules defined by their relations (passengers or segments eligible for the enclosed OfferItems) and would be combined to produce a single Order, returned by the OrderViewRS message.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\SelectedPricedOfferType[]
     */
    public $SelectedPricedOffer;
    /**
     * Constructor method for AcceptSelectedQuotedOfferListType
     * @uses AcceptSelectedQuotedOfferListType::setSelectedPricedOffer()
     * @param \StructType\SelectedPricedOfferType[] $selectedPricedOffer
     */
    public function __construct(array $selectedPricedOffer = array())
    {
        $this
            ->setSelectedPricedOffer($selectedPricedOffer);
    }
    /**
     * Get SelectedPricedOffer value
     * @return \StructType\SelectedPricedOfferType[]
     */
    public function getSelectedPricedOffer()
    {
        return $this->SelectedPricedOffer;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectedPricedOffer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectedPricedOffer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectedPricedOfferForArrayConstraintsFromSetSelectedPricedOffer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $acceptSelectedQuotedOfferListTypeSelectedPricedOfferItem) {
            // validation for constraint: itemType
            if (!$acceptSelectedQuotedOfferListTypeSelectedPricedOfferItem instanceof \StructType\SelectedPricedOfferType) {
                $invalidValues[] = is_object($acceptSelectedQuotedOfferListTypeSelectedPricedOfferItem) ? get_class($acceptSelectedQuotedOfferListTypeSelectedPricedOfferItem) : sprintf('%s(%s)', gettype($acceptSelectedQuotedOfferListTypeSelectedPricedOfferItem), var_export($acceptSelectedQuotedOfferListTypeSelectedPricedOfferItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectedPricedOffer property can only contain items of type \StructType\SelectedPricedOfferType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectedPricedOffer value
     * @throws \InvalidArgumentException
     * @param \StructType\SelectedPricedOfferType[] $selectedPricedOffer
     * @return \StructType\AcceptSelectedQuotedOfferListType
     */
    public function setSelectedPricedOffer(array $selectedPricedOffer = array())
    {
        // validation for constraint: array
        if ('' !== ($selectedPricedOfferArrayErrorMessage = self::validateSelectedPricedOfferForArrayConstraintsFromSetSelectedPricedOffer($selectedPricedOffer))) {
            throw new \InvalidArgumentException($selectedPricedOfferArrayErrorMessage, __LINE__);
        }
        $this->SelectedPricedOffer = $selectedPricedOffer;
        return $this;
    }
    /**
     * Add item to SelectedPricedOffer value
     * @throws \InvalidArgumentException
     * @param \StructType\SelectedPricedOfferType $item
     * @return \StructType\AcceptSelectedQuotedOfferListType
     */
    public function addToSelectedPricedOffer(\StructType\SelectedPricedOfferType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SelectedPricedOfferType) {
            throw new \InvalidArgumentException(sprintf('The SelectedPricedOffer property can only contain items of type \StructType\SelectedPricedOfferType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectedPricedOffer[] = $item;
        return $this;
    }
}
