<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Flx ServiceType
 * @subpackage Services
 */
class Flx extends AbstractSoapClientBase
{
    /**
     * Sets the TransactionControl SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\TransactionControl $transactionControl
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderTransactionControl(\StructType\TransactionControl $transactionControl, $nameSpace = 'http://farelogix.com/flx/tc', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'TransactionControl', $transactionControl, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named FlxTransaction
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: TransactionControl
     * - SOAPHeaderNamespaces: http://farelogix.com/flx/tc
     * - SOAPHeaderTypes: \StructType\TransactionControl
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FlxTransaction $body
     * @return \StructType\FlxTransactionResponse|bool
     */
    public function FlxTransaction(\StructType\FlxTransaction $body)
    {
        try {
            $this->setResult($this->getSoapClient()->FlxTransaction($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\FlxTransactionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
