<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ReportingTypeCodeContentType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Enum values for Reporting Type Code BDT. {codeListAgencyName}IATA AIDM{/codeListAgencyName}
 * @subpackage Enumerations
 */
class ReportingTypeCodeContentType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Airline'
     * Meta information extracted from the WSDL
     * - documentation: Airline reporting type code
     * @return string 'Airline'
     */
    const VALUE_AIRLINE = 'Airline';
    /**
     * Constant for value 'ARC'
     * Meta information extracted from the WSDL
     * - documentation: ARC reporting type code
     * @return string 'ARC'
     */
    const VALUE_ARC = 'ARC';
    /**
     * Constant for value 'BSP'
     * Meta information extracted from the WSDL
     * - documentation: BSP reporting type code
     * @return string 'BSP'
     */
    const VALUE_BSP = 'BSP';
    /**
     * Constant for value 'Not applicable'
     * Meta information extracted from the WSDL
     * - documentation: Not applicable reporting type code
     * @return string 'Not applicable'
     */
    const VALUE_NOT_APPLICABLE = 'Not applicable';
    /**
     * Return allowed values
     * @uses self::VALUE_AIRLINE
     * @uses self::VALUE_ARC
     * @uses self::VALUE_BSP
     * @uses self::VALUE_NOT_APPLICABLE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AIRLINE,
            self::VALUE_ARC,
            self::VALUE_BSP,
            self::VALUE_NOT_APPLICABLE,
        );
    }
}
