<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for MeasurementSystemCodeContentType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Enumeration set for the measurement system code BDT. {codeListAgencyName}PADIS{/codeListAgencyName}
 * @subpackage Enumerations
 */
class MeasurementSystemCodeContentType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Imperial'
     * Meta information extracted from the WSDL
     * - documentation: The imperial measurement system.
     * @return string 'Imperial'
     */
    const VALUE_IMPERIAL = 'Imperial';
    /**
     * Constant for value 'Metric'
     * Meta information extracted from the WSDL
     * - documentation: The metric measurement system.
     * @return string 'Metric'
     */
    const VALUE_METRIC = 'Metric';
    /**
     * Return allowed values
     * @uses self::VALUE_IMPERIAL
     * @uses self::VALUE_METRIC
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_IMPERIAL,
            self::VALUE_METRIC,
        );
    }
}
