<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for LengthUnitCodeContentType EnumType
 * Meta information extracted from the WSDL
 * - documentation: List of Length Unit Codes. Subset of UN/CEFACT Recommendation 20. {codeListAgencyName}AIDM (extract from UN/CEFACT){/codeListAgencyName}
 * @subpackage Enumerations
 */
class LengthUnitCodeContentType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'CMT'
     * Meta information extracted from the WSDL
     * - documentation: Centimeter
     * @return string 'CMT'
     */
    const VALUE_CMT = 'CMT';
    /**
     * Constant for value 'FOT'
     * Meta information extracted from the WSDL
     * - documentation: Foot
     * @return string 'FOT'
     */
    const VALUE_FOT = 'FOT';
    /**
     * Constant for value 'INH'
     * Meta information extracted from the WSDL
     * - documentation: Inch
     * @return string 'INH'
     */
    const VALUE_INH = 'INH';
    /**
     * Constant for value 'MTR'
     * Meta information extracted from the WSDL
     * - documentation: Meter
     * @return string 'MTR'
     */
    const VALUE_MTR = 'MTR';
    /**
     * Return allowed values
     * @uses self::VALUE_CMT
     * @uses self::VALUE_FOT
     * @uses self::VALUE_INH
     * @uses self::VALUE_MTR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CMT,
            self::VALUE_FOT,
            self::VALUE_INH,
            self::VALUE_MTR,
        );
    }
}
