<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for JourneyStageCode EnumType
 * Meta information extracted from the WSDL
 * - documentation: Valid Stage Codes are defined in the Journey Stage Type Code ENUM PRIOR TO DEPARTURE NO SHOW AFTER DEPARTURE This will be used either in addition to other BBIE's or individually to qualify a condition.
 * @subpackage Enumerations
 */
class JourneyStageCode extends AbstractStructEnumBase
{
    /**
     * Constant for value 'After Departure'
     * Meta information extracted from the WSDL
     * - documentation: After Departure Any time after a journey segment which was included in the offer/order item has taken place irrespective of whether the segment was flown or not. | After Departure Any time after a journey segment which was included
     * in the offer/order item has taken place irrespective of whether the segment was flown or not. | After Departure Any time after a journey segment which was included in the offer/order item has taken place irrespective of whether the segment was flown
     * or not.
     * @return string 'After Departure'
     */
    const VALUE_AFTER_DEPARTURE = 'After Departure';
    /**
     * Constant for value 'No Show'
     * Meta information extracted from the WSDL
     * - documentation: No Show When passenger(s) have not turned up for any of the flights in the itinerary. | No Show When passenger(s) have not turned up for any of the flights in the itinerary. | No Show When passenger(s) have not turned up for any of
     * the flights in the itinerary.
     * @return string 'No Show'
     */
    const VALUE_NO_SHOW = 'No Show';
    /**
     * Constant for value 'Prior To Departure'
     * Meta information extracted from the WSDL
     * - documentation: Prior to Departure Any time before the first flight segment but after payment received. | Prior to Departure Any time before the first flight segment but after payment received. | Prior to Departure Any time before the first flight
     * segment but after payment received.
     * @return string 'Prior To Departure'
     */
    const VALUE_PRIOR_TO_DEPARTURE = 'Prior To Departure';
    /**
     * Return allowed values
     * @uses self::VALUE_AFTER_DEPARTURE
     * @uses self::VALUE_NO_SHOW
     * @uses self::VALUE_PRIOR_TO_DEPARTURE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AFTER_DEPARTURE,
            self::VALUE_NO_SHOW,
            self::VALUE_PRIOR_TO_DEPARTURE,
        );
    }
}
