<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for FlightCharacteristicsCodeContentType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Enumeration set for the flight characteristics code BDT.
 * @subpackage Enumerations
 */
class FlightCharacteristicsCodeContentType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'AirportChange'
     * Meta information extracted from the WSDL
     * - documentation: Airport Change
     * @return string 'AirportChange'
     */
    const VALUE_AIRPORT_CHANGE = 'AirportChange';
    /**
     * Constant for value 'Direct'
     * Meta information extracted from the WSDL
     * - documentation: Direct
     * @return string 'Direct'
     */
    const VALUE_DIRECT = 'Direct';
    /**
     * Constant for value 'NonStop'
     * Meta information extracted from the WSDL
     * - documentation: Non Stop
     * @return string 'NonStop'
     */
    const VALUE_NON_STOP = 'NonStop';
    /**
     * Constant for value 'OvernightStop'
     * Meta information extracted from the WSDL
     * - documentation: Overnight Stop
     * @return string 'OvernightStop'
     */
    const VALUE_OVERNIGHT_STOP = 'OvernightStop';
    /**
     * Constant for value 'RedEye'
     * Meta information extracted from the WSDL
     * - documentation: Red eye
     * @return string 'RedEye'
     */
    const VALUE_RED_EYE = 'RedEye';
    /**
     * Return allowed values
     * @uses self::VALUE_AIRPORT_CHANGE
     * @uses self::VALUE_DIRECT
     * @uses self::VALUE_NON_STOP
     * @uses self::VALUE_OVERNIGHT_STOP
     * @uses self::VALUE_RED_EYE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AIRPORT_CHANGE,
            self::VALUE_DIRECT,
            self::VALUE_NON_STOP,
            self::VALUE_OVERNIGHT_STOP,
            self::VALUE_RED_EYE,
        );
    }
}
