<?php
/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'TransactionControl' => '\\StructType\\TransactionControl',
            'tc' => '\\StructType\\Tc',
            'al' => '\\StructType\\Al',
            'app' => '\\StructType\\App',
            'iden' => '\\StructType\\Iden',
            'provider' => '\\StructType\\Provider',
            'script' => '\\StructType\\Script',
            'agent' => '\\StructType\\Agent',
            'trace' => '\\StructType\\Trace',
            'Transaction' => '\\StructType\\Transaction',
            'SignatureType' => '\\StructType\\SignatureType',
            'SignatureValueType' => '\\StructType\\SignatureValueType',
            'SignedInfoType' => '\\StructType\\SignedInfoType',
            'CanonicalizationMethodType' => '\\StructType\\CanonicalizationMethodType',
            'SignatureMethodType' => '\\StructType\\SignatureMethodType',
            'ReferenceType' => '\\StructType\\ReferenceType',
            'TransformsType' => '\\StructType\\TransformsType',
            'TransformType' => '\\StructType\\TransformType',
            'DigestMethodType' => '\\StructType\\DigestMethodType',
            'KeyInfoType' => '\\StructType\\KeyInfoType',
            'KeyValueType' => '\\StructType\\KeyValueType',
            'RetrievalMethodType' => '\\StructType\\RetrievalMethodType',
            'X509DataType' => '\\StructType\\X509DataType',
            'X509IssuerSerialType' => '\\StructType\\X509IssuerSerialType',
            'PGPDataType' => '\\StructType\\PGPDataType',
            'SPKIDataType' => '\\StructType\\SPKIDataType',
            'ObjectType' => '\\StructType\\ObjectType',
            'ManifestType' => '\\StructType\\ManifestType',
            'SignaturePropertiesType' => '\\StructType\\SignaturePropertiesType',
            'SignaturePropertyType' => '\\StructType\\SignaturePropertyType',
            'DSAKeyValueType' => '\\StructType\\DSAKeyValueType',
            'RSAKeyValueType' => '\\StructType\\RSAKeyValueType',
            'Amex' => '\\StructType\\Amex',
            'ATPCO' => '\\StructType\\ATPCO',
            'Group' => '\\StructType\\Group',
            'SubGroup' => '\\StructType\\SubGroup',
            'Carrier' => '\\StructType\\Carrier',
            'CCApprovalCode' => '\\StructType\\CCApprovalCode',
            'ClassOfService' => '\\StructType\\ClassOfService',
            'Code' => '\\StructType\\Code',
            'MarketingName' => '\\StructType\\MarketingName',
            'Combinability' => '\\StructType\\Combinability',
            'Association' => '\\StructType\\Association',
            'Commission' => '\\StructType\\Commission',
            'CustomParams' => '\\StructType\\CustomParams',
            'Param' => '\\StructType\\Param',
            'Diagnostics' => '\\StructType\\Diagnostics',
            'Diagnostic' => '\\StructType\\Diagnostic',
            'EquivID' => '\\StructType\\EquivID',
            'LoyaltyAccrual' => '\\StructType\\LoyaltyAccrual',
            'OCNContents' => '\\StructType\\OCNContents',
            'OnTimePerformance' => '\\StructType\\OnTimePerformance',
            'Late' => '\\StructType\\Late',
            'OtherServiceInformation' => '\\StructType\\OtherServiceInformation',
            'Redemption' => '\\StructType\\Redemption',
            'Redeem' => '\\StructType\\Redeem',
            'DatedMarketingSegmentRefID' => '\\StructType\\DatedMarketingSegmentRefID',
            'CurrencyConversion' => '\\StructType\\CurrencyConversion',
            'RequiredAmount' => '\\StructType\\RequiredAmount',
            'RedemptionAmountCalc' => '\\StructType\\RedemptionAmountCalc',
            'Operation' => '\\StructType\\Operation',
            'Adjustment' => '\\StructType\\Adjustment',
            'DescriptionDetails' => '\\StructType\\DescriptionDetails',
            'Offer' => '\\StructType\\Offer',
            'UnitControl' => '\\StructType\\UnitControl',
            'Units' => '\\StructType\\Units',
            'DiscountLevel' => '\\StructType\\DiscountLevel',
            'TravelDates' => '\\StructType\\TravelDates',
            'EffectiveDate' => '\\StructType\\EffectiveDate',
            'ExpirationDate' => '\\StructType\\ExpirationDate',
            'BookingDates' => '\\StructType\\BookingDates',
            'Slider' => '\\StructType\\Slider',
            'Position' => '\\StructType\\Position',
            'UATPReportingData' => '\\StructType\\UATPReportingData',
            'IK' => '\\StructType\\IK',
            'KS' => '\\StructType\\KS',
            'DS' => '\\StructType\\DS',
            'PK' => '\\StructType\\PK',
            'PR' => '\\StructType\\PR',
            'AK' => '\\StructType\\AK',
            'AE' => '\\StructType\\AE',
            'BD' => '\\StructType\\BD',
            'RZ' => '\\StructType\\RZ',
            'AU' => '\\StructType\\AU',
            'UseDocument' => '\\StructType\\UseDocument',
            'UserInput' => '\\StructType\\UserInput',
            'UserText' => '\\StructType\\UserText',
            'UserChoices' => '\\StructType\\UserChoices',
            'VoucherPin' => '\\StructType\\VoucherPin',
            'Vouchers' => '\\StructType\\Vouchers',
            'CouponReference' => '\\StructType\\CouponReference',
            'VoucherImage' => '\\StructType\\VoucherImage',
            'Image' => '\\StructType\\Image',
            'WebLinks' => '\\StructType\\WebLinks',
            'WebLink' => '\\StructType\\WebLink',
            'Arrival' => '\\StructType\\Arrival',
            'Classes' => '\\StructType\\Classes',
            'Departure' => '\\StructType\\Departure',
            'Equipment' => '\\StructType\\Equipment',
            'ExchangeInfo' => '\\StructType\\ExchangeInfo',
            'Penalty' => '\\StructType\\Penalty',
            'CommPenalty' => '\\StructType\\CommPenalty',
            'ValueOfOldTicket' => '\\StructType\\ValueOfOldTicket',
            'FiledAmount' => '\\StructType\\FiledAmount',
            'FiledCurrencyCode' => '\\StructType\\FiledCurrencyCode',
            'FiledIn' => '\\StructType\\FiledIn',
            'Amount' => '\\StructType\\Amount',
            'NUCAmount' => '\\StructType\\NUCAmount',
            'Flight' => '\\StructType\\Flight',
            'FlightOptions' => '\\StructType\\FlightOptions',
            'OperatingCarrier' => '\\StructType\\OperatingCarrier',
            'OperatingCarrierDisclosure' => '\\StructType\\OperatingCarrierDisclosure',
            'PriceClass' => '\\StructType\\PriceClass',
            'Price' => '\\StructType\\Price',
            'BaseFare' => '\\StructType\\BaseFare',
            'PriceGroup' => '\\StructType\\PriceGroup',
            'Segment' => '\\StructType\\Segment',
            'StopInformation' => '\\StructType\\StopInformation',
            'Tax' => '\\StructType\\Tax',
            'CollectionPoint' => '\\StructType\\CollectionPoint',
            'Taxes' => '\\StructType\\Taxes',
            'TravelerIDRef' => '\\StructType\\TravelerIDRef',
            'AmountType' => '\\StructType\\AmountType',
            'BaseFareType' => '\\StructType\\BaseFareType',
            'CabinTypeType' => '\\StructType\\CabinTypeType',
            'CancelRestrictionsType' => '\\StructType\\CancelRestrictionsType',
            'CarrierFeeType' => '\\StructType\\CarrierFeeType',
            'CarrierType' => '\\StructType\\CarrierType',
            'ChangeOrCancelFeeType' => '\\StructType\\ChangeOrCancelFeeType',
            'ChangeRestrictionsType' => '\\StructType\\ChangeRestrictionsType',
            'CountryType' => '\\StructType\\CountryType',
            'CurConversionType' => '\\StructType\\CurConversionType',
            'ConversionRate' => '\\StructType\\ConversionRate',
            'CurrencyCodeType' => '\\StructType\\CurrencyCodeType',
            'DifferentialPriceType' => '\\StructType\\DifferentialPriceType',
            'Discount' => '\\StructType\\Discount',
            'DiscountContext' => '\\StructType\\DiscountContext',
            'PrefLevel' => '\\StructType\\PrefLevel',
            'Fee' => '\\StructType\\Fee',
            'Markup' => '\\StructType\\Markup',
            'Surcharge' => '\\StructType\\Surcharge',
            'FareComponentType' => '\\StructType\\FareComponentType',
            'FareDetailType' => '\\StructType\\FareDetailType',
            'DifferentialFarePriceType' => '\\StructType\\DifferentialFarePriceType',
            'FareCalculationInfo' => '\\StructType\\FareCalculationInfo',
            'FareComponent' => '\\StructType\\FareComponent',
            'CancelRestrictions' => '\\StructType\\CancelRestrictions',
            'Refund' => '\\StructType\\Refund',
            'ChangeRestrictions' => '\\StructType\\ChangeRestrictions',
            'RBD' => '\\StructType\\RBD',
            'FareWaiver' => '\\StructType\\FareWaiver',
            'FareRuleType' => '\\StructType\\FareRuleType',
            'Remark' => '\\StructType\\Remark',
            'FeeType' => '\\StructType\\FeeType',
            'FlightNumberWithSuffixType' => '\\StructType\\FlightNumberWithSuffixType',
            'IATA_EasyPayEncryptedDataType' => '\\StructType\\IATA_EasyPayEncryptedDataType',
            'IATA_EasyPayType' => '\\StructType\\IATA_EasyPayType',
            'MerchantAccountType' => '\\StructType\\MerchantAccountType',
            'OfferAssociationType' => '\\StructType\\OfferAssociationType',
            'OrderAssociationType' => '\\StructType\\OrderAssociationType',
            'OriginDestType' => '\\StructType\\OriginDestType',
            'PriceDifferentialType' => '\\StructType\\PriceDifferentialType',
            'DiffPrice' => '\\StructType\\DiffPrice',
            'FareDetail' => '\\StructType\\FareDetail',
            'NewPrice' => '\\StructType\\NewPrice',
            'OldPrice' => '\\StructType\\OldPrice',
            'PriceType' => '\\StructType\\PriceType',
            'RBD_Type' => '\\StructType\\RBD_Type',
            'RefundType' => '\\StructType\\RefundType',
            'SettlementDataType' => '\\StructType\\SettlementDataType',
            'SurchargesType' => '\\StructType\\SurchargesType',
            'SurchargeType' => '\\StructType\\SurchargeType',
            'SurchargeTypeBasic' => '\\StructType\\SurchargeTypeBasic',
            'TaxSummaryType' => '\\StructType\\TaxSummaryType',
            'TaxType' => '\\StructType\\TaxType',
            'CollectionPointTax' => '\\StructType\\CollectionPointTax',
            'Station' => '\\StructType\\Station',
            'CountrySubDivision' => '\\StructType\\CountrySubDivision',
            'AcceptanceRuleType' => '\\StructType\\AcceptanceRuleType',
            'AcceptCancelOfferType' => '\\StructType\\AcceptCancelOfferType',
            'AcceptOrderItemListType' => '\\StructType\\AcceptOrderItemListType',
            'AcceptRepricedOrderType' => '\\StructType\\AcceptRepricedOrderType',
            'AcceptSelectedQuotedOfferListType' => '\\StructType\\AcceptSelectedQuotedOfferListType',
            'AccountableDocType' => '\\StructType\\AccountableDocType',
            'AccountedDifferentialFareDetailType' => '\\StructType\\AccountedDifferentialFareDetailType',
            'AccountedDiffPriceAndFareDetailsType' => '\\StructType\\AccountedDiffPriceAndFareDetailsType',
            'AccountedFareComponentType' => '\\StructType\\AccountedFareComponentType',
            'AccountedFareDetailType' => '\\StructType\\AccountedFareDetailType',
            'AccountedForfeitedInfoListType' => '\\StructType\\AccountedForfeitedInfoListType',
            'AccountedForfeitedInfoType' => '\\StructType\\AccountedForfeitedInfoType',
            'AccountedOrderInstructionType' => '\\StructType\\AccountedOrderInstructionType',
            'AccountedOrderItemType' => '\\StructType\\AccountedOrderItemType',
            'AccountedOrderType' => '\\StructType\\AccountedOrderType',
            'AccountedPenaltyInfoListType' => '\\StructType\\AccountedPenaltyInfoListType',
            'AccountedPenaltyInfoType' => '\\StructType\\AccountedPenaltyInfoType',
            'AccountedPriceDifferentialType' => '\\StructType\\AccountedPriceDifferentialType',
            'AccountedPriceType' => '\\StructType\\AccountedPriceType',
            'AccountedServiceType' => '\\StructType\\AccountedServiceType',
            'AccountingFarePriceTypeType' => '\\StructType\\AccountingFarePriceTypeType',
            'AccountingIATA_EasyPayType' => '\\StructType\\AccountingIATA_EasyPayType',
            'AccountingPaymentMethodType' => '\\StructType\\AccountingPaymentMethodType',
            'AccountingPriceAndFareDetailsType' => '\\StructType\\AccountingPriceAndFareDetailsType',
            'AccountingTrxPaymentCardType' => '\\StructType\\AccountingTrxPaymentCardType',
            'AckType' => '\\StructType\\AckType',
            'AddedOfferItemType' => '\\StructType\\AddedOfferItemType',
            'AddlNameType' => '\\StructType\\AddlNameType',
            'AddOfferItemsType' => '\\StructType\\AddOfferItemsType',
            'AffectedOrderItemRequestType' => '\\StructType\\AffectedOrderItemRequestType',
            'AffinityArrivalRequestType' => '\\StructType\\AffinityArrivalRequestType',
            'AffinityDepRequestType' => '\\StructType\\AffinityDepRequestType',
            'AffinityOriginDestType' => '\\StructType\\AffinityOriginDestType',
            'AffinityShoppingCriteriaType' => '\\StructType\\AffinityShoppingCriteriaType',
            'AggregatorType' => '\\StructType\\AggregatorType',
            'AirlineProfileDataItemType' => '\\StructType\\AirlineProfileDataItemType',
            'AirlineProfileFilterCriteriaType' => '\\StructType\\AirlineProfileFilterCriteriaType',
            'AirlineProfileNotifType' => '\\StructType\\AirlineProfileNotifType',
            'AirlineProfileRequestType' => '\\StructType\\AirlineProfileRequestType',
            'AirlineProfileResponseType' => '\\StructType\\AirlineProfileResponseType',
            'AirlineProfileType' => '\\StructType\\AirlineProfileType',
            'AirlineTaxonomyType' => '\\StructType\\AirlineTaxonomyType',
            'AirShoppingRequestType' => '\\StructType\\AirShoppingRequestType',
            'AirShoppingResponseType' => '\\StructType\\AirShoppingResponseType',
            'ALaCarteOfferItemType' => '\\StructType\\ALaCarteOfferItemType',
            'ALaCarteOfferType' => '\\StructType\\ALaCarteOfferType',
            'ALaCarteServiceType' => '\\StructType\\ALaCarteServiceType',
            'AllianceCriteriaType' => '\\StructType\\AllianceCriteriaType',
            'AllianceType' => '\\StructType\\AllianceType',
            'ArrivalFilterCriteriaType' => '\\StructType\\ArrivalFilterCriteriaType',
            'ArrivalType' => '\\StructType\\ArrivalType',
            'AugmentationPointType' => '\\StructType\\AugmentationPointType',
            'AugPoint' => '\\StructType\\AugPoint',
            'DatedMarketingSegmentRef' => '\\StructType\\DatedMarketingSegmentRef',
            'AvailableSeatType' => '\\StructType\\AvailableSeatType',
            'AvailPeriodType' => '\\StructType\\AvailPeriodType',
            'BagDimensionType' => '\\StructType\\BagDimensionType',
            'BaggageAllowanceListType' => '\\StructType\\BaggageAllowanceListType',
            'BaggageAllowanceRefType' => '\\StructType\\BaggageAllowanceRefType',
            'BaggageAllowanceType' => '\\StructType\\BaggageAllowanceType',
            'BaggageAssociationsType' => '\\StructType\\BaggageAssociationsType',
            'BaggageDisclosureListType' => '\\StructType\\BaggageDisclosureListType',
            'BaggageDisclosureType' => '\\StructType\\BaggageDisclosureType',
            'BaggageItemType' => '\\StructType\\BaggageItemType',
            'BaggagePricingCriteriaType' => '\\StructType\\BaggagePricingCriteriaType',
            'BagItemDetailsType' => '\\StructType\\BagItemDetailsType',
            'BagTagType' => '\\StructType\\BagTagType',
            'BagType' => '\\StructType\\BagType',
            'BDC_Type' => '\\StructType\\BDC_Type',
            'BilateralTimeLimitType' => '\\StructType\\BilateralTimeLimitType',
            'BinaryObjectType' => '\\StructType\\BinaryObjectType',
            'BookingEntityType' => '\\StructType\\BookingEntityType',
            'BookingInfoType' => '\\StructType\\BookingInfoType',
            'BookingInstructionsType' => '\\StructType\\BookingInstructionsType',
            'BookingRefType' => '\\StructType\\BookingRefType',
            'CabinCompartmentType' => '\\StructType\\CabinCompartmentType',
            'CabinComponentType' => '\\StructType\\CabinComponentType',
            'CabinTypeAssociationChoiceType' => '\\StructType\\CabinTypeAssociationChoiceType',
            'CabinTypeListType' => '\\StructType\\CabinTypeListType',
            'CalendarDateCriteriaType' => '\\StructType\\CalendarDateCriteriaType',
            'CancelOrderRefType' => '\\StructType\\CancelOrderRefType',
            'CancelUnpaidOrderType' => '\\StructType\\CancelUnpaidOrderType',
            'CarrierAircraftTypeType' => '\\StructType\\CarrierAircraftTypeType',
            'CarrierCriteriaType' => '\\StructType\\CarrierCriteriaType',
            'CarrierOffersType' => '\\StructType\\CarrierOffersType',
            'ChangeDetailsType' => '\\StructType\\ChangeDetailsType',
            'ChangedOfferType' => '\\StructType\\ChangedOfferType',
            'ChangeGroupType' => '\\StructType\\ChangeGroupType',
            'ChangeOperationGroupType' => '\\StructType\\ChangeOperationGroupType',
            'ChangeOperationType' => '\\StructType\\ChangeOperationType',
            'ChangeOrderChoiceType' => '\\StructType\\ChangeOrderChoiceType',
            'ChangesToOrderItemType' => '\\StructType\\ChangesToOrderItemType',
            'ChangesToOrderType' => '\\StructType\\ChangesToOrderType',
            'ChangeToServiceType' => '\\StructType\\ChangeToServiceType',
            'CityType' => '\\StructType\\CityType',
            'ClearanceCarrierType' => '\\StructType\\ClearanceCarrierType',
            'ClearanceCriteriaType' => '\\StructType\\ClearanceCriteriaType',
            'ClearanceDataType' => '\\StructType\\ClearanceDataType',
            'ClearanceMethodsType' => '\\StructType\\ClearanceMethodsType',
            'ClearanceOrgType' => '\\StructType\\ClearanceOrgType',
            'ClearancePayeeDataType' => '\\StructType\\ClearancePayeeDataType',
            'ClearancePayeeType' => '\\StructType\\ClearancePayeeType',
            'ClearancePayerDataType' => '\\StructType\\ClearancePayerDataType',
            'ClearancePayerType' => '\\StructType\\ClearancePayerType',
            'ClearanceRoleChoiceType' => '\\StructType\\ClearanceRoleChoiceType',
            'ClearanceTravelAgencyType' => '\\StructType\\ClearanceTravelAgencyType',
            'CodesetMetadataType' => '\\StructType\\CodesetMetadataType',
            'CollectionPointTaxType' => '\\StructType\\CollectionPointTaxType',
            'CommissionListType' => '\\StructType\\CommissionListType',
            'CommissionType' => '\\StructType\\CommissionType',
            'ConnectionCriteriaType' => '\\StructType\\ConnectionCriteriaType',
            'ContactInfoListType' => '\\StructType\\ContactInfoListType',
            'ContactInfoType' => '\\StructType\\ContactInfoType',
            'CountrySubDivisionType' => '\\StructType\\CountrySubDivisionType',
            'CouponType' => '\\StructType\\CouponType',
            'CouponValidityPeriodType' => '\\StructType\\CouponValidityPeriodType',
            'CreateOrderItemType' => '\\StructType\\CreateOrderItemType',
            'CreateOrderType' => '\\StructType\\CreateOrderType',
            'CryptographyKeyType' => '\\StructType\\CryptographyKeyType',
            'CurParameterType' => '\\StructType\\CurParameterType',
            'CurrentCouponFlightInfoRefType' => '\\StructType\\CurrentCouponFlightInfoRefType',
            'CypherDataType' => '\\StructType\\CypherDataType',
            'DataListsType' => '\\StructType\\DataListsType',
            'DatedMarketingSegmentListType' => '\\StructType\\DatedMarketingSegmentListType',
            'DatedMarketingSegmentType' => '\\StructType\\DatedMarketingSegmentType',
            'DatedOperatingLegListType' => '\\StructType\\DatedOperatingLegListType',
            'DatedOperatingLegRefType' => '\\StructType\\DatedOperatingLegRefType',
            'DatedOperatingLegType' => '\\StructType\\DatedOperatingLegType',
            'DatedOperatingSegmentListType' => '\\StructType\\DatedOperatingSegmentListType',
            'DatedOperatingSegmentType' => '\\StructType\\DatedOperatingSegmentType',
            'DateRangeType' => '\\StructType\\DateRangeType',
            'DateTimeRangeType' => '\\StructType\\DateTimeRangeType',
            'DeliveredOrderItemType' => '\\StructType\\DeliveredOrderItemType',
            'DeliveredOrderType' => '\\StructType\\DeliveredOrderType',
            'DeliveredServiceType' => '\\StructType\\DeliveredServiceType',
            'DeliveryProviderType' => '\\StructType\\DeliveryProviderType',
            'DepFilterCriteriaType' => '\\StructType\\DepFilterCriteriaType',
            'DepType' => '\\StructType\\DepType',
            'DescType' => '\\StructType\\DescType',
            'DestArrivalCriteriaType' => '\\StructType\\DestArrivalCriteriaType',
            'DeviceLocationType' => '\\StructType\\DeviceLocationType',
            'DeviceType' => '\\StructType\\DeviceType',
            'DifferentialFareDetailType' => '\\StructType\\DifferentialFareDetailType',
            'DifferentialFarePriceTypeType' => '\\StructType\\DifferentialFarePriceTypeType',
            'DiffPriceAndFareDetailsType' => '\\StructType\\DiffPriceAndFareDetailsType',
            'DigitalSignatureType' => '\\StructType\\DigitalSignatureType',
            'DimensionAllowanceType' => '\\StructType\\DimensionAllowanceType',
            'DirectBillType' => '\\StructType\\DirectBillType',
            'DirectionalIndType' => '\\StructType\\DirectionalIndType',
            'DisclosureListType' => '\\StructType\\DisclosureListType',
            'DisclosureType' => '\\StructType\\DisclosureType',
            'DiscountType' => '\\StructType\\DiscountType',
            'DistributionChainLinkType' => '\\StructType\\DistributionChainLinkType',
            'DistributionChainType' => '\\StructType\\DistributionChainType',
            'DocNotifCouponType' => '\\StructType\\DocNotifCouponType',
            'DocNotifType' => '\\StructType\\DocNotifType',
            'EligibilityType' => '\\StructType\\EligibilityType',
            'EmailAddressType' => '\\StructType\\EmailAddressType',
            'EmployerType' => '\\StructType\\EmployerType',
            'EncryptedDataType' => '\\StructType\\EncryptedDataType',
            'ErrorType' => '\\StructType\\ErrorType',
            'ExcessBaggageType' => '\\StructType\\ExcessBaggageType',
            'ExistingOrderItemType' => '\\StructType\\ExistingOrderItemType',
            'ExistingOrderType' => '\\StructType\\ExistingOrderType',
            'ExistingServiceType' => '\\StructType\\ExistingServiceType',
            'FareCalculationInfoType' => '\\StructType\\FareCalculationInfoType',
            'FareCriteriaType' => '\\StructType\\FareCriteriaType',
            'FarePriceTypeType' => '\\StructType\\FarePriceTypeType',
            'FareRefType' => '\\StructType\\FareRefType',
            'FareRuleTextCriteriaType' => '\\StructType\\FareRuleTextCriteriaType',
            'FareRuleTextType' => '\\StructType\\FareRuleTextType',
            'FareWaiverType' => '\\StructType\\FareWaiverType',
            'FieldMetadataType' => '\\StructType\\FieldMetadataType',
            'FiledFeeType' => '\\StructType\\FiledFeeType',
            'FilterAirlineProfileType' => '\\StructType\\FilterAirlineProfileType',
            'FlightCharacteristicsCriteriaType' => '\\StructType\\FlightCharacteristicsCriteriaType',
            'FlightCriteriaType' => '\\StructType\\FlightCriteriaType',
            'FlightFilterCriteriaType' => '\\StructType\\FlightFilterCriteriaType',
            'FlightItemType' => '\\StructType\\FlightItemType',
            'FlightRelatedCriteriaType' => '\\StructType\\FlightRelatedCriteriaType',
            'FlightRequestOriginDestinationsCriteriaType' => '\\StructType\\FlightRequestOriginDestinationsCriteriaType',
            'FlightRequestSpecificOriginDestinationsType' => '\\StructType\\FlightRequestSpecificOriginDestinationsType',
            'FlightRequestType' => '\\StructType\\FlightRequestType',
            'FOID_Type' => '\\StructType\\FOID_Type',
            'GeneralAssociationType' => '\\StructType\\GeneralAssociationType',
            'GeographicFilterCriteriaType' => '\\StructType\\GeographicFilterCriteriaType',
            'GeospatialLocationType' => '\\StructType\\GeospatialLocationType',
            'GroupFareCriteriaType' => '\\StructType\\GroupFareCriteriaType',
            'IATA_AircraftTypeType' => '\\StructType\\IATA_AircraftTypeType',
            'IATA_PayloadStandardAttributesType' => '\\StructType\\IATA_PayloadStandardAttributesType',
            'IdentityDocType' => '\\StructType\\IdentityDocType',
            'IndividualType' => '\\StructType\\IndividualType',
            'InterlineALaCarteOfferType' => '\\StructType\\InterlineALaCarteOfferType',
            'InterlineCarrierType' => '\\StructType\\InterlineCarrierType',
            'InterlineFlightRequestOriginDestinationsCriteriaType' => '\\StructType\\InterlineFlightRequestOriginDestinationsCriteriaType',
            'InterlineOfferQueryType' => '\\StructType\\InterlineOfferQueryType',
            'InterlineOfferRequestType' => '\\StructType\\InterlineOfferRequestType',
            'InterlineOfferResponsePayloadType' => '\\StructType\\InterlineOfferResponsePayloadType',
            'InterlineOrderItemType' => '\\StructType\\InterlineOrderItemType',
            'InterlineOrderRequestType' => '\\StructType\\InterlineOrderRequestType',
            'InterlineOrderResponsePayloadType' => '\\StructType\\InterlineOrderResponsePayloadType',
            'InterlineOrderServiceAssociationType' => '\\StructType\\InterlineOrderServiceAssociationType',
            'InterlineOriginDestCriteriaType' => '\\StructType\\InterlineOriginDestCriteriaType',
            'InterlinePaxSegmentCriteriaType' => '\\StructType\\InterlinePaxSegmentCriteriaType',
            'InterlineResponseParametersRequestType' => '\\StructType\\InterlineResponseParametersRequestType',
            'InterlineSearchCriteriaRequestType' => '\\StructType\\InterlineSearchCriteriaRequestType',
            'InterlineServiceType' => '\\StructType\\InterlineServiceType',
            'JourneyDurationCriteriaType' => '\\StructType\\JourneyDurationCriteriaType',
            'JourneyOverviewType' => '\\StructType\\JourneyOverviewType',
            'JourneyPriceClassType' => '\\StructType\\JourneyPriceClassType',
            'KeyValuePropertyType' => '\\StructType\\KeyValuePropertyType',
            'LangUsageType' => '\\StructType\\LangUsageType',
            'LegCabinAssociationsType' => '\\StructType\\LegCabinAssociationsType',
            'LegsAssociatedCabinType' => '\\StructType\\LegsAssociatedCabinType',
            'LoyaltyAmountType' => '\\StructType\\LoyaltyAmountType',
            'LoyaltyProgramAccountType' => '\\StructType\\LoyaltyProgramAccountType',
            'LoyaltyProgramType' => '\\StructType\\LoyaltyProgramType',
            'LoyaltyRedemptionType' => '\\StructType\\LoyaltyRedemptionType',
            'MarketingCarrierInfoType' => '\\StructType\\MarketingCarrierInfoType',
            'MarketingMessageType' => '\\StructType\\MarketingMessageType',
            'MarkupType' => '\\StructType\\MarkupType',
            'MatchedOrderType' => '\\StructType\\MatchedOrderType',
            'MeasureType' => '\\StructType\\MeasureType',
            'MediaResourceRefType' => '\\StructType\\MediaResourceRefType',
            'MetadataType' => '\\StructType\\MetadataType',
            'NameChangeOfferItemType' => '\\StructType\\NameChangeOfferItemType',
            'NameChangeServiceType' => '\\StructType\\NameChangeServiceType',
            'NewOfferItemType' => '\\StructType\\NewOfferItemType',
            'NewOfferType' => '\\StructType\\NewOfferType',
            'NoChangeIndType' => '\\StructType\\NoChangeIndType',
            'OfferCriteriaType' => '\\StructType\\OfferCriteriaType',
            'OfferedServiceType' => '\\StructType\\OfferedServiceType',
            'OfferFilterCriteriaChoiceType' => '\\StructType\\OfferFilterCriteriaChoiceType',
            'OfferFilterCriteriaType' => '\\StructType\\OfferFilterCriteriaType',
            'OfferFilterCriteriawithOriginandDestType' => '\\StructType\\OfferFilterCriteriawithOriginandDestType',
            'OfferFlightAssociationsType' => '\\StructType\\OfferFlightAssociationsType',
            'OfferForfeitedInfoListType' => '\\StructType\\OfferForfeitedInfoListType',
            'OfferForfeitedInfoType' => '\\StructType\\OfferForfeitedInfoType',
            'OfferItemTimeLimitsType' => '\\StructType\\OfferItemTimeLimitsType',
            'OfferItemTypeCriteriaType' => '\\StructType\\OfferItemTypeCriteriaType',
            'OfferItemTypeType' => '\\StructType\\OfferItemTypeType',
            'OfferPenaltyInfoListType' => '\\StructType\\OfferPenaltyInfoListType',
            'OfferPenaltyInfoType' => '\\StructType\\OfferPenaltyInfoType',
            'OfferPriceRequestType' => '\\StructType\\OfferPriceRequestType',
            'OfferPriceResponseType' => '\\StructType\\OfferPriceResponseType',
            'OfferServiceAssociationType' => '\\StructType\\OfferServiceAssociationType',
            'OfferServiceDefinitionRefType' => '\\StructType\\OfferServiceDefinitionRefType',
            'OffersGroupType' => '\\StructType\\OffersGroupType',
            'OffersSummaryType' => '\\StructType\\OffersSummaryType',
            'OfflinePaymentInstructionReceiptType' => '\\StructType\\OfflinePaymentInstructionReceiptType',
            'OfflinePaymentType' => '\\StructType\\OfflinePaymentType',
            'OperatingSegmentCriteriaType' => '\\StructType\\OperatingSegmentCriteriaType',
            'OptionalDataListsType' => '\\StructType\\OptionalDataListsType',
            'OptionalOriginDestListType' => '\\StructType\\OptionalOriginDestListType',
            'OptionalOriginDestType' => '\\StructType\\OptionalOriginDestType',
            'OptionalPaxSegmentListType' => '\\StructType\\OptionalPaxSegmentListType',
            'OrderChangeNotifType' => '\\StructType\\OrderChangeNotifType',
            'OrderChangeRequestType' => '\\StructType\\OrderChangeRequestType',
            'OrderChangeUpdatePaxType' => '\\StructType\\OrderChangeUpdatePaxType',
            'OrderClosingNotifRequestType' => '\\StructType\\OrderClosingNotifRequestType',
            'OrderCreateRequestType' => '\\StructType\\OrderCreateRequestType',
            'OrderCriteriaType' => '\\StructType\\OrderCriteriaType',
            'OrderedOrderInstructionType' => '\\StructType\\OrderedOrderInstructionType',
            'OrderedOrderItemType' => '\\StructType\\OrderedOrderItemType',
            'OrderedOrderType' => '\\StructType\\OrderedOrderType',
            'OrderedServiceAssociationType' => '\\StructType\\OrderedServiceAssociationType',
            'OrderedServiceType' => '\\StructType\\OrderedServiceType',
            'OrderFilterCriteriaType' => '\\StructType\\OrderFilterCriteriaType',
            'OrderFlightAssociationsType' => '\\StructType\\OrderFlightAssociationsType',
            'OrderForfeitedInfoListType' => '\\StructType\\OrderForfeitedInfoListType',
            'OrderForfeitedInfoType' => '\\StructType\\OrderForfeitedInfoType',
            'OrderHistoryRequestType' => '\\StructType\\OrderHistoryRequestType',
            'OrderHistoryResponseType' => '\\StructType\\OrderHistoryResponseType',
            'OrderingQtyType' => '\\StructType\\OrderingQtyType',
            'OrderItemDeletionOfferItemType' => '\\StructType\\OrderItemDeletionOfferItemType',
            'OrderItemKeyType' => '\\StructType\\OrderItemKeyType',
            'OrderKeyType' => '\\StructType\\OrderKeyType',
            'OrderListParametersType' => '\\StructType\\OrderListParametersType',
            'OrderListRequestType' => '\\StructType\\OrderListRequestType',
            'OrderListResponseType' => '\\StructType\\OrderListResponseType',
            'OrderPenaltyInfoListType' => '\\StructType\\OrderPenaltyInfoListType',
            'OrderPenaltyInfoType' => '\\StructType\\OrderPenaltyInfoType',
            'OrderQuotePayloadType' => '\\StructType\\OrderQuotePayloadType',
            'OrderReshopRequestType' => '\\StructType\\OrderReshopRequestType',
            'OrderReshopResponseType' => '\\StructType\\OrderReshopResponseType',
            'OrderRetrieveRequestType' => '\\StructType\\OrderRetrieveRequestType',
            'OrderRulesRequestType' => '\\StructType\\OrderRulesRequestType',
            'OrderRulesResponseType' => '\\StructType\\OrderRulesResponseType',
            'OrderSalesInfoAccountingDocNotifRequestType' => '\\StructType\\OrderSalesInfoAccountingDocNotifRequestType',
            'OrderSalesInfoNotifRequestType' => '\\StructType\\OrderSalesInfoNotifRequestType',
            'OrderSearchFilterCriteriaType' => '\\StructType\\OrderSearchFilterCriteriaType',
            'OrderServiceAssociationType' => '\\StructType\\OrderServiceAssociationType',
            'OrderServiceDefinitionRefType' => '\\StructType\\OrderServiceDefinitionRefType',
            'OrderSnapshotType' => '\\StructType\\OrderSnapshotType',
            'OrderStructureKeyType' => '\\StructType\\OrderStructureKeyType',
            'OrderValidationFilterCriteriaType' => '\\StructType\\OrderValidationFilterCriteriaType',
            'OrderViewResponseType' => '\\StructType\\OrderViewResponseType',
            'OrgType' => '\\StructType\\OrgType',
            'OriginalOrderItemType' => '\\StructType\\OriginalOrderItemType',
            'OriginalTicketIssuanceInfoType' => '\\StructType\\OriginalTicketIssuanceInfoType',
            'OriginDepCriteriaType' => '\\StructType\\OriginDepCriteriaType',
            'OriginDestCriteriaType' => '\\StructType\\OriginDestCriteriaType',
            'OriginDestFilterCriteriaType' => '\\StructType\\OriginDestFilterCriteriaType',
            'OriginDestListType' => '\\StructType\\OriginDestListType',
            'OtherAddressType' => '\\StructType\\OtherAddressType',
            'OtherItemType' => '\\StructType\\OtherItemType',
            'OtherOffersType' => '\\StructType\\OtherOffersType',
            'OtherPaymentMethodType' => '\\StructType\\OtherPaymentMethodType',
            'ParticipatingOrgType' => '\\StructType\\ParticipatingOrgType',
            'PaxFilterCriteriaType' => '\\StructType\\PaxFilterCriteriaType',
            'PaxGroupType' => '\\StructType\\PaxGroupType',
            'PaxJourneyListType' => '\\StructType\\PaxJourneyListType',
            'PaxJourneyRefType' => '\\StructType\\PaxJourneyRefType',
            'PaxJourneyType' => '\\StructType\\PaxJourneyType',
            'PaxListType' => '\\StructType\\PaxListType',
            'PaxNameChangeType' => '\\StructType\\PaxNameChangeType',
            'PaxRefType' => '\\StructType\\PaxRefType',
            'PaxSegmentListType' => '\\StructType\\PaxSegmentListType',
            'PaxSegmentRefListType' => '\\StructType\\PaxSegmentRefListType',
            'PaxSegmentRefType' => '\\StructType\\PaxSegmentRefType',
            'PaxSegmentRequestType' => '\\StructType\\PaxSegmentRequestType',
            'PaxSegmentType' => '\\StructType\\PaxSegmentType',
            'PaxSharingPrefType' => '\\StructType\\PaxSharingPrefType',
            'PaxType' => '\\StructType\\PaxType',
            'PayerIndividualType' => '\\StructType\\PayerIndividualType',
            'PayerNameType' => '\\StructType\\PayerNameType',
            'PayerOrganisationType' => '\\StructType\\PayerOrganisationType',
            'PayerType' => '\\StructType\\PayerType',
            'PayloadRestrictionsType' => '\\StructType\\PayloadRestrictionsType',
            'PaymentAddressType' => '\\StructType\\PaymentAddressType',
            'PaymentAddressVerificationType' => '\\StructType\\PaymentAddressVerificationType',
            'PaymentAssociatedFunctionsCriteriaType' => '\\StructType\\PaymentAssociatedFunctionsCriteriaType',
            'PaymentAssociatedOfferFunctionsCriteriaType' => '\\StructType\\PaymentAssociatedOfferFunctionsCriteriaType',
            'PaymentCardAddlInfoType' => '\\StructType\\PaymentCardAddlInfoType',
            'PaymentCardCriteriaAddlInfoType' => '\\StructType\\PaymentCardCriteriaAddlInfoType',
            'PaymentCardCriteriaType' => '\\StructType\\PaymentCardCriteriaType',
            'PaymentCriteriaAddlInfoType' => '\\StructType\\PaymentCriteriaAddlInfoType',
            'PaymentFilterCriteriaType' => '\\StructType\\PaymentFilterCriteriaType',
            'PaymentFunctionsChangeType' => '\\StructType\\PaymentFunctionsChangeType',
            'PaymentFunctionsCreateType' => '\\StructType\\PaymentFunctionsCreateType',
            'PaymentFunctionsCriteriaType' => '\\StructType\\PaymentFunctionsCriteriaType',
            'PaymentFunctionsOfferType' => '\\StructType\\PaymentFunctionsOfferType',
            'PaymentFunctionsOrderType' => '\\StructType\\PaymentFunctionsOrderType',
            'PaymentInfoListType' => '\\StructType\\PaymentInfoListType',
            'PaymentInfoType' => '\\StructType\\PaymentInfoType',
            'PaymentMethodAddlInfoType' => '\\StructType\\PaymentMethodAddlInfoType',
            'PaymentMethodCriteriaType' => '\\StructType\\PaymentMethodCriteriaType',
            'PaymentMethodType' => '\\StructType\\PaymentMethodType',
            'PaymentOtherMethodAddlInfoType' => '\\StructType\\PaymentOtherMethodAddlInfoType',
            'PaymentProcessingClearanceDataType' => '\\StructType\\PaymentProcessingClearanceDataType',
            'PaymentProcessingDeliveryRequestSummaryType' => '\\StructType\\PaymentProcessingDeliveryRequestSummaryType',
            'PaymentProcessingDeliveryResponseSummaryType' => '\\StructType\\PaymentProcessingDeliveryResponseSummaryType',
            'PaymentProcessingDetailsType' => '\\StructType\\PaymentProcessingDetailsType',
            'PaymentProcessingIATA_EasyPayType' => '\\StructType\\PaymentProcessingIATA_EasyPayType',
            'PaymentProcessingPaymentCardType' => '\\StructType\\PaymentProcessingPaymentCardType',
            'PaymentProcessingSummaryPaymentMethodType' => '\\StructType\\PaymentProcessingSummaryPaymentMethodType',
            'PaymentProcessingSummaryType' => '\\StructType\\PaymentProcessingSummaryType',
            'PaymentRedirectionResponseType' => '\\StructType\\PaymentRedirectionResponseType',
            'PaymentSupportedMethodType' => '\\StructType\\PaymentSupportedMethodType',
            'PaymentSurchargeType' => '\\StructType\\PaymentSurchargeType',
            'PaymentTimeLimitDateType' => '\\StructType\\PaymentTimeLimitDateType',
            'PaymentTimeLimitDurationType' => '\\StructType\\PaymentTimeLimitDurationType',
            'PaymentTimeLimitType' => '\\StructType\\PaymentTimeLimitType',
            'PaymentTrxType' => '\\StructType\\PaymentTrxType',
            'PenaltyDetailsType' => '\\StructType\\PenaltyDetailsType',
            'PenaltyInfoPriceType' => '\\StructType\\PenaltyInfoPriceType',
            'PenaltyListType' => '\\StructType\\PenaltyListType',
            'PenaltyPriceType' => '\\StructType\\PenaltyPriceType',
            'PenaltyRefType' => '\\StructType\\PenaltyRefType',
            'PenaltyType' => '\\StructType\\PenaltyType',
            'PhoneType' => '\\StructType\\PhoneType',
            'PieceAllowanceType' => '\\StructType\\PieceAllowanceType',
            'PolicyNodeInfoType' => '\\StructType\\PolicyNodeInfoType',
            'PolicyType' => '\\StructType\\PolicyType',
            'POS_FilterCriteriaType' => '\\StructType\\POS_FilterCriteriaType',
            'POS_Type' => '\\StructType\\POS_Type',
            'PostalAddressType' => '\\StructType\\PostalAddressType',
            'PrefLevelType' => '\\StructType\\PrefLevelType',
            'PrePaidCertificateType' => '\\StructType\\PrePaidCertificateType',
            'PriceAndFareDetailsType' => '\\StructType\\PriceAndFareDetailsType',
            'PriceCalendarDateType' => '\\StructType\\PriceCalendarDateType',
            'PriceCalendarType' => '\\StructType\\PriceCalendarType',
            'PriceClassListType' => '\\StructType\\PriceClassListType',
            'PriceClassType' => '\\StructType\\PriceClassType',
            'PricedOfferType' => '\\StructType\\PricedOfferType',
            'PriceSummaryType' => '\\StructType\\PriceSummaryType',
            'PriceVarianceRuleType' => '\\StructType\\PriceVarianceRuleType',
            'PricingMethodCriteriaType' => '\\StructType\\PricingMethodCriteriaType',
            'PricingParameterType' => '\\StructType\\PricingParameterType',
            'ProgamContractType' => '\\StructType\\ProgamContractType',
            'ProgramAccountType' => '\\StructType\\ProgramAccountType',
            'ProgramCriteriaType' => '\\StructType\\ProgramCriteriaType',
            'ProgramOwnerType' => '\\StructType\\ProgramOwnerType',
            'PromotionIssuerType' => '\\StructType\\PromotionIssuerType',
            'PromotionListType' => '\\StructType\\PromotionListType',
            'PromotionType' => '\\StructType\\PromotionType',
            'PTC_OfferParametersType' => '\\StructType\\PTC_OfferParametersType',
            'RateType' => '\\StructType\\RateType',
            'ReceiptIATA_EasyPayType' => '\\StructType\\ReceiptIATA_EasyPayType',
            'ReceiptPaymentCardType' => '\\StructType\\ReceiptPaymentCardType',
            'RedressCaseType' => '\\StructType\\RedressCaseType',
            'RefundFOP_Type' => '\\StructType\\RefundFOP_Type',
            'RefundMethodCriteriaType' => '\\StructType\\RefundMethodCriteriaType',
            'RefundPaymentCardType' => '\\StructType\\RefundPaymentCardType',
            'RemarkType' => '\\StructType\\RemarkType',
            'RepricedOfferItemType' => '\\StructType\\RepricedOfferItemType',
            'RepricedOfferType' => '\\StructType\\RepricedOfferType',
            'RepricedOrderType' => '\\StructType\\RepricedOrderType',
            'ResChangeInfoType' => '\\StructType\\ResChangeInfoType',
            'ReshopOffersType' => '\\StructType\\ReshopOffersType',
            'ReshopOrderChoiceType' => '\\StructType\\ReshopOrderChoiceType',
            'ReshopOrderType' => '\\StructType\\ReshopOrderType',
            'ReshopPriceType' => '\\StructType\\ReshopPriceType',
            'ReshopResultsType' => '\\StructType\\ReshopResultsType',
            'ResponseParametersOrderChangeType' => '\\StructType\\ResponseParametersOrderChangeType',
            'ResponseParametersRequestType' => '\\StructType\\ResponseParametersRequestType',
            'ResponseParametersResponseType' => '\\StructType\\ResponseParametersResponseType',
            'RetailerOrderInfoType' => '\\StructType\\RetailerOrderInfoType',
            'RSA_KeyValueType' => '\\StructType\\RSA_KeyValueType',
            'RulesCoreRequestType' => '\\StructType\\RulesCoreRequestType',
            'RulesFareComponentType' => '\\StructType\\RulesFareComponentType',
            'RulesFareDetailType' => '\\StructType\\RulesFareDetailType',
            'RulesPenaltyType' => '\\StructType\\RulesPenaltyType',
            'RulesType' => '\\StructType\\RulesType',
            'SalesAgentType' => '\\StructType\\SalesAgentType',
            'SalesBranchType' => '\\StructType\\SalesBranchType',
            'SalesTaxRegistrationType' => '\\StructType\\SalesTaxRegistrationType',
            'SeatAssignmentAssociationsType' => '\\StructType\\SeatAssignmentAssociationsType',
            'SeatAssignmentType' => '\\StructType\\SeatAssignmentType',
            'SeatAvailCoreRequestType' => '\\StructType\\SeatAvailCoreRequestType',
            'SeatAvailOfferItemType' => '\\StructType\\SeatAvailOfferItemType',
            'SeatAvailOfferRequestType' => '\\StructType\\SeatAvailOfferRequestType',
            'SeatAvailOfferType' => '\\StructType\\SeatAvailOfferType',
            'SeatAvailOrderRequestType' => '\\StructType\\SeatAvailOrderRequestType',
            'SeatAvailRequestOrderItemType' => '\\StructType\\SeatAvailRequestOrderItemType',
            'SeatAvailRequestOrderType' => '\\StructType\\SeatAvailRequestOrderType',
            'SeatAvailRequestType' => '\\StructType\\SeatAvailRequestType',
            'SeatAvailResponseType' => '\\StructType\\SeatAvailResponseType',
            'SeatColumnType' => '\\StructType\\SeatColumnType',
            'SeatCriteriaType' => '\\StructType\\SeatCriteriaType',
            'SeatItemType' => '\\StructType\\SeatItemType',
            'SeatMapType' => '\\StructType\\SeatMapType',
            'SeatOnLegType' => '\\StructType\\SeatOnLegType',
            'SeatProfileCriteriaType' => '\\StructType\\SeatProfileCriteriaType',
            'SeatProfileListType' => '\\StructType\\SeatProfileListType',
            'SeatProfileRefType' => '\\StructType\\SeatProfileRefType',
            'SeatProfileType' => '\\StructType\\SeatProfileType',
            'SeatRowType' => '\\StructType\\SeatRowType',
            'SeatType' => '\\StructType\\SeatType',
            'SecurePaymentAuthenticationInstructionsVersion1Type' => '\\StructType\\SecurePaymentAuthenticationInstructionsVersion1Type',
            'SecurePaymentAuthenticationInstructionsVersion2Type' => '\\StructType\\SecurePaymentAuthenticationInstructionsVersion2Type',
            'SecurePaymentAuthenticationVersionType' => '\\StructType\\SecurePaymentAuthenticationVersionType',
            'SecurePaymentVersion1Type' => '\\StructType\\SecurePaymentVersion1Type',
            'SecurePaymentVersion2Type' => '\\StructType\\SecurePaymentVersion2Type',
            'SecureProgramType' => '\\StructType\\SecureProgramType',
            'SegmentDurationCriteriaType' => '\\StructType\\SegmentDurationCriteriaType',
            'SegmentFilterCriteriaType' => '\\StructType\\SegmentFilterCriteriaType',
            'SelectedALaCarteOfferItemType' => '\\StructType\\SelectedALaCarteOfferItemType',
            'SelectedBundleServicesType' => '\\StructType\\SelectedBundleServicesType',
            'SelectedOfferItemType' => '\\StructType\\SelectedOfferItemType',
            'SelectedOfferListType' => '\\StructType\\SelectedOfferListType',
            'SelectedOfferType' => '\\StructType\\SelectedOfferType',
            'SelectedOrderItemType' => '\\StructType\\SelectedOrderItemType',
            'SelectedPricedOfferType' => '\\StructType\\SelectedPricedOfferType',
            'SelectedSeatType' => '\\StructType\\SelectedSeatType',
            'SellerFollowUpActionType' => '\\StructType\\SellerFollowUpActionType',
            'ServiceBundleType' => '\\StructType\\ServiceBundleType',
            'ServiceCriteriaType' => '\\StructType\\ServiceCriteriaType',
            'ServiceDefinitionAssociationType' => '\\StructType\\ServiceDefinitionAssociationType',
            'ServiceDefinitionListType' => '\\StructType\\ServiceDefinitionListType',
            'ServiceDefinitionType' => '\\StructType\\ServiceDefinitionType',
            'ServiceDeliveryDataListsType' => '\\StructType\\ServiceDeliveryDataListsType',
            'ServiceDeliveryNotifRequestType' => '\\StructType\\ServiceDeliveryNotifRequestType',
            'ServiceDeliveryPaxSegmentListType' => '\\StructType\\ServiceDeliveryPaxSegmentListType',
            'ServiceDeliveryRequestType' => '\\StructType\\ServiceDeliveryRequestType',
            'ServiceDeliveryResponseType' => '\\StructType\\ServiceDeliveryResponseType',
            'ServiceFilterCriteriaType' => '\\StructType\\ServiceFilterCriteriaType',
            'ServiceIdKeyType' => '\\StructType\\ServiceIdKeyType',
            'ServiceKeyType' => '\\StructType\\ServiceKeyType',
            'ServiceListCoreRequestType' => '\\StructType\\ServiceListCoreRequestType',
            'ServiceListOfferItemType' => '\\StructType\\ServiceListOfferItemType',
            'ServiceListOfferRequestType' => '\\StructType\\ServiceListOfferRequestType',
            'ServiceListOfferType' => '\\StructType\\ServiceListOfferType',
            'ServiceListOrderRequestType' => '\\StructType\\ServiceListOrderRequestType',
            'ServiceListRequestType' => '\\StructType\\ServiceListRequestType',
            'ServiceListResponseType' => '\\StructType\\ServiceListResponseType',
            'ServiceOrderType' => '\\StructType\\ServiceOrderType',
            'ServiceRequestOrderItemType' => '\\StructType\\ServiceRequestOrderItemType',
            'ServiceRequestOrderType' => '\\StructType\\ServiceRequestOrderType',
            'ServiceStatusChangeNotifRequestType' => '\\StructType\\ServiceStatusChangeNotifRequestType',
            'SettlementInfoType' => '\\StructType\\SettlementInfoType',
            'SettlementPlanType' => '\\StructType\\SettlementPlanType',
            'ShopandReshopRequestPaxSegmentType' => '\\StructType\\ShopandReshopRequestPaxSegmentType',
            'ShoppingRequestCabinTypeType' => '\\StructType\\ShoppingRequestCabinTypeType',
            'ShoppingRequestDataListsType' => '\\StructType\\ShoppingRequestDataListsType',
            'ShoppingRequestPaxJourneyListType' => '\\StructType\\ShoppingRequestPaxJourneyListType',
            'ShoppingRequestPaxJourneyType' => '\\StructType\\ShoppingRequestPaxJourneyType',
            'ShoppingRequestPaxSegmentListType' => '\\StructType\\ShoppingRequestPaxSegmentListType',
            'ShoppingRequestPaxSegmentType' => '\\StructType\\ShoppingRequestPaxSegmentType',
            'SpecialServiceListType' => '\\StructType\\SpecialServiceListType',
            'SpecialServiceType' => '\\StructType\\SpecialServiceType',
            'StationCriteriaType' => '\\StructType\\StationCriteriaType',
            'StationType' => '\\StructType\\StationType',
            'StayPeriodType' => '\\StructType\\StayPeriodType',
            'StopOverLocationType' => '\\StructType\\StopOverLocationType',
            'StopOverRestrictionsType' => '\\StructType\\StopOverRestrictionsType',
            'SupplierOfferedServiceType' => '\\StructType\\SupplierOfferedServiceType',
            'SupplierOfferItemType' => '\\StructType\\SupplierOfferItemType',
            'SupplierOfferType' => '\\StructType\\SupplierOfferType',
            'SupplierOrderedServiceType' => '\\StructType\\SupplierOrderedServiceType',
            'SupplierOrderItemType' => '\\StructType\\SupplierOrderItemType',
            'SupplierOrderType' => '\\StructType\\SupplierOrderType',
            'SupplierPriceType' => '\\StructType\\SupplierPriceType',
            'TaxonomyFeatureType' => '\\StructType\\TaxonomyFeatureType',
            'TermsListType' => '\\StructType\\TermsListType',
            'TermType' => '\\StructType\\TermType',
            'TicketDocInfoType' => '\\StructType\\TicketDocInfoType',
            'TicketFilterCriteriaType' => '\\StructType\\TicketFilterCriteriaType',
            'TicketIssuanceInfoType' => '\\StructType\\TicketIssuanceInfoType',
            'TicketRefIdentificationType' => '\\StructType\\TicketRefIdentificationType',
            'TicketType' => '\\StructType\\TicketType',
            'TransportPointType' => '\\StructType\\TransportPointType',
            'TravelAgencyType' => '\\StructType\\TravelAgencyType',
            'TravelAgentType' => '\\StructType\\TravelAgentType',
            'UpdateOrderType' => '\\StructType\\UpdateOrderType',
            'UpdatePaxNameType' => '\\StructType\\UpdatePaxNameType',
            'UpdatePaxType' => '\\StructType\\UpdatePaxType',
            'UpdateServiceNotifRequestType' => '\\StructType\\UpdateServiceNotifRequestType',
            'VAT_BreakdownElementType' => '\\StructType\\VAT_BreakdownElementType',
            'VisaType' => '\\StructType\\VisaType',
            'VoucherType' => '\\StructType\\VoucherType',
            'WarningType' => '\\StructType\\WarningType',
            'WeightAllowanceType' => '\\StructType\\WeightAllowanceType',
            'IATA_AirShoppingRQ' => '\\StructType\\IATA_AirShoppingRQ',
            'FlxTransaction' => '\\StructType\\FlxTransaction',
            'IATA_AirShoppingRS' => '\\StructType\\IATA_AirShoppingRS',
            'FlxTransactionResponse' => '\\StructType\\FlxTransactionResponse',
        );
    }
}
