<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WeightAllowanceType StructType
 * Meta information extracted from the WSDL
 * - documentation: Baggage weight allowance with application information.
 * @subpackage Structs
 */
class WeightAllowanceType extends AbstractStructBase
{
    /**
     * The WeightUnitOfMeasurement
     * Meta information extracted from the WSDL
     * - documentation: The unit of measurement of weight defined as imperial or metric. | Specifies Weight Unit code list.
     * - base: WeightUnitCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $WeightUnitOfMeasurement;
    /**
     * The MaximumWeightMeasure
     * Meta information extracted from the WSDL
     * - documentation: Maximum weight value and unit of measure. Example: 50 | A numeric value determining a weight along with the specified unit of measure.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $MaximumWeightMeasure;
    /**
     * The MinimumWeightMeasure
     * Meta information extracted from the WSDL
     * - documentation: Minimum weight value and unit of measure. Example: 50 | A numeric value determining a weight along with the specified unit of measure.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $MinimumWeightMeasure;
    /**
     * The TotalMaximumWeightMeasure
     * Meta information extracted from the WSDL
     * - documentation: Stores the maximum weight for all the combined pieces within this baggage allowance. | A numeric value determining a weight along with the specified unit of measure.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $TotalMaximumWeightMeasure;
    /**
     * Constructor method for WeightAllowanceType
     * @uses WeightAllowanceType::setWeightUnitOfMeasurement()
     * @uses WeightAllowanceType::setMaximumWeightMeasure()
     * @uses WeightAllowanceType::setMinimumWeightMeasure()
     * @uses WeightAllowanceType::setTotalMaximumWeightMeasure()
     * @param string $weightUnitOfMeasurement
     * @param float $maximumWeightMeasure
     * @param float $minimumWeightMeasure
     * @param float $totalMaximumWeightMeasure
     */
    public function __construct($weightUnitOfMeasurement = null, $maximumWeightMeasure = null, $minimumWeightMeasure = null, $totalMaximumWeightMeasure = null)
    {
        $this
            ->setWeightUnitOfMeasurement($weightUnitOfMeasurement)
            ->setMaximumWeightMeasure($maximumWeightMeasure)
            ->setMinimumWeightMeasure($minimumWeightMeasure)
            ->setTotalMaximumWeightMeasure($totalMaximumWeightMeasure);
    }
    /**
     * Get WeightUnitOfMeasurement value
     * @return string
     */
    public function getWeightUnitOfMeasurement()
    {
        return $this->WeightUnitOfMeasurement;
    }
    /**
     * Set WeightUnitOfMeasurement value
     * @param string $weightUnitOfMeasurement
     * @return \StructType\WeightAllowanceType
     */
    public function setWeightUnitOfMeasurement($weightUnitOfMeasurement = null)
    {
        // validation for constraint: string
        if (!is_null($weightUnitOfMeasurement) && !is_string($weightUnitOfMeasurement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($weightUnitOfMeasurement, true), gettype($weightUnitOfMeasurement)), __LINE__);
        }
        $this->WeightUnitOfMeasurement = $weightUnitOfMeasurement;
        return $this;
    }
    /**
     * Get MaximumWeightMeasure value
     * @return float|null
     */
    public function getMaximumWeightMeasure()
    {
        return $this->MaximumWeightMeasure;
    }
    /**
     * Set MaximumWeightMeasure value
     * @param float $maximumWeightMeasure
     * @return \StructType\WeightAllowanceType
     */
    public function setMaximumWeightMeasure($maximumWeightMeasure = null)
    {
        // validation for constraint: float
        if (!is_null($maximumWeightMeasure) && !(is_float($maximumWeightMeasure) || is_numeric($maximumWeightMeasure))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maximumWeightMeasure, true), gettype($maximumWeightMeasure)), __LINE__);
        }
        $this->MaximumWeightMeasure = $maximumWeightMeasure;
        return $this;
    }
    /**
     * Get MinimumWeightMeasure value
     * @return float|null
     */
    public function getMinimumWeightMeasure()
    {
        return $this->MinimumWeightMeasure;
    }
    /**
     * Set MinimumWeightMeasure value
     * @param float $minimumWeightMeasure
     * @return \StructType\WeightAllowanceType
     */
    public function setMinimumWeightMeasure($minimumWeightMeasure = null)
    {
        // validation for constraint: float
        if (!is_null($minimumWeightMeasure) && !(is_float($minimumWeightMeasure) || is_numeric($minimumWeightMeasure))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minimumWeightMeasure, true), gettype($minimumWeightMeasure)), __LINE__);
        }
        $this->MinimumWeightMeasure = $minimumWeightMeasure;
        return $this;
    }
    /**
     * Get TotalMaximumWeightMeasure value
     * @return float|null
     */
    public function getTotalMaximumWeightMeasure()
    {
        return $this->TotalMaximumWeightMeasure;
    }
    /**
     * Set TotalMaximumWeightMeasure value
     * @param float $totalMaximumWeightMeasure
     * @return \StructType\WeightAllowanceType
     */
    public function setTotalMaximumWeightMeasure($totalMaximumWeightMeasure = null)
    {
        // validation for constraint: float
        if (!is_null($totalMaximumWeightMeasure) && !(is_float($totalMaximumWeightMeasure) || is_numeric($totalMaximumWeightMeasure))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalMaximumWeightMeasure, true), gettype($totalMaximumWeightMeasure)), __LINE__);
        }
        $this->TotalMaximumWeightMeasure = $totalMaximumWeightMeasure;
        return $this;
    }
}
