<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebLinks StructType
 * Meta information extracted from the WSDL
 * - documentation: Links to associated promotional material
 * @subpackage Structs
 */
class WebLinks extends AbstractStructBase
{
    /**
     * The WebLink
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\WebLink[]
     */
    public $WebLink;
    /**
     * Constructor method for WebLinks
     * @uses WebLinks::setWebLink()
     * @param \StructType\WebLink[] $webLink
     */
    public function __construct(array $webLink = array())
    {
        $this
            ->setWebLink($webLink);
    }
    /**
     * Get WebLink value
     * @return \StructType\WebLink[]|null
     */
    public function getWebLink()
    {
        return $this->WebLink;
    }
    /**
     * This method is responsible for validating the values passed to the setWebLink method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWebLink method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWebLinkForArrayConstraintsFromSetWebLink(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $webLinksWebLinkItem) {
            // validation for constraint: itemType
            if (!$webLinksWebLinkItem instanceof \StructType\WebLink) {
                $invalidValues[] = is_object($webLinksWebLinkItem) ? get_class($webLinksWebLinkItem) : sprintf('%s(%s)', gettype($webLinksWebLinkItem), var_export($webLinksWebLinkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WebLink property can only contain items of type \StructType\WebLink, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WebLink value
     * @throws \InvalidArgumentException
     * @param \StructType\WebLink[] $webLink
     * @return \StructType\WebLinks
     */
    public function setWebLink(array $webLink = array())
    {
        // validation for constraint: array
        if ('' !== ($webLinkArrayErrorMessage = self::validateWebLinkForArrayConstraintsFromSetWebLink($webLink))) {
            throw new \InvalidArgumentException($webLinkArrayErrorMessage, __LINE__);
        }
        $this->WebLink = $webLink;
        return $this;
    }
    /**
     * Add item to WebLink value
     * @throws \InvalidArgumentException
     * @param \StructType\WebLink $item
     * @return \StructType\WebLinks
     */
    public function addToWebLink(\StructType\WebLink $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WebLink) {
            throw new \InvalidArgumentException(sprintf('The WebLink property can only contain items of type \StructType\WebLink, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WebLink[] = $item;
        return $this;
    }
}
