<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VoucherImage StructType
 * @subpackage Structs
 */
class VoucherImage extends AbstractStructBase
{
    /**
     * The PassengerReferences
     * Meta information extracted from the WSDL
     * - documentation: Association to multiple Passenger instance(s). Example: pax1 pax2
     * @var string
     */
    public $PassengerReferences;
    /**
     * The SegmentReferences
     * @var string
     */
    public $SegmentReferences;
    /**
     * The VoucherNumber
     * Meta information extracted from the WSDL
     * - documentation: Voucher Number for this voucher Example: 1
     * @var string
     */
    public $VoucherNumber;
    /**
     * The Image
     * @var \StructType\Image
     */
    public $Image;
    /**
     * The WebLinks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\WebLinks
     */
    public $WebLinks;
    /**
     * Constructor method for VoucherImage
     * @uses VoucherImage::setPassengerReferences()
     * @uses VoucherImage::setSegmentReferences()
     * @uses VoucherImage::setVoucherNumber()
     * @uses VoucherImage::setImage()
     * @uses VoucherImage::setWebLinks()
     * @param string $passengerReferences
     * @param string $segmentReferences
     * @param string $voucherNumber
     * @param \StructType\Image $image
     * @param \StructType\WebLinks $webLinks
     */
    public function __construct($passengerReferences = null, $segmentReferences = null, $voucherNumber = null, \StructType\Image $image = null, \StructType\WebLinks $webLinks = null)
    {
        $this
            ->setPassengerReferences($passengerReferences)
            ->setSegmentReferences($segmentReferences)
            ->setVoucherNumber($voucherNumber)
            ->setImage($image)
            ->setWebLinks($webLinks);
    }
    /**
     * Get PassengerReferences value
     * @return string|null
     */
    public function getPassengerReferences()
    {
        return $this->PassengerReferences;
    }
    /**
     * Set PassengerReferences value
     * @param string $passengerReferences
     * @return \StructType\VoucherImage
     */
    public function setPassengerReferences($passengerReferences = null)
    {
        // validation for constraint: string
        if (!is_null($passengerReferences) && !is_string($passengerReferences)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passengerReferences, true), gettype($passengerReferences)), __LINE__);
        }
        $this->PassengerReferences = $passengerReferences;
        return $this;
    }
    /**
     * Get SegmentReferences value
     * @return string|null
     */
    public function getSegmentReferences()
    {
        return $this->SegmentReferences;
    }
    /**
     * Set SegmentReferences value
     * @param string $segmentReferences
     * @return \StructType\VoucherImage
     */
    public function setSegmentReferences($segmentReferences = null)
    {
        // validation for constraint: string
        if (!is_null($segmentReferences) && !is_string($segmentReferences)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($segmentReferences, true), gettype($segmentReferences)), __LINE__);
        }
        $this->SegmentReferences = $segmentReferences;
        return $this;
    }
    /**
     * Get VoucherNumber value
     * @return string|null
     */
    public function getVoucherNumber()
    {
        return $this->VoucherNumber;
    }
    /**
     * Set VoucherNumber value
     * @param string $voucherNumber
     * @return \StructType\VoucherImage
     */
    public function setVoucherNumber($voucherNumber = null)
    {
        // validation for constraint: string
        if (!is_null($voucherNumber) && !is_string($voucherNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherNumber, true), gettype($voucherNumber)), __LINE__);
        }
        $this->VoucherNumber = $voucherNumber;
        return $this;
    }
    /**
     * Get Image value
     * @return \StructType\Image|null
     */
    public function getImage()
    {
        return $this->Image;
    }
    /**
     * Set Image value
     * @param \StructType\Image $image
     * @return \StructType\VoucherImage
     */
    public function setImage(\StructType\Image $image = null)
    {
        $this->Image = $image;
        return $this;
    }
    /**
     * Get WebLinks value
     * @return \StructType\WebLinks|null
     */
    public function getWebLinks()
    {
        return $this->WebLinks;
    }
    /**
     * Set WebLinks value
     * @param \StructType\WebLinks $webLinks
     * @return \StructType\VoucherImage
     */
    public function setWebLinks(\StructType\WebLinks $webLinks = null)
    {
        $this->WebLinks = $webLinks;
        return $this;
    }
}
