<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserInput StructType
 * Meta information extracted from the WSDL
 * - documentation: To be used when agent needs to supply additional information or make choices in order to book an ancillary service
 * @subpackage Structs
 */
class UserInput extends AbstractStructBase
{
    /**
     * The OrderItemID
     * Meta information extracted from the WSDL
     * - documentation: The airline-assigned unique Order Item ID. Example: ORD769-A850-4EC4-8F46-02293F72D7E6
     * - choice: OrderItemID | OfferItemID
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $OrderItemID;
    /**
     * The OfferItemID
     * Meta information extracted from the WSDL
     * - documentation: Reference to the OfferItemID of the selected OfferItem (contained in either a standard Offer or an a-la-carte Offer) returned in a previous shopping response.
     * - choice: OrderItemID | OfferItemID
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $OfferItemID;
    /**
     * The UserText
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UserText[]
     */
    public $UserText;
    /**
     * The UserChoices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UserChoices
     */
    public $UserChoices;
    /**
     * Constructor method for UserInput
     * @uses UserInput::setOrderItemID()
     * @uses UserInput::setOfferItemID()
     * @uses UserInput::setUserText()
     * @uses UserInput::setUserChoices()
     * @param string[] $orderItemID
     * @param string[] $offerItemID
     * @param \StructType\UserText[] $userText
     * @param \StructType\UserChoices $userChoices
     */
    public function __construct(array $orderItemID = array(), array $offerItemID = array(), array $userText = array(), \StructType\UserChoices $userChoices = null)
    {
        $this
            ->setOrderItemID($orderItemID)
            ->setOfferItemID($offerItemID)
            ->setUserText($userText)
            ->setUserChoices($userChoices);
    }
    /**
     * Get OrderItemID value
     * @return string[]|null
     */
    public function getOrderItemID()
    {
        return isset($this->OrderItemID) ? $this->OrderItemID : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderItemID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderItemID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderItemIDForArrayConstraintsFromSetOrderItemID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $userInputOrderItemIDItem) {
            // validation for constraint: itemType
            if (!is_string($userInputOrderItemIDItem)) {
                $invalidValues[] = is_object($userInputOrderItemIDItem) ? get_class($userInputOrderItemIDItem) : sprintf('%s(%s)', gettype($userInputOrderItemIDItem), var_export($userInputOrderItemIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OrderItemID property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setOrderItemID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderItemID method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateOrderItemIDForChoiceConstraintsFromSetOrderItemID($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'OfferItemID',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property OrderItemID can\'t be set as the property %s is already set. Only one property must be set among these properties: OrderItemID, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set OrderItemID value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param string[] $orderItemID
     * @return \StructType\UserInput
     */
    public function setOrderItemID(array $orderItemID = array())
    {
        // validation for constraint: array
        if ('' !== ($orderItemIDArrayErrorMessage = self::validateOrderItemIDForArrayConstraintsFromSetOrderItemID($orderItemID))) {
            throw new \InvalidArgumentException($orderItemIDArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(OrderItemID, OfferItemID)
        if ('' !== ($orderItemIDChoiceErrorMessage = self::validateOrderItemIDForChoiceConstraintsFromSetOrderItemID($orderItemID))) {
            throw new \InvalidArgumentException($orderItemIDChoiceErrorMessage, __LINE__);
        }
        if (is_null($orderItemID) || (is_array($orderItemID) && empty($orderItemID))) {
            unset($this->OrderItemID);
        } else {
            $this->OrderItemID = $orderItemID;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToOrderItemID method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToOrderItemID method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToOrderItemID($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'OfferItemID',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property OrderItemID can\'t be set as the property %s is already set. Only one property must be set among these properties: OrderItemID, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to OrderItemID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\UserInput
     */
    public function addToOrderItemID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The OrderItemID property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(OrderItemID, OfferItemID)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToOrderItemID($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->OrderItemID[] = $item;
        return $this;
    }
    /**
     * Get OfferItemID value
     * @return string[]|null
     */
    public function getOfferItemID()
    {
        return isset($this->OfferItemID) ? $this->OfferItemID : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOfferItemID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOfferItemID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOfferItemIDForArrayConstraintsFromSetOfferItemID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $userInputOfferItemIDItem) {
            // validation for constraint: itemType
            if (!is_string($userInputOfferItemIDItem)) {
                $invalidValues[] = is_object($userInputOfferItemIDItem) ? get_class($userInputOfferItemIDItem) : sprintf('%s(%s)', gettype($userInputOfferItemIDItem), var_export($userInputOfferItemIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OfferItemID property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setOfferItemID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOfferItemID method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateOfferItemIDForChoiceConstraintsFromSetOfferItemID($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'OrderItemID',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property OfferItemID can\'t be set as the property %s is already set. Only one property must be set among these properties: OfferItemID, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set OfferItemID value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param string[] $offerItemID
     * @return \StructType\UserInput
     */
    public function setOfferItemID(array $offerItemID = array())
    {
        // validation for constraint: array
        if ('' !== ($offerItemIDArrayErrorMessage = self::validateOfferItemIDForArrayConstraintsFromSetOfferItemID($offerItemID))) {
            throw new \InvalidArgumentException($offerItemIDArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(OrderItemID, OfferItemID)
        if ('' !== ($offerItemIDChoiceErrorMessage = self::validateOfferItemIDForChoiceConstraintsFromSetOfferItemID($offerItemID))) {
            throw new \InvalidArgumentException($offerItemIDChoiceErrorMessage, __LINE__);
        }
        if (is_null($offerItemID) || (is_array($offerItemID) && empty($offerItemID))) {
            unset($this->OfferItemID);
        } else {
            $this->OfferItemID = $offerItemID;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToOfferItemID method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToOfferItemID method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToOfferItemID($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'OrderItemID',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property OfferItemID can\'t be set as the property %s is already set. Only one property must be set among these properties: OfferItemID, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to OfferItemID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\UserInput
     */
    public function addToOfferItemID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The OfferItemID property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(OrderItemID, OfferItemID)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToOfferItemID($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->OfferItemID[] = $item;
        return $this;
    }
    /**
     * Get UserText value
     * @return \StructType\UserText[]|null
     */
    public function getUserText()
    {
        return $this->UserText;
    }
    /**
     * This method is responsible for validating the values passed to the setUserText method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUserText method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUserTextForArrayConstraintsFromSetUserText(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $userInputUserTextItem) {
            // validation for constraint: itemType
            if (!$userInputUserTextItem instanceof \StructType\UserText) {
                $invalidValues[] = is_object($userInputUserTextItem) ? get_class($userInputUserTextItem) : sprintf('%s(%s)', gettype($userInputUserTextItem), var_export($userInputUserTextItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UserText property can only contain items of type \StructType\UserText, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UserText value
     * @throws \InvalidArgumentException
     * @param \StructType\UserText[] $userText
     * @return \StructType\UserInput
     */
    public function setUserText(array $userText = array())
    {
        // validation for constraint: array
        if ('' !== ($userTextArrayErrorMessage = self::validateUserTextForArrayConstraintsFromSetUserText($userText))) {
            throw new \InvalidArgumentException($userTextArrayErrorMessage, __LINE__);
        }
        $this->UserText = $userText;
        return $this;
    }
    /**
     * Add item to UserText value
     * @throws \InvalidArgumentException
     * @param \StructType\UserText $item
     * @return \StructType\UserInput
     */
    public function addToUserText(\StructType\UserText $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UserText) {
            throw new \InvalidArgumentException(sprintf('The UserText property can only contain items of type \StructType\UserText, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UserText[] = $item;
        return $this;
    }
    /**
     * Get UserChoices value
     * @return \StructType\UserChoices|null
     */
    public function getUserChoices()
    {
        return $this->UserChoices;
    }
    /**
     * Set UserChoices value
     * @param \StructType\UserChoices $userChoices
     * @return \StructType\UserInput
     */
    public function setUserChoices(\StructType\UserChoices $userChoices = null)
    {
        $this->UserChoices = $userChoices;
        return $this;
    }
}
