<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserChoices StructType
 * Meta information extracted from the WSDL
 * - documentation: provides arrays of choices from which the user has to choose from
 * @subpackage Structs
 */
class UserChoices extends AbstractStructBase
{
    /**
     * The UserInstruction
     * Meta information extracted from the WSDL
     * - documentation: Provides instructions for user regarding the required input. A client app should use this as a label for the user input boxSample: Select desired flight option
     * - use: required
     * @var string
     */
    public $UserInstruction;
    /**
     * The Required
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the user input is mandatory (required) or not (optional)Allowed values: Y/N
     * - use: required
     * @var string
     */
    public $Required;
    /**
     * The FlightOptions
     * Meta information extracted from the WSDL
     * - ref: FlightOptions
     * @var \StructType\FlightOptions
     */
    public $FlightOptions;
    /**
     * Constructor method for UserChoices
     * @uses UserChoices::setUserInstruction()
     * @uses UserChoices::setRequired()
     * @uses UserChoices::setFlightOptions()
     * @param string $userInstruction
     * @param string $required
     * @param \StructType\FlightOptions $flightOptions
     */
    public function __construct($userInstruction = null, $required = null, \StructType\FlightOptions $flightOptions = null)
    {
        $this
            ->setUserInstruction($userInstruction)
            ->setRequired($required)
            ->setFlightOptions($flightOptions);
    }
    /**
     * Get UserInstruction value
     * @return string
     */
    public function getUserInstruction()
    {
        return $this->UserInstruction;
    }
    /**
     * Set UserInstruction value
     * @param string $userInstruction
     * @return \StructType\UserChoices
     */
    public function setUserInstruction($userInstruction = null)
    {
        // validation for constraint: string
        if (!is_null($userInstruction) && !is_string($userInstruction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userInstruction, true), gettype($userInstruction)), __LINE__);
        }
        $this->UserInstruction = $userInstruction;
        return $this;
    }
    /**
     * Get Required value
     * @return string
     */
    public function getRequired()
    {
        return $this->Required;
    }
    /**
     * Set Required value
     * @param string $required
     * @return \StructType\UserChoices
     */
    public function setRequired($required = null)
    {
        // validation for constraint: string
        if (!is_null($required) && !is_string($required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($required, true), gettype($required)), __LINE__);
        }
        $this->Required = $required;
        return $this;
    }
    /**
     * Get FlightOptions value
     * @return \StructType\FlightOptions|null
     */
    public function getFlightOptions()
    {
        return $this->FlightOptions;
    }
    /**
     * Set FlightOptions value
     * @param \StructType\FlightOptions $flightOptions
     * @return \StructType\UserChoices
     */
    public function setFlightOptions(\StructType\FlightOptions $flightOptions = null)
    {
        $this->FlightOptions = $flightOptions;
        return $this;
    }
}
