<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitControl StructType
 * Meta information extracted from the WSDL
 * - documentation: The units credited based on the request type.Units may be number of services, cost of service in points, miles or awardsExample: 52.25
 * @subpackage Structs
 */
class UnitControl extends AbstractStructBase
{
    /**
     * The Units
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Units[]
     */
    public $Units;
    /**
     * Constructor method for UnitControl
     * @uses UnitControl::setUnits()
     * @param \StructType\Units[] $units
     */
    public function __construct(array $units = array())
    {
        $this
            ->setUnits($units);
    }
    /**
     * Get Units value
     * @return \StructType\Units[]|null
     */
    public function getUnits()
    {
        return $this->Units;
    }
    /**
     * This method is responsible for validating the values passed to the setUnits method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnits method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnitsForArrayConstraintsFromSetUnits(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unitControlUnitsItem) {
            // validation for constraint: itemType
            if (!$unitControlUnitsItem instanceof \StructType\Units) {
                $invalidValues[] = is_object($unitControlUnitsItem) ? get_class($unitControlUnitsItem) : sprintf('%s(%s)', gettype($unitControlUnitsItem), var_export($unitControlUnitsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Units property can only contain items of type \StructType\Units, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Units value
     * @throws \InvalidArgumentException
     * @param \StructType\Units[] $units
     * @return \StructType\UnitControl
     */
    public function setUnits(array $units = array())
    {
        // validation for constraint: array
        if ('' !== ($unitsArrayErrorMessage = self::validateUnitsForArrayConstraintsFromSetUnits($units))) {
            throw new \InvalidArgumentException($unitsArrayErrorMessage, __LINE__);
        }
        $this->Units = $units;
        return $this;
    }
    /**
     * Add item to Units value
     * @throws \InvalidArgumentException
     * @param \StructType\Units $item
     * @return \StructType\UnitControl
     */
    public function addToUnits(\StructType\Units $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Units) {
            throw new \InvalidArgumentException(sprintf('The Units property can only contain items of type \StructType\Units, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Units[] = $item;
        return $this;
    }
}
